/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.resource.ConnectionManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorResource
extends J2EEResourceBase
implements Serializable {
    private static Logger _logger = null;
    public static final String CONNECTOR_OBJECT_FACTORY = "com.sun.enterprise.naming.factory.ConnectorObjectFactory";
    private String dbuser_ = "";
    private String dbpassword_ = "";
    private String connectorname_;
    private String appname_ = "";
    private String connectionFactoryClass_;

    public ConnectorResource(String string) {
        super(string);
    }

    protected J2EEResource doClone(String string) {
        ConnectorResource connectorResource = new ConnectorResource(string);
        connectorResource.setDbuser(this.getDbuser());
        connectorResource.setDbpassword(this.getDbpassword());
        connectorResource.setConnectorName(this.getConnectorName());
        connectorResource.setApplicationName(this.getApplicationName());
        connectorResource.setConnectionFactoryClass(this.getConnectionFactoryClass());
        return connectorResource;
    }

    public int getType() {
        return 6;
    }

    public String getApplicationName() {
        return this.appname_;
    }

    public void setApplicationName(String string) {
        this.appname_ = string == null ? "" : string;
    }

    public String getConnectorName() {
        return this.connectorname_;
    }

    public void setConnectorName(String string) {
        this.connectorname_ = string;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass_;
    }

    public void setConnectionFactoryClass(String string) {
        this.connectionFactoryClass_ = string;
    }

    public String getDbuser() {
        return this.dbuser_;
    }

    public void setDbuser(String string) {
        this.dbuser_ = string == null ? "" : string;
    }

    public String getDbpassword() {
        return this.dbpassword_;
    }

    public void setDbpassword(String string) {
        this.dbpassword_ = string == null ? "" : string;
    }

    public Reference createConnectionFactoryReference() {
        Reference reference = new Reference(this.getConnectionFactoryClass(), new StringRefAddr("jndiName", this.getName()), CONNECTOR_OBJECT_FACTORY, null);
        return reference;
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ClassLoader classLoader) throws PoolingException {
        try {
            if (classLoader == null) {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            ConnectorDescriptor connectorDescriptor = resourceInstaller.getDescriptorByConnectorName(this.getApplicationName(), this.getConnectorName());
            String string = this.getName();
            String string2 = connectorDescriptor.getManagedConnectionFactoryImpl();
            String string3 = this.getApplicationName();
            _logger.log(Level.FINE, "ClassLoader: " + classLoader.getClass());
            _logger.log(Level.FINE, "ClassLoader: " + classLoader.getParent().getClass());
            _logger.log(Level.FINE, "ClassLoader: " + classLoader.getParent().getParent().getClass());
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)Class.forName(string2, true, classLoader).newInstance();
            AccessController.doPrivileged(new SetMethodAction(managedConnectionFactory, connectorDescriptor));
            return managedConnectionFactory;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            _logger.log(Level.SEVERE, "enterprise.privilegedaction_exception", exception.toString());
            Log.err.flush();
            throw new PoolingException(exception.toString(), exception);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.managedconnfactory_exception", exception.toString());
            Log.err.flush();
            throw new PoolingException(exception.toString(), exception);
        }
    }

    public Object createConnectionFactory() throws PoolingException {
        ManagedConnectionFactory managedConnectionFactory = this.createManagedConnectionFactory(null);
        try {
            Object object = managedConnectionFactory.createConnectionFactory((ConnectionManager)new ConnectionManagerImpl(this.getName()));
            return object;
        }
        catch (ResourceException resourceException) {
            _logger.log(Level.SEVERE, "enterprise.resource_exception", resourceException.toString());
            Log.err.flush();
            throw new PoolingException(resourceException.toString(), (Exception)((Object)resourceException));
        }
    }

    public String toString() {
        return "< Connector Resource : " + this.getName() + " , " + this.getApplicationName() + " , " + this.getConnectorName() + " , " + this.getDbuser() + " , " + this.getDbpassword() + " >";
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
    }

    class SetMethodAction
    implements PrivilegedExceptionAction {
        ManagedConnectionFactory mcf;
        ConnectorDescriptor desc;

        SetMethodAction(ManagedConnectionFactory managedConnectionFactory, ConnectorDescriptor connectorDescriptor) {
            this.mcf = managedConnectionFactory;
            this.desc = connectorDescriptor;
        }

        public Object run() throws Exception {
            Iterator iterator = this.desc.getConfigProperties().iterator();
            while (iterator.hasNext()) {
                EnvironmentProperty environmentProperty = (EnvironmentProperty)iterator.next();
                String string = environmentProperty.getName();
                String string2 = environmentProperty.getType();
                String string3 = (String)ConnectorResource.this.getProperty(string).getValue();
                EnvironmentProperty environmentProperty2 = new EnvironmentProperty(string, string3, "", string2);
                String string4 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                Method method = this.mcf.getClass().getMethod(string4, environmentProperty2.getValueType());
                method.invoke((Object)this.mcf, environmentProperty2.getValueObject());
            }
            return null;
        }
    }
}

