/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.iplanet.ias.cis.connection.CISSocket;
import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.ior.IIOPAddress;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.EndPointInfoImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import sun.security.x509.X500Name;

public final class SecurityMechanismSelector {
    private static Logger _logger = null;
    private static final String SECURE_PROPERTIES = "security.properties";
    private static final String SEND_PASSWORD = "client.sendpassword";
    private static final String SERVER_TRUSTED_HOSTS = "server.trustedhosts";
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static final boolean debug = false;
    private static final String USE_SSL = "com.sun.enterprise.useSSL";
    private static final String NAMESERVICE_KEY = "com.sun.enterprise.nameServiceKey";
    private static boolean sendPassword;
    private static String[] serverTrustedHosts;
    private static boolean useSSL;
    private static String nameServiceKey;
    private static LocalStringManagerImpl localStrings;
    private static POAProtocolMgr protocolMgr;
    private CompoundSecMech mechanism = null;
    private POAEJBORB orb = (POAEJBORB)ORBManager.getORB();
    private CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb);
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

    public static ServerConnectionContext getServerConnectionContext() {
        Hashtable hashtable = ConnectionExecutionContext.getContext();
        ServerConnectionContext serverConnectionContext = (ServerConnectionContext)hashtable.get(SERVER_CONNECTION_CONTEXT);
        return serverConnectionContext;
    }

    public static void setServerConnectionContext(ServerConnectionContext serverConnectionContext) {
        Hashtable hashtable = ConnectionExecutionContext.getContext();
        hashtable.put(SERVER_CONNECTION_CONTEXT, serverConnectionContext);
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable hashtable = ConnectionExecutionContext.getContext();
        ConnectionContext connectionContext = (ConnectionContext)hashtable.get(CLIENT_CONNECTION_CONTEXT);
        return connectionContext;
    }

    public void setClientConnectionContext(ConnectionContext connectionContext) {
        Hashtable hashtable = ConnectionExecutionContext.getContext();
        hashtable.put(CLIENT_CONNECTION_CONTEXT, connectionContext);
    }

    public EndPointInfo getSSLPort(IOR iOR, ConnectionContext connectionContext) {
        if (this.isNameServiceIOR(iOR)) {
            if (!useSSL) {
                return null;
            }
            IIOPAddress iIOPAddress = iOR.getProfile().getTemplate().getPrimaryAddress();
            EndPointInfoImpl endPointInfoImpl = new EndPointInfoImpl("SSL", iIOPAddress.getHost(), iIOPAddress.getPort());
            return endPointInfoImpl;
        }
        EndPointInfoImpl endPointInfoImpl = null;
        try {
            this.mechanism = this.selectSecurityMechanism(iOR);
        }
        catch (SecurityMechanismException securityMechanismException) {
            throw new RuntimeException(securityMechanismException.getMessage());
        }
        connectionContext.setIOR(iOR);
        connectionContext.setMechanism(this.mechanism);
        if (this.mechanism == null) {
            return null;
        }
        TLS_SEC_TRANS tLS_SEC_TRANS = this.ctc.getSSLInformation(this.mechanism);
        if (tLS_SEC_TRANS == null) {
            return null;
        }
        short s = tLS_SEC_TRANS.target_requires;
        short s2 = tLS_SEC_TRANS.target_supports;
        if (this.isSet(s, 2) || this.isSet(s, 4) || this.isSet(s, 64)) {
            connectionContext.setSSLUsed(true);
            String string = "SSL";
            if (this.isSet(s, 64)) {
                string = "SSL_MUTUALAUTH";
                connectionContext.setSSLClientAuthenticationOccurred(true);
            }
            short s3 = tLS_SEC_TRANS.addresses[0].port;
            int n = Utility.shortToInt(s3);
            String string2 = tLS_SEC_TRANS.addresses[0].host_name;
            endPointInfoImpl = new EndPointInfoImpl(string, string2, n);
            return endPointInfoImpl;
        }
        if (this.isSet(s2, 2) || this.isSet(s2, 4) || this.isSet(s2, 64)) {
            if (this.clientPrefersSSL(iOR)) {
                connectionContext.setSSLUsed(true);
                short s4 = tLS_SEC_TRANS.addresses[0].port;
                String string = tLS_SEC_TRANS.addresses[0].host_name;
                int n = Utility.shortToInt(s4);
                endPointInfoImpl = new EndPointInfoImpl("SSL", string, n);
                return endPointInfoImpl;
            }
            return null;
        }
        return null;
    }

    private boolean isNameServiceIOR(IOR iOR) {
        byte[] byArray = iOR.getProfile().getObjectId().getId();
        String string = new String(byArray);
        return string.equals("NameService") || string.equals("INIT") || string.equals(nameServiceKey);
    }

    private boolean clientPrefersSSL(IOR iOR) {
        return useSSL;
    }

    public SecurityContext selectSecurityContext(IOR iOR) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext securityContext = null;
        ConnectionContext connectionContext = this.getClientConnectionContext();
        if (connectionContext == null) {
            return null;
        }
        this.mechanism = connectionContext.getMechanism();
        if (this.mechanism == null) {
            return null;
        }
        boolean bl = connectionContext.getSSLUsed();
        boolean bl2 = connectionContext.getSSLClientAuthenticationOccurred();
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            securityContext = this.getSecurityContextForAppClient(null, bl, bl2);
            return securityContext;
        }
        ComponentInvocation componentInvocation = null;
        componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            return null;
        }
        Object object = componentInvocation.getContainerContext();
        securityContext = object instanceof AppContainer ? this.getSecurityContextForAppClient(componentInvocation, bl, bl2) : this.getSecurityContextForWebOrEJB(componentInvocation, bl, bl2);
        return securityContext;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation componentInvocation, boolean bl, boolean bl2) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext securityContext = null;
        boolean bl3 = true;
        if (!bl) {
            securityContext = this.sendUsernameAndPassword(bl3, componentInvocation);
        } else if (!bl2) {
            bl3 = false;
            securityContext = this.sendUsernameAndPassword(bl3, componentInvocation);
        } else {
            bl3 = false;
            securityContext = this.sendUsernameAndPassword(bl3, componentInvocation);
        }
        return securityContext;
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation componentInvocation, boolean bl, boolean bl2) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext securityContext = null;
        boolean bl3 = true;
        boolean bl4 = false;
        if (!bl) {
            securityContext = this.propagateIdentity(bl3, bl4, componentInvocation);
        } else if (!bl2) {
            bl3 = false;
            securityContext = this.propagateIdentity(bl3, bl4, componentInvocation);
        } else {
            bl3 = false;
            bl4 = true;
            securityContext = this.propagateIdentity(bl3, bl4, componentInvocation);
        }
        return securityContext;
    }

    private boolean isMechanismSupported(SAS_ContextSec sAS_ContextSec) {
        byte[][] byArray = sAS_ContextSec.supported_naming_mechanisms;
        byte[] byArray2 = new byte[]{};
        try {
            byArray2 = GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray[0].length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray[0].length) {
            if (byArray[0][n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sAS_ContextSec) {
        int n = sAS_ContextSec.supported_identity_types;
        int n2 = n & 0xF;
        return n2 != 0;
    }

    private SecurityContext sendUsernameAndPassword(boolean bl, ComponentInvocation componentInvocation) throws SecurityMechanismException {
        SecurityContext securityContext = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec aS_ContextSec = this.mechanism.as_context_mech;
        if (!this.isSet(aS_ContextSec.target_requires, 64)) {
            return null;
        }
        securityContext = this.setUsernameAndPassword(bl, componentInvocation);
        return securityContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean bl, boolean bl2, ComponentInvocation componentInvocation) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext securityContext = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec aS_ContextSec = this.mechanism.as_context_mech;
        SAS_ContextSec sAS_ContextSec = this.mechanism.sas_context_mech;
        if (this.isSet(aS_ContextSec.target_requires, 64)) {
            securityContext = this.setUsernameAndPassword(bl, componentInvocation);
            if (securityContext.authcls != null) return securityContext;
            String string = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            _logger.log(Level.SEVERE, "iiop.runas_error", string);
            throw new SecurityMechanismException(string);
        }
        if (this.isSet(sAS_ContextSec.target_supports, 1024) || this.isSet(sAS_ContextSec.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sAS_ContextSec)) {
                String string = localStrings.getLocalString("securitymechanismselector.invalid_identity_type", "The given identity token is unsupported.");
                throw new InvalidIdentityTokenException(string);
            }
            if (sAS_ContextSec.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sAS_ContextSec)) return this.getIdentity();
            String string = localStrings.getLocalString("securitymechanismselector.invalid_mechanism", "The given mechanism type is unsupported.");
            _logger.log(Level.SEVERE, "iiop.unsupported_type_error", string);
            throw new InvalidMechanismException(string);
        }
        if (!this.isSet(aS_ContextSec.target_supports, 64)) return null;
        if (!bl2) return null;
        securityContext = this.setUsernameAndPassword(bl, componentInvocation);
        if (securityContext.authcls != null) return securityContext;
        return null;
    }

    private SecurityContext setUsernameAndPassword(boolean bl, ComponentInvocation componentInvocation) throws SecurityMechanismException {
        SecurityContext securityContext = null;
        if (bl && sendPassword && this.isServerTrusted()) {
            securityContext = this.getUsernameAndPassword(componentInvocation);
        } else if (!bl && this.isServerTrusted()) {
            securityContext = this.getUsernameAndPassword(componentInvocation);
        } else {
            String string = "Cannot send authentication information because ";
            string = bl && !sendPassword ? string + " client policy does not allow password to " + " be sent over plain IIOP" : string + " client does not trust the server " + " to send password over IIOP";
            throw new SecurityMechanismException(string);
        }
        return securityContext;
    }

    private boolean isServerTrusted() {
        String string = "*";
        int n = 0;
        while (n < serverTrustedHosts.length) {
            if (serverTrustedHosts[n].length() == 1 && serverTrustedHosts[n].equals(string)) {
                return true;
            }
            ++n;
        }
        ConnectionContext connectionContext = this.getClientConnectionContext();
        if (connectionContext != null) {
            Socket socket = connectionContext.getSocket();
            InetAddress inetAddress = socket.getInetAddress();
            return this.isDomainInTrustedList(inetAddress, serverTrustedHosts);
        }
        return false;
    }

    private boolean isDomainInTrustedList(InetAddress inetAddress, String[] stringArray) throws SecurityException {
        boolean bl = false;
        String string = null;
        String string2 = "*";
        String string3 = ".";
        try {
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.domain_lookup_failed", inetAddress.getHostAddress());
            }
            return false;
        }
        String[] stringArray2 = TypeUtil.stringToArray(string, string3);
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray3 = TypeUtil.stringToArray(stringArray[n], string3);
            if (stringArray3.length != stringArray2.length) {
                bl = false;
            } else {
                int n2 = stringArray3.length - 1;
                while (n2 >= 0) {
                    if (stringArray3[n2].equals(stringArray2[n2])) {
                        bl = true;
                    } else if (stringArray3[n2].equals(string2)) {
                        bl = true;
                    } else {
                        bl = false;
                        break;
                    }
                    --n2;
                }
                if (bl) {
                    return bl;
                }
            }
            ++n;
        }
        return bl;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation componentInvocation) throws SecurityMechanismException {
        try {
            Serializable serializable;
            Object object;
            Subject subject = null;
            if (componentInvocation == null) {
                object = ClientSecurityContext.getCurrent();
                if (object == null) {
                    return null;
                }
                subject = ((ClientSecurityContext)object).getSubject();
            } else {
                object = componentInvocation.getContainerContext();
                subject = object instanceof AppContainer ? ((serializable = ClientSecurityContext.getCurrent()) == null ? LoginContextDriver.doClientLogin(1, AppContainer.handler) : serializable.getSubject()) : this.getSubjectFromSecurityCurrent();
            }
            object = new SecurityContext();
            serializable = subject;
            ((SecurityContext)object).subject = subject;
            Set set = (Set)AccessController.doPrivileged(new PrivilegedAction((Subject)serializable){
                private final /* synthetic */ Subject val$sub;
                {
                    this.val$sub = subject;
                }

                public Object run() {
                    return this.val$sub.getPrivateCredentials();
                }
            });
            if (set.isEmpty()) {
                ((SecurityContext)object).authcls = null;
                ((SecurityContext)object).identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            } else {
                ((SecurityContext)object).authcls = class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential;
            }
            return object;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.user_password_exception", exception);
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject subject;
        SecurityContext securityContext;
        final SecurityContext securityContext2 = securityContext = new SecurityContext();
        com.sun.enterprise.security.SecurityContext securityContext3 = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (securityContext3 == null || securityContext3.didServerGenerateCredentials()) {
            securityContext2.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject subject;
                    securityContext2.subject = subject = new Subject();
                    securityContext2.subject.getPublicCredentials().add(new AnonCredential());
                    return null;
                }
            });
            return securityContext2;
        }
        securityContext.subject = subject = this.getSubjectFromSecurityCurrent();
        final Subject subject2 = subject;
        Set<Object> set = (Set<Object>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return subject2.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }
        });
        if (set.size() == 1) {
            Subject subject3;
            securityContext.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            final Set<Object> set2 = set;
            securityContext.subject = subject3 = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject subject = new Subject();
                    Iterator iterator = set2.iterator();
                    PasswordCredential passwordCredential = (PasswordCredential)iterator.next();
                    GSSUPName gSSUPName = new GSSUPName(passwordCredential.getUser(), passwordCredential.getRealm());
                    subject.getPublicCredentials().add(gSSUPName);
                    return subject;
                }
            });
            return securityContext;
        }
        set = subject.getPublicCredentials();
        if (set.size() != 1) {
            _logger.log(Level.SEVERE, "iiop.principal_error");
            return null;
        }
        Iterator<Object> iterator = set.iterator();
        if (iterator.hasNext()) {
            Object object = iterator.next();
            securityContext.identcls = object instanceof GSSUPName ? (class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName) : (object instanceof X500Name ? (class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name) : (class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential));
        } else {
            _logger.log(Level.SEVERE, "iiop.credential_error");
            return null;
        }
        return securityContext;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext securityContext = null;
        securityContext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (securityContext == null) {
            _logger.log(Level.FINE, " SETTING GUEST ---");
            securityContext = com.sun.enterprise.security.SecurityContext.init();
        }
        if (securityContext == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject subject = securityContext.getSubject();
        if (subject == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        return subject;
    }

    public CompoundSecMech selectSecurityMechanism(IOR iOR) throws SecurityMechanismException {
        CompoundSecMech[] compoundSecMechArray = this.ctc.getSecurityMechanisms(iOR);
        CompoundSecMech compoundSecMech = this.selectSecurityMechanism(compoundSecMechArray);
        return compoundSecMech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] compoundSecMechArray) throws SecurityMechanismException {
        if (compoundSecMechArray == null || compoundSecMechArray.length == 0) {
            return null;
        }
        CompoundSecMech compoundSecMech = null;
        int n = 0;
        while (n < compoundSecMechArray.length) {
            compoundSecMech = compoundSecMechArray[n];
            boolean bl = this.useMechanism(compoundSecMech);
            if (bl) {
                return compoundSecMech;
            }
            ++n;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech compoundSecMech) {
        boolean bl = true;
        TLS_SEC_TRANS tLS_SEC_TRANS = this.ctc.getSSLInformation(compoundSecMech);
        if (tLS_SEC_TRANS == null) {
            return true;
        }
        short s = tLS_SEC_TRANS.target_requires;
        if (this.isSet(s, 64) && !SSLUtils.isClientKeyStoreAvailable()) {
            bl = false;
        }
        return bl;
    }

    private byte[] getTargetName(Subject subject) {
        byte[] byArray = new byte[]{};
        final Subject subject2 = subject;
        final Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return subject2.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }
        });
        if (set.size() == 1) {
            byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = set.iterator();
                    PasswordCredential passwordCredential = (PasswordCredential)iterator.next();
                    return passwordCredential.getTargetName();
                }
            });
        }
        return byArray;
    }

    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor, boolean bl, X509Certificate[] x509CertificateArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        n = this.ctc.getTargetRequires(ejbIORConfigurationDescriptor);
        n2 = this.ctc.getTargetSupports(ejbIORConfigurationDescriptor);
        bl2 = this.isSet(n, 2) || this.isSet(n, 4) || this.isSet(n, 64);
        bl3 = n2 != 0;
        if (bl ? !bl2 && !bl3 : bl2) {
            return false;
        }
        return !(x509CertificateArray != null ? !this.isSet(n, 64) && !this.isSet(n2, 64) : this.isSet(n, 64));
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext securityContext, EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor) {
        boolean bl = false;
        AS_ContextSec aS_ContextSec = null;
        try {
            aS_ContextSec = this.ctc.createASContextSec(ejbIORConfigurationDescriptor);
        }
        catch (Exception exception) {
            return false;
        }
        if (aS_ContextSec == null) {
            return false;
        }
        bl = securityContext != null && securityContext.authcls != null && securityContext.subject != null;
        if (bl) {
            if (!this.isSet(aS_ContextSec.target_requires, 64) && !this.isSet(aS_ContextSec.target_supports, 64)) {
                return false;
            }
            byte[] byArray = this.getTargetName(securityContext.subject);
            if (aS_ContextSec.target_name.length != byArray.length) {
                return false;
            }
            int n = 0;
            while (n < aS_ContextSec.target_name.length) {
                if (aS_ContextSec.target_name[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
        } else if (this.isSet(aS_ContextSec.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext securityContext, EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor) {
        boolean bl = false;
        SAS_ContextSec sAS_ContextSec = null;
        try {
            sAS_ContextSec = this.ctc.createSASContextSec(ejbIORConfigurationDescriptor);
        }
        catch (Exception exception) {
            return false;
        }
        if (sAS_ContextSec == null) {
            return false;
        }
        bl = securityContext != null && securityContext.identcls != null && securityContext.subject != null;
        if (bl) {
            return this.isSet(sAS_ContextSec.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext securityContext, byte[] byArray, boolean bl, X509Certificate[] x509CertificateArray) {
        if (byArray == null) {
            return true;
        }
        if (protocolMgr == null) {
            protocolMgr = (POAProtocolMgr)Switch.getSwitch().getProtocolManager();
        }
        if (protocolMgr == null) {
            return true;
        }
        EjbDescriptor ejbDescriptor = protocolMgr.getEjbDescriptor(byArray);
        if (ejbDescriptor == null) {
            return true;
        }
        Set set = ejbDescriptor.getIORConfigurationDescriptors();
        if (set.isEmpty()) {
            return true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor = (EjbIORConfigurationDescriptor)iterator.next();
            if (!this.evaluate_client_conformance_ssl(ejbIORConfigurationDescriptor, bl, x509CertificateArray) || !this.evaluate_client_conformance_ascontext(securityContext, ejbIORConfigurationDescriptor) || !this.evaluate_client_conformance_sascontext(securityContext, ejbIORConfigurationDescriptor)) continue;
            return true;
        }
        return false;
    }

    public SecurityContext evaluateTrust(SecurityContext securityContext, byte[] byArray) throws SecurityMechanismException {
        Object object;
        SecurityContext securityContext2 = null;
        CISSocket cISSocket = null;
        boolean bl = false;
        X509Certificate[] x509CertificateArray = null;
        ServerConnectionContext serverConnectionContext = SecurityMechanismSelector.getServerConnectionContext();
        if (serverConnectionContext != null && (cISSocket = (CISSocket)serverConnectionContext.getSocket()) != null && cISSocket.isSSLConnection()) {
            bl = true;
            object = null;
            try {
                object = cISSocket.getSSLSession();
            }
            catch (Exception exception) {
                System.out.println("Exception caught while retrieving SSLSession Object");
                exception.printStackTrace();
            }
            try {
                x509CertificateArray = object.getPeerCertificate();
            }
            catch (Exception exception) {
                System.out.println("Caught an error while retrieving certificate ");
            }
        }
        if (cISSocket == null && securityContext == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(securityContext, byArray, bl, x509CertificateArray)) {
            object = "Trust evaluation failed because ";
            object = (String)object + "client does not conform to configured security policies";
            throw new SecurityMechanismException((String)object);
        }
        if (securityContext == null) {
            if (cISSocket == null || !bl || x509CertificateArray == null) {
                return null;
            }
            securityContext2 = new SecurityContext();
            object = (X500Name)x509CertificateArray[0].getSubjectDN();
            securityContext2.subject = new Subject();
            securityContext2.subject.getPublicCredentials().add(object);
            securityContext2.identcls = class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name;
            securityContext2.authcls = null;
            return securityContext2;
        }
        securityContext2 = securityContext;
        object = securityContext.authcls;
        Class clazz = securityContext.identcls;
        securityContext2.subject = securityContext.subject;
        securityContext2.authcls = null;
        securityContext2.identcls = null;
        if (clazz != null) {
            securityContext2.identcls = clazz;
        } else if (object != null) {
            securityContext2.authcls = object;
        } else {
            securityContext2.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
        }
        return securityContext2;
    }

    private boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    private void debug(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        sendPassword = false;
        serverTrustedHosts = null;
        useSSL = false;
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor == null ? (class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.SecServerRequestInterceptor")) : class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor);
        protocolMgr = null;
        Properties properties = null;
        try {
            String string;
            properties = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String string2 = properties.getProperty(SEND_PASSWORD);
            if (string2 != null && !string2.trim().equals("")) {
                sendPassword = new Boolean(string2);
            }
            if ((string = properties.getProperty(SERVER_TRUSTED_HOSTS)) != null && !string.trim().equals("")) {
                serverTrustedHosts = TypeUtil.stringToArray(string, ",");
            }
            useSSL = new Boolean(System.getProperty(USE_SSL));
            nameServiceKey = System.getProperty(NAMESERVICE_KEY);
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
    }
}

