/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodDescriptor
extends Descriptor {
    public static String EJB_HOME = "Home";
    public static String EJB_LOCALHOME = "LocalHome";
    public static String EJB_REMOTE = "Remote";
    public static String EJB_LOCAL = "Local";
    public static String EJB_BEAN = "Bean";
    public static String ALL_OF_NAME = "AllOfName";
    public static String ALL_EJB_METHODS = "*";
    private String[] parameterClassNames = null;
    private String[] javaParameterClassNames = null;
    private String className = "";
    private String ejbClassSymbol;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$MethodDescriptor == null ? (class$com$sun$enterprise$deployment$MethodDescriptor = MethodDescriptor.class$("com.sun.enterprise.deployment.MethodDescriptor")) : class$com$sun$enterprise$deployment$MethodDescriptor);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private int JAVA_FORMAT = 1;
    private int XML_FORMAT = -1;
    private int XML_JAVA_FORMAT = 0;
    private static Map javaPrimitivesTypes;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$MethodDescriptor;

    public MethodDescriptor(String string, String string2, String[] stringArray, String string3) {
        super(string, string2);
        if (string == null) {
            super.setName("");
        }
        if (stringArray != null) {
            this.convertToAppropriateFormat(stringArray);
        }
        this.setEjbClassSymbol(string3);
    }

    private void convertToAppropriateFormat(String[] stringArray) {
        int n = this.isJavaFormat(stringArray);
        if (n == this.JAVA_FORMAT) {
            this.javaParameterClassNames = stringArray;
            this.parameterClassNames = this.fixParamClassNames(stringArray);
        } else if (n == this.XML_FORMAT) {
            this.javaParameterClassNames = this.xmlFormat2JavaClassNames(stringArray);
            this.parameterClassNames = stringArray;
        } else if (n == this.XML_JAVA_FORMAT) {
            this.javaParameterClassNames = stringArray;
            this.parameterClassNames = stringArray;
        }
    }

    public MethodDescriptor(String string, String string2, String string3) {
        super(string, string2);
        this.parameterClassNames = null;
        this.setEjbClassSymbol(string3);
    }

    public MethodDescriptor(Method method) {
        super(method.getName(), "");
        Class<?> clazz = method.getClass();
        Method[] methodArray = clazz.getMethods();
        this.parameterClassNames = this.getParameterClassNamesFor(method);
        this.javaParameterClassNames = this.getJavaFormatClassNamesFor(method);
        this.className = method.getDeclaringClass().getName();
    }

    public MethodDescriptor(Method method, String string) {
        this(method);
        this.setEjbClassSymbol(string);
    }

    public MethodDescriptor(Method method, EjbDescriptor ejbDescriptor, ClassLoader classLoader) {
        this(method);
        this.processEjbSymbol(method, ejbDescriptor, classLoader);
    }

    public boolean isExact() {
        boolean bl = !this.getName().equals(ALL_EJB_METHODS);
        boolean bl2 = !"".equals(this.getEjbClassSymbol());
        boolean bl3 = this.getParameterClassNames() != null;
        return bl && bl2 && bl3;
    }

    public int getStyle() {
        if (this.getName().equals(ALL_EJB_METHODS)) {
            return 1;
        }
        if (this.getParameterClassNames() == null) {
            return 2;
        }
        return 3;
    }

    public Method getMethod(EjbDescriptor ejbDescriptor) {
        Method method;
        block22: {
            method = null;
            try {
                EjbBundleArchivist ejbBundleArchivist = (EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist();
                ClassLoader classLoader = ejbBundleArchivist.getClassLoader();
                String[] stringArray = this.getJavaParameterClassNames();
                if (this.ejbClassSymbol == null || this.ejbClassSymbol.equals("") || this.ejbClassSymbol.equals(EJB_BEAN)) {
                    try {
                        Class<?> clazz = classLoader.loadClass(ejbDescriptor.getEjbClassName());
                        return TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                                Class<?> clazz = classLoader.loadClass(ejbDescriptor.getHomeClassName());
                                return TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            // empty catch block
                        }
                        try {
                            if (ejbDescriptor.isLocalInterfacesSupported()) {
                                Class<?> clazz = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
                                return TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {}
                        break block22;
                    }
                }
                if (this.ejbClassSymbol.equals(EJB_HOME)) {
                    try {
                        Class<?> clazz = classLoader.loadClass(ejbDescriptor.getHomeClassName());
                        method = TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break block22;
                }
                if (this.ejbClassSymbol.equals(EJB_LOCALHOME)) {
                    try {
                        Class<?> clazz = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
                        method = TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break block22;
                }
                if (this.ejbClassSymbol.equals(EJB_REMOTE)) {
                    try {
                        Class<?> clazz = classLoader.loadClass(ejbDescriptor.getRemoteClassName());
                        method = TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break block22;
                }
                if (!this.ejbClassSymbol.equals(EJB_LOCAL)) break block22;
                try {
                    Class<?> clazz = classLoader.loadClass(ejbDescriptor.getLocalClassName());
                    method = TypeUtil.getMethod(clazz, classLoader, this.getName(), stringArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise.deployment_getMethod_exception", exception);
            }
        }
        return method;
    }

    public Method getMethod(Class clazz) {
        try {
            return TypeUtil.getMethod(clazz, clazz.getClassLoader(), this.getName(), this.getJavaParameterClassNames());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.deployment_getMethod_exception", exception);
            return null;
        }
    }

    public Vector doStyleConversion(EjbDescriptor ejbDescriptor, Collection collection) {
        Vector<MethodDescriptor> vector = new Vector<MethodDescriptor>();
        if (this.getName().equals(ALL_EJB_METHODS)) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
                if (!methodDescriptor.isExact()) {
                    // empty if block
                }
                methodDescriptor.setDescription(this.getDescription());
                if (this.getEjbClassSymbol().equals("")) {
                    vector.addElement(methodDescriptor);
                    continue;
                }
                if (!this.getEjbClassSymbol().equals(methodDescriptor.getEjbClassSymbol())) continue;
                vector.addElement(methodDescriptor);
            }
        } else if (this.getParameterClassNames() == null) {
            vector.addAll(this.getMethodDescriptorsOfName(this.getName(), collection));
        } else if (this.getEjbClassSymbol().equals("")) {
            vector.addAll(this.getMethodDescriptorsOfNameAndParameters(this.getName(), this.getParameterClassNames(), collection));
        } else {
            vector.addElement(this);
        }
        return vector;
    }

    private Set getMethodDescriptorsOfNameAndParameters(String string, String[] stringArray, Collection collection) {
        HashSet<MethodDescriptor> hashSet = new HashSet<MethodDescriptor>();
        Iterator iterator = this.getMethodDescriptorsOfName(string, collection).iterator();
        while (iterator.hasNext()) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
            if (!this.stringArrayEquals(stringArray, methodDescriptor.getParameterClassNames())) continue;
            if (!methodDescriptor.isExact()) {
                // empty if block
            }
            hashSet.add(methodDescriptor);
        }
        return hashSet;
    }

    private Set getMethodDescriptorsOfName(String string, Collection collection) {
        HashSet<MethodDescriptor> hashSet = new HashSet<MethodDescriptor>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
            if (!string.equals(methodDescriptor.getName())) continue;
            if (!methodDescriptor.isExact()) {
                // empty if block
            }
            if (this.getEjbClassSymbol().equals("")) {
                hashSet.add(methodDescriptor);
                continue;
            }
            if (!this.getEjbClassSymbol().equals(methodDescriptor.getEjbClassSymbol())) continue;
            hashSet.add(methodDescriptor);
        }
        return hashSet;
    }

    public boolean isEquivalent(Method method) {
        return this.equals(new MethodDescriptor(method));
    }

    public String getEjbClassSymbol() {
        if (this.ejbClassSymbol == null) {
            this.ejbClassSymbol = "";
        }
        return this.ejbClassSymbol;
    }

    public void setEjbClassSymbol(String string) {
        this.ejbClassSymbol = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEjbSymbol(Method method, EjbDescriptor ejbDescriptor, ClassLoader classLoader) {
        try {
            Class<?> clazz;
            Class<?> clazz2 = null;
            String string = method.getDeclaringClass().getName();
            ClassLoader classLoader2 = classLoader != null ? classLoader : ((EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist()).getClassLoader();
            Class<?> clazz3 = classLoader2.loadClass(ejbDescriptor.getEjbClassName());
            clazz2 = classLoader.loadClass(string);
            if (ejbDescriptor.getType().equals("Message-driven")) {
                if (clazz2.isAssignableFrom(clazz3)) {
                    this.ejbClassSymbol = EJB_BEAN;
                    return;
                }
                _logger.log(Level.FINE, "declaring class = " + clazz2);
                _logger.log(Level.FINE, "method = " + this);
                _logger.log(Level.FINE, "bean class = " + clazz3);
                throw new IllegalArgumentException();
            }
            boolean bl = ejbDescriptor.isRemoteInterfacesSupported();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                Class<?> clazz4 = classLoader2.loadClass(ejbDescriptor.getHomeClassName());
                clazz = classLoader2.loadClass(ejbDescriptor.getRemoteClassName());
                if (clazz2.isAssignableFrom(clazz4)) {
                    this.ejbClassSymbol = EJB_HOME;
                } else if (clazz2.isAssignableFrom(clazz)) {
                    this.ejbClassSymbol = EJB_REMOTE;
                } else if (clazz2.isAssignableFrom(clazz3)) {
                    this.ejbClassSymbol = EJB_BEAN;
                } else {
                    bl = false;
                }
            }
            boolean bl2 = ejbDescriptor.isLocalInterfacesSupported();
            if (!bl && ejbDescriptor.isLocalInterfacesSupported()) {
                clazz = classLoader2.loadClass(ejbDescriptor.getLocalHomeClassName());
                Class<?> clazz5 = classLoader2.loadClass(ejbDescriptor.getLocalClassName());
                if (clazz2.isAssignableFrom(clazz)) {
                    this.ejbClassSymbol = EJB_LOCALHOME;
                } else if (clazz2.isAssignableFrom(clazz5)) {
                    this.ejbClassSymbol = EJB_LOCAL;
                } else if (clazz2.isAssignableFrom(clazz3)) {
                    this.ejbClassSymbol = EJB_BEAN;
                } else {
                    bl2 = false;
                }
            }
            if (bl2) return;
            if (bl) return;
            _logger.log(Level.FINE, "method class = " + clazz2);
            _logger.log(Level.FINE, "bean class = " + clazz3);
            throw new IllegalArgumentException("Method is not on any EJB interface");
        }
        catch (Throwable throwable) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.deployment_exception_method_not_found", new Object[]{method, ejbDescriptor});
                _logger.log(Level.SEVERE, "enterprise.deployment_exception_method_not_found_excp", throwable);
            }
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmethodnotfound", "{0} not found in {1}", new Object[]{method, ejbDescriptor}));
        }
    }

    public String getFormattedString() {
        return this.getName() + this.getPrettyParameterString();
    }

    public String getPrettyParameterString() {
        String string = "(";
        if (this.parameterClassNames != null) {
            int n = 0;
            while (n < this.parameterClassNames.length) {
                int n2 = n + 1;
                string = n > 0 ? string + ", " + this.parameterClassNames[n] + " parameter" + n2 : string + this.parameterClassNames[n] + " parameter" + n2;
                ++n;
            }
        } else {
            string = "unspecified";
        }
        string = string + ")";
        return string;
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    public String[] getJavaParameterClassNames() {
        return this.javaParameterClassNames;
    }

    private boolean stringArrayEquals(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null && stringArray2 != null) {
            return false;
        }
        if (stringArray2 == null && stringArray != null) {
            return false;
        }
        if (stringArray.length == stringArray2.length) {
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals(stringArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        MethodDescriptor methodDescriptor;
        return object != null && object instanceof MethodDescriptor && (methodDescriptor = (MethodDescriptor)object).getName().equals(this.getName()) && this.stringArrayEquals(methodDescriptor.getParameterClassNames(), this.getParameterClassNames()) && this.getEjbClassSymbol().equals(methodDescriptor.getEjbClassSymbol());
    }

    public int hashCode() {
        return this.getPrettyParameterString().hashCode() + this.getName().hashCode();
    }

    public String toString() {
        return "Method Descriptor: name: " + this.getName() + " params: " + this.getPrettyParameterString() + " intf: " + this.ejbClassSymbol;
    }

    private String[] getParameterClassNamesFor(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            Class<?> clazz = classArray[n].getComponentType();
            if (clazz == null) {
                stringArray[n] = classArray[n].getName();
            } else {
                int n2 = 1;
                while (clazz.getComponentType() != null) {
                    ++n2;
                    clazz = clazz.getComponentType();
                }
                stringArray[n] = clazz.getName();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n;
                    stringArray[n4] = stringArray[n4] + "[]";
                    ++n3;
                }
            }
            ++n;
        }
        return stringArray;
    }

    private int isJavaFormat(String[] stringArray) {
        int n = this.XML_JAVA_FORMAT;
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = stringArray[n2].indexOf(91);
            if (n3 != -1) {
                if (n3 == 0) {
                    return this.JAVA_FORMAT;
                }
                return this.XML_FORMAT;
            }
            n = this.XML_JAVA_FORMAT;
            ++n2;
        }
        return n;
    }

    private String[] getJavaFormatClassNamesFor(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = classArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    private String[] fixParamClassNames(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = MethodDescriptor.fixParamClassName(stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    private String[] xmlFormat2JavaClassNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = new String(MethodDescriptor.xmlFormat2JavaClassNames(stringArray[n]));
            ++n;
        }
        return stringArray2;
    }

    public static String xmlFormat2JavaClassNames(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        int n2 = string.lastIndexOf(93);
        int n3 = n2 - n + 1;
        n3 /= 2;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append("[");
            ++n4;
        }
        String string3 = (String)MethodDescriptor.getJavaPrimitiveTypes().get(string2);
        if (string3 != null) {
            stringBuffer.append(string3);
        } else {
            stringBuffer.append("L");
            stringBuffer.append(string2);
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public static Map getJavaPrimitiveTypes() {
        if (javaPrimitivesTypes == null) {
            javaPrimitivesTypes = new Hashtable();
            javaPrimitivesTypes.put("char", "C");
            javaPrimitivesTypes.put("byte", "B");
            javaPrimitivesTypes.put("double", "D");
            javaPrimitivesTypes.put("float", "F");
            javaPrimitivesTypes.put("int", "I");
            javaPrimitivesTypes.put("long", "J");
            javaPrimitivesTypes.put("short", "S");
            javaPrimitivesTypes.put("boolean", "Z");
        }
        return javaPrimitivesTypes;
    }

    public static String fixParamClassName(String string) {
        if (string.charAt(0) == '[') {
            int n = string.lastIndexOf(91) + 1;
            char c = string.charAt(n);
            String string2 = null;
            switch (c) {
                case 'B': {
                    string2 = "byte";
                }
                case 'C': {
                    string2 = "char";
                }
                case 'D': {
                    string2 = "double";
                }
                case 'F': {
                    string2 = "float";
                }
                case 'I': {
                    string2 = "int";
                }
                case 'J': {
                    string2 = "long";
                }
                case 'S': {
                    string2 = "short";
                }
                case 'Z': {
                    string2 = "boolean";
                }
                case 'L': {
                    string2 = string.substring(n + 1);
                }
            }
            int n2 = 0;
            while (n2 < n) {
                string2 = string2 + "[]";
                ++n2;
            }
            return string2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

