/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.SessionFileCacheStore;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.PassivatedSessionInfo;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PassivatedBeansCache {
    StatefulSessionContainer container;
    PassivatedSessionInfo[] buckets;
    Object[] bucketLocks;
    IdleBeanCleanerTimerTask idleBeanCleanerTimerTask;
    boolean addedIdleBeanWork;
    int removalTimeoutInSeconds;
    ClassLoader loader;
    String cacheName;
    SessionFileCacheStore cacheStore;
    private int _bucketMask;
    int size;
    Object sizeLock;
    private Object numExpiredLock;
    private int numExpiredSessionsRemoved;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    PassivatedBeansCache(String string, StatefulSessionContainer statefulSessionContainer, int n) {
        block4: {
            this.size = 0;
            this.sizeLock = new Object();
            this.numExpiredLock = new Object();
            this.cacheName = "PassivatedBeansCache::" + string;
            this.container = statefulSessionContainer;
            this.removalTimeoutInSeconds = n;
            if (n > 0) {
                try {
                    this.idleBeanCleanerTimerTask = new IdleBeanCleanerTimerTask();
                    ContainerFactoryImpl.getTimer().scheduleAtFixedRate((TimerTask)this.idleBeanCleanerTimerTask, n * 1000, (long)(n * 1000));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + string + "]: IdleBeanCleanerTimer Task created");
                    }
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block4;
                    _logger.log(Level.WARNING, "[" + string + "]: Could not add" + " PoolTimerTask. Continuing anyway...", throwable);
                }
            }
        }
        this.loader = this.getClass().getClassLoader();
    }

    void setSessionFileCacheStore(SessionFileCacheStore sessionFileCacheStore) {
        this.cacheStore = sessionFileCacheStore;
    }

    public void init(int n) {
        this._bucketMask = 1;
        while (this._bucketMask < n) {
            this._bucketMask <<= 1;
        }
        this.bucketLocks = new Object[this._bucketMask];
        this.buckets = new PassivatedSessionInfo[this._bucketMask];
        int n2 = 0;
        while (n2 < this._bucketMask) {
            this.bucketLocks[n2] = new Object();
            ++n2;
        }
        --this._bucketMask;
    }

    public int getSize() {
        return this.size;
    }

    protected int getIndex(Long l) {
        return (int)l.longValue() & this._bucketMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Long l, int n) {
        int n2 = this.getIndex(l);
        PassivatedSessionInfo passivatedSessionInfo = new PassivatedSessionInfo(l, n);
        Object object = this.bucketLocks[n2];
        synchronized (object) {
            passivatedSessionInfo.next = this.buckets[n2];
            this.buckets[n2] = passivatedSessionInfo;
        }
        Object object2 = this.sizeLock;
        synchronized (object2) {
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassivatedSessionInfo get(Long l) {
        int n = this.getIndex(l);
        long l2 = l;
        Object object = this.bucketLocks[n];
        synchronized (object) {
            PassivatedSessionInfo passivatedSessionInfo = this.buckets[n];
            while (passivatedSessionInfo != null) {
                if (l2 == passivatedSessionInfo.key) {
                    return passivatedSessionInfo;
                }
                passivatedSessionInfo = passivatedSessionInfo.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassivatedSessionInfo remove(Long l) {
        int n = this.getIndex(l);
        long l2 = l;
        PassivatedSessionInfo passivatedSessionInfo = null;
        PassivatedSessionInfo passivatedSessionInfo2 = null;
        Object object = this.bucketLocks[n];
        synchronized (object) {
            passivatedSessionInfo2 = this.buckets[n];
            while (passivatedSessionInfo2 != null) {
                if (l2 == passivatedSessionInfo2.key) {
                    if (passivatedSessionInfo == null) {
                        this.buckets[n] = passivatedSessionInfo2.next;
                    } else {
                        passivatedSessionInfo.next = passivatedSessionInfo2.next;
                    }
                    passivatedSessionInfo2.next = null;
                    break;
                }
                passivatedSessionInfo = passivatedSessionInfo2;
                passivatedSessionInfo2 = passivatedSessionInfo2.next;
            }
        }
        if (passivatedSessionInfo2 != null) {
            Object object2 = this.sizeLock;
            synchronized (object2) {
                --this.size;
            }
        }
        return passivatedSessionInfo2;
    }

    public void cancelTimerTasks() {
        try {
            this.idleBeanCleanerTimerTask.cancel();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        int n = 0;
        while (n <= this._bucketMask) {
            PassivatedSessionInfo passivatedSessionInfo = null;
            Object object = this.bucketLocks[n];
            synchronized (object) {
                passivatedSessionInfo = this.buckets[n];
                while (passivatedSessionInfo != null) {
                    this.cacheStore.removeState(new Long(passivatedSessionInfo.key));
                    passivatedSessionInfo = passivatedSessionInfo.next;
                }
                this.buckets[n] = null;
            }
            ++n;
        }
        this.container = null;
        this.buckets = null;
        this.bucketLocks = null;
        this.idleBeanCleanerTimerTask = null;
        this.loader = null;
        this.cacheStore = null;
        this.sizeLock = null;
        this.numExpiredLock = null;
    }

    public int getNumExpiredSessionsRemoved() {
        return this.numExpiredSessionsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementExpiredSessionsRemoved() {
        Object object = this.numExpiredLock;
        synchronized (object) {
            ++this.numExpiredSessionsRemoved;
        }
    }

    private class ASyncPassivator
    implements Servicable {
        private ASyncPassivator() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            ClassLoader classLoader2 = PassivatedBeansCache.this.loader;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Removal Work started");
            }
            try {
                Object object;
                thread.setContextClassLoader(PassivatedBeansCache.this.loader);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = (int)(System.currentTimeMillis() / 1000L) - PassivatedBeansCache.this.removalTimeoutInSeconds;
                int n2 = 0;
                while (n2 <= PassivatedBeansCache.this._bucketMask) {
                    PassivatedSessionInfo passivatedSessionInfo = null;
                    PassivatedSessionInfo passivatedSessionInfo2 = null;
                    Object object2 = PassivatedBeansCache.this.bucketLocks[n2];
                    synchronized (object2) {
                        passivatedSessionInfo2 = PassivatedBeansCache.this.buckets[n2];
                        while (passivatedSessionInfo2 != null) {
                            if (passivatedSessionInfo2.lastAccessedAt <= n) {
                                object = passivatedSessionInfo2;
                                if (passivatedSessionInfo == null) {
                                    PassivatedBeansCache.this.buckets[n2] = passivatedSessionInfo2.next;
                                    passivatedSessionInfo2 = PassivatedBeansCache.this.buckets[n2];
                                } else {
                                    passivatedSessionInfo2 = passivatedSessionInfo.next = passivatedSessionInfo2.next;
                                }
                                ((PassivatedSessionInfo)object).next = null;
                                arrayList.add(object);
                                continue;
                            }
                            passivatedSessionInfo = passivatedSessionInfo2;
                            passivatedSessionInfo2 = passivatedSessionInfo2.next;
                        }
                    }
                    ++n2;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Total victims selected for removal =  " + arrayList.size());
                }
                object = PassivatedBeansCache.this.sizeLock;
                synchronized (object) {
                    PassivatedBeansCache.this.size -= arrayList.size();
                }
                Object object3 = PassivatedBeansCache.this.numExpiredLock;
                synchronized (object3) {
                    PassivatedBeansCache.this.numExpiredSessionsRemoved += arrayList.size();
                }
                int n3 = arrayList.size() - 1;
                while (n3 >= 0) {
                    PassivatedSessionInfo passivatedSessionInfo = (PassivatedSessionInfo)arrayList.get(n3);
                    PassivatedBeansCache.this.cacheStore.removeState(new Long(passivatedSessionInfo.key));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Removed " + " passivated session: " + passivatedSessionInfo.key);
                    }
                    --n3;
                }
            }
            catch (Throwable throwable) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "[" + PassivatedBeansCache.this.cacheName + "]: Timer task got Exception:", throwable);
                }
            }
            finally {
                thread.setContextClassLoader(classLoader);
                PassivatedBeansCache.this.addedIdleBeanWork = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Timer Task completed");
                }
            }
        }
    }

    private class IdleBeanCleanerTimerTask
    extends TimerTask {
        Object lock;

        IdleBeanCleanerTimerTask() {
        }

        IdleBeanCleanerTimerTask(Object object) {
            this.lock = object;
        }

        public void run() {
            block5: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: IdleBeanCleanerTimer Task started");
                }
                if (PassivatedBeansCache.this.addedIdleBeanWork) {
                    return;
                }
                try {
                    ASyncPassivator aSyncPassivator = new ASyncPassivator();
                    ContainerWorkPool.addLast(aSyncPassivator);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Removal Work added");
                    }
                    PassivatedBeansCache.this.addedIdleBeanWork = true;
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.WARNING)) break block5;
                    _logger.log(Level.WARNING, "Cannot perform idle bean cleanup", exception);
                }
            }
        }
    }
}

