/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.EndPointInfo;
import com.sun.corba.ee.ActivationIDL.InvalidORBid;
import com.sun.corba.ee.ActivationIDL.LocatorPackage.ServerLocation;
import com.sun.corba.ee.ActivationIDL.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.ee.ActivationIDL.NoSuchEndPoint;
import com.sun.corba.ee.ActivationIDL.ORBAlreadyRegistered;
import com.sun.corba.ee.ActivationIDL.ORBPortInfo;
import com.sun.corba.ee.ActivationIDL.Repository;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.Server;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyActive;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyInstalled;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyUninstalled;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.ActivationIDL.ServerNotActive;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.ActivationIDL._ServerManagerImplBase;
import com.sun.corba.ee.internal.Activation.ProcessMonitorThread;
import com.sun.corba.ee.internal.Activation.ServerTableEntry;
import com.sun.corba.ee.internal.POA.BadServerIdHandler;
import com.sun.corba.ee.internal.POA.ForwardException;
import com.sun.corba.ee.internal.POA.POAORB;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ORB;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.ior.ObjectKey;
import com.sun.corba.ee.internal.ior.POAObjectKeyTemplate;
import com.sun.corba.ee.internal.orbutil.ORBClassLoader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class ServerManagerImpl
extends _ServerManagerImplBase
implements BadServerIdHandler {
    HashMap serverTable;
    Repository repository;
    ServerGIOP sgiop;
    int initialPort;
    POAORB orb;
    String dbDirName;
    boolean debug = false;
    private int serverStartupDelay;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    ServerManagerImpl(POAORB pOAORB, ServerGIOP serverGIOP, Repository repository, String string, boolean bl) {
        this.orb = pOAORB;
        this.sgiop = serverGIOP;
        this.repository = repository;
        this.dbDirName = string;
        this.debug = bl;
        this.initialPort = pOAORB.getServerGIOP().getBootstrapEndpoint(0).getPort();
        this.serverTable = new HashMap(256);
        this.serverStartupDelay = 1000;
        String string2 = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
        if (string2 != null) {
            try {
                this.serverStartupDelay = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BadServerIdHandler badServerIdHandler = null;
        if (pOAORB.getBadServerIdHandlerClass() == null) {
            badServerIdHandler = this;
        } else {
            try {
                Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ServerManagerImpl.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB};
                Object[] objectArray = new Object[]{pOAORB};
                Class clazz = ORBClassLoader.loadClass(pOAORB.getBadServerIdHandlerClass());
                Constructor constructor = clazz.getConstructor(classArray);
                badServerIdHandler = (BadServerIdHandler)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "", exception);
                throw new INITIALIZE("Error while creating BadServerIdHandler: " + exception.getMessage());
            }
        }
        pOAORB.setBadServerIdHandler(badServerIdHandler);
        pOAORB.connect(this);
        ProcessMonitorThread.start(this.serverTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(int n) throws ServerAlreadyActive, ServerNotRegistered, ServerHeldDown {
        block9: {
            ServerTableEntry serverTableEntry;
            Integer n2 = new Integer(n);
            HashMap hashMap = this.serverTable;
            synchronized (hashMap) {
                serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            }
            if (serverTableEntry != null && serverTableEntry.isActive()) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n + " failed because server is already active. " + "entry = " + serverTableEntry);
                }
                throw new ServerAlreadyActive(n);
            }
            try {
                serverTableEntry = this.getEntry(n);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n + " endpointType=" + "IIOP_CLEAR_TEXT" + " block=false");
                }
                ServerLocation serverLocation = this.locateServer(serverTableEntry, "IIOP_CLEAR_TEXT", false);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n + " found location " + serverLocation.hostname + " and activated it");
                }
            }
            catch (NoSuchEndPoint noSuchEndPoint) {
                LogWrap.logger.log(Level.WARNING, "", noSuchEndPoint);
                if (!this.debug) break block9;
                System.out.println("ServerManagerImpl: activate for server Id  threw NoSuchEndpoint exception, which was ignored");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(int n, Server server) throws ServerNotRegistered {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: active for server Id " + n + " called, but no such server is registered.");
                }
                throw new INTERNAL(1398079891, CompletionStatus.COMPLETED_NO);
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: active for server Id " + n + " called.  This server is now active.");
            }
            serverTableEntry.register(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoints(int n, String string, EndPointInfo[] endPointInfoArray) throws NoSuchEndPoint, ServerNotRegistered, ORBAlreadyRegistered {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: registerEndpoint for server Id " + n + " called, but no such server is registered.");
                }
                throw new INTERNAL(1398079891, CompletionStatus.COMPLETED_NO);
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: registerEndpoints for server Id " + n + " called.  This server is now active.");
            }
            serverTableEntry.registerPorts(string, endPointInfoArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getActiveServers() {
        Serializable serializable;
        int[] nArray = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry;
            serializable = new ArrayList<ServerTableEntry>(0);
            Iterator iterator = this.serverTable.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    serverTableEntry = (ServerTableEntry)this.serverTable.get(n);
                    if (!serverTableEntry.isValid() || !serverTableEntry.isActive()) continue;
                    ((ArrayList)serializable).add(serverTableEntry);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            nArray = new int[((ArrayList)serializable).size()];
            int n = 0;
            while (n < ((ArrayList)serializable).size()) {
                serverTableEntry = (ServerTableEntry)((ArrayList)serializable).get(n);
                nArray[n] = serverTableEntry.getServerId();
                ++n;
            }
        }
        if (this.debug) {
            serializable = new StringBuffer();
            int n = 0;
            while (n < nArray.length) {
                ((StringBuffer)serializable).append(' ');
                ((StringBuffer)serializable).append(nArray[n]);
                ++n;
            }
            System.out.println("ServerManagerImpl: getActiveServers returns" + ((StringBuffer)serializable).toString());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int n) throws ServerNotActive {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            block8: {
                ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.remove(n2);
                if (serverTableEntry == null) {
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n + " throws ServerNotActive.");
                    }
                    throw new ServerNotActive(n);
                }
                try {
                    serverTableEntry.destroy();
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n + " completed.");
                    }
                }
                catch (Exception exception) {
                    LogWrap.logger.log(Level.WARNING, "iiop.server_shutdown_failure", new Object[]{new Integer(n)});
                    LogWrap.logger.log(Level.WARNING, "", exception);
                    if (!this.debug) break block8;
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n + " threw exception " + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerTableEntry getEntry(int n) throws ServerNotRegistered {
        Integer n2 = new Integer(n);
        ServerTableEntry serverTableEntry = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (this.debug) {
                if (serverTableEntry == null) {
                    System.out.println("ServerManagerImpl: getEntry: no active server found.");
                } else {
                    System.out.println("ServerManagerImpl: getEntry:  active server found " + serverTableEntry + ".");
                }
            }
            if (serverTableEntry != null && !serverTableEntry.isValid()) {
                this.serverTable.remove(n2);
                serverTableEntry = null;
            }
            if (serverTableEntry == null) {
                ServerDef serverDef = this.repository.getServer(n);
                serverTableEntry = new ServerTableEntry(n, serverDef, this.initialPort, this.dbDirName, false, this.debug);
                this.serverTable.put(n2, serverTableEntry);
                serverTableEntry.activate();
            }
        }
        return serverTableEntry;
    }

    private ServerLocation locateServer(ServerTableEntry serverTableEntry, String string, boolean bl) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerLocation serverLocation = new ServerLocation();
        if (bl) {
            String string2;
            ORBPortInfo[] oRBPortInfoArray;
            try {
                oRBPortInfoArray = serverTableEntry.lookup(string);
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "iiop.server_held_down", new Object[]{new Integer(serverTableEntry.getServerId())});
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocation.hostname = string2 = this.orb.getServerEndpoint().getHostName();
            int n = oRBPortInfoArray != null ? oRBPortInfoArray.length : 0;
            serverLocation.ports = new ORBPortInfo[n];
            int n2 = 0;
            while (n2 < n) {
                serverLocation.ports[n2] = new ORBPortInfo(oRBPortInfoArray[n2].orbId, oRBPortInfoArray[n2].port);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocation.hostname + " ORBid  " + oRBPortInfoArray[n2].orbId + " Port " + oRBPortInfoArray[n2].port);
                }
                ++n2;
            }
        }
        return serverLocation;
    }

    private ServerLocationPerORB locateServerForORB(ServerTableEntry serverTableEntry, String string, boolean bl) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerLocationPerORB serverLocationPerORB = new ServerLocationPerORB();
        if (bl) {
            String string2;
            EndPointInfo[] endPointInfoArray;
            try {
                endPointInfoArray = serverTableEntry.lookupForORB(string);
            }
            catch (InvalidORBid invalidORBid) {
                LogWrap.logger.log(Level.WARNING, "", invalidORBid);
                throw invalidORBid;
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "iiop.server_held_down", new Object[]{new Integer(serverTableEntry.getServerId())});
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServerForORB: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocationPerORB.hostname = string2 = this.orb.getServerEndpoint().getHostName();
            int n = endPointInfoArray != null ? endPointInfoArray.length : 0;
            serverLocationPerORB.ports = new EndPointInfo[n];
            int n2 = 0;
            while (n2 < n) {
                serverLocationPerORB.ports[n2] = new EndPointInfo(endPointInfoArray[n2].endpointType, endPointInfoArray[n2].port);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocationPerORB.hostname + " endpointType  " + endPointInfoArray[n2].endpointType + " Port " + endPointInfoArray[n2].port);
                }
                ++n2;
            }
        }
        return serverLocationPerORB;
    }

    public String[] getORBNames(int n) throws ServerNotRegistered {
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n);
            return serverTableEntry.getORBList();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
            throw new ServerNotRegistered(n);
        }
    }

    private ServerTableEntry getRunningEntry(int n) throws ServerNotRegistered {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        try {
            ORBPortInfo[] oRBPortInfoArray = serverTableEntry.lookup("IIOP_CLEAR_TEXT");
        }
        catch (Exception exception) {
            return null;
        }
        return serverTableEntry;
    }

    public void install(int n) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyInstalled {
        ServerTableEntry serverTableEntry = this.getRunningEntry(n);
        if (serverTableEntry != null) {
            this.repository.install(n);
            serverTableEntry.install();
        }
    }

    public void uninstall(int n) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyUninstalled {
        ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(new Integer(n));
        if (serverTableEntry != null) {
            serverTableEntry = (ServerTableEntry)this.serverTable.remove(new Integer(n));
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n + " throws ServerNotActive.");
                }
                throw new ServerHeldDown(n);
            }
            serverTableEntry.uninstall();
        }
    }

    public ServerLocation locateServer(int n, String string) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n + " endpointType=" + string + " block=true");
        }
        return this.locateServer(serverTableEntry, string, true);
    }

    public ServerLocationPerORB locateServerForORB(int n, String string) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServerForORB called with  serverId=" + n + " orbId=" + string + " block=true");
        }
        return this.locateServerForORB(serverTableEntry, string, true);
    }

    public void handle(ObjectKey objectKey) throws ForwardException {
        IOR iOR = null;
        POAObjectKeyTemplate pOAObjectKeyTemplate = (POAObjectKeyTemplate)objectKey.getTemplate();
        int n = pOAObjectKeyTemplate.getServerId();
        String string = pOAObjectKeyTemplate.getORBId();
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n);
            ServerLocationPerORB serverLocationPerORB = this.locateServerForORB(serverTableEntry, string, true);
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle called for server id" + n + "  orbid  " + string);
            }
            int n2 = 0;
            EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
            int n3 = 0;
            while (n3 < endPointInfoArray.length) {
                if (endPointInfoArray[n3].endpointType.equals("IIOP_CLEAR_TEXT")) {
                    n2 = endPointInfoArray[n3].port;
                    break;
                }
                ++n3;
            }
            iOR = new IOR((ORB)this.orb, "IDL:org/omg/CORBA/Object:1.0", serverLocationPerORB.hostname, n2, objectKey);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "iiop.OBJECT_NOT_EXIST", exception);
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle throws OBJECT_NOT_EXIST");
            }
            throw new OBJECT_NOT_EXIST();
        }
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle throws ForwardException");
        }
        try {
            Thread.sleep(this.serverStartupDelay);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        throw new ForwardException(iOR);
    }

    public int getEndpoint(String string) throws NoSuchEndPoint {
        return this.sgiop.getServerPort(string);
    }

    public int getServerPortForType(ServerLocationPerORB serverLocationPerORB, String string) throws NoSuchEndPoint {
        EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
        int n = 0;
        while (n < endPointInfoArray.length) {
            if (endPointInfoArray[n].endpointType.equals(string)) {
                return endPointInfoArray[n].port;
            }
            ++n;
        }
        throw new NoSuchEndPoint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

