/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.security;

import com.sun.appserv.security.ProgrammaticLoginPermission;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebProgrammaticLogin;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProgrammaticLogin {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static ProgrammaticLoginPermission plLogin = new ProgrammaticLoginPermission("login");
    private static ProgrammaticLoginPermission plLogout = new ProgrammaticLoginPermission("logout");

    public Boolean login(final String string, final String string2) {
        if (!this.checkLoginPermission(string)) {
            return new Boolean(false);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LoginContextDriver.login(string, string2);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            logger.fine("Programmatic login failed: " + exception.toString());
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public Boolean login(final String string, final String string2, final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) {
        if (!this.checkLoginPermission(string)) {
            return new Boolean(false);
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WebProgrammaticLogin.login(string, string2, httpServletRequest, httpServletResponse);
            }
        });
        return bl;
    }

    public Boolean logout() {
        if (!this.checkLogoutPermission()) {
            return new Boolean(false);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LoginContextDriver.logout();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            logger.fine("Programmatic logout failed: " + exception.toString());
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public Boolean logout(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) {
        if (!this.checkLogoutPermission()) {
            return new Boolean(false);
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WebProgrammaticLogin.logout(httpServletRequest, httpServletResponse);
            }
        });
        return bl;
    }

    private boolean checkLoginPermission(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(plLogin);
            }
        }
        catch (Exception exception) {
            logger.warning("proglogin.noperm");
            return false;
        }
        logger.fine("ProgrammaticLogin.login() called for user: " + string);
        return true;
    }

    private boolean checkLogoutPermission() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(plLogout);
            }
        }
        catch (Exception exception) {
            logger.warning("prologout.noperm");
            return false;
        }
        logger.fine("ProgrammaticLogin.logout() called.");
        return true;
    }
}

