/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetMap;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.connector.nsapi.NSAPICertificatesValve;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIRequestStream;
import com.iplanet.ias.web.util.CookieTokenizer;
import com.iplanet.ias.web.util.I18NParseUtil;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringParser;

final class NSAPIRequest
extends HttpRequestBase {
    String[] _rqStrs;
    byte[][] _mbRqStrs;
    int[] _rqInts;
    int _iParamStrs;
    private String _jrouteId;
    private static final int REQ_REMOTE_ADDRESS = 0;
    private static final int REQ_PROTOCOL = 1;
    private static final int REQ_METHOD = 2;
    private static final int REQ_URI = 3;
    private static final int SERVER_NAME = 4;
    private static final int REQ_CONTENT_LENGTH = 5;
    private static final int REQ_COOKIE = 6;
    private static final int REQ_CONTENT_TYPE = 7;
    private static final int REQ_AUTH_TYPE = 8;
    private static final int REQ_ACCEPT_LANG = 9;
    private static final int REQ_CLIENT_CERT = 10;
    private static final int REQ_HTTPS_CIPHER = 11;
    private static final int REQ_AUTHORIZATION = 12;
    private static final int REQ_PROXY_JROUTE = 13;
    private static final int REQ_REMOTE_HOST = 14;
    private static final int REQ_ERROR_REQUEST_URI = 15;
    private static final int LAST_DEFINED_HEADER = 15;
    private static final int MB_REQ_QUERY_STRING = 0;
    private static final int MB_REQ_COOKIE = 1;
    private static final int REQ_SERVER_PORT = 0;
    private static final int REQ_IS_SECURE = 1;
    private static final int REQ_HTTPS_KEY_SIZE = 2;
    private static final int REQ_NATIVE_STREAM_SIZE = 3;
    private static final int REQ_ERROR_STATUS_CODE = 4;
    private static final String _match = ";jsessionid=";
    private StringParser _parser = new StringParser();
    private CookieTokenizer _cookieTokens = new CookieTokenizer();
    private static Logger _logger = null;
    private static boolean _debugLog;
    private boolean _headersLoaded = false;
    private boolean _localeParsed = false;
    private boolean _queryStringSet = false;

    public NSAPIRequest() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
    }

    public void initialize(String[] stringArray, byte[][] byArray, int[] nArray) {
        this._rqStrs = stringArray;
        this._mbRqStrs = byArray;
        this._rqInts = nArray;
        this.setupRequestFields();
    }

    public String getJrouteId() {
        return this._jrouteId;
    }

    public void addHeader(String string, String string2) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        super.addHeader(string, string2);
    }

    public void clearHeaders() {
        this._headersLoaded = true;
        super.clearHeaders();
    }

    public void addLocale(Locale locale) {
        if (!this._localeParsed) {
            this.parseAcceptLanguage();
        }
        super.addLocale(locale);
    }

    public void clearLocales() {
        this._localeParsed = true;
        super.clearLocales();
    }

    public void recycle() {
        super.recycle();
        this._rqStrs = null;
        this._mbRqStrs = null;
        this._rqInts = null;
        this._jrouteId = null;
        this._headersLoaded = false;
        this._localeParsed = false;
        this._queryStringSet = false;
        this._cookieTokens.reset();
    }

    public Locale getLocale() {
        if (!this._localeParsed) {
            this.parseAcceptLanguage();
        }
        return super.getLocale();
    }

    public Enumeration getLocales() {
        if (!this._localeParsed) {
            this.parseAcceptLanguage();
        }
        return super.getLocales();
    }

    public String getHeader(String string) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getHeader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getHeaders(String string) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        string = string.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.headers.get(string);
            if (arrayList != null && arrayList.size() > 0) {
                return this.parseHeaders(arrayList);
            }
        }
        return new Enumerator(HttpRequestBase.empty);
    }

    public Enumeration getHeaderNames() {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getHeaderNames();
    }

    private void parseAcceptLanguage() {
        int n;
        int n2;
        if (this._localeParsed) {
            return;
        }
        String string = this._rqStrs[9];
        this._localeParsed = true;
        if (string == null) {
            return;
        }
        TreeMap<Object, ArrayList<Locale>> treeMap = new TreeMap<Object, ArrayList<Locale>>();
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(9);
        }
        if (n3 >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = string.length();
            n = 0;
            while (n < n2) {
                char c = string.charAt(n);
                if (c != ' ' && c != '\t') {
                    stringBuffer.append(c);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        this._parser.setString(string);
        int n4 = this._parser.getLength();
        while ((n2 = this._parser.getIndex()) < n4) {
            Object object;
            n = this._parser.findChar(',');
            String string2 = this._parser.extract(n2, n).trim();
            this._parser.advance();
            double d = 1.0;
            int n5 = string2.indexOf(";q=");
            if (n5 >= 0) {
                try {
                    d = Double.parseDouble(string2.substring(n5 + 3));
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                string2 = string2.substring(0, n5);
            }
            if (d < 5.0E-5 || "*".equals(string2)) continue;
            String string3 = null;
            Object object2 = null;
            String string4 = null;
            int n6 = string2.indexOf(45);
            if (n6 < 0) {
                string3 = string2;
                object2 = "";
                string4 = "";
            } else {
                string3 = string2.substring(0, n6);
                object2 = string2.substring(n6 + 1);
                int n7 = ((String)object2).indexOf(45);
                if (n7 > 0) {
                    object = ((String)object2).substring(0, n7);
                    string4 = ((String)object2).substring(n7 + 1);
                    object2 = object;
                } else {
                    string4 = "";
                }
            }
            Locale locale = new Locale(string3, (String)object2, string4);
            object = new Double(-d);
            ArrayList<Locale> arrayList = (ArrayList<Locale>)treeMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Locale>();
                treeMap.put(object, arrayList);
            }
            arrayList.add(locale);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double d = (Double)iterator.next();
            ArrayList arrayList = (ArrayList)treeMap.get(d);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Locale locale = (Locale)iterator2.next();
                super.addLocale(locale);
            }
        }
    }

    private void setJrouteId(String string) {
        this._jrouteId = string;
    }

    private void setupRequestFields() {
        X509Certificate[] x509CertificateArray;
        WebModule webModule;
        int n;
        boolean bl;
        int n2 = this._rqStrs.length;
        this.setServerPort(this._rqInts[0]);
        boolean bl2 = bl = this._rqInts[1] == 1;
        if (bl) {
            this.setAttribute("javax.servlet.request.cipher_suite", this._rqStrs[11]);
            this.setAttribute("javax.servlet.request.key_size", new Integer(this._rqInts[2]));
        }
        if (this._rqStrs[12] != null) {
            this.setAuthorization(this._rqStrs[12]);
        }
        if (this._rqStrs[13] != null) {
            this.setJrouteId(this._rqStrs[13]);
        }
        int n3 = 16;
        while (this._rqStrs[n3] != null) {
            n3 += 2;
        }
        this._headersLoaded = false;
        this._localeParsed = false;
        this._iParamStrs = n3 + 1;
        this.setRemoteAddr(this._rqStrs[0]);
        this.setRemoteHost(this._rqStrs[14]);
        this.setProtocol(this._rqStrs[1]);
        this.setMethod(this._rqStrs[2]);
        String string = this._rqStrs[3];
        int n4 = string.indexOf(_match);
        if (n4 >= 0) {
            String string2;
            String string3 = string.substring(n4 + _match.length());
            n = string3.indexOf(59);
            if (n >= 0) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n);
            } else {
                string2 = string3;
                string3 = "";
            }
            int n5 = string2.indexOf(58);
            if (n5 > 0) {
                string2 = string2.substring(0, n5);
            }
            this.setRequestedSessionId(string2);
            this.setRequestedSessionURL(true);
            string = string.substring(0, n4) + string3;
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
        this.setRequestURI(string);
        int n6 = -1;
        if (this._rqStrs[5] != null) {
            try {
                n = this._rqStrs[5].indexOf(44);
                n6 = n > 0 ? Integer.parseInt(this._rqStrs[5].substring(0, n).trim()) : Integer.parseInt(this._rqStrs[5]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setContentLength(n6);
        }
        this.setStream((InputStream)((Object)new NSAPIRequestStream((NSAPIConnector)this.connector, n6)));
        if (this._rqStrs[7] != null) {
            this.setContentType(this._rqStrs[7]);
        }
        if (!(webModule = (WebModule)this.context).getEncodeCookies()) {
            this.tokenizeMultibyteCookies();
        } else {
            this._cookieTokens.tokenize(this._rqStrs[6]);
        }
        n3 = 0;
        while (n3 < this._cookieTokens.getNumTokens() - 1) {
            if (this._cookieTokens.tokenAt(n3).equals("JSESSIONID") && !this.isRequestedSessionIdFromCookie()) {
                this.setRequestedSessionId(this._cookieTokens.tokenAt(n3 + 1));
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionURL(false);
            }
            n3 += 2;
        }
        if (this._rqStrs[4] != null) {
            int n7 = this._rqStrs[4].indexOf(58);
            if (n7 > 0) {
                this.setServerName(this._rqStrs[4].substring(0, n7).trim());
            } else {
                this.setServerName(this._rqStrs[4]);
            }
        }
        if (this._rqInts[4] != -1) {
            this.setAttribute("javax.servlet.error.status_code", new Integer(this._rqInts[4]));
        }
        if (this._rqStrs[15] != null) {
            this.setAttribute("javax.servlet.error.request_uri", this._rqStrs[15]);
        }
        if (this._rqStrs[10] != null && (x509CertificateArray = new X509Certificate[]{NSAPICertificatesValve.getX509Certificate(this._rqStrs[10])})[0] != null) {
            this.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
        }
        if (bl) {
            this.setSecure(true);
        } else {
            this.setSecure(false);
        }
    }

    private Enumeration parseHeaders(ArrayList arrayList) {
        int n = arrayList.size();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            stringBuffer.setLength(0);
            String string = (String)arrayList.get(n2);
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n4);
                if (c == ',') {
                    if (!bl) {
                        String string2 = this.trimHeaderString(stringBuffer);
                        if (string2 != null) {
                            vector.add(string2);
                        }
                        stringBuffer.setLength(0);
                    } else {
                        stringBuffer.append(c);
                    }
                } else {
                    if (c == '\"') {
                        bl = !bl;
                    }
                    stringBuffer.append(c);
                }
                ++n4;
            }
            String string3 = this.trimHeaderString(stringBuffer);
            if (string3 != null) {
                vector.add(string3);
            }
            ++n2;
        }
        return vector.elements();
    }

    private String trimHeaderString(StringBuffer stringBuffer) {
        String string = stringBuffer.toString().trim();
        int n = string.length();
        if (n > 0) {
            int n2 = n - 1;
            if (string.charAt(0) == '\"' && string.charAt(n2) == '\"') {
                string = string.substring(1, n2);
                n -= 2;
            }
            if (n > 0) {
                return string;
            }
        }
        return null;
    }

    private void parseCommas(Vector vector, String string) {
        if ((string = string.trim()).equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.length() == 0) continue;
            vector.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            if (this.cookies.size() < 1) {
                int n = 0;
                Cookie cookie = null;
                int n2 = this._cookieTokens.getNumTokens();
                int n3 = 0;
                while (n3 + 1 < n2) {
                    String string;
                    String string2;
                    WebModule webModule = (WebModule)this.context;
                    if (webModule.getEncodeCookies()) {
                        string2 = RequestUtil.URLDecode(this._cookieTokens.tokenAt(n3), "UTF-8");
                        string = RequestUtil.URLDecode(this._cookieTokens.tokenAt(n3 + 1), "UTF-8");
                    } else {
                        string2 = this._cookieTokens.tokenAt(n3);
                        string = this._cookieTokens.tokenAt(n3 + 1);
                    }
                    if (string2.charAt(0) == '$') {
                        if (string2.equalsIgnoreCase("$Version")) {
                            n = string.charAt(0) - 48;
                        } else if (cookie != null) {
                            if (string2.equalsIgnoreCase("$Path")) {
                                cookie.setPath(string);
                            } else if (string2.equalsIgnoreCase("$Domain")) {
                                cookie.setDomain(string);
                            }
                        }
                    } else {
                        cookie = new Cookie(string2, string);
                        cookie.setVersion(n);
                        this.cookies.add(cookie);
                    }
                    n3 += 2;
                }
            }
            if (this.cookies.size() < 1) {
                return null;
            }
            Cookie[] cookieArray = new Cookie[this.cookies.size()];
            return this.cookies.toArray(cookieArray);
        }
    }

    public String getQueryString() {
        if (!this._queryStringSet && this._mbRqStrs[0] != null) {
            try {
                this.setQueryString(new String(this._mbRqStrs[0], "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                _logger.log(Level.WARNING, "nsapi_req.getqueryString.exception", unsupportedEncodingException);
            }
            this._queryStringSet = true;
        }
        return this.queryString;
    }

    protected void parseParameters() {
        int n;
        String string;
        if (this.parsed) {
            return;
        }
        if (!this._queryStringSet) {
            this.getQueryString();
        }
        if ((string = this.getCharacterEncoding()) != null) {
            if (_debugLog) {
                _logger.fine("Using encoding from getCharacterEncoding(): " + string);
            }
            this.parseMultiByteParameters();
            this.parseSSIParameters();
            return;
        }
        WebModule webModule = (WebModule)this.context;
        LocaleCharsetMap[] localeCharsetMapArray = webModule.getLocaleCharsetMap();
        String string2 = webModule.getFormHintField();
        if (string2 == null) {
            if (localeCharsetMapArray != null && (string = I18NParseUtil.getLocaleCharsetEncoding(this, localeCharsetMapArray)) != null) {
                try {
                    this.setCharacterEncoding(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.parseMultiByteParameters();
            this.parseSSIParameters();
            return;
        }
        ParameterMap parameterMap = this.parameters;
        if (parameterMap == null) {
            parameterMap = new ParameterMap();
        }
        parameterMap.setLocked(false);
        String string3 = this.getContentType();
        if (string3 == null) {
            string3 = "";
        }
        if ((n = string3.indexOf(59)) >= 0) {
            string3 = string3.substring(0, n).trim();
        }
        try {
            byte[] byArray = null;
            if ("POST".equals(this.getMethod()) && this.getContentLength() > 0 && this.stream == null && "application/x-www-form-urlencoded".equals(string3)) {
                int n2 = this.getContentLength();
                int n3 = 0;
                byArray = new byte[this.getContentLength()];
                ServletInputStream servletInputStream = this.getInputStream();
                while (n3 < n2) {
                    int n4 = servletInputStream.read(byArray, n3, n2 - n3);
                    n3 += n4;
                }
                servletInputStream.close();
            }
            if ((string = I18NParseUtil.parseParametersUsingLCInfo(parameterMap, this._mbRqStrs[0], byArray, localeCharsetMapArray, string2, this)) != null) {
                this.setCharacterEncoding(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _logger.log(Level.WARNING, "nsapi_req.parseparam.unsupported_enc", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "nsapi_req.parseparam.ioexception", iOException);
        }
        parameterMap.setLocked(true);
        this.parsed = true;
        this.parameters = parameterMap;
        this.parseSSIParameters();
    }

    protected int getNativeStreamSize() {
        return this._rqInts[3];
    }

    public String getScheme() {
        return ((NSAPIConnector)this.connector).getScheme();
    }

    private void parseSSIParameters() {
        if (this.parameters == null) {
            this.parameters = new ParameterMap();
        }
        this.parameters.setLocked(false);
        int n = this._iParamStrs;
        while (n < this._rqStrs.length) {
            String[] stringArray = null;
            String[] stringArray2 = (String[])this.parameters.get(this._rqStrs[n]);
            if (stringArray2 == null) {
                stringArray = new String[1];
            } else {
                stringArray = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            }
            stringArray[stringArray.length - 1] = this._rqStrs[n + 1];
            this.parameters.put(this._rqStrs[n], stringArray);
            n += 2;
        }
        this.parameters.setLocked(true);
    }

    private void loadHeaders() {
        if (!this._headersLoaded) {
            int n = 16;
            while (this._rqStrs[n] != null) {
                super.addHeader(this._rqStrs[n], this._rqStrs[n + 1]);
                n += 2;
            }
            this._headersLoaded = true;
        }
    }

    private void parseMultiByteParameters() {
        int n;
        if (this.parsed) {
            return;
        }
        ParameterMap parameterMap = this.parameters;
        if (parameterMap == null) {
            parameterMap = new ParameterMap();
        }
        parameterMap.setLocked(false);
        String string = this.getCharacterEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        try {
            if (this._mbRqStrs[0] != null) {
                RequestUtil.parseParameters((Map)parameterMap, this._mbRqStrs[0], string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string2 = this.getContentType();
        if (string2 == null) {
            string2 = "";
        }
        string2 = (n = string2.indexOf(59)) >= 0 ? string2.substring(0, n).trim() : string2.trim();
        if ("POST".equals(this.getMethod()) && this.getContentLength() > 0 && this.stream == null && "application/x-www-form-urlencoded".equals(string2)) {
            try {
                int n2 = this.getContentLength();
                int n3 = 0;
                byte[] byArray = new byte[this.getContentLength()];
                ServletInputStream servletInputStream = this.getInputStream();
                while (n3 < n2) {
                    int n4 = servletInputStream.read(byArray, n3, n2 - n3);
                    if (n4 < 0) break;
                    n3 += n4;
                }
                servletInputStream.close();
                if (n3 < n2) {
                    throw new RuntimeException(RequestBase.sm.getString("httpRequestBase.contentLengthMismatch"));
                }
                RequestUtil.parseParameters((Map)parameterMap, byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                throw new RuntimeException(RequestBase.sm.getString("httpRequestBase.contentReadFail") + iOException.getMessage());
            }
        }
        parameterMap.setLocked(true);
        this.parsed = true;
        this.parameters = parameterMap;
    }

    private void tokenizeMultibyteCookies() {
        block4: {
            Object object;
            LocaleCharsetMap[] localeCharsetMapArray;
            if (this._mbRqStrs[1] == null) break block4;
            String string = this.getCharacterEncoding();
            if (string == null && (localeCharsetMapArray = ((WebModule)(object = (WebModule)this.context)).getLocaleCharsetMap()) != null) {
                string = I18NParseUtil.getLocaleCharsetEncoding(this, localeCharsetMapArray);
            }
            if (string == null) {
                this._cookieTokens.tokenize(this._rqStrs[6]);
                return;
            }
            try {
                object = new String(this._mbRqStrs[1], string);
                this._cookieTokens.tokenize((String)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._cookieTokens.tokenize(this._rqStrs[6]);
            }
        }
    }
}

