/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LongArrayList
implements List {
    long[] data;
    int minIndex;
    int size;
    double growFactor;

    public LongArrayList() {
        this(6, 0.5);
    }

    public LongArrayList(int n) {
        this(n, 0.5);
    }

    public LongArrayList(int n, double d) {
        this.data = new long[n];
        this.growFactor = d;
    }

    private LongArrayList(long[] lArray, int n, int n2, double d) {
        this.data = lArray;
        this.minIndex = n;
        this.size = n2;
        this.growFactor = d;
    }

    public void add(int n, Object object) {
        long l = (Long)object;
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = l;
        ++this.size;
    }

    public void add(int n, long l) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = l;
        ++this.size;
    }

    public boolean add(Object object) {
        long l = (Long)object;
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = l;
        return true;
    }

    public boolean add(long l) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = l;
        return true;
    }

    public boolean addAll(Collection collection) {
        int n = collection.size();
        this.makeRoom(n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.data[this.size++] = (Long)iterator.next();
        }
        return n > 0;
    }

    public boolean addAll(LongArrayList longArrayList) {
        int n = longArrayList.size();
        this.makeRoom(n);
        LongIterator longIterator = longArrayList.longIterator();
        while (longIterator.hasNext()) {
            this.data[this.size++] = longIterator.nextLong();
        }
        return n > 0;
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = collection.size();
        this.makeRoom(n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.data[n++] = (Long)iterator.next();
        }
        this.size += n2;
        return n2 > 0;
    }

    public boolean addAll(int n, LongArrayList longArrayList) {
        int n2 = longArrayList.size();
        this.makeRoom(n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        LongIterator longIterator = longArrayList.longIterator();
        while (longIterator.hasNext()) {
            this.data[n++] = longIterator.nextLong();
        }
        this.size += n2;
        return n2 > 0;
    }

    public void clear() {
        this.size = 0;
        this.data = new long[6];
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean contains(long l) {
        return this.indexOf(l) >= 0;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongArrayList longArrayList) {
        LongIterator longIterator = longArrayList.longIterator();
        while (longIterator.hasNext()) {
            if (this.contains(longIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] lArray) {
        int n = lArray.length;
        while (n > 0) {
            if (this.contains(lArray[--n])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Object get(int n) {
        return new Long(this.data[n]);
    }

    public long getValue(int n) {
        return this.data[n];
    }

    public int hashCode() {
        long l = 1L;
        int n = 0;
        while (n < this.size) {
            l = 31L * l + this.data[n];
            ++n;
        }
        return (int)l;
    }

    public int indexOf(Object object) {
        long l = (Long)object;
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(long l) {
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Object object) {
        long l = (Long)object;
        int n = this.size - 1;
        while (n >= 0) {
            if (this.data[n] == l) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        int n = this.size - 1;
        while (n >= 0) {
            if (this.data[n] == l) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new LongIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new LongIterator(n);
    }

    public Object remove(int n) {
        long l = this.data[n];
        if (n < this.size - 1) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        --this.size;
        return new Long(l);
    }

    public long removeLong(int n) {
        long l = this.data[n];
        if (n < this.size - 1) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        --this.size;
        return l;
    }

    public boolean remove(Object object) {
        long l = (Long)object;
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l && n < this.size - 1) {
                System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
                --this.size;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean remove(long l) {
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == l && n < this.size - 1) {
                System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
                --this.size;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(LongArrayList longArrayList) {
        boolean bl = false;
        LongIterator longIterator = longArrayList.longIterator();
        while (longIterator.hasNext()) {
            if (!this.remove(longIterator.nextLong())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(long[] lArray) {
        boolean bl = false;
        int n = 0;
        while (n < lArray.length) {
            if (this.remove(lArray[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        return false;
    }

    public boolean retainAll(LongArrayList longArrayList) {
        return false;
    }

    public boolean retainAll(long[] lArray) {
        return false;
    }

    public Object set(int n, Object object) {
        long l = this.data[n];
        this.data[n] = (Long)object;
        return new Long(l);
    }

    public long set(int n, long l) {
        long l2 = this.data[n];
        this.data[n] = l;
        return l2;
    }

    public int size() {
        return this.size;
    }

    public List subList(int n, int n2) {
        return new LongArrayList(this.data, n, n2, this.growFactor);
    }

    public Object[] toArray() {
        Object[] objectArray = new Long[this.size];
        int n = 0;
        while (n < this.size) {
            objectArray[n] = new Long(this.data[n]);
            ++n;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = new Long[this.size];
        int n = 0;
        while (n < this.size) {
            objectArray2[n] = new Long(this.data[n]);
            ++n;
        }
        return objectArray2;
    }

    protected void makeRoom(int n) {
        if (n + this.size >= this.data.length) {
            long[] lArray = this.data;
            int n2 = this.size + n + (int)((double)this.size * this.growFactor) + 1;
            this.data = new long[n2];
            System.arraycopy(lArray, 0, this.data, 0, lArray.length);
        }
    }

    public Iterator iterator() {
        return new LongIterator(0);
    }

    public LongIterator longIterator() {
        return new LongIterator(0);
    }

    public void print() {
        System.out.print("Data (size: " + this.size + "): ");
        int n = 0;
        while (n < this.size) {
            System.out.print(" " + this.data[n]);
            ++n;
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        LongArrayList longArrayList = new LongArrayList();
        int n = 0;
        while (n < 15) {
            longArrayList.add(n);
            n += 2;
        }
        int n2 = 1;
        while (n2 < 15) {
            longArrayList.add(n2);
            n2 += 2;
        }
    }

    private class LongIterator
    implements ListIterator {
        int startIndex;
        int index = 0;

        LongIterator(int n) {
            this.startIndex = n;
        }

        public void add(Object object) {
        }

        public boolean hasPrevious() {
            return this.index > this.startIndex;
        }

        public boolean hasNext() {
            return this.index < LongArrayList.this.size;
        }

        public Object previous() {
            return new Long(LongArrayList.this.data[--this.index]);
        }

        public int previousIndex() {
            return this.index;
        }

        public Object next() {
            return new Long(LongArrayList.this.data[this.index++]);
        }

        public int nextIndex() {
            return this.index;
        }

        public long previousLong() {
            return LongArrayList.this.data[--this.index];
        }

        public long nextLong() {
            return LongArrayList.this.data[this.index++];
        }

        public void remove() {
        }

        public void set(Object object) {
        }
    }
}

