/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.collection.DListNode;
import com.iplanet.ias.util.collection.DListNodeFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class DList
implements List,
DListNodeFactory {
    protected DListNode first;
    protected DListNode last;
    protected int size = 0;
    protected DListNodeFactory nodeFactory;

    public DList() {
        this.first = new DListNode(null);
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = this;
    }

    public DList(DListNode dListNode, DListNode dListNode2, DListNodeFactory dListNodeFactory) {
        this.initDListWithNodes(dListNode, dListNode2, dListNodeFactory);
    }

    protected void initDListWithNodes(DListNode dListNode, DListNode dListNode2, DListNodeFactory dListNodeFactory) {
        this.first = dListNode;
        this.first.next = this.last = dListNode2;
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = dListNodeFactory == null ? this : dListNodeFactory;
    }

    public DList(DListNodeFactory dListNodeFactory) {
        this.first = new DListNode(null);
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = dListNodeFactory;
    }

    private DList(DListNode dListNode, DListNode dListNode2, int n, DListNodeFactory dListNodeFactory) {
        this.first = dListNode;
        this.last = dListNode2;
        this.size = n;
        this.nodeFactory = dListNodeFactory;
    }

    public void add(int n, Object object) {
        this.insertAt(n, object);
        ++this.size;
    }

    public boolean add(Object object) {
        this.last.insertBefore(this.nodeFactory.createDListNode(object));
        ++this.size;
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            this.add(iterator.next());
            bl = true;
        }
        this.size += collection.size();
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        DListNode dListNode;
        DListNode dListNode2 = this.getDListNodeAt(n);
        Iterator iterator = collection.iterator();
        boolean bl = iterator.hasNext();
        DListNode dListNode3 = dListNode = new DListNode(null);
        while (iterator.hasNext()) {
            dListNode3.insertAfter(this.nodeFactory.createDListNode(iterator.next()));
            dListNode3 = dListNode3.next;
        }
        if (dListNode != dListNode3) {
            dListNode2.prev.next = dListNode.next;
            dListNode2.prev = dListNode3;
            dListNode.next.prev = dListNode2;
            dListNode3.next = dListNode2;
        }
        this.size += collection.size();
        return bl;
    }

    public void clear() {
        this.first.next = this.last;
        this.last.prev = this.first;
        this.size = 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.indexOf(e) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.size()) {
                return false;
            }
            Object object2 = null;
            Object var4_4 = null;
            DListNode dListNode = this.first;
            int n = 0;
            while (n < this.size) {
                object2 = dListNode.next.object;
                var4_4 = list.get(n);
                if (!object2.equals(var4_4)) {
                    return false;
                }
                dListNode = dListNode.next;
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        DListNode dListNode = this.first;
        Object object = null;
        int n2 = 0;
        while (n2 < this.size) {
            object = dListNode.next.object;
            n = 31 * n + (object == null ? 0 : object.hashCode());
            dListNode = dListNode.next;
            ++n2;
        }
        return n;
    }

    public Object get(int n) {
        DListNode dListNode = this.getDListNodeAt(n);
        return dListNode == null ? null : dListNode.object;
    }

    public int indexOf(Object object) {
        int n = 0;
        DListNode dListNode = this.first.next;
        while (dListNode != this.last) {
            if (dListNode.object.equals(object)) {
                return n;
            }
            ++n;
            dListNode = dListNode.next;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size > 0;
    }

    public Iterator iterator() {
        return new DListIterator(this.first, this.last, false, 0);
    }

    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        DListNode dListNode = this.last.prev;
        while (dListNode != this.first) {
            if (dListNode.object.equals(object)) {
                return n;
            }
            --n;
            dListNode = dListNode.prev;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new DListIterator(this.first, this.last, true, 0);
    }

    public ListIterator listIterator(int n) {
        return new DListIterator(this.first, this.last, true, n);
    }

    public Object remove(int n) {
        DListNode dListNode = this.getDListNodeAt(n);
        dListNode.delink();
        --this.size;
        Object object = dListNode.object;
        this.destroyDListNode(dListNode);
        return object;
    }

    public boolean remove(Object object) {
        DListNode dListNode = this.getDListNode(object);
        if (dListNode == null) {
            return false;
        }
        dListNode.delink();
        this.destroyDListNode(dListNode);
        --this.size;
        return true;
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            --this.size;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        DListNode dListNode = this.first;
        DListNode dListNode2 = null;
        while (dListNode.next != this.last) {
            dListNode2 = dListNode.next;
            if (collection.contains(dListNode2.object)) {
                dListNode2.delink();
                this.destroyDListNode(dListNode2);
                --this.size;
                bl = true;
                continue;
            }
            dListNode = dListNode.next;
        }
        return bl;
    }

    public Object set(int n, Object object) {
        DListNode dListNode = this.getDListNodeAt(n);
        Object object2 = dListNode == null ? null : dListNode.object;
        dListNode.object = object;
        return object2;
    }

    public DListNode insertAt(int n, Object object) {
        int n2;
        if (n < 0 || n >= this.size) {
            return null;
        }
        int n3 = this.size >> 1;
        DListNode dListNode = null;
        if (n <= n3) {
            dListNode = this.first.next;
            n2 = 0;
            while (n2 < n) {
                dListNode = dListNode.next;
                ++n2;
            }
        } else {
            n = this.size - n - 1;
            dListNode = this.last.prev;
            n2 = 0;
            while (n2 < n) {
                dListNode = dListNode.prev;
                ++n2;
            }
        }
        DListNode dListNode2 = this.nodeFactory.createDListNode(object);
        dListNode.insertBefore(dListNode2);
        ++this.size;
        return dListNode2;
    }

    public int size() {
        return this.size;
    }

    public List subList(int n, int n2) {
        System.out.println("subList(" + n + ", " + n2 + ")");
        DListNode dListNode = this.getDListNodeAt(n);
        System.out.println("nodeAt(" + n + "): " + dListNode.object);
        DListNode dListNode2 = this.getDListNodeAt(n2);
        System.out.println("nodeAt(" + n2 + "): " + dListNode2.object);
        return new DList(dListNode.prev, dListNode2, n2 - n, this.nodeFactory);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        DListNode dListNode = this.first.next;
        while (dListNode != this.last) {
            objectArray[n++] = dListNode.object;
            dListNode = dListNode.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        DListNode dListNode = this.first.next;
        while (dListNode != this.last) {
            objectArray[n++] = dListNode.object;
            dListNode = dListNode.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public DListNode createDListNode(Object object) {
        return new DListNode(object);
    }

    public void destroyDListNode(DListNode dListNode) {
    }

    public DListNodeFactory getDListNodeFactory() {
        return this.nodeFactory;
    }

    public void setDListNodeFactory(DListNodeFactory dListNodeFactory) {
        this.nodeFactory = dListNodeFactory;
    }

    public void addAsFirstNode(DListNode dListNode) {
        DListNode dListNode2;
        dListNode.next = dListNode2 = this.first.next;
        dListNode.prev = this.first;
        dListNode2.prev = this.first.next = dListNode;
        ++this.size;
    }

    public DListNode addAsFirstObject(Object object) {
        DListNode dListNode = this.nodeFactory.createDListNode(object);
        this.addAsFirstNode(dListNode);
        return dListNode;
    }

    public void addAsLastNode(DListNode dListNode) {
        DListNode dListNode2 = this.last.prev;
        dListNode.next = this.last;
        dListNode.prev = dListNode2;
        dListNode2.next = this.last.prev = dListNode;
        ++this.size;
    }

    public DListNode addAsLastObject(Object object) {
        DListNode dListNode = this.nodeFactory.createDListNode(object);
        this.addAsLastNode(dListNode);
        return dListNode;
    }

    public DListNode delinkFirstNode() {
        if (this.size > 0) {
            DListNode dListNode = this.first.next;
            dListNode.delink();
            --this.size;
            return dListNode;
        }
        return null;
    }

    public Object removeFirstObject() {
        DListNode dListNode = this.delinkFirstNode();
        if (dListNode == null) {
            return null;
        }
        Object object = dListNode.object;
        this.destroyDListNode(dListNode);
        return object;
    }

    public DListNode delinkLastNode() {
        if (this.size > 0) {
            DListNode dListNode = this.last.prev;
            dListNode.delink();
            --this.size;
            return dListNode;
        }
        return null;
    }

    public Object removeLastObject() {
        DListNode dListNode = this.delinkLastNode();
        if (dListNode == null) {
            return null;
        }
        Object object = dListNode.object;
        this.destroyDListNode(dListNode);
        return object;
    }

    public DListNode getDListNode(Object object) {
        DListNode dListNode = this.first.next;
        while (dListNode != this.last) {
            if (dListNode.object.equals(object)) {
                return dListNode;
            }
            dListNode = dListNode.next;
        }
        return null;
    }

    public void delink(DListNode dListNode) {
        dListNode.delink();
        --this.size;
    }

    public DListNode getDListNodeAt(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("DList size: " + this.size + "; index: " + n);
        }
        int n2 = this.size >> 1;
        DListNode dListNode = null;
        if (n <= n2) {
            dListNode = this.first.next;
            int n3 = 0;
            while (n3 < n) {
                dListNode = dListNode.next;
                ++n3;
            }
        } else {
            n = this.size - n - 1;
            dListNode = this.last.prev;
            int n4 = 0;
            while (n4 < n) {
                dListNode = dListNode.prev;
                ++n4;
            }
        }
        return dListNode;
    }

    public DListNode getFirstDListNode() {
        return this.size == 0 ? null : this.first.next;
    }

    public DListNode getLastDListNode() {
        return this.size == 0 ? null : this.last.prev;
    }

    public DListNode getNextNode(DListNode dListNode) {
        DListNode dListNode2 = dListNode.next;
        return dListNode2 == this.last ? null : dListNode2;
    }

    public DListNode getPreviousNode(DListNode dListNode) {
        DListNode dListNode2 = dListNode.prev;
        return dListNode2 == this.first ? null : dListNode2;
    }

    public Iterator nodeIterator() {
        return new DListIterator(this.first, this.last, true, 0);
    }

    private class DListIterator
    implements ListIterator {
        DListNode firstNode;
        DListNode lastNode;
        DListNode currentNode;
        boolean toReturnNode;
        int currentIndex = -1;

        DListIterator(DListNode dListNode, DListNode dListNode2, boolean bl, int n) {
            this.firstNode = this.currentNode = dListNode;
            this.lastNode = dListNode2;
            this.toReturnNode = bl;
            int n2 = 0;
            while (n2 < n) {
                this.currentNode = this.currentNode.next;
                ++n2;
            }
            this.currentIndex = n;
        }

        DListIterator(int n, int n2, boolean bl, int n3) {
            this.firstNode = this.currentNode = this.firstNode;
            this.lastNode = DList.this.getDListNodeAt(n2);
            this.toReturnNode = bl;
            int n4 = 0;
            while (n4 < n3) {
                this.currentNode = this.currentNode.next;
                ++n4;
            }
            this.currentIndex = n3;
        }

        public void add(Object object) {
            this.currentNode.insertAfter(DList.this.nodeFactory.createDListNode(object));
        }

        public boolean hasNext() {
            return this.currentNode.next != this.lastNode;
        }

        public boolean hasPrevious() {
            return this.currentNode != this.firstNode;
        }

        public Object next() {
            if (this.currentNode.next == this.lastNode) {
                throw new NoSuchElementException("No next after this element");
            }
            this.currentNode = this.currentNode.next;
            ++this.currentIndex;
            return this.toReturnNode ? this.currentNode : this.currentNode.object;
        }

        public int nextIndex() {
            return this.currentIndex + 1;
        }

        public Object previous() {
            if (this.currentNode == this.firstNode) {
                throw new NoSuchElementException("No previous before this element");
            }
            DListNode dListNode = this.currentNode;
            this.currentNode = this.currentNode.prev;
            --this.currentIndex;
            return this.toReturnNode ? dListNode : dListNode.object;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("list.remove() not supported by DList iterator....");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("list.remove() not supported by DList iterator....");
        }
    }
}

