/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache.test;

import com.iplanet.ias.util.cache.BucketMap;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BucketMapTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] keys;
    private int maxKeys;
    private int maxLoop;

    public BucketMapTest(int n, int n2) {
        this.maxKeys = n;
        this.maxLoop = n2;
        this.keys = new String[n];
        int n3 = 0;
        while (n3 < n) {
            this.keys[n3] = "" + n3;
            ++n3;
        }
    }

    public void testBucketMap() {
        int n = 0;
        n = this.maxKeys * 100 / 89;
        BucketMap bucketMap = new BucketMap(n);
        int n2 = 0;
        while (n2 < this.maxKeys) {
            bucketMap.putEntry(this.keys[n2], this.keys[n2]);
            ++n2;
        }
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.maxLoop) {
            l = System.currentTimeMillis();
            int n4 = 0;
            while (n4 < this.maxKeys) {
                String string = this.keys[n4];
                if (!bucketMap.getEntry(string).equals(string)) {
                    System.err.println("Error: Key: " + string);
                    _logger.log(Level.WARNING, "iplanet_util.lookup_fail", string);
                }
                ++n4;
            }
            l2 = System.currentTimeMillis();
            _logger.log(Level.FINE, "ConcurrentMap lookup took: " + (double)(l2 - l) / 1000.0 + " seconds.");
            d += (double)(l2 - l);
            ++n3;
        }
        _logger.log(Level.FINE, "Average Cache lookup took: " + d / (double)this.maxLoop / 1000.0 + " seconds.");
        bucketMap = null;
    }

    public static void main(String[] stringArray) {
        BucketMapTest bucketMapTest = new BucketMapTest(200000, 10);
        bucketMapTest.testBucketMap();
    }
}

