/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache;

import com.iplanet.ias.util.cache.Bucket;
import com.iplanet.ias.util.cache.Cache;

public class BucketMap
implements Cache {
    private int maxBuckets;
    private Bucket[] buckets;
    private int size;

    public BucketMap(int n) {
        this.maxBuckets = n;
        this.buckets = new Bucket[n];
        int n2 = 0;
        while (n2 < n) {
            this.buckets[n2] = new Bucket();
            ++n2;
        }
        this.size = 0;
    }

    public Bucket getBucket(Object object) {
        int n = (Integer.MAX_VALUE & object.hashCode()) % this.maxBuckets;
        return this.buckets[n];
    }

    public Bucket getBucket(int n) {
        return this.buckets[(Integer.MAX_VALUE & n) % this.maxBuckets];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Bucket bucket = this.buckets[n2];
        synchronized (bucket) {
            return this.buckets[n2].contains(object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getEntry(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Bucket bucket = this.buckets[n2];
        synchronized (bucket) {
            return this.buckets[n2].getEntry(object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object object, Object object2) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Bucket bucket = this.buckets[n2];
        synchronized (bucket) {
            return this.buckets[n2].putEntry(object, object2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Bucket bucket = this.buckets[n2];
        synchronized (bucket) {
            return this.buckets[n2].removeEntry(object, n);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

