/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.ui;

import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeployerFactory;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.ui.SystemPropertiesSetter;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.Console;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.SystemProps;
import com.iplanet.ias.util.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DeployUnitTestTool {
    private String installRoot;
    private List args;
    private boolean debug = false;
    private DeploymentCommand command;
    private DeployableObjectType type;
    private String name;
    private String contextRoot = null;
    private String instance;
    private File file;
    private boolean interactive = false;
    private boolean shared = false;
    private boolean forced = false;
    private static boolean byron;
    private boolean noEJBC = false;
    String[][] DEFAULT_PROPS = new String[][]{{"org.xml.sax.parser", "org.xml.sax.helpers.XMLReaderAdapter"}, {"org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl"}, {"java.security.policy", "%IAS_HOME%/admin-server/config/server.policy"}, {"java.security.auth.login.config", "%IAS_HOME%/admin-server/config/login.conf"}, {"com.sun.jdo.api.persistence.model.multipleClassLoaders", "reload"}, {"KeepFailedStubs", "true"}};
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$ui$DeployUnitTestTool;

    DeployUnitTestTool(String[] stringArray) {
        this.args = new ArrayList();
        if (stringArray == null || stringArray.length < 1) {
            DeployUnitTestTool.goodbye("No arguments");
        }
        int n = 0;
        while (n < stringArray.length) {
            this.args.add(stringArray[n]);
            ++n;
        }
        this.parseResponseFile();
        this.setEnv();
        this.parseReporter();
        this.parseEJBCFlag();
        this.parseInstance();
        this.parseCommand();
        this.parseName();
        this.parseFile();
        this.parseType();
        this.parseShared();
        this.parseContextRoot();
        this.parseForced();
        this.doDeploy();
    }

    private void doDeploy() {
        try {
            DeploymentRequest deploymentRequest = new DeploymentRequest(new InstanceEnvironment(this.instance), this.type, this.command);
            if (this.file != null) {
                deploymentRequest.setFileSource(this.file);
            }
            if (this.name != null) {
                deploymentRequest.setName(this.name);
            }
            if (this.contextRoot != null) {
                deploymentRequest.setContextRoot(this.contextRoot);
            }
            if (this.debug) {
                deploymentRequest.setDebug(true);
            }
            if (this.type.isEJB() && this.shared) {
                deploymentRequest.setShared(true);
            }
            if (this.noEJBC) {
                deploymentRequest.setNoEJBC();
            }
            deploymentRequest.setForced(this.forced);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
        }
        catch (IASDeploymentException iASDeploymentException) {
            iASDeploymentException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void parseReporter() {
    }

    private void parseEJBCFlag() {
        this.noEJBC = this.getSwitch("-noejbc");
    }

    private void parseResponseFile() {
        String string = this.getSwitchParameter("-response");
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() && !(file = new File(new File(System.getProperty("user.dir")), string)).exists()) {
            DeployUnitTestTool.goodbye("Can't find either " + string + " or " + file.getPath());
        }
        try {
            this.args = new ArrayList();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() > 0 && string2.charAt(0) != '#') {
                    this.args.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            DeployUnitTestTool.goodbye("Error reading response file: " + iOException);
        }
    }

    private void parseInstance() {
        this.instance = this.getSwitchParameter("-instance");
        if (this.instance == null) {
            if (this.interactive) {
                this.instance = Console.readLine("Instance Name:");
            } else {
                DeployUnitTestTool.goodbye("You must specify '-instance instance-name'");
            }
        }
    }

    private void parseFile() {
        String string = this.getSwitchParameter("-file");
        this.file = null;
        if (string != null) {
            this.file = new File(string);
            return;
        }
        if (this.command == DeploymentCommand.UNDEPLOY) {
            return;
        }
        if (this.interactive) {
            string = Console.readLine("Ear filename: ");
        }
        if (!StringUtils.ok((String)string)) {
            DeployUnitTestTool.goodbye("You must specify '-file ear-filename' for deploy");
        }
        this.file = new File(string);
    }

    private void parseName() {
        this.name = this.getSwitchParameter("-name");
        if (this.name != null) {
            return;
        }
        if (this.command == DeploymentCommand.DEPLOY) {
            if (!this.interactive) {
                return;
            }
            this.name = Console.readLine("App Name [optional - leave empty for Deployment to create a name]:");
            if (!StringUtils.ok((String)this.name)) {
                this.name = null;
            }
            return;
        }
        if (this.interactive) {
            this.name = Console.readLine("App Name [required]:");
        }
        if (this.name == null) {
            DeployUnitTestTool.goodbye("You must specify '-name aname' for undeploy");
        }
    }

    private void parseCommand() {
        this.command = this.getDeployCommand();
        if (this.command == null) {
            String string;
            char c;
            if (!this.interactive) {
                DeployUnitTestTool.goodbye("You must specify -deploy or -undeploy");
            }
            if ((c = (string = Console.readLine("Command [D|U]:").toLowerCase()).charAt(0)) == 'u') {
                this.command = DeploymentCommand.UNDEPLOY;
            } else if (c == 'd') {
                this.command = DeploymentCommand.DEPLOY;
            } else {
                DeployUnitTestTool.goodbye("Unknown command: " + string);
            }
        }
    }

    private void parseContextRoot() {
        this.contextRoot = null;
        if (!this.type.isWEB()) {
            return;
        }
        this.contextRoot = this.getContextRoot();
        if (this.contextRoot == null && this.command != DeploymentCommand.UNDEPLOY) {
            if (!this.interactive) {
                DeployUnitTestTool.goodbye("You must specify a context root for Web Modules (-contextroot name)");
            }
            this.contextRoot = Console.readLine("Context Root:");
        }
    }

    private void promptType() {
        String string = Console.readLine("Command [A|E|W|C]:").toLowerCase();
        char c = string.charAt(0);
        this.type = null;
        if (c == 'a') {
            this.type = DeployableObjectType.APP;
        } else if (c == 'e') {
            this.type = DeployableObjectType.EJB;
        } else if (c == 'w') {
            this.type = DeployableObjectType.WEB;
        } else if (c == 'c') {
            this.type = DeployableObjectType.CONN;
        }
    }

    private void parseShared() {
        this.shared = this.getSwitch("-shared");
    }

    private void parseForced() {
        this.forced = this.getSwitch("-forced");
    }

    private void parseType() {
        this.type = this.getDeployType();
        if (this.type != null) {
            return;
        }
        if (this.command == DeploymentCommand.UNDEPLOY) {
            if (this.interactive) {
                this.promptType();
                if (this.type == null) {
                    DeployUnitTestTool.goodbye("You need to specify whether it's an App or Module.");
                }
            } else {
                DeployUnitTestTool.goodbye("You must specify -app, -web, -connector or -ejb for Undeploy");
            }
            return;
        }
        if (this.interactive) {
            this.promptType();
            if (this.type != null) {
                return;
            }
        }
        if (FileUtils.isEar(this.file)) {
            this.type = DeployableObjectType.APP;
        } else if (FileUtils.isJar(this.file)) {
            this.type = DeployableObjectType.EJB;
        } else if (FileUtils.isWar(this.file)) {
            this.type = DeployableObjectType.WEB;
        } else if (FileUtils.isRar(this.file)) {
            this.type = DeployableObjectType.CONN;
        } else {
            DeployUnitTestTool.goodbye("Can't figure out whether it's an App or what kind of Module from the filename: " + this.file);
        }
    }

    private DeploymentCommand getDeployCommand() {
        boolean bl = this.getSwitch("-deploy");
        if (bl) {
            return DeploymentCommand.DEPLOY;
        }
        bl = this.getSwitch("-undeploy");
        if (bl) {
            return DeploymentCommand.UNDEPLOY;
        }
        return null;
    }

    private String getContextRoot() {
        String string = this.getSwitchParameter("-contextroot");
        if (StringUtils.ok((String)string)) {
            return string;
        }
        return null;
    }

    private DeployableObjectType getDeployType() {
        boolean bl = this.getSwitch("-ejb");
        if (bl) {
            return DeployableObjectType.EJB;
        }
        bl = this.getSwitch("-web");
        if (bl) {
            return DeployableObjectType.WEB;
        }
        bl = this.getSwitch("-app");
        if (bl) {
            return DeployableObjectType.APP;
        }
        bl = this.getSwitch("-connector");
        if (bl) {
            return DeployableObjectType.CONN;
        }
        bl = this.getSwitch("-conn");
        if (bl) {
            return DeployableObjectType.CONN;
        }
        return null;
    }

    private void setEnv() {
        if (this.getSwitch("-debug")) {
            this.debug = true;
        }
        if (this.getSwitch("-i")) {
            this.interactive = true;
        }
        this.setInstallRoot();
        this.checkInstallRoot();
        if (!this.setEnvFromFile()) {
            this.setDefaultEnv();
        }
        if (this.debug) {
            System.out.println("\n\n************* Here are all the System Props *****\n" + SystemProps.toStringStatic());
        }
    }

    private void setInstallRoot() {
        this.installRoot = this.getSwitchParameter("-installroot");
        if (this.installRoot == null) {
            this.installRoot = System.getProperty("com.sun.aas.installRoot");
        }
    }

    private void checkInstallRoot() {
        if (!StringUtils.ok((String)this.installRoot)) {
            DeployUnitTestTool.goodbye("com.sun.aas.installRoot is a mandatory java environmental variable, and it isn't set.");
        }
        if (!FileUtils.safeIsDirectory(new File(this.installRoot))) {
            DeployUnitTestTool.goodbye("com.sun.aas.installRoot is not pointing at a directory (" + this.installRoot + ")");
        }
        System.out.println("com.sun.aas.installRoot is OK -- set to " + this.installRoot);
    }

    private boolean setEnvFromFile() {
        String string = this.getSwitchParameter("-config");
        if (string == null) {
            return false;
        }
        System.out.println("config file: " + string);
        File file = new File(string);
        if (!file.exists()) {
            DeployUnitTestTool.goodbye("Config File doesn't exist: " + FileUtils.safeGetCanonicalPath(file));
        }
        new SystemPropertiesSetter(file);
        System.out.println("Set props from config file...");
        return true;
    }

    private void setDefaultEnv() {
        Properties properties = new Properties();
        properties.setProperty("com.sun.aas.installRoot", this.installRoot);
        properties.setProperty("com.sun.aas.instanceRoot", this.installRoot + "/instances");
        int n = 0;
        while (n < this.DEFAULT_PROPS.length) {
            properties.setProperty(this.DEFAULT_PROPS[n][0], this.DEFAULT_PROPS[n][1]);
            ++n;
        }
        new SystemPropertiesSetter(properties);
    }

    private String getSwitchParameter(String string) {
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.toLowerCase().equals(string)) continue;
            if (!iterator.hasNext()) {
                DeployUnitTestTool.goodbye(string + " switch with no parameter");
            }
            iterator.remove();
            String string3 = (String)iterator.next();
            iterator.remove();
            return string3;
        }
        return null;
    }

    private boolean getSwitch(String string) {
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.toLowerCase().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("DeployUnitTestTool [-debug] [-ejb|-web|-app|-connector] [-installroot ias-install-dir] [-config config-filename] [-deploy|-undeploy] [-name appName] [-file ear-filename] -instance instanceName[-contextroot rootname][-shared]\n == OR ==\nDeployUnitTestTool -response response-filename\nOne line per command in the response file.  The filename can be either a full pathname, or the name of a file located in the current working directory.");
    }

    private static void goodbye(String string) {
        System.out.println("FATAL ERROR:  " + string);
        DeployUnitTestTool.usage();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            DeployUnitTestTool.goodbye("no args");
        }
        try {
            try {
                if (stringArray[0].equals("-responses")) {
                    DeployUnitTestTool.doMulti(stringArray);
                }
                new DeployUnitTestTool(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var3_2 = null;
                System.exit(0);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doMulti(String[] stringArray) {
        if (!$assertionsDisabled && stringArray.length <= 1) {
            throw new AssertionError();
        }
        String[] stringArray2 = new String[2];
        stringArray2[0] = "-response";
        try {
            try {
                int n = 1;
                while (n < stringArray.length) {
                    stringArray2[1] = stringArray[n];
                    new DeployUnitTestTool(stringArray2);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var4_5 = null;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$ui$DeployUnitTestTool == null ? (class$com$iplanet$ias$deployment$ui$DeployUnitTestTool = DeployUnitTestTool.class$("com.iplanet.ias.deployment.ui.DeployUnitTestTool")) : class$com$iplanet$ias$deployment$ui$DeployUnitTestTool).desiredAssertionStatus();
        byron = false;
    }
}

