/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.EjbModule;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.ConnectorModulesManager;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.WebModulesManager;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.Reminder;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class DeploymentCleaner
implements Runnable {
    private InstanceEnvironment iEnv;
    private AppsManager appMgr;
    private EjbModulesManager ejbMgr;
    private WebModulesManager webMgr;
    private ConnectorModulesManager conMgr;
    private Set deployedDirs;
    private Set existingDirs;
    private Set orphanDirs;
    private Set missingDirs;
    private final Logger logger = DeploymentLogger.get();
    private long timeStamp = 0L;
    private static final int minimumAgeMsec = 60000;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$DeploymentCleaner;

    public DeploymentCleaner(InstanceEnvironment instanceEnvironment) {
        this.iEnv = instanceEnvironment;
    }

    public File[] getOrphanedDirectories() {
        File[] fileArray = new File[this.orphanDirs.size()];
        return this.orphanDirs.toArray(fileArray);
    }

    public void run() {
        try {
            this.init();
            this.getDeployedLocations();
            this.setExistingDirs();
            this.setOrphanAndMissingDirs();
            if (this.orphanDirs.size() <= 0) {
                return;
            }
            this.timeStamp = System.currentTimeMillis();
            Iterator iterator = this.orphanDirs.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (this.isOldEnough(file)) {
                    if (this.isDeploymentInProgress(file)) {
                        this.logger.info("Can't clean-up " + file.getPath() + " -- A deployment is in progress.");
                        continue;
                    }
                    FileUtils.whack(file);
                    this.logger.info("Deleted orphan directory: " + file.getPath());
                    continue;
                }
                this.logger.info("Can't clean-up " + file.getPath() + " -- it is not old enough.  Try again in 10 minutes.");
            }
        }
        catch (Exception exception) {
            this.logger.warning("error in DeploymentCleaner.run(): " + exception);
        }
    }

    private void init() throws IASDeploymentException {
        if (this.iEnv == null) {
            String string = localStrings.getString("enterprise.deployment.backend.deploymentcleaner_null_instanceenvironment");
            throw new IASDeploymentException(string);
        }
        try {
            this.appMgr = new AppsManager(this.iEnv);
            this.ejbMgr = new EjbModulesManager(this.iEnv);
            this.webMgr = new WebModulesManager(this.iEnv);
            this.conMgr = new ConnectorModulesManager(this.iEnv);
        }
        catch (ConfigException configException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_creating_appsmanager", configException);
            throw new IASDeploymentException(string);
        }
        this.deployedDirs = new HashSet();
    }

    private void getDeployedLocations() throws IASDeploymentException {
        this.getDeployedAppLocations();
        this.getDeployedModuleLocations();
    }

    private void setExistingDirs() throws IASDeploymentException {
        int n;
        File[] fileArray;
        this.existingDirs = new HashSet();
        File file = new File(this.iEnv.getApplicationRepositoryPath());
        File file2 = new File(this.iEnv.getModuleRepositoryPath());
        if (FileUtils.safeIsDirectory(file)) {
            fileArray = file.listFiles();
            n = 0;
            while (fileArray != null && n < fileArray.length) {
                if (FileUtils.safeIsDirectory(fileArray[n])) {
                    this.existingDirs.add(this.fixFile(fileArray[n]));
                }
                ++n;
            }
        }
        if (FileUtils.safeIsDirectory(file2)) {
            fileArray = file2.listFiles();
            n = 0;
            while (fileArray != null && n < fileArray.length) {
                if (FileUtils.safeIsDirectory(fileArray[n])) {
                    this.existingDirs.add(this.fixFile(fileArray[n]));
                }
                ++n;
            }
        }
    }

    private void setOrphanAndMissingDirs() throws IASDeploymentException {
        this.orphanDirs = new HashSet(this.existingDirs);
        this.missingDirs = new HashSet();
        Iterator iterator = this.deployedDirs.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (this.orphanDirs.remove(file)) continue;
            this.missingDirs.add(file);
        }
    }

    private void getDeployedAppLocations() throws IASDeploymentException {
        J2eeApplication[] j2eeApplicationArray;
        try {
            j2eeApplicationArray = this.appMgr.getAllApps();
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.backend.getallapps_exception");
            throw new IASDeploymentException(string);
        }
        if (j2eeApplicationArray == null) {
            return;
        }
        int n = 0;
        while (n < j2eeApplicationArray.length) {
            File file = this.getLocationFile(j2eeApplicationArray[n].getName(), j2eeApplicationArray[n].getLocation());
            if (file != null && !this.deployedDirs.add(file)) {
                this.logger.fine("The same directory is specified for more than one Application: " + file.getPath());
            }
            ++n;
        }
    }

    private void getDeployedModuleLocations() throws IASDeploymentException {
        this.getDeployedWebModuleLocations();
        this.getDeployedEjbModuleLocations();
        this.getDeployedConnectorModuleLocations();
    }

    private void getDeployedWebModuleLocations() throws IASDeploymentException {
        WebModule[] webModuleArray;
        try {
            webModuleArray = this.webMgr.listWebModules();
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.backend.listwebmodules_exception");
            throw new IASDeploymentException(string);
        }
        if (webModuleArray == null) {
            return;
        }
        int n = 0;
        while (n < webModuleArray.length) {
            File file = this.getLocationFile(webModuleArray[n].getName(), webModuleArray[n].getLocation());
            if (file != null && !this.deployedDirs.add(file)) {
                this.logger.fine("The same directory is specified for more than one Web Module: " + file.getPath());
            }
            ++n;
        }
    }

    private void getDeployedEjbModuleLocations() throws IASDeploymentException {
        EjbModule[] ejbModuleArray;
        try {
            ejbModuleArray = this.ejbMgr.listEjbModules();
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.backend.listejbmodules_exception");
            throw new IASDeploymentException(string);
        }
        if (ejbModuleArray == null) {
            return;
        }
        int n = 0;
        while (n < ejbModuleArray.length) {
            File file = this.getLocationFile(ejbModuleArray[n].getName(), ejbModuleArray[n].getLocation());
            if (file != null && !this.deployedDirs.add(file)) {
                this.logger.fine("The same directory is specified for more than one Ejb Module: " + file.getPath());
            }
            ++n;
        }
    }

    private void getDeployedConnectorModuleLocations() throws IASDeploymentException {
        ConnectorModule[] connectorModuleArray;
        try {
            connectorModuleArray = this.conMgr.listConnectorModules();
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.backend.listconnectormodules");
            throw new IASDeploymentException(string);
        }
        if (connectorModuleArray == null) {
            return;
        }
        int n = 0;
        while (n < connectorModuleArray.length) {
            File file = this.getLocationFile(connectorModuleArray[n].getName(), connectorModuleArray[n].getLocation());
            if (file != null && !this.deployedDirs.add(file)) {
                this.logger.fine("The same directory is specified for more than one Connector Module: " + file.getPath());
            }
            ++n;
        }
    }

    private File getLocationFile(String string, String string2) {
        if (!StringUtils.ok((String)string)) {
            this.logger.warning("Null or empty ID");
            return null;
        }
        if (!StringUtils.ok((String)string2)) {
            this.logger.warning("Null or empty location for App or Module: " + string);
            return null;
        }
        File file = this.fixFile(new File(string2));
        if (!FileUtils.safeIsDirectory(file)) {
            this.logger.warning("The location for ID: " + string + " (" + file.getPath() + ") -- doesn't exist");
        }
        return file;
    }

    File fixFile(File file) {
        if (file == null) {
            return file;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private boolean isDeploymentInProgress(File file) {
        return new File(file, Deployer.getLockFileName()).exists();
    }

    private boolean isOldEnough(File file) {
        if (!$assertionsDisabled && this.timeStamp <= 0L) {
            throw new AssertionError();
        }
        return this.timeStamp - file.lastModified() > 60000L;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            if (System.getProperty("user.name").equals("bnevins")) {
                stringArray = new String[]{"D:/iAS7SE/ias70/instances", "server1"};
            } else {
                System.out.println("DeploymentCleaner <IAS_ROOT> <instance-name>");
                System.exit(1);
            }
        }
        System.setProperty("com.sun.aas.instanceRoot", stringArray[0]);
        String string = stringArray.length >= 2 ? stringArray[1] : "server1";
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
        try {
            DeploymentCleaner deploymentCleaner = new DeploymentCleaner(instanceEnvironment);
            System.out.println("**** Bonafide Deployment Directories: " + deploymentCleaner.deployedDirs.size());
            Iterator iterator = deploymentCleaner.deployedDirs.iterator();
            while (iterator.hasNext()) {
                System.out.println(((File)iterator.next()).getPath());
            }
            System.out.println("*******");
            System.out.println("**** Existing Directories: " + deploymentCleaner.existingDirs.size());
            Iterator iterator2 = deploymentCleaner.existingDirs.iterator();
            while (iterator2.hasNext()) {
                System.out.println(((File)iterator2.next()).getPath());
            }
            System.out.println("*******");
            File[] fileArray = deploymentCleaner.getOrphanedDirectories();
            System.out.println("**** Orphaned Directories: " + fileArray.length);
            int n = 0;
            while (n < fileArray.length) {
                System.out.println(fileArray[n].getPath());
                ++n;
            }
            System.out.println("*******");
            System.out.println("**** Missing Deployment Directories: " + deploymentCleaner.missingDirs.size());
            Iterator iterator3 = deploymentCleaner.missingDirs.iterator();
            while (iterator3.hasNext()) {
                System.out.println(((File)iterator3.next()).getPath());
            }
            System.out.println("*******");
            if (Reminder.yesno("Do you REALLY want to delete the orphaned directories?")) {
                deploymentCleaner.run();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$DeploymentCleaner == null ? (class$com$iplanet$ias$deployment$backend$DeploymentCleaner = DeploymentCleaner.class$("com.iplanet.ias.deployment.backend.DeploymentCleaner")) : class$com$iplanet$ias$deployment$backend$DeploymentCleaner).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$DeploymentCleaner == null ? (class$com$iplanet$ias$deployment$backend$DeploymentCleaner = DeploymentCleaner.class$("com.iplanet.ias.deployment.backend.DeploymentCleaner")) : class$com$iplanet$ias$deployment$backend$DeploymentCleaner);
    }
}

