/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.connectors.util.xml;

import com.iplanet.ias.connectors.util.xml.AttributeXMLTagProcessor;
import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.iplanet.ias.connectors.util.xml.DefaultXMLTagProcessor;
import com.iplanet.ias.connectors.util.xml.GenericXMLTagProcessor;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.iplanet.ias.connectors.util.xml.TagHandlerException;
import com.iplanet.ias.connectors.util.xml.XMLTagProcessor;
import com.iplanet.ias.connectors.util.xml.XMLTagProcessorParser;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagProcessorHandler
extends XMLValidationHandler
implements XMLTagProcessorParser {
    Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$connectors$util$xml$TagProcessorHandler == null ? (class$com$iplanet$ias$connectors$util$xml$TagProcessorHandler = TagProcessorHandler.class$("com.iplanet.ias.connectors.util.xml.TagProcessorHandler")) : class$com$iplanet$ias$connectors$util$xml$TagProcessorHandler);
    private Stack tagProcessorStack = new Stack();
    private XMLTagProcessor currentTagProcessor;
    private ConnectorDeploymentObject cdo;
    private InstancePropertiesObject ipo;
    private SAXParser saxParser;
    private HashMap resourceAdapterAttributesMethodTable = new HashMap(10);
    private HashMap principalAttributesMethodTable = new HashMap(10);
    private HashMap backendAttributesMethodTable = new HashMap(10);
    static /* synthetic */ Class class$com$iplanet$ias$connectors$util$xml$TagProcessorHandler;

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentTagProcessor.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void moveForward(XMLTagProcessor xMLTagProcessor) {
        this.tagProcessorStack.push(this.currentTagProcessor);
        this.currentTagProcessor = xMLTagProcessor;
    }

    public void moveBackward() {
        this.currentTagProcessor = (XMLTagProcessor)this.tagProcessorStack.pop();
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (attributes.getLength() != 0) {
            this.currentTagProcessor.tagStart(string3, attributes);
        } else {
            this.currentTagProcessor.tagStart(string3);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentTagProcessor.tagEnd();
    }

    private void createGeneralConnectorTagProcessors(XMLTagProcessor xMLTagProcessor) {
        GenericXMLTagProcessor genericXMLTagProcessor = new GenericXMLTagProcessor(this, "display-name", this.cdo, "setDisplayName");
        xMLTagProcessor.addChildXMLProcessor("display-name", genericXMLTagProcessor);
        GenericXMLTagProcessor genericXMLTagProcessor2 = new GenericXMLTagProcessor(this, "vendor-name", this.cdo, "setVendorName");
        xMLTagProcessor.addChildXMLProcessor("vendor-name", genericXMLTagProcessor2);
        GenericXMLTagProcessor genericXMLTagProcessor3 = new GenericXMLTagProcessor(this, "spec-version", this.cdo, "setSpecVersion");
        xMLTagProcessor.addChildXMLProcessor("spec-version", genericXMLTagProcessor3);
        GenericXMLTagProcessor genericXMLTagProcessor4 = new GenericXMLTagProcessor(this, "eis-type", this.cdo, "setEisType");
        xMLTagProcessor.addChildXMLProcessor("eis-type", genericXMLTagProcessor4);
        GenericXMLTagProcessor genericXMLTagProcessor5 = new GenericXMLTagProcessor(this, "version", this.cdo, "setVersion");
        xMLTagProcessor.addChildXMLProcessor("version", genericXMLTagProcessor5);
    }

    private void createResourceAdapterTagProcessors(XMLTagProcessor xMLTagProcessor) {
        GenericXMLTagProcessor genericXMLTagProcessor = new GenericXMLTagProcessor(this, "managedconnectionfactory-class", this.cdo, "setManagedConnectionFactoryClass");
        xMLTagProcessor.addChildXMLProcessor("managedconnectionfactory-class", genericXMLTagProcessor);
        GenericXMLTagProcessor genericXMLTagProcessor2 = new GenericXMLTagProcessor(this, "connectionfactory-interface", this.cdo, "setConnectionFactoryInterface");
        xMLTagProcessor.addChildXMLProcessor("connectionfactory-interface", genericXMLTagProcessor2);
        GenericXMLTagProcessor genericXMLTagProcessor3 = new GenericXMLTagProcessor(this, "connectionfactory-impl-class", this.cdo, "setConnectionFactoryImplClass");
        xMLTagProcessor.addChildXMLProcessor("connectionfactory-impl-class", genericXMLTagProcessor3);
        GenericXMLTagProcessor genericXMLTagProcessor4 = new GenericXMLTagProcessor(this, "connection-interface", this.cdo, "setConnectionInterface");
        xMLTagProcessor.addChildXMLProcessor("connection-interface", genericXMLTagProcessor4);
        GenericXMLTagProcessor genericXMLTagProcessor5 = new GenericXMLTagProcessor(this, "connection-impl-class", this.cdo, "setConnectionImplClass");
        xMLTagProcessor.addChildXMLProcessor("connection-impl-class", genericXMLTagProcessor5);
        GenericXMLTagProcessor genericXMLTagProcessor6 = new GenericXMLTagProcessor(this, "transaction-support", this.cdo, "setTransactionSupport");
        xMLTagProcessor.addChildXMLProcessor("transaction-support", genericXMLTagProcessor6);
        DefaultXMLTagProcessor defaultXMLTagProcessor = new DefaultXMLTagProcessor(this, "config-property");
        xMLTagProcessor.addChildXMLProcessor("config-property", defaultXMLTagProcessor);
        GenericXMLTagProcessor genericXMLTagProcessor7 = new GenericXMLTagProcessor(this, "config-property-name", this.cdo, "setConfigPropertyName");
        defaultXMLTagProcessor.addChildXMLProcessor("config-property-name", genericXMLTagProcessor7);
        GenericXMLTagProcessor genericXMLTagProcessor8 = new GenericXMLTagProcessor(this, "config-property-type", this.cdo, "setConfigPropertyType");
        defaultXMLTagProcessor.addChildXMLProcessor("config-property-type", genericXMLTagProcessor8);
        GenericXMLTagProcessor genericXMLTagProcessor9 = new GenericXMLTagProcessor(this, "config-property-value", this.cdo, "setConfigPropertyValue");
        defaultXMLTagProcessor.addChildXMLProcessor("config-property-value", genericXMLTagProcessor9);
        DefaultXMLTagProcessor defaultXMLTagProcessor2 = new DefaultXMLTagProcessor(this, "authentication-mechanism");
        xMLTagProcessor.addChildXMLProcessor("authentication-mechanism", defaultXMLTagProcessor2);
        GenericXMLTagProcessor genericXMLTagProcessor10 = new GenericXMLTagProcessor(this, "authentication-mechanism-type", this.cdo, "setAuthMechType");
        defaultXMLTagProcessor2.addChildXMLProcessor("authentication-mechanism-type", genericXMLTagProcessor10);
        GenericXMLTagProcessor genericXMLTagProcessor11 = new GenericXMLTagProcessor(this, "credential-interface", this.cdo, "setCredentialInterface");
        defaultXMLTagProcessor2.addChildXMLProcessor("credential-interface", genericXMLTagProcessor11);
        GenericXMLTagProcessor genericXMLTagProcessor12 = new GenericXMLTagProcessor(this, "reauthentication-support", this.cdo, "setReauthenticationSupport");
        xMLTagProcessor.addChildXMLProcessor("reauthentication-support", genericXMLTagProcessor12);
    }

    private void createConnectorDeploymentObjectTagProcessors() {
        DefaultXMLTagProcessor defaultXMLTagProcessor = new DefaultXMLTagProcessor(this, "root");
        this.currentTagProcessor = defaultXMLTagProcessor;
        DefaultXMLTagProcessor defaultXMLTagProcessor2 = new DefaultXMLTagProcessor(this, "connector");
        defaultXMLTagProcessor.addChildXMLProcessor("connector", defaultXMLTagProcessor2);
        this.createGeneralConnectorTagProcessors(defaultXMLTagProcessor2);
        DefaultXMLTagProcessor defaultXMLTagProcessor3 = new DefaultXMLTagProcessor(this, "resourceadapter");
        defaultXMLTagProcessor2.addChildXMLProcessor("resourceadapter", defaultXMLTagProcessor3);
        this.createResourceAdapterTagProcessors(defaultXMLTagProcessor3);
    }

    private void initAttributesMethodTable() {
        this.resourceAdapterAttributesMethodTable.put("jndi-name", "setJndiName");
        this.resourceAdapterAttributesMethodTable.put("max-pool-size", "setMaxPoolSize");
        this.resourceAdapterAttributesMethodTable.put("max-wait-time-in-millis", "setMaxWait");
        this.resourceAdapterAttributesMethodTable.put("steady-pool-size", "setSteadyPoolSize");
        this.resourceAdapterAttributesMethodTable.put("idle-timeout-in-seconds", "setUnusedMaxLife");
        this.resourceAdapterAttributesMethodTable.put("map-id", "setMapId");
        this.principalAttributesMethodTable.put("user-name", "setSecurityPrincipalName");
        this.backendAttributesMethodTable.put("user-name", "setSecurityPrincipalBackEndUser");
        this.backendAttributesMethodTable.put("password", "setSecurityPrincipalBackEndPassword");
        this.backendAttributesMethodTable.put("credential", "setSecurityPrincipalBackEndCredential");
    }

    public ConnectorDeploymentObject getConnectorDeploymentObject(String string) throws TagHandlerException {
        this.cdo = new ConnectorDeploymentObject();
        this.createConnectorDeploymentObjectTagProcessors();
        this.doParse(string);
        return this.cdo;
    }

    private void createRAConfigPropertiesTagProcessors(XMLTagProcessor xMLTagProcessor) {
        DefaultXMLTagProcessor defaultXMLTagProcessor = new DefaultXMLTagProcessor(this, "property");
        xMLTagProcessor.addChildXMLProcessor("property", defaultXMLTagProcessor);
        GenericXMLTagProcessor genericXMLTagProcessor = new GenericXMLTagProcessor(this, "name", this.ipo, "setConfigPropertyName");
        defaultXMLTagProcessor.addChildXMLProcessor("name", genericXMLTagProcessor);
        GenericXMLTagProcessor genericXMLTagProcessor2 = new GenericXMLTagProcessor(this, "value", this.ipo, "setConfigPropertyValue");
        defaultXMLTagProcessor.addChildXMLProcessor("value", genericXMLTagProcessor2);
    }

    private void createSecurityTablesTagProcessors(XMLTagProcessor xMLTagProcessor) {
        GenericXMLTagProcessor genericXMLTagProcessor = new GenericXMLTagProcessor(this, "description", this.ipo, "setRoleMapDescription");
        xMLTagProcessor.addChildXMLProcessor("description", genericXMLTagProcessor);
        DefaultXMLTagProcessor defaultXMLTagProcessor = new DefaultXMLTagProcessor(this, "map-element");
        xMLTagProcessor.addChildXMLProcessor("map-element", defaultXMLTagProcessor);
        AttributeXMLTagProcessor attributeXMLTagProcessor = new AttributeXMLTagProcessor(this, "principal", this.ipo, this.principalAttributesMethodTable);
        defaultXMLTagProcessor.addChildXMLProcessor("principal", attributeXMLTagProcessor);
        AttributeXMLTagProcessor attributeXMLTagProcessor2 = new AttributeXMLTagProcessor(this, "backend-principal", this.ipo, this.backendAttributesMethodTable);
        defaultXMLTagProcessor.addChildXMLProcessor("backend-principal", attributeXMLTagProcessor2);
    }

    private void createConfigPropertiesObjectTagProcessors() {
        DefaultXMLTagProcessor defaultXMLTagProcessor = new DefaultXMLTagProcessor(this, "root");
        this.currentTagProcessor = defaultXMLTagProcessor;
        DefaultXMLTagProcessor defaultXMLTagProcessor2 = new DefaultXMLTagProcessor(this, "sun-connector");
        defaultXMLTagProcessor.addChildXMLProcessor("sun-connector", defaultXMLTagProcessor2);
        AttributeXMLTagProcessor attributeXMLTagProcessor = new AttributeXMLTagProcessor(this, "resource-adapter", this.ipo, this.resourceAdapterAttributesMethodTable);
        defaultXMLTagProcessor2.addChildXMLProcessor("resource-adapter", attributeXMLTagProcessor);
        AttributeXMLTagProcessor attributeXMLTagProcessor2 = new AttributeXMLTagProcessor(this, "role-map", this.ipo, this.resourceAdapterAttributesMethodTable);
        defaultXMLTagProcessor2.addChildXMLProcessor("role-map", attributeXMLTagProcessor2);
        this.createSecurityTablesTagProcessors(attributeXMLTagProcessor2);
        this.createRAConfigPropertiesTagProcessors(attributeXMLTagProcessor);
    }

    public InstancePropertiesObject getInstancePropertiesObject(String string) throws TagHandlerException {
        this.ipo = new InstancePropertiesObject();
        this.createConfigPropertiesObjectTagProcessors();
        this.doParse(string);
        return this.ipo;
    }

    private void createSaxParser() throws TagHandlerException {
        if (this.saxParser == null) {
            try {
                SAXParserFactory sAXParserFactory = XMLUtils.getSAXParserFactory();
                sAXParserFactory.setValidating(true);
                this.saxParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                String string = localStrings.getString("connectors.util.xml.FAILED_TO_INVOKE_PARSER", parserConfigurationException.getMessage());
                throw new TagHandlerException(string);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException;
                if (sAXException.getException() != null) {
                    exception = sAXException.getException();
                }
                String string = localStrings.getString("connectors.util.xml.XML_PARSER_EXCEPTION", sAXException.getMessage());
                throw new TagHandlerException(string);
            }
        }
    }

    private void doParse(String string) throws TagHandlerException {
        try {
            InputSource inputSource = new InputSource(new FileInputStream(new File(string)));
            this.saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            Object[] objectArray = new Object[]{sAXParseException.getMessage(), String.valueOf(sAXParseException.getLineNumber()), String.valueOf(sAXParseException.getSystemId())};
            this._logger.log(Level.SEVERE, "xml.sax_error", objectArray);
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            this._logger.log(Level.SEVERE, "xml.parser_exception", exception);
            String string2 = localStrings.getString("connectors.util.xml.XML_SAX_PARSER_ERROR", string, exception.getMessage());
            throw new TagHandlerException(string2);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            this._logger.log(Level.SEVERE, "xml.parser_exception", exception);
            String string3 = localStrings.getString("connectors.util.xml.XML_PARSER_EXCEPTION", sAXException.getMessage());
            throw new TagHandlerException(string3);
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, "xml.parser_exception", throwable);
            String string4 = localStrings.getString("connectors.util.xml.XML_PARSER_EXCEPTION", throwable.getMessage());
            throw new TagHandlerException(string4);
        }
    }

    public TagProcessorHandler() throws TagHandlerException {
        this.initAttributesMethodTable();
        this.createSaxParser();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

