/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ChannelManager;
import com.iplanet.ias.cis.channel.ChannelOptions;
import com.iplanet.ias.cis.channel.ssl.SSLBlockingChannel;
import com.iplanet.ias.cis.connection.BlockingConnectionInputStream;
import com.iplanet.ias.cis.connection.BlockingConnectionOutputStream;
import com.iplanet.ias.cis.connection.CISSocket;
import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.cis.connection.ConnectionException;
import com.iplanet.ias.cis.connection.ConnectionIOException;
import com.iplanet.ias.cis.connection.ConnectionInputStream;
import com.iplanet.ias.cis.connection.ConnectionOutputStream;
import com.iplanet.ias.cis.connection.EndPoint;
import com.iplanet.ias.cis.connection.HandshakeNotCompletedException;
import com.iplanet.ias.cis.connection.InvalidOperationException;
import com.iplanet.ias.cis.connection.NonBlockingConnectionInputStream;
import com.iplanet.ias.cis.connection.NonBlockingConnectionOutputStream;
import com.iplanet.ias.cis.connection.SSLSession;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Connection {
    public static final int POLL_READ_READY = 1;
    public static final int POLL_WRITE_READY = 2;
    public static final int POLL_EXCEPTION = 4;
    public static final int POLL_ERROR = 8;
    public static final int POLL_NVAL = 16;
    private static final int defaultTimeout = 10000;
    private static final int defaultReadBuffSize = 8192;
    private static final int defaultWriteBuffSize = 8192;
    private static ChannelManager channelManager = ChannelManager.getChannelManager();
    private Channel channel;
    private boolean isBlocking;
    private boolean isAcceptedConn;
    private EndPoint peerEndPoint = null;
    private EndPoint localEndPoint = null;
    private ConnectionInputStream inStream;
    private ConnectionOutputStream outStream;
    private ChannelOptions channelOptions;
    private int readBuffSize;
    private int writeBuffSize;
    private CISSocket cisSocket;
    private String certname = null;
    private boolean clientAuth = false;
    private boolean tlsRollback = false;

    public Connection(EndPoint endPoint, EndPoint endPoint2, boolean bl, int n) throws ConnectException {
        this(endPoint, endPoint2, bl, n, 8192, 8192);
    }

    public Connection(EndPoint endPoint, EndPoint endPoint2, boolean bl) throws ConnectException {
        this(endPoint, endPoint2, bl, 10000);
    }

    public Connection(EndPoint endPoint, EndPoint endPoint2) throws ConnectException {
        this(endPoint, endPoint2, true);
    }

    public Connection(EndPoint endPoint, EndPoint endPoint2, boolean bl, int n, int n2, int n3) throws ConnectException {
        try {
            this.channel = channelManager.createChannel(endPoint, endPoint2, bl, n, n2, n3);
            this.isBlocking = bl;
            this.isAcceptedConn = false;
            this.localEndPoint = this.channel.getLocalEndPoint();
            this.peerEndPoint = this.channel.getPeerEndPoint();
            if (this.isBlocking) {
                this.inStream = new BlockingConnectionInputStream(this.channel);
                this.outStream = new BlockingConnectionOutputStream(this.channel);
            } else {
                this.inStream = new NonBlockingConnectionInputStream(this.channel);
                this.outStream = new NonBlockingConnectionOutputStream(this.channel);
            }
            this.channelOptions = this.channel.getChannelOptions();
            this.readBuffSize = n2;
            this.writeBuffSize = n3;
        }
        catch (ChannelException channelException) {
            throw new ConnectException(channelException);
        }
        catch (ConnectionException connectionException) {
            throw new ConnectException(connectionException);
        }
        catch (Throwable throwable) {
            throw new ConnectException(throwable);
        }
    }

    protected Connection(Channel channel, boolean bl) throws ConnectException {
        this.channel = channel;
        this.isAcceptedConn = true;
        this.isBlocking = bl;
        try {
            this.peerEndPoint = channel.getPeerEndPoint();
            this.localEndPoint = channel.getLocalEndPoint();
            this.channelOptions = channel.getChannelOptions();
        }
        catch (ChannelException channelException) {
            throw new ConnectException(channelException);
        }
        try {
            if (this.isBlocking) {
                this.inStream = new BlockingConnectionInputStream(channel);
                this.outStream = new BlockingConnectionOutputStream(channel);
            } else {
                this.inStream = new NonBlockingConnectionInputStream(channel);
                this.outStream = new NonBlockingConnectionOutputStream(channel);
            }
        }
        catch (ConnectionException connectionException) {
            throw new ConnectException(connectionException);
        }
        catch (Throwable throwable) {
            throw new ConnectException(throwable);
        }
    }

    public Connection(EndPoint endPoint, EndPoint endPoint2, String string, int n, String[] stringArray, String[] stringArray2, boolean bl) throws ConnectException {
        try {
            this.channel = channelManager.createChannel(endPoint, endPoint2, string, n, stringArray, stringArray2, bl);
            this.isBlocking = true;
            this.isAcceptedConn = false;
            try {
                this.localEndPoint = this.channel.getLocalEndPoint();
                this.peerEndPoint = this.channel.getPeerEndPoint();
                this.channelOptions = this.channel.getChannelOptions();
                this.inStream = new BlockingConnectionInputStream(this.channel);
                this.outStream = new BlockingConnectionOutputStream(this.channel);
                this.channelOptions = this.channel.getChannelOptions();
            }
            catch (ChannelException channelException) {
                throw new ConnectException(channelException);
            }
            this.certname = string;
            this.clientAuth = false;
            this.tlsRollback = bl;
        }
        catch (ChannelException channelException) {
            throw new ConnectException(channelException.getMessage());
        }
        catch (ConnectionException connectionException) {
            throw new ConnectException(connectionException.getMessage());
        }
        catch (Throwable throwable) {
            throw new ConnectException(throwable);
        }
    }

    public Connection(EndPoint endPoint, String string, int n, String[] stringArray, String[] stringArray2, boolean bl) throws ConnectException {
        this(null, endPoint, string, n, stringArray, stringArray2, bl);
    }

    protected Connection(Channel channel, String string, boolean bl, boolean bl2, boolean bl3) throws ConnectException {
        this.channel = channel;
        this.isBlocking = bl;
        this.isAcceptedConn = true;
        try {
            this.localEndPoint = channel.getLocalEndPoint();
            this.peerEndPoint = channel.getPeerEndPoint();
            this.inStream = new BlockingConnectionInputStream(channel);
            this.outStream = new BlockingConnectionOutputStream(channel);
            this.channelOptions = channel.getChannelOptions();
        }
        catch (ChannelException channelException) {
            throw new ConnectException(channelException.getMessage());
        }
        catch (Throwable throwable) {
            throw new ConnectException(throwable);
        }
        this.certname = string;
        this.clientAuth = bl2;
        this.tlsRollback = bl3;
    }

    public ConnectionInputStream getInputStream() throws ConnectionIOException {
        return this.inStream;
    }

    public ConnectionOutputStream getOutputStream() throws ConnectionIOException {
        return this.outStream;
    }

    protected boolean isAcceptedConnection() {
        return this.isAcceptedConn;
    }

    public boolean isClientAuthEnabled() {
        return this.clientAuth;
    }

    public String getCertName() {
        return this.certname;
    }

    public boolean isTlsRollbackEnabled() {
        return this.tlsRollback;
    }

    public Socket getSocket() {
        if (this.cisSocket == null) {
            this.cisSocket = new CISSocket(this);
        }
        return this.cisSocket;
    }

    protected InetAddress getInetAddress() {
        InetAddress inetAddress = null;
        try {
            String string = this.getPeerEndPoint().getHostIP();
            inetAddress = InetAddress.getByName(string);
        }
        catch (ConnectionException connectionException) {
        }
        catch (UnknownHostException unknownHostException) {}
        return inetAddress;
    }

    public EndPoint getLocalEndPoint() throws ConnectionException {
        if (this.localEndPoint == null) {
            try {
                this.localEndPoint = this.channel.getLocalEndPoint();
            }
            catch (ChannelException channelException) {
                throw new ConnectionException("Error in retrieving EndPoint from underlying channel");
            }
        }
        return this.localEndPoint;
    }

    public EndPoint getPeerEndPoint() throws ConnectionException {
        if (this.peerEndPoint == null) {
            try {
                this.peerEndPoint = this.channel.getPeerEndPoint();
            }
            catch (ChannelException channelException) {
                throw new ConnectionException("Error in retrieving EndPoint from underlying channel");
            }
        }
        return this.peerEndPoint;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public boolean isSSLConnection() {
        return this.channel instanceof SSLBlockingChannel;
    }

    public SSLSession getSSLSession() throws ConnectionException, HandshakeNotCompletedException, InvalidOperationException {
        if (this.channel instanceof SSLBlockingChannel) {
            try {
                return ((SSLBlockingChannel)this.channel).getSSLSession();
            }
            catch (ChannelException channelException) {
                throw new ConnectionException(channelException.getMessage());
            }
        }
        throw new InvalidOperationException("Trying to get SSLSession from NonSSL Connection");
    }

    public boolean getKeepAlive() {
        return this.channelOptions.isKeepAlive();
    }

    public int getReceiveBufferSize() {
        return this.channelOptions.getRecvBufSize();
    }

    public int getSendBufferSize() {
        return this.channelOptions.getSendBufSize();
    }

    public int getSoLinger() {
        return this.channelOptions.getLinger();
    }

    public boolean getTcpNoDelay() {
        return this.channelOptions.isNoDelay();
    }

    public void setKeepAlive(boolean bl) throws ConnectionException {
        try {
            this.channelOptions.setKeepAlive(bl);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void setReceiveBufferSize(int n) throws ConnectionException {
        try {
            this.channelOptions.setRecvBufSize(n);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void setSendBufferSize(int n) throws ConnectionException {
        try {
            this.channelOptions.setSendBufSize(n);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void setSoLinger(boolean bl, int n) throws ConnectionException {
        try {
            this.channelOptions.setLinger(bl, n);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void setTcpNoDelay(boolean bl) throws ConnectionException {
        try {
            this.channelOptions.setNoDelay(bl);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void close() throws ConnectException {
        if (null == this.channel) {
            return;
        }
        try {
            this.inStream.close();
            this.outStream.close();
            this.channel.close();
            this.channel = null;
        }
        catch (Exception exception) {
            throw new ConnectException(exception);
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }

    public boolean isReadReady() {
        try {
            int n = this.getPollOperationStatus();
            return (n & 1) == 1;
        }
        catch (ConnectionException connectionException) {
            return false;
        }
    }

    public boolean isWriteReady() {
        try {
            int n = this.getPollOperationStatus();
            return (n & 2) == 2;
        }
        catch (ConnectionException connectionException) {
            return false;
        }
    }

    public boolean isInException() {
        int n = 28;
        try {
            int n2 = this.getPollOperationStatus();
            return (n2 & n) != 0;
        }
        catch (ConnectionException connectionException) {
            return false;
        }
    }

    public int getPollOperationMask() throws ConnectionException {
        try {
            return this.channel.getPollFlag();
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void setPollOperationMask(int n) throws ConnectionException {
        try {
            this.channel.setPollFlag(n);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public void resetPollOperationMask() throws ConnectionException {
        try {
            this.channel.setPollFlag(0);
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }

    public int getPollOperationStatus() throws ConnectionException {
        try {
            return this.channel.getOutPollFlag();
        }
        catch (ChannelException channelException) {
            throw new ConnectionException(channelException);
        }
    }
}

