/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Acl;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AclTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Acl[] aclArray = server.getHttpService().getAcl();
            int n = 0;
            while (n < aclArray.length) {
                String string = aclArray[n].getFile();
                File file = new File(string);
                if (!file.exists()) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidACL", "Acl File " + string + " is not Valid", new Object[]{string}));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        File file;
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            result = this.testSave(string2, (String)object);
            return result;
        }
        Acl acl = (Acl)object;
        String string3 = acl.getId();
        if (!StaticTest.checkObjectName(string3, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidID", "Invalid Acl ID"));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        if (acl != null && !(file = new File(acl.getFile())).exists()) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noAcl", "Acl File Does Not Exist"));
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        File file;
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.FILE) && string2 != null && !(file = new File(string2)).exists()) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidFile", "Invalid ACL File"));
        }
        return result;
    }
}

