/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier;

import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.ConfigContextEventListener;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultMgr;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerMgr
implements ConfigContextEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public String testFileName = "ServerTestList.xml";
    public static HashMap testCases = new HashMap();
    public static String fileUrl = null;
    public String description = "Tests for server.xml";
    public boolean debug;
    public Result result = null;
    public Vector vresult = null;
    public LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public ServerMgr() {
        this.debug = false;
    }

    public ServerMgr(boolean bl) {
        this.debug = true;
    }

    public static void setFile(String string) {
        fileUrl = string;
    }

    public boolean loadTestInfo() {
        boolean bl;
        block12: {
            bl = true;
            if (!testCases.isEmpty()) break block12;
            if (this.debug) {
                _logger.log(Level.INFO, "serverxmlverifier.getting_testnamefrom_propertyfile");
            }
            File file = this.getTestFile(this.testFileName);
            try {
                DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                NodeList nodeList = document.getElementsByTagName("description");
                if (nodeList.getLength() > 0) {
                    Element element = (Element)nodeList.item(0);
                    this.description = element.getFirstChild().getNodeValue().trim();
                }
                nodeList = document.getElementsByTagName("test");
                int n = 0;
                while (n < nodeList.getLength()) {
                    Element element = (Element)nodeList.item(n);
                    NodeList nodeList2 = element.getChildNodes();
                    TestInformation testInformation = new TestInformation();
                    String string = "";
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Node node;
                        String string2 = nodeList2.item(n2).getNodeName();
                        if ("test-name".equals(string2.trim())) {
                            node = nodeList2.item(n2);
                            string = node.getFirstChild().getNodeValue().trim();
                        }
                        if ("test-class".equals(string2.trim())) {
                            node = nodeList2.item(n2);
                            testInformation.setClassName(node.getFirstChild().getNodeValue().trim());
                        }
                        if ("minimum-version".equals(string2.trim())) {
                            node = nodeList2.item(n2);
                            testInformation.setMinimumVersion(node.getFirstChild().getNodeValue().trim());
                        }
                        if ("maximum-version".equals(string2.trim())) {
                            node = nodeList2.item(n2);
                            testInformation.setMaximumVersion(node.getFirstChild().getNodeValue().trim());
                        }
                        ++n2;
                    }
                    testCases.put(string, testInformation);
                    ++n;
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                _logger.log(Level.WARNING, "serverxmlverifier.parser_error", parserConfigurationException);
                bl = false;
            }
            catch (SAXException sAXException) {
                _logger.log(Level.WARNING, "serverxmlverifier.sax_error", sAXException);
                bl = false;
            }
            catch (IOException iOException) {
                _logger.log(Level.WARNING, "serverxmlverifier.error_loading_xmlfile");
                bl = false;
            }
        }
        return bl;
    }

    public HashMap getTests() {
        return testCases;
    }

    private File getTestFile(String string) {
        String string2 = System.getProperty("s1as.home");
        if (string2 != null) {
            File file = new File(string2, "lib");
            if ((file = new File(file, string)).exists()) {
                return file;
            }
            return null;
        }
        return this.getFileFromCP(string);
    }

    private File getFileFromCP(String string) {
        File file = null;
        String string2 = System.getProperty("java.class.path");
        String string3 = File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.endsWith("appserv-rt.jar")) continue;
            int n = string4.lastIndexOf(47);
            if (n == -1) {
                n = string4.lastIndexOf(File.separator);
            }
            if (n == -1) break;
            String string5 = string4.substring(0, n);
            file = new File(string5, string);
            break;
        }
        return file;
    }

    public boolean check(ConfigContext configContext) {
        if (testCases.isEmpty()) {
            this.loadTestInfo();
        }
        Iterator iterator = testCases.values().iterator();
        ResultMgr resultMgr = new ResultMgr();
        while (iterator.hasNext()) {
            TestInformation testInformation = (TestInformation)iterator.next();
            String string = testInformation.getClassName();
            try {
                Result result = null;
                Class<?> clazz = Class.forName(string);
                ServerCheck serverCheck = (ServerCheck)clazz.newInstance();
                result = serverCheck.check(configContext);
                result.setStatus(0);
                resultMgr.addResults(result);
                result.setStatus(1);
                resultMgr.addResults(result);
            }
            catch (Throwable throwable) {
                _logger.log(Level.FINE, "serverxmlverifier.error_check", throwable);
            }
        }
        this.writeToFile(resultMgr);
        return true;
    }

    public boolean testStatus(ConfigContext configContext) {
        boolean bl = true;
        if (testCases.isEmpty()) {
            this.loadTestInfo();
        }
        Iterator iterator = testCases.values().iterator();
        ResultMgr resultMgr = new ResultMgr();
        while (iterator.hasNext()) {
            TestInformation testInformation = (TestInformation)iterator.next();
            String string = testInformation.getClassName();
            try {
                Result result = null;
                Class<?> clazz = Class.forName(string);
                ServerCheck serverCheck = (ServerCheck)clazz.newInstance();
                result = serverCheck.check(configContext);
                result.setStatus(0);
                resultMgr.addResults(result);
                result.setStatus(1);
                resultMgr.addResults(result);
                Vector vector = resultMgr.getFailedResults();
                int n = 0;
                while (n < vector.size()) {
                    this.result = (Result)vector.elementAt(n);
                    this.vresult = this.result.getErrorDetails();
                    if (this.vresult.size() > 0) {
                        bl = false;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                _logger.log(Level.FINE, "serverxmlverifier.error_check", throwable);
                return false;
            }
        }
        this.writeToFile(resultMgr);
        return bl;
    }

    public void writeToFile(ResultMgr resultMgr) {
        String string = System.getProperty("java.io.tmpdir");
        Calendar calendar = Calendar.getInstance();
        String string2 = new Integer(calendar.get(11)).toString() + new Integer(calendar.get(12)).toString() + new Integer(calendar.get(14)).toString();
        if (fileUrl == null) {
            fileUrl = string + "/TestResults" + string2 + ".txt";
        }
        _logger.log(Level.INFO, "serverxmlverifier.test_output", fileUrl);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileUrl);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("------------------------------------");
            printWriter.println("SERVER.XML VERIFICATION TEST RESULTS");
            printWriter.println("------------------------------------");
            printWriter.println();
            this.printFailedDetails(resultMgr.getFailedResults(), printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "serverxmlverifier.error_writing_file");
        }
    }

    public void printFailedDetails(Vector vector, PrintWriter printWriter) {
        printWriter.println("    FAILED TESTS   ");
        printWriter.println("    ------------   ");
        printWriter.println();
        boolean bl = true;
        int n = 0;
        while (n < vector.size()) {
            this.result = (Result)vector.elementAt(n);
            this.vresult = this.result.getErrorDetails();
            if (this.vresult.size() > 0) {
                bl = false;
                printWriter.println(this.result.getTestName() + ":");
            }
            int n2 = 0;
            while (n2 < this.vresult.size()) {
                printWriter.println("       " + (String)this.vresult.elementAt(n2));
                ++n2;
            }
            printWriter.println();
            ++n;
        }
        if (bl) {
            printWriter.println("                      ***** None *****");
        }
    }

    public boolean check(ConfigContextEvent configContextEvent) {
        boolean bl;
        block8: {
            String string;
            TestInformation testInformation;
            String string2 = configContextEvent.getName();
            Object object = configContextEvent.getObject();
            ConfigContext configContext = configContextEvent.getConfigContext();
            String string3 = configContextEvent.getChoice();
            String string4 = configContextEvent.getBeanName();
            if (string2 == null && string4 == null) {
                return true;
            }
            bl = false;
            if (testCases.isEmpty()) {
                this.loadTestInfo();
            }
            if ((testInformation = (TestInformation)testCases.get(string2)) == null && string4 != null) {
                testInformation = (TestInformation)testCases.get(string4);
            }
            try {
                string = testInformation.getClassName();
            }
            catch (Exception exception) {
                return true;
            }
            try {
                Class<?> clazz = Class.forName(string);
                ServerCheck serverCheck = (ServerCheck)clazz.newInstance();
                this.result = serverCheck.check(configContextEvent);
                if (this.result.getStatus() == 0) {
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                _logger.log(Level.FINE, "serverxmlverifier.error_check", throwable);
                bl = true;
            }
        }
        return bl;
    }

    public void postAccessNotification(ConfigContextEvent configContextEvent) {
    }

    public void postChangeNotification(ConfigContextEvent configContextEvent) {
    }

    public void preAccessNotification(ConfigContextEvent configContextEvent) {
    }

    public void preChangeNotification(ConfigContextEvent configContextEvent) {
        if (!this.check(configContextEvent)) {
            throw new AFRuntimeException(this.result.getErrorDetails().toString());
        }
    }
}

