/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config.naming;

import com.iplanet.ias.admin.common.MalformedNameException;
import com.iplanet.ias.admin.common.Name;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.util.i18n.StringManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNamingDescriptor {
    String m_type;
    String m_className;
    String m_objectPattern;
    String[] m_dottedPatterns;
    String m_xpathPattern;
    int m_mode;
    int m_parmListSize = 0;
    Object[][] m_dottedTokens = null;
    Object[] m_objectTokens = null;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$naming$MBeanNamingDescriptor == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$naming$MBeanNamingDescriptor = MBeanNamingDescriptor.class$("com.iplanet.ias.admin.server.core.mbean.config.naming.MBeanNamingDescriptor")) : class$com$iplanet$ias$admin$server$core$mbean$config$naming$MBeanNamingDescriptor);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$naming$MBeanNamingDescriptor;

    public MBeanNamingDescriptor(Object[] objectArray) throws MBeanConfigException {
        this((String)objectArray[0], (Integer)objectArray[1], (String)objectArray[2], (String)objectArray[3], (String)objectArray[4], (String)objectArray[5]);
    }

    public MBeanNamingDescriptor(String string, Integer n, String string2, String string3, String string4, String string5) throws MBeanConfigException {
        this.m_type = string;
        this.m_className = string5;
        this.m_dottedPatterns = this.splitDottedPatternsString(string2);
        this.m_xpathPattern = string4;
        this.m_objectPattern = string3;
        this.m_mode = n;
        try {
            this.m_dottedTokens = new Object[this.m_dottedPatterns.length][];
            int n2 = 0;
            while (n2 < this.m_dottedPatterns.length) {
                this.m_dottedTokens[n2] = this.getDottedNamePatternTokens(this.m_dottedPatterns[n2]);
                ++n2;
            }
            this.m_objectTokens = this.getObjectNamePatternTokens(this.m_objectPattern);
            this.m_parmListSize = this.getMaxTokenIndex(this.m_objectTokens) + 1;
            this.checkConsistency();
        }
        catch (Exception exception) {
            String string6 = localStrings.getString("admin.server.core.mbean.config.naming.mbeandescriptor_creation_failure_for_object_pattern", string3, exception.getMessage());
            throw new MBeanConfigException(string6);
        }
    }

    private void checkConsistency() throws MBeanConfigException {
    }

    boolean isDottedPatternMatch(Name name) {
        return this.findDottedPatternTokens(name) != null;
    }

    private Object[] findDottedPatternTokens(Name name) {
        int n = 0;
        while (n < this.m_dottedTokens.length) {
            if (MBeanNamingDescriptor.isDottedPatternMatch(name, this.m_dottedTokens[n], true)) {
                return this.m_dottedTokens[n];
            }
            ++n;
        }
        return null;
    }

    boolean isObjectNamePatternMatch(Hashtable hashtable) {
        if (this.m_objectTokens.length != hashtable.size() * 2) {
            return false;
        }
        int n = 0;
        while (n < this.m_objectTokens.length) {
            String string = (String)hashtable.get(this.m_objectTokens[n]);
            if (string == null || this.m_objectTokens[n + 1] instanceof String && !string.equals((String)this.m_objectTokens[n + 1])) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    String[] extractParmList(String string) throws MalformedNameException {
        if (this.m_dottedTokens == null) {
            return null;
        }
        Name name = new Name(string);
        Object[] objectArray = this.findDottedPatternTokens(name);
        if (objectArray == null) {
            return null;
        }
        int n = name.getNumParts();
        if (name.getNumParts() != objectArray.length) {
            return null;
        }
        String[] stringArray = new String[this.m_parmListSize];
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] instanceof Integer) {
                stringArray[((Integer)objectArray[n2]).intValue()] = name.getNamePart(n2).toString();
            }
            ++n2;
        }
        return stringArray;
    }

    private Object[] getDottedNamePatternTokens(String string) throws MalformedNameException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        if (string != null) {
            while (n < string.length() && (n2 = string.indexOf(46, n)) >= 0) {
                if (n == n2) {
                    arrayList.add("");
                } else {
                    arrayList.add(string.substring(n, n2).trim());
                }
                n = n2 + 1;
            }
            if (n < string.length()) {
                arrayList.add(string.substring(n).trim());
            }
            Object[] objectArray = arrayList.toArray();
            this.replacePlaceholdersToIntegers(objectArray);
            return objectArray;
        }
        return null;
    }

    private Object[] getObjectNamePatternTokens(String string) throws MalformedObjectNameException {
        if (string != null) {
            ObjectName objectName = new ObjectName(string);
            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
            Enumeration<String> enumeration = hashtable.keys();
            Object[] objectArray = new Object[hashtable.size() * 2];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                objectArray[n++] = string2;
                objectArray[n++] = hashtable.get(string2);
            }
            this.replacePlaceholdersToIntegers(objectArray);
            return objectArray;
        }
        return null;
    }

    public int getParmListSize() {
        return this.m_parmListSize;
    }

    public String[] extractParmList(ObjectName objectName) {
        if (this.m_objectTokens == null) {
            return null;
        }
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        String[] stringArray = new String[this.m_parmListSize];
        int n = 0;
        while (n < this.m_objectTokens.length) {
            if (this.m_objectTokens[n + 1] instanceof Integer) {
                stringArray[((Integer)this.m_objectTokens[n + 1]).intValue()] = hashtable.get(this.m_objectTokens[n]);
            }
            n += 2;
        }
        return stringArray;
    }

    private void replacePlaceholdersToIntegers(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Integer n2 = this.getIndexForPlaceholder((String)objectArray[n]);
            if (n2 != null) {
                objectArray[n] = n2;
            }
            ++n;
        }
    }

    private Integer getIndexForPlaceholder(String string) {
        int n = string.length();
        if (n < 3 || string.charAt(0) != '{' || string.charAt(n - 1) != '}') {
            return null;
        }
        try {
            return Integer.valueOf(string.substring(1, n - 1));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getMaxTokenIndex(Object[] objectArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3;
            if (objectArray[n2] instanceof Integer && n < (n3 = ((Integer)objectArray[n2]).intValue())) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public String getMBeanClassName() {
        return this.m_className;
    }

    public String getType() {
        return this.m_type;
    }

    public int getMode() {
        return this.m_mode;
    }

    public String[] getDottedPatterns() {
        return this.m_dottedPatterns;
    }

    public Object[][] getDottedTokens() {
        return this.m_dottedTokens;
    }

    public String getXPathPattern() {
        return this.m_xpathPattern;
    }

    public ObjectName createObjectName(Object[] objectArray) throws MalformedObjectNameException {
        return new ObjectName(this.formatPattern(this.m_objectPattern, objectArray));
    }

    public String createDottedNameName(Object[] objectArray) {
        if (this.m_dottedPatterns == null || this.m_dottedPatterns.length < 1) {
            return null;
        }
        return this.formatPattern(this.m_dottedPatterns[0], objectArray);
    }

    public String createXPath(Object[] objectArray) {
        return this.formatPattern(this.m_xpathPattern, objectArray);
    }

    private String formatPattern(String string, Object[] objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    private String[] splitDottedPatternsString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n < string.length() && (n2 = string.indexOf(124, n)) >= 0) {
            if (n2 != n) {
                arrayList.add(string.substring(n, n2));
            }
            n = n2 + 1;
        }
        if (n2 < 0) {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isDottedPatternMatch(Name name, Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return false;
        }
        int n = name.getNumParts();
        if (bl ? n != objectArray.length : n > objectArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] instanceof String && !name.getNamePart(n2).toString().equals((String)objectArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

