/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config.naming;

import com.iplanet.ias.admin.common.Name;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.admin.server.core.mbean.config.naming.MBeanNamingDescriptor;
import com.iplanet.ias.admin.server.core.mbean.config.naming.MBeansDescriptions;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.instance.InstanceEnvironment;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ConfigMBeansNaming
extends MBeansDescriptions {
    static MBeanNamingDescriptor[] m_mbeanDescr = ConfigMBeansNaming.initConfigMBeanNaming();
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_FINDNAMINDESCRIPTOR_FAILED = "mbean.config.findnamingdescriptor_failed";
    private static final String MSG_MALFORMED_DOTTED_NAME = "mbean.config.malformed_dotted_name";
    private static final String MSG_EXCEPTION_DURING_LIST_NAMES = "mbean.config.list_names_failed";

    static MBeanNamingDescriptor findNamingDescriptorByType(String string) {
        try {
            int n = 0;
            while (n < m_mbeanDescr.length) {
                if (string.equals(m_mbeanDescr[n].getType())) {
                    return m_mbeanDescr[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(String string) {
        try {
            Name name = new Name(string);
            int n = 0;
            while (n < m_mbeanDescr.length) {
                if (m_mbeanDescr[n].isDottedPatternMatch(name)) {
                    return m_mbeanDescr[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(ObjectName objectName) {
        try {
            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
            int n = 0;
            while (n < m_mbeanDescr.length) {
                if (m_mbeanDescr[n].isObjectNamePatternMatch(hashtable)) {
                    return m_mbeanDescr[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    public static String[] findNameContinuation(String string, String string2) {
        HashSet<String> hashSet;
        block21: {
            Object object;
            hashSet = new HashSet<String>();
            int n = -1;
            Name name = null;
            int n2 = 0;
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
            try {
                name = new Name(string2);
                n2 = name.getNumParts();
            }
            catch (Exception exception) {
                sLogger.log(Level.FINE, MSG_MALFORMED_DOTTED_NAME, exception);
                return new String[0];
            }
            int n3 = 0;
            while (n3 < m_mbeanDescr.length) {
                object = m_mbeanDescr[n3].getDottedTokens();
                if (object != null) {
                    int n4 = 0;
                    while (n4 < ((Object[][])object).length) {
                        if (MBeanNamingDescriptor.isDottedPatternMatch(name, (Object[])object[n4], false) && ((Object)object[n4]).length > n2) {
                            if (!(object[n4][n2] instanceof String)) {
                                if (((Object)object[n4]).length == n2 + 1) {
                                    n = n3;
                                }
                            } else {
                                hashSet.add(string2 + "." + object[n4][n2]);
                            }
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            object = null;
            if (n >= 0) {
                try {
                    ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(string2 + ".fake");
                    object = configMBeanNamingInfo.getXPath();
                }
                catch (Exception exception) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, exception);
                }
            }
            if (object == null) break block21;
            String string3 = null;
            String string4 = null;
            if (((String)(object = ((String)object).trim())).length() > 0 && ((String)object).endsWith("]")) {
                int n5 = ((String)object).lastIndexOf(64) + 1;
                int n6 = ((String)object).indexOf(61, n5);
                if (n5 > 0 && n6 > n5) {
                    string3 = ((String)object).substring(n5, n6).trim();
                    n6 = ((String)object).lastIndexOf(91);
                    if (n6 > 0 && n6 < n5 && (n6 = ((String)(object = ((String)object).substring(0, n6))).lastIndexOf(47)) > 0 && n6 < ((String)object).length() - 2) {
                        string4 = ((String)object).substring(n6 + 1).trim();
                        object = ((String)object).substring(0, n6);
                    }
                }
            }
            if (string3 != null && string4 != null) {
                try {
                    String string5 = instanceEnvironment.getBackupConfigFilePath();
                    ConfigContext configContext = ConfigFactory.createConfigContext(string5);
                    ConfigBean configBean = ConfigBeansFactory.getConfigBeanByXPath(configContext, (String)object);
                    ConfigBean[] configBeanArray = configBean.getChildBeansByName(string4);
                    int n7 = 0;
                    while (n7 < configBeanArray.length) {
                        String string6 = configBeanArray[n7].getAttributeValue(string3);
                        if (string6 != null) {
                            hashSet.add(string2 + "." + string6);
                        }
                        ++n7;
                    }
                }
                catch (ConfigException configException) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, configException);
                }
                catch (NullPointerException nullPointerException) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, nullPointerException);
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static synchronized MBeanNamingDescriptor[] initConfigMBeanNaming() {
        MBeanNamingDescriptor[] mBeanNamingDescriptorArray = null;
        try {
            mBeanNamingDescriptorArray = new MBeanNamingDescriptor[MBeansDescriptions.mbean_descriptions.length];
            int n = 0;
            while (n < MBeansDescriptions.mbean_descriptions.length) {
                mBeanNamingDescriptorArray[n] = new MBeanNamingDescriptor(MBeansDescriptions.mbean_descriptions[n]);
                ++n;
            }
        }
        catch (MBeanConfigException mBeanConfigException) {}
        return mBeanNamingDescriptorArray;
    }

    public static void main(String[] stringArray) {
        ConfigMBeansNaming.testDottedName("myInstance.http-listener.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-listener");
        ConfigMBeansNaming.testDottedName("myInstance.http-server");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.mymy");
        ConfigMBeansNaming.testDottedName("myInstance.http-listeners.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-serve");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.http-listener.myListener");
        try {
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-listener,instance-name=myServer,name=myListener"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-listener,instance-name=myServer,name=myListener,chtoto=to"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,instance-name=myServer,name=jhgv"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,server-instances=myServer"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,instance-name=myServer"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:name=myListener,instance-name=myServer,type=http-listener"));
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
            throwable.printStackTrace();
        }
    }

    private static void print(String string) {
        System.out.println(string);
    }

    private static void testDottedName(String string) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for dotted name: " + string);
            ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(string);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + configMBeanNamingInfo);
            ConfigMBeansNaming.print("       ObjectName =" + configMBeanNamingInfo.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + configMBeanNamingInfo.getXPath());
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
        }
    }

    private static void testObjectName(ObjectName objectName) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for object name: " + objectName);
            ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(objectName);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + configMBeanNamingInfo);
            ConfigMBeansNaming.print("       ObjectName =" + configMBeanNamingInfo.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + configMBeanNamingInfo.getXPath());
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
            throwable.printStackTrace();
        }
    }
}

