/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.mbean.config.AdminEntityResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ModulesXMLHelper {
    public static final int MODULE_TYPE_EJB = 1;
    public static final int MODULE_TYPE_WEB = 2;
    public static final int MODULE_TYPE_JAVA = 4;
    public static final int MODULE_TYPE_ALL = 255;
    public static final int EJB_TYPE_SESSION = 1;
    public static final int EJB_TYPE_ENTITY = 2;
    public static final int EJB_TYPE_MSGDRIVEN = 4;
    public static final int EJB_TYPE_ALL = 255;
    static final String APPLICATION_TAG = "application";
    static final String MODULE_TAG = "module";
    static final String EJB_MODULE_TAG = "ejb";
    static final String WEB_MODULE_TAG = "web";
    static final String WEB_URI_TAG = "web-uri";
    static final String CONTEXT_ROOT_TAG = "context-root";
    static final String JAVA_MODULE_TAG = "java";
    static final String ENTERPRISE_BEANS_TAG = "enterprise-beans";
    static final String SESSION_TAG = "session";
    static final String ENTITY_TAG = "entity";
    static final String MESSAGE_DRIVEN_TAG = "message-driven";
    static final String EJB_NAME_TAG = "ejb-name";
    static final String SERVLET_TAG = "servlet";
    static final String SERVLET_NAME_TAG = "servlet-name";
    static final Logger sLogger = AdminService.sLogger;
    Document document;

    public ModulesXMLHelper(String string) throws Exception {
        this.document = this.createDocument(string);
    }

    public static String[] getModulesFromApplicationLocation(String string, int n) throws Exception {
        ModulesXMLHelper modulesXMLHelper = new ModulesXMLHelper(string + "/META-INF/application.xml");
        return modulesXMLHelper.getModules(n);
    }

    public static boolean isModuleExists(String string, String string2, int n) throws Exception {
        String[] stringArray = ModulesXMLHelper.getModulesFromApplicationLocation(string, n);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.equals(stringArray[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String[] getEnterpriseBeansForEjbModule(String string, String string2, int n) throws Exception {
        if (string2 != null) {
            if (string2.endsWith(".jar")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            string = string + "/" + string2 + "_jar";
        }
        ModulesXMLHelper modulesXMLHelper = new ModulesXMLHelper(string + "/META-INF/ejb-jar.xml");
        return modulesXMLHelper.getEnterpriseBeans(n);
    }

    public static String[] getServletsForWebModule(String string, String string2) throws Exception {
        if (string2 != null) {
            if (string2.endsWith(".war")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            string = string + "/" + string2 + "_war";
        }
        ModulesXMLHelper modulesXMLHelper = new ModulesXMLHelper(string + "/WEB-INF/web.xml");
        return modulesXMLHelper.getServlets();
    }

    public String[] getModules(int n) throws Exception {
        if (this.document != null) {
            Object object;
            ArrayList arrayList = this.findChildNodesByName(this.document.getDocumentElement(), MODULE_TAG);
            String[] stringArray = new String[arrayList.size()];
            int n2 = 0;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                object = this.getModuleNameFromNode((Node)arrayList.get(n3), n);
                if (object != null) {
                    stringArray[n2++] = object;
                }
                ++n3;
            }
            object = new String[n2];
            int n4 = 0;
            while (n4 < n2) {
                object[n4] = stringArray[n4];
                ++n4;
            }
            return object;
        }
        return new String[0];
    }

    public String[] getEnterpriseBeans(int n) throws Exception {
        Node node;
        if (this.document != null && (node = this.findChildNodeByName(this.document.getDocumentElement(), ENTERPRISE_BEANS_TAG)) != null) {
            ArrayList arrayList = new ArrayList();
            if ((n & 1) != 0) {
                this.addToListEjbNames(arrayList, node, SESSION_TAG);
            }
            if ((n & 1) != 0) {
                this.addToListEjbNames(arrayList, node, ENTITY_TAG);
            }
            if ((n & 1) != 0) {
                this.addToListEjbNames(arrayList, node, MESSAGE_DRIVEN_TAG);
            }
            String[] stringArray = new String[arrayList.size()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)arrayList.get(n2);
                ++n2;
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getServlets() throws Exception {
        if (this.document != null) {
            ArrayList arrayList = this.findChildNodesByName(this.document.getDocumentElement(), SERVLET_TAG);
            String[] stringArray = new String[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                Node node = this.findChildNodeByName((Node)arrayList.get(n), SERVLET_NAME_TAG);
                stringArray[n] = this.getTextForNode(node);
                ++n;
            }
            return stringArray;
        }
        return new String[0];
    }

    private void addToListEjbNames(ArrayList arrayList, Node node, String string) {
        ArrayList arrayList2 = this.findChildNodesByName(node, string);
        int n = 0;
        while (n < arrayList2.size()) {
            Node node2 = this.findChildNodeByName((Node)arrayList2.get(n), EJB_NAME_TAG);
            arrayList.add(this.getTextForNode(node2));
            ++n;
        }
    }

    private Document createDocument(String string) throws Exception {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            AdminEntityResolver adminEntityResolver = new AdminEntityResolver();
            documentBuilder.setEntityResolver(adminEntityResolver);
            document = documentBuilder.parse(new File(string));
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            sLogger.throwing(this.getClass().getName(), "createDocument", exception);
            throw new ControlException(exception.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            sLogger.throwing(this.getClass().getName(), "createDocument", parserConfigurationException);
            throw new ControlException(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            sLogger.throwing(this.getClass().getName(), "createDocument", iOException);
            throw new ControlException(iOException.getLocalizedMessage());
        }
        return document;
    }

    private ArrayList findChildNodesByName(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase(string)) {
                arrayList.add(node);
            }
            node = node.getNextSibling();
        }
        return arrayList;
    }

    private Node findChildNodeByName(Node node, String string) {
        ArrayList arrayList = new ArrayList();
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase(string)) {
                return node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private String getModuleNameFromNode(Node node, int n) {
        ArrayList arrayList;
        if ((n & 1) != 0 && (arrayList = this.findChildNodesByName(node, EJB_MODULE_TAG)).size() > 0) {
            return this.getTextForNode((Node)arrayList.get(0));
        }
        if ((n & 4) != 0 && (arrayList = this.findChildNodesByName(node, JAVA_MODULE_TAG)).size() > 0) {
            return this.getTextForNode((Node)arrayList.get(0));
        }
        if ((n & 2) != 0 && (arrayList = this.findChildNodesByName(node, WEB_MODULE_TAG)).size() > 0 && (arrayList = this.findChildNodesByName(node = (Node)arrayList.get(0), WEB_URI_TAG)) != null && arrayList.size() > 0) {
            String string = this.getTextForNode((Node)arrayList.get(0));
            return string;
        }
        return null;
    }

    private String getTextForNode(Node node) {
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            node = node.getNextSibling();
        }
        return null;
    }
}

