/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.HTTPQosBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.AuthDb;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.util.i18n.StringManager;

public class ManagedVirtualServer
extends ConfigMBeanBase
implements ConfigAttributeName.VirtualServer {
    private static final String FAKE_ATTR = "@@~";
    private static final String[][] MAPLIST = new String[][]{{"id", "@" + ServerTags.ID}, {"httpListeners", "@" + ServerTags.HTTP_LISTENERS}, {"defaultWebModule", "@" + ServerTags.DEFAULT_WEB_MODULE}, {"configFile", "@" + ServerTags.CONFIG_FILE}, {"defaultObject", "@" + ServerTags.DEFAULT_OBJECT}, {"hosts", "@" + ServerTags.HOSTS}, {"mime", "@" + ServerTags.MIME}, {"state", "@" + ServerTags.STATE}, {"acls", "@" + ServerTags.ACLS}, {"accepotLanguage", "@" + ServerTags.ACCEPT_LANGUAGE}, {"logFile", "@" + ServerTags.LOG_FILE}, {"property.dir", "@@~"}, {"property.nice", "@@~"}, {"property.user", "@@~"}, {"property.group", "@@~"}, {"property.chroot", "@@~"}, {"property.docroot", "@@~"}, {"property.accesslog", "@@~"}};
    private static final String[] ATTRIBUTES = new String[]{"id, String,       R", "httpListeners, String,       RW", "defaultWebModule, String,       RW", "configFile, String,       RW", "defaultObject, String,       RW", "hosts, String,       RW", "mime, String,       RW", "state, String,       RW", "acls, String,       RW", "accepotLanguage, Boolean,      RW", "logFile, String,       RW", "property.dir, String,       RW", "property.nice, String,       RW", "property.user, String,       RW", "property.group, String,       RW", "property.chroot, String,       RW", "property.docroot, String,       RW", "property.accesslog, String,       RW"};
    private static final String[] OPERATIONS = new String[]{"createHttpQos(String bandwidthLimit, Boolean enforceBandwidthLimit, String connectionLimit, Boolean enforceConnectionLimit), ACTION", "deleteHttpQos(), ACTION", "isHttpQosCreated(), INFO", "createAuthDb(String id, String database, String basedn, String certmaps), ACTION", "deleteAuthDb(String id), ACTION", "listAuthDbs(), INFO"};
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServer == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServer = ManagedVirtualServer.class$("com.iplanet.ias.admin.server.core.mbean.config.ManagedVirtualServer")) : class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServer);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServer;

    public ManagedVirtualServer() throws MBeanConfigException {
        Object[] objectArray = ConfigMBeanBase.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, HTTPQosBase.MAPLIST, HTTPQosBase.ATTRIBUTES, ServerTags.HTTP_QOS, null);
        this.setDescriptions((String[][])objectArray[0], (String[])objectArray[1], OPERATIONS);
    }

    public ManagedVirtualServer(String string, String string2, String string3) throws MBeanConfigException {
        this();
        this.initialize("virtual-server", new String[]{string, string2, string3});
    }

    public void createHttpQos(String string, Boolean bl, String string2, Boolean bl2) throws ConfigException {
        HttpQos httpQos = new HttpQos();
        if (string != null) {
            httpQos.setBandwidthLimit(string);
        }
        if (bl != null) {
            httpQos.setEnforceBandwidthLimit(bl);
        }
        if (string2 != null) {
            httpQos.setConnectionLimit(string2);
        }
        if (bl2 != null) {
            httpQos.setEnforceConnectionLimit(bl2);
        }
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        virtualServer.setHttpQos(httpQos);
        this.getConfigContext().flush();
    }

    public boolean isHttpQosCreated() throws ConfigException {
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        return virtualServer.getHttpQos() != null;
    }

    public void deleteHttpQos() throws ConfigException {
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        virtualServer.setHttpQos(null);
        this.getConfigContext().flush();
    }

    public void createAuthDb(String string, String string2, String string3, String string4) throws ConfigException {
        AuthDb authDb = new AuthDb();
        if (string != null) {
            authDb.setId(string);
        }
        if (string2 != null) {
            authDb.setDatabase(string2);
        }
        if (string3 != null) {
            authDb.setBasedn(string3);
        }
        if (string4 != null) {
            authDb.setCertmaps(string4);
        }
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        virtualServer.addAuthDb(authDb);
        this.getConfigContext().flush();
    }

    public void deleteAuthDb(String string) throws ConfigException {
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        AuthDb authDb = virtualServer.getAuthDbById(string);
        if (authDb != null) {
            virtualServer.removeAuthDb(authDb);
        }
        this.getConfigContext().flush();
    }

    public String[] listAuthDbs() throws ConfigException {
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        AuthDb[] authDbArray = virtualServer.getAuthDb();
        String[] stringArray = new String[authDbArray.length];
        int n = 0;
        while (n < authDbArray.length) {
            stringArray[n] = authDbArray[n].getId();
            ++n;
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

