/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.JavaConfig;
import com.iplanet.ias.config.serverbeans.Profiler;
import com.iplanet.ias.config.serverbeans.ServerTags;

public class ManagedJVM
extends ConfigMBeanBase
implements ConfigAttributeName.JVM {
    private static final String[][] MAPLIST = new String[][]{{"javahome", "@" + ServerTags.JAVA_HOME}, {"debugEnabled", "@" + ServerTags.DEBUG_ENABLED}, {"debugOptions", "@" + ServerTags.DEBUG_OPTIONS}, {"rmicoptions", "@" + ServerTags.RMIC_OPTIONS}, {"javacOptions", "@" + ServerTags.JAVAC_OPTIONS}, {"classpathprefix", "@" + ServerTags.CLASSPATH_PREFIX}, {"serverClasspath", "@" + ServerTags.SERVER_CLASSPATH}, {"classpathsuffix", "@" + ServerTags.CLASSPATH_SUFFIX}, {"libpathprefix", "@" + ServerTags.NATIVE_LIBRARY_PATH_PREFIX}, {"libpathsuffix", "@" + ServerTags.NATIVE_LIBRARY_PATH_SUFFIX}, {"envpathignore", "@" + ServerTags.ENV_CLASSPATH_IGNORED}};
    private static final String[] ATTRIBUTES = new String[]{"javahome,   String,  RW", "debugEnabled,   boolean, RW", "debugOptions,   String,  RW", "rmicoptions,   String,  RW", "javacOptions,   String,  RW", "classpathprefix,   String,  RW", "serverClasspath,   String,  RW", "classpathsuffix,   String,  RW", "libpathprefix,   String,  RW", "libpathsuffix,   String,  RW", "envpathignore,   boolean, RW"};
    private static final String[] OPERATIONS = new String[]{"createProfiler(String name, String classpath, String nativeLibraryPath, Boolean enabled), ACTION", "deleteProfiler(), ACTION", "isProfilerExist(), INFO", "getProfiler(), INFO", "getJvmOptions(), INFO", "setJvmOptions(String[] options), ACTION"};
    private final String JVM_NODE_PATH = "/server/java-config";

    public ManagedJVM() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedJVM(String string) throws MBeanConfigException {
        this();
        this.initialize("java-config", new String[]{string});
    }

    public void createProfiler(String string, String string2, String string3, Boolean bl) throws ConfigException {
        Profiler profiler = new Profiler();
        if (string != null) {
            profiler.setName(string);
        }
        if (string2 != null) {
            profiler.setClasspath(string2);
        }
        if (string3 != null) {
            profiler.setNativeLibraryPath(string3);
        }
        if (bl != null) {
            profiler.setEnabled(bl);
        }
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setProfiler(profiler);
        this.getConfigContext().flush();
    }

    public void deleteProfiler() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setProfiler(null);
        this.getConfigContext().flush();
    }

    public boolean isProfilerExist() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        return javaConfig.getProfiler() != null;
    }

    public String getProfiler() throws ConfigException {
        String string = null;
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        Profiler profiler = javaConfig.getProfiler();
        if (profiler != null) {
            string = profiler.getName();
        }
        return string;
    }

    public String[] getJvmOptions() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        return javaConfig.getJvmOptions();
    }

    public void setJvmOptions(String[] stringArray) throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setJvmOptions(stringArray);
        this.getConfigContext().flush();
    }
}

