/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.channel;

import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.channel.AdminChannelServer;
import com.iplanet.ias.admin.server.core.channel.LocalRMIClientSocketFactory;
import com.iplanet.ias.admin.server.core.channel.LocalRMIServerSocketFactory;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.server.J2EEServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminChannel {
    static Logger logger;
    static final String instanceRoot;
    static final String fileSeparator = "/";
    static final int SEED_LENGTH = 16;
    private static AdminChannelServer server;
    private static HashMap rmiClientMap;
    private static StringManager localStrings;
    static final String stubFileName = "admch";
    static final String seedFileName = "admsn";
    static final String LOCAL_ONLY_ACCESS = "high";
    static final String ALLOW_ALL_ACCESS = "none";
    static final String ENFORCE = "high";
    static final String REQUIRE_KEY = "medium";
    static final String NO_ENFORCE = "low";
    static final String SERVER_CREATION_ERRCODE = "channel.creation_error";
    static final String KEY_READ_ERROR = "channel.key_read_error";
    static final String KEY_WRITE_ERROR = "channel.key_write_error";
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$channel$AdminChannel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void createRMIChannel() throws ServerLifecycleException {
        try {
            server = AdminChannel.createServerObject();
            AdminChannel.saveStubToFile(server.getRemoteStub());
        }
        catch (Exception exception) {
            AdminChannel.warn(SERVER_CREATION_ERRCODE);
            AdminChannel.debug(exception);
            throw new ServerLifecycleException(exception);
        }
    }

    public static void destroyRMIChannel() throws ServerLifecycleException {
        if (server != null) {
            server.setChannelStopping();
            try {
                UnicastRemoteObject.unexportObject(server, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new ServerLifecycleException(noSuchObjectException);
            }
        }
        AdminChannel.deleteStubFile();
    }

    public static void createSharedSecret() throws ServerLifecycleException {
        AdminChannel.assertAdminServiceNotNull();
        AdminChannel.assertAdminServerChannelNotNull();
        String string = AdminChannel.getSeedFileName(AdminService.getAdminService().getInstanceName());
        File file = new File(string);
        byte[] byArray = AdminChannel.getPreviousSeed(file);
        SecureRandom secureRandom = new SecureRandom(byArray);
        byte[] byArray2 = new byte[16];
        secureRandom.nextBytes(byArray2);
        AdminChannel.saveSeedToFile(byArray2, file);
        server.setSharedInfo(byArray2);
        server.setChannelStarting();
    }

    public static RMIClient getRMIClient(String string) {
        RMIClient rMIClient = (RMIClient)rmiClientMap.get(string);
        if (rMIClient == null) {
            rMIClient = new RMIClient(AdminChannel.getStubFileName(string), AdminChannel.getSeedFileName(string));
            rmiClientMap.put(string, rMIClient);
        }
        return rMIClient;
    }

    public static void setRMIChannelReady() {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelReady();
    }

    static String getStubFileName(String string) {
        return instanceRoot + fileSeparator + string + fileSeparator + "config" + fileSeparator + stubFileName;
    }

    static String getSeedFileName(String string) {
        return instanceRoot + fileSeparator + string + fileSeparator + "config" + fileSeparator + seedFileName;
    }

    private static AdminChannelServer createServerObject() throws RemoteException {
        AdminChannelServer adminChannelServer = null;
        InetAddress inetAddress = AdminChannel.getLocalLoopbackAddress();
        if (inetAddress == null) {
            adminChannelServer = new AdminChannelServer();
        } else {
            LocalRMIClientSocketFactory localRMIClientSocketFactory = new LocalRMIClientSocketFactory(inetAddress);
            LocalRMIServerSocketFactory localRMIServerSocketFactory = new LocalRMIServerSocketFactory(inetAddress);
            adminChannelServer = new AdminChannelServer(0, localRMIClientSocketFactory, localRMIServerSocketFactory);
            adminChannelServer.setLocalAddress(inetAddress);
        }
        return adminChannelServer;
    }

    private static InetAddress getLocalLoopbackAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
            if (!inetAddress.isLoopbackAddress()) {
                inetAddress = null;
            }
        }
        catch (Throwable throwable) {
            inetAddress = null;
        }
        return inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static byte[] getPreviousSeed(File var0) {
        block14: {
            var1_1 = false;
            var2_2 = new byte[16];
            var3_3 = J2EEServer.secureRandom;
            if (!AdminChannel.$assertionsDisabled && var3_3 == null) {
                throw new AssertionError();
            }
            var3_3.setSeed(System.currentTimeMillis());
            if (var0.exists() && var0.canRead()) {
                var4_4 = null;
                try {
                    var4_4 = new FileInputStream(var0);
                    var4_4.read(var2_2);
                    var3_3.setSeed(var2_2);
                    var3_3.nextBytes(var2_2);
                    var1_1 = true;
                    var7_5 = null;
                    ** if (var4_4 == null) goto lbl-1000
                }
                catch (Throwable var6_12) {
                    var7_7 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var8_10) {
                            // empty catch block
                        }
                    }
                    throw var6_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var4_4.close();
                    }
                    catch (IOException var8_8) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (IOException var5_11) {
                        AdminChannel.warn("channel.key_read_error");
                        AdminChannel.debug(var5_11);
                        var7_6 = null;
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var8_9) {}
                        }
                    }
                }
            }
        }
        if (!var1_1) {
            var3_3.nextBytes(var2_2);
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveSeedToFile(byte[] byArray, File file) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        Object var5_3 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                AdminChannel.warn(KEY_WRITE_ERROR);
                AdminChannel.debug(iOException);
                Object var5_4 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void saveStubToFile(RemoteStub remoteStub) {
        AdminChannel.assertAdminServiceNotNull();
        String string = AdminChannel.getStubFileName(AdminService.getAdminService().getInstanceName());
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(remoteStub);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = localStrings.getString("admin.server.core.channel.unable_saving_stub_to_file", string);
            throw new RuntimeException(string2, exception);
        }
    }

    private static void deleteStubFile() {
        String string = AdminChannel.getStubFileName(AdminService.getAdminService().getInstanceName());
        new File(string).delete();
    }

    private static final void assertAdminServiceNotNull() {
        if (AdminService.getAdminService() == null) {
            String string = localStrings.getString("admin.server.core.channel.admin_service_not_initialized");
            throw new RuntimeException(string);
        }
    }

    private static final void assertAdminServerChannelNotNull() {
        if (server == null) {
            String string = localStrings.getString("admin.server.core.channel.admin_server_channel_not_initialized");
            throw new RuntimeException(string);
        }
    }

    static void warn(String string) {
        logger.warning(string);
    }

    static void warn(String string, String string2) {
        logger.log(Level.WARNING, string, string2);
    }

    static void debug(String string) {
        logger.fine(string);
    }

    static void debug(String string, String string2) {
        logger.log(Level.FINE, string, string2);
    }

    static void debug(String string, Object[] objectArray) {
        logger.log(Level.FINE, string, objectArray);
    }

    static void debug(Throwable throwable) {
        logger.log(Level.FINE, throwable.getMessage(), throwable);
    }

    static void trace(Throwable throwable) {
        logger.log(Level.FINEST, throwable.getMessage(), throwable);
    }

    static String getAccessLevel() {
        return "high";
    }

    static String getKeyCheckLevel() {
        return "high";
    }

    static boolean getClientAutoRefreshEnabled() {
        return true;
    }

    static long getClientAutoRefreshInterval() {
        return 60000L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$admin$server$core$channel$AdminChannel == null ? (class$com$iplanet$ias$admin$server$core$channel$AdminChannel = AdminChannel.class$("com.iplanet.ias.admin.server.core.channel.AdminChannel")) : class$com$iplanet$ias$admin$server$core$channel$AdminChannel).desiredAssertionStatus();
        logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        instanceRoot = AdminService.getAdminService().getContext().getInstallRoot();
        server = null;
        rmiClientMap = new HashMap();
        localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$channel$AdminChannel == null ? (class$com$iplanet$ias$admin$server$core$channel$AdminChannel = AdminChannel.class$("com.iplanet.ias.admin.server.core.channel.AdminChannel")) : class$com$iplanet$ias$admin$server$core$channel$AdminChannel);
    }
}

