/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.TableIndex;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.ResourceBundle;

public abstract class QueryPlan {
    public static final int ACT_NOOP = 5;
    public static final int ACT_DELETE = 3;
    public static final int ACT_INSERT = 2;
    public static final int ACT_SELECT = 4;
    public static final int ACT_UPDATE = 1;
    public static final int ST_BUILT = 1;
    public static final int ST_EXECUTED = 2;
    public ArrayList statements;
    public ClassDesc config;
    public int status;
    public int action;
    public int options;
    protected SQLStoreManager store;
    protected ArrayList tables = new ArrayList();
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$QueryPlan == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$QueryPlan = QueryPlan.class$("com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan")) : class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$QueryPlan).getClassLoader());
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$QueryPlan;

    public QueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager) {
        this.statements = new ArrayList();
        this.store = sQLStoreManager;
        this.config = (ClassDesc)sQLStoreManager.getPersistenceConfig(actionDesc.getPersistenceCapableClass());
    }

    public QueryTable addQueryTable(TableDesc tableDesc) {
        QueryTable queryTable = new QueryTable(tableDesc);
        this.tables.add(queryTable);
        queryTable.setTableIndex(new TableIndex(this.tables.size() - 1));
        return queryTable;
    }

    public QueryTable addQueryTable(TableElement tableElement, ClassDesc classDesc) {
        TableDesc tableDesc = null;
        tableDesc = classDesc == null ? this.config.findTableDesc(tableElement) : classDesc.findTableDesc(tableElement);
        if (tableDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.classnotmapped", this.config.getPersistenceCapableClass().getName(), tableDesc.getName()));
        }
        return this.addQueryTable(tableDesc);
    }

    public void addQueryTables(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            QueryTable queryTable = (QueryTable)arrayList.get(n);
            if (this.tables.indexOf(queryTable) == -1) {
                this.tables.add(queryTable);
                queryTable.getTableIndex().setValue(this.tables.size() - 1);
            }
            ++n;
        }
    }

    public QueryTable findQueryTable(TableElement tableElement) {
        int n = 0;
        while (n < this.tables.size()) {
            QueryTable queryTable = (QueryTable)this.tables.get(n);
            if (queryTable.getTableDesc().getTableElement() == tableElement) {
                return queryTable;
            }
            ++n;
        }
        return null;
    }

    public QueryTable findQueryTable(TableDesc tableDesc) {
        int n = 0;
        while (n < this.tables.size()) {
            QueryTable queryTable = (QueryTable)this.tables.get(n);
            if (queryTable.getTableDesc() == tableDesc) {
                return queryTable;
            }
            ++n;
        }
        return null;
    }

    public ArrayList getStatements() {
        int n = 0;
        while (n < this.statements.size()) {
            Statement statement = (Statement)this.statements.get(n);
            String string = statement.getText();
            ++n;
        }
        return this.statements;
    }

    protected Statement addStatement(QueryTable queryTable) {
        Statement statement = this.createStatement(queryTable);
        this.statements.add(statement);
        return statement;
    }

    protected abstract Statement newStatement();

    protected Statement createStatement(QueryTable queryTable) {
        Statement statement = this.newStatement();
        statement.plan = this;
        statement.action = this.action;
        statement.addQueryTable(queryTable);
        return statement;
    }

    protected Statement getStatement(QueryTable queryTable) {
        if (queryTable == null) {
            return null;
        }
        int n = 0;
        while (n < this.statements.size()) {
            Statement statement = (Statement)this.statements.get(n);
            if (statement.tableList.indexOf(queryTable) != -1) {
                return statement;
            }
            ++n;
        }
        return null;
    }

    public abstract void build();

    protected void processStatements() {
        int n = 0;
        while (n < this.statements.size()) {
            ArrayList arrayList;
            Statement statement = (Statement)this.statements.get(n);
            QueryTable queryTable = (QueryTable)statement.getQueryTables().get(0);
            ArrayList arrayList2 = queryTable.getTableDesc().getSubtableKeys();
            if (arrayList2 != null) {
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    ReferenceKeyDesc referenceKeyDesc = (ReferenceKeyDesc)arrayList2.get(n2);
                    statement.addSubtableStatement(this.getStatement(this.findQueryTable(referenceKeyDesc.getTableDesc())));
                    ++n2;
                }
            }
            if ((arrayList = queryTable.getTableDesc().getSecondaryTableKeys()) != null) {
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    ReferenceKeyDesc referenceKeyDesc = (ReferenceKeyDesc)arrayList.get(n3);
                    statement.addSecondaryTableStatement(this.getStatement(this.findQueryTable(referenceKeyDesc.getTableDesc())));
                    ++n3;
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

