/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataFatalError;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataProperties;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class JDOMetaDataPropertyImpl
extends Support
implements ExtendedJDOMetaData {
    private static final HashSet transientTypePrefixes = new HashSet();
    private static final HashSet secondClassObjectTypes = new HashSet();
    private static final HashSet mutableSecondClassObjectTypes = new HashSet();
    private final JDOMetaDataProperties properties;

    public JDOMetaDataPropertyImpl(Properties properties, PrintWriter printWriter) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (properties == null) {
            throw new JDOMetaDataFatalError("Initializing meta data: properties == null");
        }
        this.properties = new JDOMetaDataProperties(properties);
        this.readProperties();
    }

    public JDOMetaDataPropertyImpl(Properties properties) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        this(properties, null);
    }

    public boolean isPersistenceCapableClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        Object object;
        Iterator iterator = transientTypePrefixes.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!string.startsWith((String)object)) continue;
            return false;
        }
        object = this.getJDOClass(string);
        return object != null ? ((JDOMetaDataProperties.JDOClass)object).isPersistent() : false;
    }

    public boolean isTransientClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return !this.isPersistenceCapableClass(string);
    }

    public boolean isPersistenceCapableRootClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (!this.isPersistenceCapableClass(string)) {
            return false;
        }
        String string2 = this.getSuperClass(string);
        return string2 != null ? !this.isPersistenceCapableClass(string2) : true;
    }

    public String getPersistenceCapableRootClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistenceCapableClass(string) ? string : null;
    }

    public final String getSuperClass(String string) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getSuperClassName() : null;
    }

    public boolean isSecondClassObjectType(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return secondClassObjectTypes.contains(string);
    }

    public boolean isMutableSecondClassObjectType(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return mutableSecondClassObjectTypes.contains(string);
    }

    public boolean isPersistentField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.isPersistent() : false;
    }

    public boolean isTransactionalField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.isTransactional() : false;
    }

    public boolean isPrimaryKeyField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.isPk() : false;
    }

    public boolean isDefaultFetchGroupField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.isInDefaultFetchGroup() : false;
    }

    public int getFieldNo(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getIndexOfField(string2) : -1;
    }

    public String[] getManagedFields(String string) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getManagedFieldNames() : new String[]{};
    }

    public final String[] getKnownClasses() {
        return this.properties.getKnownClassNames();
    }

    public final String[] getKnownFields(String string) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getFields() : new String[]{};
    }

    public final int getClassModifiers(String string) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getModifiers() : 0;
    }

    public final int getFieldModifiers(String string, String string2) {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.getModifiers() : 0;
    }

    public final String getFieldType(String string, String string2) {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.getType() : null;
    }

    private final JDOMetaDataProperties.JDOClass getJDOClass(String string) throws JDOMetaDataUserException {
        return this.properties.getJDOClass(string);
    }

    private final void readProperties() {
        String[] stringArray = this.properties.getKnownClassNames();
        int n = stringArray.length - 1;
        while (n >= 0) {
            JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(stringArray[n]);
            if (jDOClass.isPersistent() && secondClassObjectTypes.contains(jDOClass.getName())) {
                throw new JDOMetaDataUserException("ERROR: Parsing meta data properties: The persistent-capable class '" + jDOClass.getName() + "' is second class object type.");
            }
            --n;
        }
    }

    private final JDOMetaDataProperties.JDOField getJDOField(String string, String string2) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getField(string2) : null;
    }

    public String getKeyClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        return jDOClass != null ? jDOClass.getOidClassName() : null;
    }

    public boolean isKeyField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField jDOField = this.getJDOField(string, string2);
        return jDOField != null ? jDOField.isPk() : false;
    }

    public boolean isKnownNonManagedField(String string, String string2, String string3) {
        JDOMetaDataProperties.JDOClass jDOClass = this.getJDOClass(string);
        if (jDOClass == null) {
            return true;
        }
        JDOMetaDataProperties.JDOField jDOField = jDOClass.getField(string2);
        return jDOField != null ? jDOField.isKnownTransient() : false;
    }

    public boolean isManagedField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistentField(string, string2) || this.isTransactionalField(string, string2);
    }

    public int getFieldFlags(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (!this.isManagedField(string, string2)) {
            Assertion.affirm(!this.isTransactionalField(string, string2));
            Assertion.affirm(!this.isPersistentField(string, string2));
            Assertion.affirm(!this.isKeyField(string, string2));
            Assertion.affirm(!this.isDefaultFetchGroupField(string, string2));
            return 0;
        }
        if (this.isTransactionalField(string, string2)) {
            Assertion.affirm(!this.isPersistentField(string, string2));
            Assertion.affirm(!this.isKeyField(string, string2));
            return 4;
        }
        Assertion.affirm(this.isPersistentField(string, string2));
        if (this.isKeyField(string, string2)) {
            return 8;
        }
        if (this.isDefaultFetchGroupField(string, string2)) {
            return 5;
        }
        return 10;
    }

    public int[] getFieldFlags(String string, String[] stringArray) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        int n = stringArray != null ? stringArray.length : 0;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getFieldFlags(string, stringArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public final String[] getFieldType(String string, String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = this.getFieldType(string, stringArray[n2]);
            ++n2;
        }
        return stringArray2;
    }

    public int[] getFieldNo(String string, String[] stringArray) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        int n = stringArray != null ? stringArray.length : 0;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getFieldNo(string, stringArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public String[] getKeyFields(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getManagedFields(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.isKeyField(string, stringArray[n2])) {
                arrayList.add(stringArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPersistenceCapableSuperClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = this.getSuperClass(string);
        while (string2 != null) {
            if (this.isPersistenceCapableClass(string2)) {
                return string2;
            }
            string2 = this.getSuperClass(string2);
        }
        return null;
    }

    public String getSuperKeyClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = this.getPersistenceCapableSuperClass(string);
        while (string2 != null) {
            String string3 = this.getKeyClass(string2);
            if (string3 != null) {
                return string3;
            }
            string2 = this.getPersistenceCapableSuperClass(string2);
        }
        return null;
    }

    static {
        transientTypePrefixes.add("java/");
        transientTypePrefixes.add("javax/");
        transientTypePrefixes.add("com/sun/jdo/");
        mutableSecondClassObjectTypes.add("java/util/Date");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/Date");
        mutableSecondClassObjectTypes.add("java/sql/Date");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlTime");
        mutableSecondClassObjectTypes.add("java/sql/Time");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlDate");
        mutableSecondClassObjectTypes.add("java/sql/Timestamp");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlTimestamp");
        mutableSecondClassObjectTypes.add("java/util/Collection");
        mutableSecondClassObjectTypes.add("java/util/Set");
        mutableSecondClassObjectTypes.add("java/util/List");
        mutableSecondClassObjectTypes.add("java/util/HashSet");
        mutableSecondClassObjectTypes.add("java/util/Vector");
        mutableSecondClassObjectTypes.add("java/util/ArrayList");
        secondClassObjectTypes.add("java/lang/Boolean");
        secondClassObjectTypes.add("java/lang/Byte");
        secondClassObjectTypes.add("java/lang/Short");
        secondClassObjectTypes.add("java/lang/Integer");
        secondClassObjectTypes.add("java/lang/Long");
        secondClassObjectTypes.add("java/lang/Float");
        secondClassObjectTypes.add("java/lang/Double");
        secondClassObjectTypes.add("java/lang/Number");
        secondClassObjectTypes.add("java/lang/Character");
        secondClassObjectTypes.add("java/lang/String");
        secondClassObjectTypes.add("java/math/BigInteger");
        secondClassObjectTypes.add("java/math/BigDecimal");
        secondClassObjectTypes.addAll(mutableSecondClassObjectTypes);
    }
}

