/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class ClassControl
extends Support {
    public static final int TransientOnly = -1;
    public static final int PersistUnknown = 0;
    public static final int PersistAware = 1;
    public static final int PersistCapable = 2;
    public static final int UpdateNotNeeded = -1;
    public static final int UpdateUnknown = 0;
    public static final int UpdateNew = 1;
    public static final int UpdateNewer = 2;
    private final Environment env;
    private final ClassFileSource theClassSource;
    private ClassFile theClass;
    private int persistenceType = 0;
    private int updateType = 0;
    private final ClassAction classAction;
    private boolean classUpdated;

    public boolean updated() {
        return this.classUpdated;
    }

    public void noteUpdate() {
        this.classUpdated = true;
    }

    public ClassFile classFile() {
        return this.theClass;
    }

    public int persistType() {
        return this.persistenceType;
    }

    public boolean filterRequired() {
        if (this.updateType == 0) {
            this.checkUpdateType();
        }
        return this.updateType > 0 || this.env.forceOverwrite();
    }

    public void requireUpdate() {
        this.updateType = 1;
    }

    public boolean annotateable() {
        return this.persistenceType >= 0;
    }

    public ClassAction action() {
        return this.classAction;
    }

    public ClassControl(ClassFileSource classFileSource, Environment environment) {
        this.theClassSource = classFileSource;
        this.buildTheClass(true);
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this, environment);
        this.env = environment;
    }

    public ClassControl(ClassFileSource classFileSource, ClassFile classFile, Environment environment) {
        this.theClassSource = classFileSource;
        this.theClass = classFile;
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this, environment);
        this.env = environment;
    }

    private void setPersistenceType() {
        JDOMetaData jDOMetaData = this.env.getJDOMetaData();
        if (this.persistenceType != 0) {
            return;
        }
        if (this.classFile().isInterface()) {
            this.persistenceType = -1;
            return;
        }
        String string = this.className();
        if (jDOMetaData.isTransientClass(string)) {
            this.persistenceType = -1;
            return;
        }
        if (jDOMetaData.isPersistenceCapableClass(string)) {
            this.persistenceType = 2;
            Assertion.affirm(jDOMetaData.isPersistenceCapableRootClass(string), "Sorry, not supported yet: the persistent-capable class " + this.userClassName() + "cannot extend a persistent-capable super-class.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan1() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.scan1()");
            }
            this.setPersistenceType();
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.scan1();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void augment() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.augment()");
            }
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.augment();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.annotate()");
            }
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.annotate();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
            Object var2_1 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
            throw throwable;
        }
    }

    public String className() {
        ConstClass constClass = this.theClass.className();
        return constClass == null ? null : constClass.asString();
    }

    public String userClassName() {
        return ClassControl.userClassFromVMClass(this.className());
    }

    public static String userClassFromVMClass(String string) {
        return string.replace('/', '.');
    }

    public static String vmClassFromUserClass(String string) {
        return string.replace('.', '/');
    }

    public String pkg() {
        return ClassControl.packageOf(this.className());
    }

    public static String packageOf(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public String sourceName() {
        return this.theClassSource.containingFilePath();
    }

    public ClassFileSource source() {
        return this.theClassSource;
    }

    public void write(File file) throws IOException, FileNotFoundException {
        DataOutputStream dataOutputStream = this.theClassSource.getOutputStream(file);
        this.theClass.write(dataOutputStream);
        dataOutputStream.close();
    }

    private void checkUpdateType() {
        block6: {
            if (this.updateType != 0) break block6;
            String string = this.className();
            ClassFileSource classFileSource = this.env.updateInPlace() && !this.theClassSource.isZipped() ? this.theClassSource : this.env.lookupDestClass(string);
            if (classFileSource == null) {
                this.updateType = 1;
            } else {
                try {
                    long l = classFileSource.modificationDate();
                    long l2 = this.source().modificationDate();
                    if (l < l2) {
                        this.updateType = 2;
                        break block6;
                    }
                    if (classFileSource == this.theClassSource && !this.action().hasAnnotatedAttribute()) {
                        this.updateType = this.persistenceType == 2 || this.persistenceType == 1 ? 2 : -1;
                        break block6;
                    }
                    this.updateType = -1;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.updateType = 1;
                }
            }
        }
    }

    private void buildTheClass(boolean bl) {
        try {
            DataInputStream dataInputStream = this.theClassSource.classFileContents();
            this.theClass = new ClassFile(dataInputStream);
            dataInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UserException(Support.getI18N("enhancer.file_not_found", this.sourceName()), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UserException(Support.getI18N("enhancer.io_error_while_reading_file", this.sourceName()), iOException);
        }
    }
}

