/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.OutputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ByteCodeEnhancerHelper {
    public static final boolean enhanceClassFile(ByteCodeEnhancer byteCodeEnhancer, InputStream inputStream, OutputStream outputStream) throws EnhancerUserException, EnhancerFatalError {
        return byteCodeEnhancer.enhanceClassFile(inputStream, new OutputStreamWrapper(outputStream));
    }

    public static final boolean enhanceZipFile(ByteCodeEnhancer byteCodeEnhancer, ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws EnhancerUserException, EnhancerFatalError {
        boolean bl = false;
        try {
            ZipEntry zipEntry;
            CRC32 cRC32 = new CRC32();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                InputStream inputStream = zipInputStream;
                ZipEntry zipEntry2 = new ZipEntry(zipEntry);
                if (ByteCodeEnhancerHelper.isClassFileEntry(zipEntry)) {
                    inputStream = ByteCodeEnhancerHelper.openZipEntry(zipInputStream);
                    inputStream.mark(Integer.MAX_VALUE);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    if (byteCodeEnhancer.enhanceClassFile(inputStream, byteArrayOutputStream)) {
                        bl = true;
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                        inputStream.close();
                        ByteCodeEnhancerHelper.modifyZipEntry(zipEntry2, byArray, cRC32);
                        inputStream = new ByteArrayInputStream(byArray);
                    } else {
                        inputStream.reset();
                    }
                }
                zipOutputStream.putNextEntry(zipEntry2);
                ByteCodeEnhancerHelper.copyZipEntry(inputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                if (inputStream == zipInputStream) continue;
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new EnhancerFatalError(iOException);
        }
        return bl;
    }

    private static final void copyZipEntry(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while (inputStream.available() > 0 && (n = inputStream.read()) > -1) {
            outputStream.write(n);
        }
    }

    private static final InputStream openZipEntry(ZipInputStream zipInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteCodeEnhancerHelper.copyZipEntry(zipInputStream, byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static final void modifyZipEntry(ZipEntry zipEntry, byte[] byArray, CRC32 cRC32) {
        zipEntry.setSize(byArray.length);
        if (zipEntry.getMethod() == 0) {
            cRC32.reset();
            cRC32.update(byArray);
            zipEntry.setCrc(cRC32.getValue());
            zipEntry.setCompressedSize(byArray.length);
        }
    }

    private static final boolean isClassFileEntry(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(".class");
    }
}

