/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.compile;

import com.iplanet.ias.tools.forte.compile.InternalCompiler;
import com.iplanet.ias.tools.forte.compile.WDCompilationDescriptor;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;

public class InternalCompilerContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ClassLoader loader;
    boolean errPage;
    String jspFile;
    String servletClassName;
    String servletPackageName = "_jasper";
    String servletJavaFileName;
    String contentType;
    Options options;
    String uriBase;
    File uriRoot;
    WDCompilationDescriptor cd;

    public InternalCompilerContext(ClassLoader newLoader, String newJspFile, WDCompilationDescriptor compDesc, boolean newErrPage, Options newOptions) throws JasperException {
        this.loader = newLoader;
        this.jspFile = newJspFile;
        this.errPage = newErrPage;
        this.options = newOptions;
        this.cd = compDesc;
    }

    public String getClassPath() {
        return "";
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isErrorPage() {
        return this.errPage;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJavacOutputDir() {
        throw new UnsupportedOperationException();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    String getRealClassName() {
        String pkg = this.getServletPackageName();
        pkg = pkg != null ? pkg + "." : "";
        return pkg + this.getServletClassName();
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setErrorPage(boolean isErrPage) {
        this.errPage = isErrPage;
    }

    public Compiler createCompiler() throws JasperException {
        InternalCompiler comp = new InternalCompiler(this);
        String className = comp.getMangler().getClassName();
        this.setServletClassName(className);
        return comp;
    }

    public String resolveRelativeUri(String uri) {
        return this.cd.resolveRelativeURI(uri);
    }

    public InputStream getResourceAsStream(String res) {
        return this.cd.getResourceAsStream(res);
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.cd.getResource(res);
    }

    public String getRealPath(String path) {
        return this.cd.getRealPath(path);
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.options.getTldLocationsCache().getLocation(uri);
        return location;
    }
}

