/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.util.Enumeration;
import java.util.Vector;

public class Role
implements Comparable {
    private String description = null;
    private String name = null;
    private Vector users = new Vector();
    private Vector groups = new Vector();

    public Role(String name, String description) {
        Reporter.assertIt(name);
        this.name = name;
        this.description = description;
    }

    public int compareTo(Object o) {
        Reporter.assertIt(o instanceof Role, "Illegal call to compareTo with a non-role -- " + o.getClass().getName());
        Role role = (Role)o;
        return this.getName().compareTo(role.getName());
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasUser(String user) {
        Enumeration e = this.getUsersEnum();
        while (e.hasMoreElements()) {
            String aUser = (String)e.nextElement();
            if (!aUser.equals(user)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroup(String group) {
        Enumeration e = this.getGroupsEnum();
        while (e.hasMoreElements()) {
            String aGroup = (String)e.nextElement();
            if (!aGroup.equals(group)) continue;
            return true;
        }
        return false;
    }

    public Vector getUsers() {
        return this.users;
    }

    public Vector getGroups() {
        return this.groups;
    }

    void addUser(String name) {
        if (this.users.indexOf(name) >= 0) {
            return;
        }
        this.users.addElement(name);
    }

    void addGroup(String name) {
        if (this.groups.indexOf(name) >= 0) {
            return;
        }
        this.groups.addElement(name);
    }

    void removeUser(String user) {
        int index = this.users.indexOf(user);
        if (index < 0) {
            Reporter.warn("No such mapped user: " + user);
            return;
        }
        this.users.removeElementAt(index);
    }

    void removeGroup(String group) {
        int index = this.groups.indexOf(group);
        if (index < 0) {
            Reporter.warn("No such mapped group: " + group);
            return;
        }
        this.groups.removeElementAt(index);
    }

    boolean hasUsers() {
        return this.users.size() > 0;
    }

    boolean hasGroups() {
        return this.groups.size() > 0;
    }

    boolean hasMapping() {
        if (this.users.size() > 0) {
            return true;
        }
        return this.groups.size() > 0;
    }

    Enumeration getUsersEnum() {
        return this.users.elements();
    }

    Enumeration getGroupsEnum() {
        return this.groups.elements();
    }
}

