/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ConfigurationController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.ServerComponentController;
import com.iplanet.ias.admin.util.ArgChecker;
import javax.management.AttributeList;

public abstract class ServerComponent
implements Controllable {
    protected final String identifier;
    private String displayName;
    private ContextHolder contextHolder;
    private boolean isChanged = false;
    private transient ConfigurationController configController;

    protected ServerComponent() {
        this.identifier = null;
    }

    protected ServerComponent(String identifier) {
        ArgChecker.checkValid(identifier, "identifier");
        this.identifier = identifier;
        this.configController = new ServerComponentController(this);
    }

    protected ServerComponent(String identifier, String displayName) {
        this(identifier);
        this.displayName = displayName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract Controller getController();

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        return this.configController.getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object value) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        this.configController.setAttribute(attributeName, value);
    }

    public AttributeList getAttributes(String[] attributeNames) throws AFException {
        return this.configController.getAttributes(attributeNames);
    }

    public AttributeList setAttributes(AttributeList al) throws AFException {
        return this.configController.setAttributes(al);
    }

    public Object getDefaultAttributeValue(String attributeName) throws AFException {
        return this.configController.getDefaultAttributeValue(attributeName);
    }

    public void applyChanges() throws AFException {
        this.configController.applyChanges();
    }

    public String[] queryAttributeNames() {
        return null;
    }

    public void setContextHolder(ContextHolder ctxHolder) {
        this.contextHolder = ctxHolder;
    }

    public ContextHolder getContextHolder() {
        return this.contextHolder;
    }

    public String toString() {
        String str = this.displayName != null ? this.displayName : this.identifier;
        return str;
    }
}

