/*
 * Decompiled with CFR 0.152.
 */
package samples.webservices.jaxr.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRQueryByNAICSClassification {
    Connection connection = null;

    public static void main(String[] stringArray) {
        String string = "http://www-3.ibm.com/services/uddi/v2beta/inquiryapi";
        String string2 = "https://www-3.ibm.com/services/uddi/v2beta/protect/publishapi";
        JAXRQueryByNAICSClassification jAXRQueryByNAICSClassification = new JAXRQueryByNAICSClassification();
        jAXRQueryByNAICSClassification.makeConnection(string, string2);
        jAXRQueryByNAICSClassification.executeQuery();
    }

    public void makeConnection(String string, String string2) {
        block4: {
            String string3 = "";
            String string4 = "8080";
            String string5 = "";
            String string6 = "8080";
            Properties properties = new Properties();
            properties.setProperty("javax.xml.registry.queryManagerURL", string);
            properties.setProperty("javax.xml.registry.lifeCycleManagerURL", string2);
            properties.setProperty("com.sun.xml.registry.http.proxyHost", string3);
            properties.setProperty("com.sun.xml.registry.http.proxyPort", string4);
            properties.setProperty("com.sun.xml.registry.https.proxyHost", string5);
            properties.setProperty("com.sun.xml.registry.https.proxyPort", string6);
            try {
                ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
                connectionFactory.setProperties(properties);
                this.connection = connectionFactory.createConnection();
                System.out.println("Created connection to registry");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.connection == null) break block4;
                try {
                    this.connection.close();
                }
                catch (JAXRException jAXRException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQuery() {
        RegistryService registryService = null;
        BusinessQueryManager businessQueryManager = null;
        BusinessLifeCycleManager businessLifeCycleManager = null;
        registryService = this.connection.getRegistryService();
        businessQueryManager = registryService.getBusinessQueryManager();
        businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
        System.out.println("Got registry service, query manager, and lifecycle manager");
        ClassificationScheme classificationScheme = businessQueryManager.findClassificationSchemeByName(null, "ntis-gov:naics");
        Classification classification = businessLifeCycleManager.createClassification(classificationScheme, "Snack and Nonalcoholic Beverage Bars", "722213");
        ArrayList<Classification> arrayList = new ArrayList<Classification>();
        arrayList.add(classification);
        BulkResponse bulkResponse = businessQueryManager.findOrganizations(null, null, arrayList, null, null, null);
        Collection collection = bulkResponse.getCollection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EmailAddress emailAddress;
            Iterator iterator2;
            Collection collection2;
            Object object;
            Object object2;
            Object object3;
            Organization organization = (Organization)iterator.next();
            System.out.println("Org name: " + this.getName((RegistryObject)organization));
            System.out.println("Org description: " + this.getDescription((RegistryObject)organization));
            System.out.println("Org key id: " + this.getKey((RegistryObject)organization));
            User user = organization.getPrimaryContact();
            if (user != null) {
                object3 = user.getPersonName();
                System.out.println(" Contact name: " + object3.getFullName());
                object2 = user.getTelephoneNumbers(null);
                object = object2.iterator();
                while (object.hasNext()) {
                    collection2 = (TelephoneNumber)object.next();
                    System.out.println("  Phone number: " + collection2.getNumber());
                }
                collection2 = user.getEmailAddresses();
                iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    emailAddress = (EmailAddress)iterator2.next();
                    System.out.println("  Email Address: " + emailAddress.getAddress());
                }
            }
            object3 = organization.getServices();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Service)object2.next();
                System.out.println(" Service name: " + this.getName((RegistryObject)object));
                System.out.println(" Service description: " + this.getDescription((RegistryObject)object));
                collection2 = object.getServiceBindings();
                iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    emailAddress = (ServiceBinding)iterator2.next();
                    System.out.println("  Binding Description: " + this.getDescription((RegistryObject)emailAddress));
                    System.out.println("  Access URI: " + emailAddress.getAccessURI());
                }
            }
            System.out.println(" --- ");
        }
        Object var19_19 = null;
        if (this.connection == null) return;
        try {
            this.connection.close();
            return;
        }
        catch (JAXRException jAXRException) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var19_20 = null;
                if (this.connection == null) return;
                try {
                    this.connection.close();
                    return;
                }
                catch (JAXRException jAXRException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            if (this.connection == null) throw throwable;
            try {
                this.connection.close();
                throw throwable;
            }
            catch (JAXRException jAXRException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getName(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getName().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Name";
        }
    }

    private String getDescription(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getDescription().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Description";
        }
    }

    private String getKey(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getKey().getId();
        }
        catch (NullPointerException nullPointerException) {
            return "No Key";
        }
    }
}

