/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class AbstractLogger
implements Logger {
    private static final ResourceBundle _messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$utility$logging$AbstractLogger == null ? (class$com$sun$jdo$spi$persistence$utility$logging$AbstractLogger = AbstractLogger.class$("com.sun.jdo.spi.persistence.utility.logging.AbstractLogger")) : class$com$sun$jdo$spi$persistence$utility$logging$AbstractLogger);
    private static final int _defaultLevel = 800;
    private static final char _levelSeparator = '.';
    private static Map _levelNamesToValues;
    private static boolean _hasLoggingProperties;
    private static Properties _loggingProperties;
    private final ResourceBundle _bundle;
    private final String _loggerName;
    private final int _level;
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$utility$logging$AbstractLogger;

    public AbstractLogger(String string, String string2, ClassLoader classLoader) {
        this._loggerName = string;
        this._level = this.readLoggingLevel(string);
        this._bundle = I18NHelper.loadBundle(string2, classLoader);
    }

    protected static ResourceBundle getMessages() {
        return _messages;
    }

    private static Map getLevelNameMap() {
        return _levelNamesToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized Properties getLoggingProperties() {
        Object object;
        if (!_hasLoggingProperties || _loggingProperties != null) return _loggingProperties;
        String string = System.getProperty("java.util.logging.config.file");
        if (string == null && (string = System.getProperty("java.home")) != null) {
            object = new File(string, "lib");
            object = new File((File)object, "logging.properties");
            try {
                string = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        if (string != null) {
            object = null;
            Object var2_3 = null;
            Properties properties = new Properties();
            BufferedInputStream bufferedInputStream = null;
            object = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream((InputStream)object);
            properties.load(bufferedInputStream);
            _loggingProperties = properties;
            Object var6_7 = null;
            if (object == null) return _loggingProperties;
            try {
                ((InputStream)object).close();
                return _loggingProperties;
            }
            catch (IOException iOException) {}
            return _loggingProperties;
            {
                catch (Exception exception) {
                    _hasLoggingProperties = false;
                    Object var6_8 = null;
                    if (object == null) return _loggingProperties;
                    try {
                        ((InputStream)object).close();
                        return _loggingProperties;
                    }
                    catch (IOException iOException) {}
                    return _loggingProperties;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (object == null) throw throwable;
                try {
                    ((InputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        _hasLoggingProperties = false;
        return _loggingProperties;
    }

    public static String toString(int n) {
        String string = null;
        switch (n) {
            case 0x7FFFFFFF: {
                string = "utility.level_off";
                break;
            }
            case 1000: {
                string = "utility.level_severe";
                break;
            }
            case 900: {
                string = "utility.level_warning";
                break;
            }
            case 800: {
                string = "utility.level_info";
                break;
            }
            case 700: {
                string = "utility.level_config";
                break;
            }
            case 500: {
                string = "utility.level_fine";
                break;
            }
            case 400: {
                string = "utility.level_finer";
                break;
            }
            case 300: {
                string = "utility.level_finest";
                break;
            }
            case -2147483648: {
                string = "utility.level_all";
            }
        }
        return string != null ? I18NHelper.getMessage(AbstractLogger.getMessages(), string) : null;
    }

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    public int getLevel() {
        return this._level;
    }

    private int readLoggingLevel(String string) {
        int n;
        block4: {
            String string2 = this.findLevelMatch(string);
            n = 800;
            if (string2 == null) break block4;
            Object var4_4 = null;
            string2 = string2.trim();
            var4_4 = AbstractLogger.getLevelNameMap().get(string2);
            if (var4_4 != null) {
                n = var4_4;
            } else {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return n;
    }

    private String findLevelMatch(String string) {
        Properties properties = AbstractLogger.getLoggingProperties();
        String string2 = null;
        if (properties != null) {
            while (string2 == null) {
                int n = string.lastIndexOf(46);
                string2 = properties.getProperty(string + ".level");
                if (string.trim().length() > 0) {
                    string = n == -1 ? "" : string.substring(0, n);
                    continue;
                }
                return string2;
            }
        }
        return string2;
    }

    public boolean isLoggable() {
        return 500 >= this.getLevel();
    }

    public boolean isLoggable(int n) {
        return n >= this.getLevel();
    }

    public void entering(String string, String string2) {
        this.entering(string, string2, null);
    }

    public void entering(String string, String string2, Object object) {
        if (this.isLoggable(400)) {
            this.entering(string, string2, new Object[]{object});
        }
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = null;
            String string3 = null;
            String[] stringArray = null;
            if (objectArray != null && objectArray.length > 0) {
                string3 = "entering_method_params";
                stringArray = new String[]{string, string2, StringHelper.arrayToSeparatedList(Arrays.asList(objectArray))};
            } else {
                string3 = "entering_method";
                stringArray = new String[]{string, string2};
            }
            messageFormat = new MessageFormat(AbstractLogger.getMessages().getString(string3));
            this.finer(messageFormat.format(stringArray));
        }
    }

    public void exiting(String string, String string2) {
        this.exiting(string, string2, null);
    }

    public void exiting(String string, String string2, Object object) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = null;
            String string3 = null;
            Object[] objectArray = null;
            if (object != null) {
                string3 = "exiting_method_return";
                objectArray = new Object[]{string, string2, object};
            } else {
                string3 = "exiting_method";
                objectArray = new Object[]{string, string2};
            }
            messageFormat = new MessageFormat(AbstractLogger.getMessages().getString(string3));
            this.finer(messageFormat.format(objectArray));
        }
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = new MessageFormat(AbstractLogger.getMessages().getString("throwing_method"));
            this.log(400, messageFormat.format(new String[]{string, string2}), throwable);
        }
    }

    public void severe(String string) {
        this.log(1000, string);
    }

    public void warning(String string) {
        this.log(900, string);
    }

    public void info(String string) {
        this.log(800, string);
    }

    public void config(String string) {
        this.log(700, string);
    }

    public void log(int n, String string) {
        if (this.isLoggable(n)) {
            this.logInternal(n, this.getMessage(string));
        }
    }

    public void log(int n, String string, Object object) {
        if (this.isLoggable(n)) {
            this.log(n, string, new Object[]{object});
        }
    }

    public void log(int n, String string, Object[] objectArray) {
        if (this.isLoggable(n)) {
            int n2 = objectArray == null ? 0 : objectArray.length;
            String string2 = string;
            if (n2 > 0) {
                MessageFormat messageFormat = new MessageFormat(this.getBundle().getString(string));
                if (messageFormat != null) {
                    string2 = messageFormat.format(objectArray);
                }
            } else {
                string2 = this.getMessage(string);
            }
            this.logInternal(n, string2);
        }
    }

    public void log(int n, String string, Object object, Object object2) {
        if (this.isLoggable(n)) {
            this.log(n, string, new Object[]{object, object2});
        }
    }

    public void log(int n, String string, Object object, Object object2, Object object3) {
        if (this.isLoggable(n)) {
            this.log(n, string, new Object[]{object, object2, object3});
        }
    }

    public abstract void log(int var1, String var2, Throwable var3);

    public void fine(String string) {
        this.log(500, string);
    }

    public void fine(String string, Object object) {
        this.log(500, string, object);
    }

    public void fine(String string, Object[] objectArray) {
        this.log(500, string, objectArray);
    }

    public void fine(String string, Object object, Object object2) {
        this.log(500, string, object, object2);
    }

    public void fine(String string, Object object, Object object2, Object object3) {
        this.log(500, string, object, object2, object3);
    }

    public void finer(String string) {
        this.log(400, string);
    }

    public void finer(String string, Object[] objectArray) {
        this.log(400, string, objectArray);
    }

    public void finer(String string, Object object) {
        this.log(400, string, object);
    }

    public void finer(String string, Object object, Object object2) {
        this.log(400, string, object, object2);
    }

    public void finer(String string, Object object, Object object2, Object object3) {
        this.log(400, string, object, object2, object3);
    }

    public void finest(String string) {
        this.log(300, string);
    }

    public void finest(String string, Object[] objectArray) {
        this.log(300, string, objectArray);
    }

    public void finest(String string, Object object) {
        this.log(300, string, object);
    }

    public void finest(String string, Object object, Object object2) {
        this.log(300, string, object, object2);
    }

    public void finest(String string, Object object, Object object2, Object object3) {
        this.log(300, string, object, object2, object3);
    }

    public String getName() {
        return this._loggerName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": ");
        stringBuffer.append(" name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(", logging level: ");
        stringBuffer.append(AbstractLogger.toString(this.getLevel()));
        return stringBuffer.toString();
    }

    protected String getMessage(String string) {
        try {
            return this.getBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getMessageWithPrefix(int n, String string) {
        MessageFormat messageFormat = new MessageFormat(AbstractLogger.getMessages().getString("logging_prefix"));
        return messageFormat.format(new String[]{AbstractLogger.toString(n), string});
    }

    protected abstract void logInternal(int var1, String var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _hasLoggingProperties = true;
        _levelNamesToValues = new HashMap();
        _levelNamesToValues.put("ALL", new Integer(Integer.MIN_VALUE));
        _levelNamesToValues.put("FINEST", new Integer(300));
        _levelNamesToValues.put("FINER", new Integer(400));
        _levelNamesToValues.put("FINE", new Integer(500));
        _levelNamesToValues.put("CONFIG", new Integer(700));
        _levelNamesToValues.put("INFO", new Integer(800));
        _levelNamesToValues.put("WARNING", new Integer(900));
        _levelNamesToValues.put("SEVERE", new Integer(1000));
        _levelNamesToValues.put("OFF", new Integer(Integer.MAX_VALUE));
    }
}

