/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.connection;

import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.utility.StringScanner;
import com.sun.jdo.spi.persistence.utility.DoubleLinkedList;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class ConnectionManager {
    private String driverName = null;
    private transient String expandedDriverName = null;
    private String url = null;
    private transient String expandedUrl = null;
    private String userName = null;
    private transient String expandedUserName = null;
    private String password = null;
    private transient String expandedPassword = null;
    private int minPool = 0;
    private int maxPool = 0;
    private transient int poolSize = 0;
    private transient boolean pooling = false;
    transient DoubleLinkedList freeList = null;
    transient DoubleLinkedList busyList = null;
    private transient Hashtable xactConnections = null;
    transient boolean shutDownPending = false;
    private transient boolean connectionBlocking = false;
    private int msInterval = 0;
    private int msWait = 0;
    private static final int DEFAULT_RETRY_INTERVAL = 1000;
    private transient boolean initialized = false;
    private int loginTimeout;
    private transient ConnectionImpl freeConn = null;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$connection$ConnectionManager == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$connection$ConnectionManager = ConnectionManager.class$("com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionManager")) : class$com$sun$jdo$spi$persistence$support$sqlstore$connection$ConnectionManager).getClassLoader());
    static final String SQL_SUCCESS = "00000";
    static final String SQL_WARNING = "01000";
    static final String SQL_CURSOR_OP = "01001";
    static final String SQL_DISCONNECT = "01002";
    static final String SQL_NULL_ELIM = "01003";
    static final String SQL_R_TRUNC = "01004";
    static final String SQL_INSUFF_ITEM = "01005";
    static final String SQL_NOT_REVOKED = "01006";
    static final String SQL_NOT_GRANTED = "01007";
    static final String SQL_ZERO_BIT_PAD = "01008";
    static final String SQL_COND_TOO_LONG = "01009";
    static final String SQL_QUERY_TOO_LONG = "0100A";
    static final String SQL_NO_DATA = "02000";
    static final String SQL_DYN_ERROR = "07000";
    static final String SQL_USING_NO_PARAM = "07001";
    static final String SQL_USING_NO_TARGET = "07002";
    static final String SQL_CURSOR_NOEXE = "07003";
    static final String SQL_USING_REQ = "07004";
    static final String SQL_PREP_NO_CURSOR = "07005";
    static final String SQL_RESTRIC_ATTR = "07006";
    static final String SQL_USING_RESULTS = "07007";
    static final String SQL_INVAL_DESC_CNT = "07008";
    static final String SQL_INVAL_DESC_IDX = "07009";
    static final String SQL_CONN = "08000";
    static final String SQL_CLIENT_NO_CONN = "08001";
    static final String SQL_CONN_IN_USE = "08002";
    static final String SQL_NO_CONN = "08003";
    static final String SQL_REJECT_CONN = "08004";
    static final String SQL_CONN_FAIL = "08006";
    static final String SQL_TRANS_UNK = "08007";
    static final String SQL_NO_SUPPORT = "0A000";
    static final String SQL_NO_SUPPORT_MULTI = "0A001";
    static final String SQL_INVALID_VALUE = "21000";
    static final String SQL_DATA = "22000";
    static final String SQL_DATA_RTRUNC = "22001";
    static final String SQL_DATA_NULL = "22002";
    static final String SQL_OUT_OF_RANGE = "22003";
    static final String SQL_DATA_EXCEPT = "22005";
    static final String SQL_DATETIME_FMT = "22007";
    static final String SQL_DATETIME_OVFLO = "22008";
    static final String SQL_TIMEZONE = "22009";
    static final String SQL_SUBSTR_ERROR = "22011";
    static final String SQL_DIV_BY_ZERO = "22012";
    static final String SQL_INTERVAL_OVFLO = "22015";
    static final String SQL_INVAL_CHAR_CAST = "22018";
    static final String SQL_INVAL_ESCAPE_CHAR = "22019";
    static final String SQL_CHAR_NOT_REP = "22021";
    static final String SQL_IND_OVERFLOW = "22022";
    static final String SQL_INVAL_PARAM_VALUE = "22023";
    static final String SQL_UNTERM_C_STR = "22024";
    static final String SQL_INVAL_ESCAPE_SEQ = "22025";
    static final String SQL_STR_LEN_MISMATCH = "22026";
    static final String SQL_TRIM_ERROR = "22027";
    static final String SQL_INTEG_CONSTRAINT = "23000";
    static final String SQL_INVAL_CURSOR_STATE = "24000";
    static final String SQL_INVAL_TRANS_STATE = "25000";
    static final String SQL_INVAL_SQL_NAME = "26000";
    static final String SQL_INVAL_AUTH = "28000";
    static final String SQL_SYNTAX_DIRECT = "2A000";
    static final String SQL_DESC_EXIST = "2B000";
    static final String SQL_INVAL_CHAR_SET = "2C000";
    static final String SQL_INVAL_TRANS_TERM = "2D000";
    static final String SQL_INVAL_CONN_NAME = "2E000";
    static final String SQL_INVAL_SQL_DESC_NAME = "33000";
    static final String SQL_INVAL_CURSOR_NAME = "34000";
    static final String SQL_INVAL_COND_NUM = "35000";
    static final String SQL_SYNTAX_DYNAMIC = "37000";
    static final String SQL_AMBIG_CURSOR = "3C000";
    static final String SQL_INVAL_CATALOG = "3D000";
    static final String SQL_INVAL_SCHEMA_NAME = "3F000";
    static final String SQL_TRANS_ROLLBACK = "40000";
    static final String SQL_TRANS_SERIAL_FAIL = "40001";
    static final String SQL_TRANS_INTEG = "40002";
    static final String SQL_TRANS_COMP_UNK = "40003";
    static final String SQL_SYNTAX = "42000";
    static final String SQL_CHECK_OPT = "44000";
    static final String SQL_RMT_DB_ACCESS = "HZ   ";
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$connection$ConnectionManager;

    public ConnectionManager() {
    }

    public ConnectionManager(String string) throws ClassNotFoundException, SQLException {
        this();
        try {
            this.setDriverName(string);
            this.startUp();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
    }

    public ConnectionManager(String string, String string2) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.startUp();
    }

    public ConnectionManager(String string, String string2, String string3) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.startUp();
    }

    public ConnectionManager(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.setPassword(string4);
        this.startUp();
    }

    public ConnectionManager(String string, String string2, String string3, String string4, int n, int n2) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.setPassword(string4);
        this.setMinPool(n);
        this.setMaxPool(n2);
        this.startUp();
    }

    public ConnectionManager(String string, String string2, String string3, String string4, int n, int n2, int n3) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.setPassword(string4);
        this.setMinPool(n);
        this.setMaxPool(n2);
        this.setMsWait(n3);
        this.setMsInterval(1000);
        this.startUp();
    }

    public ConnectionManager(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.setPassword(string4);
        this.setMinPool(n);
        this.setMaxPool(n2);
        this.setMsWait(n3);
        this.setMsInterval(n4);
        this.startUp();
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_NO_CONN);
            throw sQLException;
        }
        ConnectionImpl connectionImpl = this.checkXact();
        if (connectionImpl == null) {
            if (!this.pooling) {
                connectionImpl = (ConnectionImpl)this.getConnection(this.userName, this.password);
                connectionImpl.setPooled(false);
                connectionImpl.checkXact();
            } else {
                if (this.freeList.size <= 0) {
                    if (this.poolSize < this.maxPool) {
                        this.expandPool(1);
                    }
                    if (!this.connectionBlocking) {
                        SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.maxpool")), SQL_INVAL_PARAM_VALUE);
                        throw sQLException;
                    }
                    this.waitForConnection();
                }
                if ((connectionImpl = (ConnectionImpl)this.freeList.removeFromHead()) == null) {
                    SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.badvalue")), SQL_INVAL_PARAM_VALUE);
                    throw sQLException;
                }
                connectionImpl.setPooled(true);
                connectionImpl.checkXact();
                this.busyList.insertAtTail(connectionImpl);
            }
        }
        connectionImpl.setFreePending(false);
        return connectionImpl;
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        boolean bl = logger.isLoggable(300);
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw sQLException;
        }
        ConnectionImpl connectionImpl = this.checkXact();
        if (connectionImpl == null) {
            if (this.freeConn != null) {
                if (bl) {
                    logger.finest("sqlstore.connection.conncectiomgr.found", this.freeConn);
                }
                connectionImpl = this.freeConn;
                this.freeConn = null;
            } else {
                connectionImpl = new ConnectionImpl(DriverManager.getConnection(this.expandedUrl, this.expandAttribute(string), this.expandAttribute(string2)), this.expandedUrl, this.expandAttribute(string), this);
                if (bl) {
                    logger.finest("sqlstore.connection.conncectiomgr.getnewconn", connectionImpl);
                }
            }
            connectionImpl.checkXact();
        } else if (!connectionImpl.getUserName().equals(this.expandAttribute(string))) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.getconnection.mismatch")), SQL_NO_CONN);
            throw sQLException;
        }
        connectionImpl.setFreePending(false);
        connectionImpl.setPooled(false);
        this.busyList.insertAtTail(connectionImpl);
        return connectionImpl;
    }

    public synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        boolean bl = logger.isLoggable(300);
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw sQLException;
        }
        ConnectionImpl connectionImpl = this.checkXact();
        if (connectionImpl == null) {
            if (this.freeConn != null) {
                if (bl) {
                    logger.finest("sqlstore.connection.conncectiomgr.found", this.freeConn);
                }
                connectionImpl = this.freeConn;
                this.freeConn = null;
            } else {
                connectionImpl = new ConnectionImpl(DriverManager.getConnection(this.expandAttribute(string), this.expandAttribute(string2), this.expandAttribute(string3)), this.expandAttribute(string), this.expandAttribute(string2), this);
                if (bl) {
                    logger.finest("sqlstore.connection.conncectiomgr.getnewconn", connectionImpl);
                }
            }
            connectionImpl.checkXact();
        } else if (!connectionImpl.getURL().equals(this.expandAttribute(string)) || !connectionImpl.getUserName().equals(this.expandAttribute(string2))) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.getconnection.mismatch")), SQL_NO_CONN);
            throw sQLException;
        }
        connectionImpl.setFreePending(false);
        connectionImpl.setPooled(false);
        this.busyList.insertAtTail(connectionImpl);
        return connectionImpl;
    }

    private synchronized ConnectionImpl checkXact() {
        Object var1_1 = null;
        if (var1_1 == null) {
            return null;
        }
        return (ConnectionImpl)this.xactConnections.get(var1_1);
    }

    public void startUp() throws ClassNotFoundException, SQLException {
        if (this.initialized) {
            return;
        }
        this.busyList = new DoubleLinkedList();
        this.xactConnections = new Hashtable();
        this.expandedDriverName = this.expandAttribute(this.driverName);
        if (this.expandedDriverName == null) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.nulldriver")), SQL_INVALID_VALUE);
            throw sQLException;
        }
        this.expandedUrl = this.expandAttribute(this.url);
        if (this.expandedUrl == null) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.nullurl")), SQL_INVALID_VALUE);
            throw sQLException;
        }
        this.expandedUserName = this.expandAttribute(this.userName);
        if (this.expandedUserName == null) {
            this.expandedUserName = "";
        }
        this.expandedPassword = this.expandAttribute(this.password);
        if (this.expandedPassword == null) {
            this.expandedPassword = "";
        }
        try {
            Class.forName(this.expandedDriverName);
            if (this.minPool > 0 && this.maxPool >= this.minPool) {
                this.pooling = true;
                this.freeList = new DoubleLinkedList();
                this.expandPool(this.minPool);
            } else if (this.minPool == 0 && this.maxPool == 0) {
                this.pooling = false;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        this.initialized = true;
    }

    public synchronized void shutDown() throws SQLException {
        this.shutDownPending = true;
        if (this.pooling) {
            this.connectionBlocking = false;
            this.pooling = false;
            this.initialized = false;
            ConnectionImpl connectionImpl = (ConnectionImpl)this.freeList.getHead();
            while (connectionImpl != null) {
                connectionImpl.close();
                connectionImpl = (ConnectionImpl)connectionImpl.getNext();
            }
            this.freeList = null;
        }
    }

    protected void finalize() {
        try {
            this.shutDown();
        }
        catch (SQLException sQLException) {}
    }

    public synchronized String getDriverName() {
        return this.driverName;
    }

    public synchronized void setDriverName(String string) throws SQLException {
        if (string == null) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.nulldriver")), SQL_INVALID_VALUE);
            throw sQLException;
        }
        this.driverName = string;
    }

    public synchronized String getURL() {
        return this.url;
    }

    public synchronized void setURL(String string) throws SQLException {
        if (string == null) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.nullurl")), SQL_INVALID_VALUE);
            throw sQLException;
        }
        this.url = string;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized void setUserName(String string) throws SQLException {
        this.userName = string;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public synchronized int getMinPool() {
        return this.minPool;
    }

    public synchronized void setMinPool(int n) throws SQLException {
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw sQLException;
        }
        if (n < 0) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.zero")), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        if (n < this.minPool) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.badnew"), Integer.toString(n), Integer.toString(n)), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        if (this.pooling && n > this.maxPool) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.poolsize")), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        this.minPool = n;
    }

    public synchronized int getMaxPool() {
        return this.maxPool;
    }

    public synchronized void setMaxPool(int n) throws SQLException {
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw sQLException;
        }
        if (n < 0) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.zero"), Integer.toString(n)), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        if (this.pooling && n < this.maxPool) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.badnew"), Integer.toString(n), Integer.toString(n)), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        if (n < this.minPool) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.poolsize")), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        this.maxPool = n;
    }

    public synchronized int getMsWait() {
        return this.msWait;
    }

    public synchronized void setMsWait(int n) throws SQLException {
        if (n < 0) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.badvalue"), Integer.toString(n)), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        if (n > 0) {
            this.msWait = n;
            this.connectionBlocking = true;
        } else {
            this.msWait = n;
            this.connectionBlocking = false;
        }
    }

    public synchronized int getMsInterval() {
        return this.msInterval;
    }

    public synchronized void setMsInterval(int n) throws SQLException {
        if (n < 0 || this.msWait < n) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.badnew"), "MsInterval", "MsWait"), SQL_INVAL_PARAM_VALUE);
            throw sQLException;
        }
        this.msInterval = n;
    }

    public synchronized String toString() {
        return null;
    }

    synchronized void associateXact(Transaction transaction, ConnectionImpl connectionImpl) {
        if (transaction != null) {
            this.xactConnections.put(transaction, connectionImpl);
        }
    }

    synchronized void disassociateXact(Transaction transaction, ConnectionImpl connectionImpl, boolean bl) throws SQLException {
        Object object = null;
        if (transaction != null) {
            object = (ConnectionImpl)this.xactConnections.remove(transaction);
        }
        if (transaction == null || object.equals(connectionImpl)) {
            if (bl) {
                if (!connectionImpl.connectionManager.shutDownPending) {
                    this.freeList.insertAtTail(connectionImpl);
                } else {
                    connectionImpl.close();
                }
            }
        } else {
            SQLException sQLException = new SQLException(StringScanner.createParamString("Internal Error: transaction mismatch"), SQL_TRANS_UNK);
            throw sQLException;
        }
    }

    private synchronized void expandPool(int n) throws SQLException {
        ConnectionImpl connectionImpl = null;
        if (this.shutDownPending) {
            SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw sQLException;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.poolSize >= this.maxPool) {
                SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.maxpool")), SQL_CONN_FAIL);
                throw sQLException;
            }
            connectionImpl = new ConnectionImpl(DriverManager.getConnection(this.expandedUrl, this.expandedUserName, this.expandedPassword), this.expandedUrl, this.expandedUserName, this);
            connectionImpl.setPooled(true);
            this.freeList.insertAtTail(connectionImpl);
            ++this.poolSize;
            ++n2;
        }
    }

    private String expandAttribute(String string) throws SQLException {
        String string2 = null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private synchronized void waitForConnection() throws SQLException {
        int n = this.msInterval;
        int n2 = this.msWait;
        int n3 = 0;
        boolean bl = false;
        Thread thread = Thread.currentThread();
        do {
            if (this.freeList.size > 0) {
                bl = true;
                continue;
            }
            if (this.poolSize < this.maxPool) {
                this.expandPool(1);
                bl = true;
            }
            if (n3 >= n2) {
                SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.conntimeout")), SQL_CONN_FAIL);
                throw sQLException;
            }
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                SQLException sQLException = new SQLException(StringScanner.createParamString(I18NHelper.getMessage(messages, "connection.connectionmanager.threaditerupted")), SQL_CONN_FAIL);
                throw sQLException;
            }
            n3 += n;
        } while (!bl);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    protected synchronized void replaceFreeConnection(ConnectionImpl connectionImpl) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.connection.conncectiomgr.replacefreeconn", this.freeConn);
        }
        if (this.freeConn != null) {
            this.freeConn.release();
        }
        this.freeConn = connectionImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

