/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class MethodHelper {
    public static final int LOCAL_RETURN = 0;
    public static final int REMOTE_RETURN = 1;
    public static final int NO_RETURN = 2;
    private EjbCMPEntityDescriptor _cmpDescriptor;
    private List finders = new ArrayList();
    private List selectors = new ArrayList();
    private List createMethods = new ArrayList();
    private Map methodNames = new HashMap();

    public MethodHelper(EjbCMPEntityDescriptor ejbCMPEntityDescriptor) {
        this._cmpDescriptor = ejbCMPEntityDescriptor;
        this.categorizeMethods();
    }

    protected EjbCMPEntityDescriptor getDescriptor() {
        return this._cmpDescriptor;
    }

    protected void categorizeMethods() {
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = this.getDescriptor();
        Iterator iterator = ejbCMPEntityDescriptor.getMethodDescriptors().iterator();
        while (iterator.hasNext()) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
            Method method = methodDescriptor.getMethod((EjbDescriptor)ejbCMPEntityDescriptor);
            String string = methodDescriptor.getName();
            if (string.startsWith("find")) {
                this.finders.add(method);
            } else if (string.startsWith("ejbSelect")) {
                this.selectors.add(method);
            } else if (string.startsWith("create")) {
                this.createMethods.add(method);
            } else if (string.startsWith("get") || string.startsWith("set")) {
                // empty if block
            }
            this.methodNames.put(string, method);
        }
    }

    public List getFinders() {
        return this.finders;
    }

    protected void setFinders(List list) {
        this.finders = list;
    }

    public List getSelectors() {
        return this.selectors;
    }

    protected void setSelectors(List list) {
        this.selectors = list;
    }

    public List getCreateMethods() {
        return this.createMethods;
    }

    public Map getMethodNames() {
        return this.methodNames;
    }

    public String getLocalHome() {
        return this.getDescriptor().getLocalHomeClassName();
    }

    public String getRemoteHome() {
        return this.getDescriptor().getHomeClassName();
    }

    public String getQueryString(Method method) {
        PersistenceDescriptor persistenceDescriptor = this.getDescriptor().getPersistenceDescriptor();
        QueryDescriptor queryDescriptor = persistenceDescriptor.getQueryFor(method);
        return queryDescriptor != null ? queryDescriptor.getQuery() : null;
    }

    public int getQueryReturnType(Method method) {
        PersistenceDescriptor persistenceDescriptor = this.getDescriptor().getPersistenceDescriptor();
        QueryDescriptor queryDescriptor = persistenceDescriptor.getQueryFor(method);
        if (queryDescriptor != null) {
            if (queryDescriptor.getHasLocalReturnTypeMapping()) {
                return 0;
            }
            if (queryDescriptor.getHasRemoteReturnTypeMapping()) {
                return 1;
            }
        }
        return 2;
    }

    public abstract String getJDOFilterExpression(Method var1);

    public abstract String getJDOParameterDeclaration(Method var1);

    public abstract String getJDOVariableDeclaration(Method var1);
}

