/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnLookupSwitch
extends Insn {
    private InsnTarget defaultOp;
    private int[] matchesOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        int n = 0;
        while (n < this.targetsOp.length) {
            this.targetsOp[n].setBranchTarget();
            ++n;
        }
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public int[] switchCases() {
        return this.matchesOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnLookupSwitch(InsnTarget insnTarget, int[] nArray, InsnTarget[] insnTargetArray) {
        this(insnTarget, nArray, insnTargetArray, -1);
    }

    InsnLookupSwitch(InsnTarget insnTarget, int[] nArray, InsnTarget[] insnTargetArray, int n) {
        super(171, n);
        this.defaultOp = insnTarget;
        this.matchesOp = nArray;
        this.targetsOp = insnTargetArray;
        if (insnTarget == null || insnTargetArray == null || nArray == null || insnTargetArray.length != nArray.length) {
            throw new InsnError("attempt to create an opc_lookupswitch with invalid operands");
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  opc_lookupswitch  ");
        int n2 = 0;
        while (n2 < this.matchesOp.length) {
            ClassPrint.spaces(printStream, n + 2);
            printStream.println(this.matchesOp[n2] + " -> " + this.targetsOp[n2].offset());
            ++n2;
        }
        ClassPrint.spaces(printStream, n + 2);
        printStream.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        n = n + 3 & 0xFFFFFFFC;
        n = Insn.storeInt(byArray, n, this.defaultOp.offset() - this.offset());
        n = Insn.storeInt(byArray, n, this.targetsOp.length);
        int n2 = 0;
        while (n2 < this.targetsOp.length) {
            n = Insn.storeInt(byArray, n, this.matchesOp[n2]);
            n = Insn.storeInt(byArray, n, this.targetsOp[n2].offset() - this.offset());
            ++n2;
        }
        return n;
    }

    int size() {
        int n = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 8;
        return n + this.targetsOp.length * 8;
    }

    static InsnLookupSwitch read(InsnReadEnv insnReadEnv, int n) {
        int n2 = n + 1;
        int n3 = (n2 + 3 & 0xFFFFFFFC) - n2;
        while (n3 > 0) {
            insnReadEnv.getByte();
            --n3;
        }
        InsnTarget insnTarget = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        int n4 = insnReadEnv.getInt();
        int[] nArray = new int[n4];
        InsnTarget[] insnTargetArray = new InsnTarget[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = insnReadEnv.getInt();
            insnTargetArray[n5] = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
            ++n5;
        }
        return new InsnLookupSwitch(insnTarget, nArray, insnTargetArray, n);
    }
}

