/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public class InsnIntOp
extends Insn {
    private int operandValue;

    public int nStackArgs() {
        return VMOp.ops[this.opcode()].nStackArgs();
    }

    public int nStackResults() {
        return VMOp.ops[this.opcode()].nStackResults();
    }

    public String argTypes() {
        return VMOp.ops[this.opcode()].argTypes();
    }

    public String resultTypes() {
        return VMOp.ops[this.opcode()].resultTypes();
    }

    public boolean branches() {
        return this.opcode() == 169;
    }

    public int value() {
        return this.operandValue;
    }

    static String primType(int n) {
        switch (n) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        throw new InsnError("Invalid primitive type(" + n + ")");
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        if (this.opcode() == 188) {
            printStream.println(this.offset() + "  opc_newarray  " + InsnIntOp.primType(this.operandValue));
        } else {
            printStream.println(this.offset() + "  " + Insn.opName(this.opcode()) + "  " + this.operandValue);
        }
    }

    int store(byte[] byArray, int n) {
        if (this.size() == 4) {
            byArray[n++] = -60;
        }
        byArray[n++] = (byte)this.opcode();
        if (this.size() > 2) {
            byArray[n++] = (byte)(this.operandValue >> 8);
        }
        byArray[n++] = (byte)(this.operandValue & 0xFF);
        return n;
    }

    int size() {
        switch (this.opcode()) {
            case 16: 
            case 188: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                if (this.operandValue < 256) {
                    return 2;
                }
                return 4;
            }
        }
        throw new InsnError("invalid instruction " + Insn.opName(this.opcode()) + " with an integer operand");
    }

    InsnIntOp(int n, int n2, int n3) {
        super(n, n3);
        this.operandValue = n2;
    }

    InsnIntOp(int n, int n2) {
        super(n, -1);
        this.operandValue = n2;
        switch (n) {
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: 
            case 188: {
                break;
            }
            default: {
                throw new InsnError("attempt to create an " + Insn.opName(n) + " with an integer operand");
            }
        }
    }
}

