/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ExceptionRange {
    private InsnTarget excStartPC;
    private InsnTarget excEndPC;
    private InsnTarget excHandlerPC;
    private ConstClass excCatchType;

    public InsnTarget startPC() {
        return this.excStartPC;
    }

    public InsnTarget endPC() {
        return this.excEndPC;
    }

    public InsnTarget handlerPC() {
        return this.excHandlerPC;
    }

    public ConstClass catchType() {
        return this.excCatchType;
    }

    public ExceptionRange(InsnTarget insnTarget, InsnTarget insnTarget2, InsnTarget insnTarget3, ConstClass constClass) {
        this.excStartPC = insnTarget;
        this.excEndPC = insnTarget2;
        this.excHandlerPC = insnTarget3;
        this.excCatchType = constClass;
    }

    static ExceptionRange read(DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        InsnTarget insnTarget = codeEnv.getTarget(dataInputStream.readUnsignedShort());
        InsnTarget insnTarget2 = codeEnv.getTarget(dataInputStream.readUnsignedShort());
        InsnTarget insnTarget3 = codeEnv.getTarget(dataInputStream.readUnsignedShort());
        ConstClass constClass = (ConstClass)codeEnv.pool().constantAt(dataInputStream.readUnsignedShort());
        return new ExceptionRange(insnTarget, insnTarget2, insnTarget3, constClass);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.excStartPC.offset());
        dataOutputStream.writeShort(this.excEndPC.offset());
        dataOutputStream.writeShort(this.excHandlerPC.offset());
        dataOutputStream.writeShort(this.excCatchType == null ? 0 : this.excCatchType.getIndex());
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.print("Exc Range:");
        if (this.excCatchType == null) {
            printStream.print("any");
        } else {
            printStream.print("'" + this.excCatchType.asString() + "'");
        }
        printStream.print(" start = " + Integer.toString(this.excStartPC.offset()));
        printStream.print(" end = " + Integer.toString(this.excEndPC.offset()));
        printStream.println(" handle = " + Integer.toString(this.excHandlerPC.offset()));
    }
}

