/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMember;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ClassField
extends ClassMember {
    private int accessFlags;
    private ConstUtf8 fieldName;
    private ConstUtf8 fieldSignature;
    private AttributeVector fieldAttributes;

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public int access() {
        return this.accessFlags;
    }

    public void setAccess(int n) {
        this.accessFlags = n;
    }

    public ConstUtf8 name() {
        return this.fieldName;
    }

    public void changeName(ConstUtf8 constUtf8) {
        this.fieldName = constUtf8;
    }

    public ConstUtf8 signature() {
        return this.fieldSignature;
    }

    public void changeSignature(ConstUtf8 constUtf8) {
        this.fieldSignature = constUtf8;
    }

    public AttributeVector attributes() {
        return this.fieldAttributes;
    }

    public ClassField(int n, ConstUtf8 constUtf8, ConstUtf8 constUtf82, AttributeVector attributeVector) {
        this.accessFlags = n;
        this.fieldName = constUtf8;
        this.fieldSignature = constUtf82;
        this.fieldAttributes = attributeVector;
    }

    static ClassField read(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        ClassField classField = null;
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        AttributeVector attributeVector = AttributeVector.readAttributes(dataInputStream, constantPool);
        classField = new ClassField(n, (ConstUtf8)constantPool.constantAt(n2), (ConstUtf8)constantPool.constantAt(n3), attributeVector);
        return classField;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.fieldName.getIndex());
        dataOutputStream.writeShort(this.fieldSignature.getIndex());
        this.fieldAttributes.write(dataOutputStream);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.print("'" + this.fieldName.asString() + "'");
        printStream.print(" sig = " + this.fieldSignature.asString());
        printStream.print(" access_flags = " + Integer.toString(this.accessFlags));
        printStream.println(" attributes:");
        this.fieldAttributes.print(printStream, n + 2);
    }
}

