/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.cmp.transform;

import archiver.XMLOutputStream;
import com.iplanet.ias.tools.common.dd.cmpmapping.CmpFieldMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.CmrFieldMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.ColumnPair;
import com.iplanet.ias.tools.common.dd.cmpmapping.Consistency;
import com.iplanet.ias.tools.common.dd.cmpmapping.EntityMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.FetchedWith;
import com.iplanet.ias.tools.common.dd.cmpmapping.HasFetchedWith;
import com.iplanet.ias.tools.common.dd.cmpmapping.SecondaryTable;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMappings;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.ConversionHelper;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.EjbJarConversionHelper;
import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceClassElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceFieldElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.RelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MappingFile {
    private static ResourceBundle bundle = null;
    public static String DEFAULT_LOCATION_IN_EJB_JAR = null;
    private Map inverseRelationships = null;
    private Map inverseRelationshipIs = null;
    private Map namedGroups = null;
    private int groupCount = -1;
    private ClassLoader classLoader = null;
    private Object[] errorMessageArgs = null;
    private String errorMessageFormat = null;
    private static int CURRENT_BEAN;
    private static int CURRENT_SCHEMA;
    private static int CURRENT_CLASSPATH;
    private static int CURRENT_TABLE;
    private static int CURRENT_COLUMN;
    private static int CURRENT_FIELD;
    private static int CURRENT_RELATION_FIELD_TYPE;
    private static int CURRENT_FETCH_WITH_LEVEL;
    private static int CURRENT_MAPPING_FILE;
    private static int LAST_INDEX;
    private static int MINIMUM_PRECISION;
    private ConversionHelper helper;
    private HashMap loadedSchema = new HashMap();

    public MappingFile() {
        this.errorMessageArgs = new Object[LAST_INDEX];
    }

    public MappingFile(ClassLoader cl) {
        this();
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Map intoMappingClasses(SunCmpMappings content, ConversionHelper validator, PrintStream messageStream) {
        try {
            EntityMapping anIasBeanMapping = null;
            this.helper = validator;
            HashMap<String, MappingClassElement> mces = null;
            mces = new HashMap<String, MappingClassElement>();
            int k = 0;
            int i = 0;
            while (i < content.sizeSunCmpMapping()) {
                boolean foo2;
                SunCmpMapping beanSet = content.getSunCmpMapping(i);
                this.inverseRelationships = new HashMap();
                this.inverseRelationshipIs = new HashMap();
                this.namedGroups = new HashMap();
                if (validator.ensureCompleteRoles() && (foo2 = this.completeCmrMappings(beanSet, validator)) && null != messageStream) {
                    beanSet.write(messageStream);
                }
                k = 0;
                while (k < beanSet.sizeEntityMapping()) {
                    MappingClassElement aTpMapping;
                    block10: {
                        anIasBeanMapping = beanSet.getEntityMapping(k);
                        aTpMapping = null;
                        if (validator.ensureCompleteRoles()) {
                            aTpMapping = this.mapFieldsOfBean(anIasBeanMapping, beanSet.getSchema(), validator, messageStream);
                        } else {
                            try {
                                aTpMapping = this.mapFieldsOfBean(anIasBeanMapping, beanSet.getSchema(), validator, messageStream);
                            }
                            catch (Throwable t) {
                                if (null == messageStream) break block10;
                                t.printStackTrace(messageStream);
                            }
                        }
                    }
                    mces.put(anIasBeanMapping.getEjbName(), aTpMapping);
                    ++k;
                }
                ++i;
            }
            return mces;
        }
        catch (Throwable re) {
            if (null != messageStream) {
                re.printStackTrace(messageStream);
            }
            RuntimeException foo3 = new RuntimeException(this.lastError());
            throw foo3;
        }
    }

    public Map intoMappingClasses(InputStream content, ConversionHelper validator, PrintStream messageStream) {
        SunCmpMappings foo2 = null;
        this.errorMessageFormat = bundle.getString("XML_ERROR_IN_MAPPING_FILE");
        this.errorMessageArgs[MappingFile.CURRENT_MAPPING_FILE] = DEFAULT_LOCATION_IN_EJB_JAR;
        try {
            foo2 = SunCmpMappings.createGraph(content);
        }
        catch (Throwable t) {
            if (validator.ensureCompleteRoles()) {
                if (null != messageStream) {
                    t.printStackTrace(messageStream);
                }
                RuntimeException bar = new RuntimeException(this.lastError());
                throw bar;
            }
            foo2 = SunCmpMappings.createGraph();
        }
        return this.intoMappingClasses(foo2, validator, messageStream);
    }

    public void fromMappingClasses(OutputStream dest, Map mappingClasses, PrintStream messageStream) throws IOException {
        SunCmpMappings tmp = this.fromMappingClasses(mappingClasses, messageStream);
        tmp.write(dest);
    }

    public SunCmpMappings fromMappingClasses(Map mappingClasses, PrintStream messageStream) {
        Iterator keyIter = mappingClasses.keySet().iterator();
        HashMap<String, SunCmpMapping> mapOfMapping = new HashMap<String, SunCmpMapping>();
        while (keyIter.hasNext()) {
            String schemaName;
            SunCmpMapping aMapping;
            String ejbName = (String)keyIter.next();
            MappingClassElement mce = (MappingClassElement)mappingClasses.get(ejbName);
            EntityMapping beanMapping = new EntityMapping();
            if (null == mce) continue;
            int consistency = mce.getConsistencyLevel();
            if (0 != consistency) {
                Consistency c = new Consistency();
                if (6 == consistency) {
                    c.setLockWhenModified(true);
                    c.setCheckAllAtCommit(true);
                }
                if (4 == consistency) {
                    c.setLockWhenModified(true);
                }
                if (2 == consistency) {
                    c.setCheckAllAtCommit(true);
                }
                if (8 == consistency) {
                    c.setLockWhenLoaded(true);
                }
                if (1 == consistency) {
                    c.setCheckModifiedAtCommit(true);
                }
                beanMapping.setConsistency(c);
            }
            if (null == (aMapping = (SunCmpMapping)((Object)mapOfMapping.get(schemaName = mce.getDatabaseRoot())))) {
                aMapping = new SunCmpMapping();
                aMapping.setSchema(schemaName);
                mapOfMapping.put(schemaName, aMapping);
            }
            ArrayList tables = mce.getTables();
            MappingTableElement primary = null;
            if (tables.size() > 0) {
                primary = (MappingTableElement)tables.get(0);
                beanMapping.setTableName(primary.getName());
            }
            beanMapping.setEjbName(ejbName);
            if (null != primary) {
                ArrayList refKeys = primary.getReferencingKeys();
                int i = 0;
                while (refKeys != null && i < refKeys.size()) {
                    SecondaryTable sT = new SecondaryTable();
                    MappingReferenceKeyElement mrke = (MappingReferenceKeyElement)refKeys.get(i);
                    MappingTableElement mte = mrke.getTable();
                    if (null != mte) {
                        sT.setTableName(mte.getName());
                        ArrayList cpnames = mrke.getColumnPairNames();
                        boolean hasPairs = false;
                        int j = 0;
                        while (cpnames != null && j < cpnames.size()) {
                            StringTokenizer toker = new StringTokenizer((String)cpnames.get(j), ";");
                            ColumnPair cp = new ColumnPair();
                            while (toker.hasMoreTokens()) {
                                String columnName = toker.nextToken();
                                cp.addColumnName(columnName);
                            }
                            sT.addColumnPair(cp);
                            hasPairs = true;
                            ++j;
                        }
                        if (hasPairs) {
                            beanMapping.addSecondaryTable(sT);
                        } else {
                            MappingFile.writeMessage(messageStream, "WARN_ILLEGAL_PAIR", new Object[]{ejbName, mte.getName(), cpnames});
                        }
                    } else {
                        MappingFile.writeMessage(messageStream, "WARN_MISSING_TABLE", new Object[]{ejbName, primary.getName()});
                    }
                    ++i;
                }
            } else {
                MappingFile.writeMessage(messageStream, "WARN_NO_PRIMARY", new Object[]{ejbName});
            }
            ArrayList fields = mce.getFields();
            PersistenceClassElement pce = null;
            PersistenceFieldElement[] pfields = null;
            if (mce instanceof MappingClassElementImpl) {
                MappingClassElementImpl mcei = (MappingClassElementImpl)mce;
                pce = mcei.getPersistenceElement();
                pfields = pce.getFields();
            }
            int len = 0;
            if (null != pfields) {
                len = pfields.length;
            }
            int i = 0;
            while (i < len) {
                PersistenceFieldElement pfield = pfields[i];
                if (pfield instanceof RelationshipElement) {
                    MappingRelationshipElement mre;
                    MappingRelationshipElement mfe = mre = (MappingRelationshipElement)mce.getField(pfield.getName());
                    CmrFieldMapping cfm = new CmrFieldMapping();
                    cfm.setCmrFieldName(pfield.getName());
                    ArrayList cols = null;
                    if (null != mfe) {
                        cols = mfe.getColumns();
                        int fgVal = mfe.getFetchGroup();
                        this.setFetchedWith(cfm, fgVal);
                    }
                    int j = 0;
                    while (null != cols && j < cols.size()) {
                        String cpstring = (String)cols.get(j);
                        int slen = cpstring.indexOf(59);
                        ColumnPair cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                        ++j;
                    }
                    if (null != mre) {
                        cols = mre.getAssociatedColumns();
                    }
                    int j2 = 0;
                    while (null != cols && j2 < cols.size()) {
                        String cpstring = (String)cols.get(j2);
                        int slen = cpstring.indexOf(59);
                        ColumnPair cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                        ++j2;
                    }
                    beanMapping.addCmrFieldMapping(cfm);
                } else {
                    MappingFieldElement mfe = mce.getField(pfield.getName());
                    CmpFieldMapping cfm = new CmpFieldMapping();
                    cfm.setFieldName(pfield.getName());
                    if (null != pce) {
                        // empty if block
                    }
                    ArrayList cols = null;
                    if (null != mfe) {
                        cols = mfe.getColumns();
                        int j = 0;
                        while (null != cols && j < cols.size()) {
                            cfm.addColumnName((String)cols.get(j));
                            ++j;
                        }
                        int fgVal = mfe.getFetchGroup();
                        this.setFetchedWith(cfm, fgVal);
                    }
                    beanMapping.addCmpFieldMapping(cfm);
                }
                ++i;
            }
            aMapping.addEntityMapping(beanMapping);
        }
        SunCmpMappings retVal = null;
        try {
            retVal = new SunCmpMappings();
            Iterator mapOfMappingIter = mapOfMapping.values().iterator();
            while (mapOfMappingIter.hasNext()) {
                SunCmpMapping aVal = (SunCmpMapping)((Object)mapOfMappingIter.next());
                retVal.addSunCmpMapping(aVal);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
        return retVal;
    }

    private void setFetchedWith(HasFetchedWith cfm, int fgVal) {
        FetchedWith fw;
        if (fgVal < 0) {
            String key = "IndependentFetchGroup" + fgVal;
            FetchedWith fw2 = new FetchedWith();
            fw2.setNamedGroup(key);
            cfm.setFetchedWith(fw2);
        }
        if (fgVal > 1) {
            fw = new FetchedWith();
            fw.setLevel(fgVal - 1);
            cfm.setFetchedWith(fw);
        }
        if (fgVal == 0) {
            fw = new FetchedWith();
            fw.setNone(true);
            cfm.setFetchedWith(fw);
        }
    }

    public String lastError() {
        String retVal = "";
        if (null != this.errorMessageFormat) {
            retVal = MessageFormat.format(this.errorMessageFormat, this.errorMessageArgs);
        }
        return retVal;
    }

    public static void main(String[] args) {
        MappingFile mf = null;
        try {
            FileInputStream iasMapping = new FileInputStream(args[0]);
            FileInputStream ejbJar = new FileInputStream(args[1]);
            String rootDir = args[2];
            FileOutputStream reflection = new FileOutputStream(args[0] + ".relection");
            EjbJarConversionHelper ddHelper = new EjbJarConversionHelper(ejbJar, args.length > 3);
            mf = new MappingFile();
            Object beansAndSchemas = null;
            Map allMappings = null;
            allMappings = mf.intoMappingClasses(iasMapping, (ConversionHelper)ddHelper, System.out);
            Iterator iter = allMappings.values().iterator();
            while (iter.hasNext()) {
                MappingClassElementImpl anMCE = (MappingClassElementImpl)iter.next();
                String className = anMCE.getName();
                PrintStream myOut = System.out;
                if (null != rootDir) {
                    String pathName = className.replace('.', File.separatorChar);
                    int len = pathName.lastIndexOf(File.separatorChar);
                    if (len > 0) {
                        File necessaryDir = new File(rootDir + File.separator + pathName.substring(0, len));
                        necessaryDir.mkdirs();
                    }
                    myOut = new PrintStream(new FileOutputStream(rootDir + File.separator + pathName + ".mapping"));
                }
                XMLOutputStream xmlOutput = new XMLOutputStream(myOut);
                xmlOutput.writeObject(anMCE);
                xmlOutput.close();
            }
            mf.fromMappingClasses(reflection, allMappings, System.out);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        System.out.println("Error message was: " + mf.lastError());
    }

    private MappingClassElement mapFieldsOfBean(EntityMapping mapping, String schemaArg, ConversionHelper helper, PrintStream out) {
        String beanName = mapping.getEjbName();
        this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
        MappingFile.writeMessage(out, "MESSAGE_START_BEAN", this.errorMessageArgs);
        MappingClassElementImpl mcei = null;
        MappingClassElementImpl mce = null;
        try {
            MappingFieldElementImpl mfei;
            block58: {
                String fieldName;
                this.errorMessageFormat = bundle.getString("ERR_J2EE_IAS_MISMATCH");
                String jdoClassName = helper.getMappedClassName(beanName);
                MappingFile.writeMessage(out, "Bean: " + beanName + "  is " + jdoClassName, null);
                if (null == jdoClassName) {
                    return null;
                }
                mcei = new MappingClassElementImpl(jdoClassName);
                PersistenceClassElementImpl persistElImpl = new PersistenceClassElementImpl(jdoClassName);
                persistElImpl.setKeyClass(jdoClassName + ".Oid");
                mcei.setPersistenceElement(new PersistenceClassElement(persistElImpl));
                this.errorMessageFormat = bundle.getString("ERR_CANNOT_FIND_SCHEMA");
                this.errorMessageArgs[MappingFile.CURRENT_SCHEMA] = schemaArg;
                this.errorMessageArgs[MappingFile.CURRENT_CLASSPATH] = this.classLoader;
                SchemaElement schema = null;
                if (schemaArg != null && !schemaArg.trim().equals("")) {
                    schema = this.setDatabaseRoot(mcei, schemaArg, helper.ensureCompleteRoles());
                }
                CmpFieldMapping[] mapOfFields = mapping.getCmpFieldMapping();
                String primaryTableName = mapping.getTableName();
                HashMap<String, TableElement> knownTables = new HashMap<String, TableElement>();
                ColumnElement candidatePK = null;
                if (null != primaryTableName && !primaryTableName.trim().equals("")) {
                    ColumnElement[] cols;
                    DBIdentifier tableDbId = DBIdentifier.create(primaryTableName);
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_TABLE");
                    this.errorMessageArgs[MappingFile.CURRENT_TABLE] = primaryTableName;
                    TableElement primTabEl = MappingFile.getTableElement(schema, tableDbId, helper);
                    mcei.addTable(primTabEl);
                    UniqueKeyElement uke = primTabEl.getPrimaryKey();
                    DBIdentifier candiName = null;
                    if (null != uke && null != (cols = uke.getColumns()) && 1 == cols.length) {
                        candidatePK = cols[0];
                        candiName = candidatePK.getName();
                        MappingFile.writeMessage(out, "Candidate PK has column name: " + candiName, null);
                        Integer len = candidatePK.getLength();
                        Integer pre = candidatePK.getPrecision();
                        Integer sca = candidatePK.getScale();
                        if (null != candidatePK && !candidatePK.isNumericType()) {
                            candidatePK = null;
                        }
                        if (null != candidatePK && pre < MINIMUM_PRECISION) {
                            candidatePK = null;
                        }
                    }
                    knownTables.put(primaryTableName, primTabEl);
                    MappingFile.loadSecondaryTables(mapping.getSecondaryTable(), knownTables, mcei, schema, out, helper);
                }
                mce = mcei;
                Consistency c = mapping.getConsistency();
                if (null == c) {
                    mce.setConsistencyLevel(0);
                } else if (c.isCheckModifiedAtCommit()) {
                    mce.setConsistencyLevel(1);
                } else if (c.isLockWhenLoaded()) {
                    mce.setConsistencyLevel(8);
                } else if (c.isCheckAllAtCommit()) {
                    mce.setConsistencyLevel(2);
                } else if (c.isLockWhenModified()) {
                    mce.setConsistencyLevel(4);
                } else if (c.isLockWhenModified() && c.isCheckAllAtCommit()) {
                    mce.setConsistencyLevel(6);
                } else if (c.isNone()) {
                    mce.setConsistencyLevel(0);
                } else {
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_CONSISTENCY_VALUE");
                    throw new RuntimeException();
                }
                int i = 0;
                while (i < mapOfFields.length) {
                    CmpFieldMapping mapForOneField = mapOfFields[i];
                    fieldName = mapForOneField.getFieldName();
                    if (this.validateField(mcei, beanName, fieldName, helper.ensureCompleteRoles())) {
                        String[] columnNames = mapForOneField.getColumnName();
                        MappingFieldElementImpl mfei2 = this.createUnmappedField(mcei, beanName, fieldName);
                        boolean fieldMappedToABlob = false;
                        this.errorMessageFormat = bundle.getString("ERR_INVALID_COLUMN");
                        int j = 0;
                        while (j < columnNames.length) {
                            String sourceTableName = MappingFile.getTableName(columnNames[j], primaryTableName);
                            this.errorMessageArgs[MappingFile.CURRENT_TABLE] = sourceTableName;
                            if (null == sourceTableName) {
                                this.errorMessageFormat = bundle.getString("ERR_UNDEFINED_TABLE");
                                throw new RuntimeException();
                            }
                            String sourceColumnName = MappingFile.getColumnName(columnNames[j]);
                            this.errorMessageArgs[MappingFile.CURRENT_COLUMN] = sourceColumnName;
                            TableElement sourceTableEl = (TableElement)knownTables.get(sourceTableName);
                            ColumnElement aCol = MappingFile.getColumnElement(sourceTableEl, DBIdentifier.create(sourceColumnName), helper);
                            MappingFile.writeMessage(out, "Adding column " + aCol + " to mapping for field " + fieldName, null);
                            if (candidatePK != null && candidatePK.equals(aCol)) {
                                candidatePK = null;
                                MappingFile.writeMessage(out, "invalidate candidatePK", null);
                            }
                            fieldMappedToABlob |= aCol.isBlobType();
                            mfei2.addColumn(aCol);
                            ++j;
                        }
                        FetchedWith fw = mapForOneField.getFetchedWith();
                        if (null != fw) {
                            String ig;
                            boolean tryLevel = false;
                            int level = 0;
                            try {
                                level = fw.getLevel();
                                tryLevel = true;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            if (tryLevel) {
                                if (level < 1) {
                                    this.errorMessageArgs[MappingFile.CURRENT_FETCH_WITH_LEVEL] = "" + level;
                                    this.errorMessageFormat = bundle.getString("ERR_INVALID_FG_LEVEL");
                                    throw new RuntimeException();
                                }
                                mfei2.setFetchGroup(level + 1);
                            }
                            if (null != (ig = fw.getNamedGroup())) {
                                Integer fgval = (Integer)this.namedGroups.get(ig);
                                if (null == fgval) {
                                    fgval = new Integer(this.groupCount--);
                                    this.namedGroups.put(ig, fgval);
                                }
                                mfei2.setFetchGroup(fgval);
                            }
                            if (fw.isNone()) {
                                mfei2.setFetchGroup(0);
                            }
                        } else if (fieldMappedToABlob) {
                            mfei2.setFetchGroup(0);
                        } else {
                            mfei2.setFetchGroup(1);
                        }
                        mcei.addField(mfei2);
                    }
                    ++i;
                }
                if (null != candidatePK) {
                    if (helper.applyDefaultUnknownPKClassStratgey(beanName)) {
                        Date uniquer = new Date();
                        fieldName = "generatedPKField" + uniquer.getTime();
                        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
                        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, mcei.getPersistenceElement());
                        pfe.setKey(true);
                        mcei.getPersistenceElement().addField(pfe);
                        mfei = new MappingFieldElementImpl(fieldName, mcei);
                        mfei.addColumn(candidatePK);
                        mcei.addField(mfei);
                    }
                } else if (helper.applyDefaultUnknownPKClassStratgey(beanName)) {
                    // empty if block
                }
                if (helper.ensureCompleteRoles()) {
                    this.mapRelationships(mcei, mapping, beanName, primaryTableName, knownTables, out, schema);
                } else {
                    try {
                        this.mapRelationships(mcei, mapping, beanName, primaryTableName, knownTables, out, schema);
                    }
                    catch (Throwable t) {
                        if (null == out) break block58;
                        t.printStackTrace(out);
                    }
                }
            }
            mce = mcei;
            this.errorMessageFormat = bundle.getString("MISSING_FIELD_MAPPING");
            Object[] fields = helper.getFields(beanName);
            int z = 0;
            while (z < fields.length) {
                String afn = (String)fields[z];
                this.errorMessageArgs[MappingFile.CURRENT_FIELD] = afn;
                MappingFieldElement mfe = mce.getField(afn);
                if (null == mfe) {
                    if (helper.ensureCompleteRoles()) {
                        throw new RuntimeException();
                    }
                    mfei = this.createUnmappedField(mcei, beanName, afn);
                    mcei.addField(mfei);
                }
                ++z;
            }
        }
        catch (FileNotFoundException fnfe) {
            if (null != out) {
                fnfe.printStackTrace(out);
            }
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            if (null != out) {
                ioe.printStackTrace(out);
            }
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            if (null != out) {
                cnfe.printStackTrace(out);
            }
            throw new RuntimeException(cnfe);
        }
        catch (DBException dbe) {
            if (null != out) {
                dbe.printStackTrace(out);
            }
            throw new RuntimeException(dbe);
        }
        catch (ModelException t) {
            if (null != out) {
                t.printStackTrace(out);
            }
            throw new RuntimeException(t);
        }
        this.errorMessageFormat = null;
        return mce;
    }

    private void mapRelationships(MappingClassElementImpl mcei, EntityMapping mapping, String beanName, String primaryTableName, Map knownTables, PrintStream out, SchemaElement schema) throws ModelException, DBException {
        CmrFieldMapping[] mapOfRelations = mapping.getCmrFieldMapping();
        int i = 0;
        while (mapOfRelations != null && i < mapOfRelations.length) {
            CmrFieldMapping aRelation = mapOfRelations[i];
            String fieldName = aRelation.getCmrFieldName();
            if (this.validateField(mcei, beanName, fieldName, this.helper.ensureCompleteRoles())) {
                RelationshipElementImpl rei = new RelationshipElementImpl(fieldName);
                RelationshipElement rel = new RelationshipElement(rei, mcei.getPersistenceElement());
                String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
                String classInJdoField = this.helper.getMappedClassName(beanInField);
                String key = beanName + "." + fieldName;
                RelationshipElement inverse = (RelationshipElement)this.inverseRelationships.get(key);
                RelationshipElementImpl inverseI = (RelationshipElementImpl)this.inverseRelationshipIs.get(key);
                if (null == inverse) {
                    String inverseField = this.helper.getInverseFieldName(beanName, fieldName);
                    if (null != inverseField) {
                        key = beanInField + "." + inverseField;
                        this.inverseRelationships.put(key, rel);
                        this.inverseRelationshipIs.put(key, rei);
                    }
                } else {
                    rel.changeInverseRelationship(inverse);
                    inverse.changeInverseRelationship(rel);
                }
                String plicity = this.helper.getMultiplicity(beanName, fieldName);
                if (plicity.equals(bundle.getString("MANY_CONST"))) {
                    rei.setUpperBound(Integer.MAX_VALUE);
                    rei.setElementClass(classInJdoField);
                    String collectionClass = this.helper.getRelationshipFieldType(beanName, fieldName);
                    this.errorMessageArgs[MappingFile.CURRENT_RELATION_FIELD_TYPE] = collectionClass;
                    this.errorMessageFormat = bundle.getString("ERR_BAD_FIELD_TYPE");
                    rei.setCollectionClass(bundle.getString(collectionClass + "_IMPL"));
                } else if (plicity.equals(bundle.getString("ONE_CONST"))) {
                    rei.setUpperBound(1);
                    rei.setElementClass(classInJdoField);
                } else {
                    this.errorMessageArgs[6] = plicity;
                    this.errorMessageFormat = bundle.getString("ERR_BAD_MULTIPLICTY");
                    throw new RuntimeException();
                }
                if (this.helper.relatedObjectsAreDeleted(beanName, fieldName)) {
                    MappingFile.writeMessage(out, "relatedObjectsAreDeleted(" + beanName + "," + fieldName + ") is TRUE", null);
                    rei.setDeleteAction(3);
                }
                mcei.getPersistenceElement().addField(rel);
                MappingRelationshipElementImpl mrei = new MappingRelationshipElementImpl(fieldName, mcei);
                rei.setLowerBound(0);
                ColumnPair[] pairs = aRelation.getColumnPair();
                int k = 0;
                while (null != pairs && k < pairs.length) {
                    ColumnPairElement cpe = new ColumnPairElement();
                    boolean localSet = false;
                    boolean referencedSet = false;
                    ColumnPair pair = pairs[k];
                    int j = 0;
                    while (j < 2) {
                        DBIdentifier dbId;
                        String nameOne = pair.getColumnName(j);
                        String sourceTableName = MappingFile.getTableName(nameOne, primaryTableName);
                        this.errorMessageArgs[3] = sourceTableName;
                        String sourceColumnName = MappingFile.getColumnName(nameOne);
                        this.errorMessageArgs[4] = sourceColumnName;
                        TableElement sourceTableEl = (TableElement)knownTables.get(sourceTableName);
                        if (null == sourceTableEl) {
                            dbId = DBIdentifier.create(sourceTableName);
                            TableElement te = MappingFile.getTableElement(schema, dbId, this.helper);
                            this.errorMessageFormat = bundle.getString("ERR_INVALID_TABLE");
                            te.toString();
                            knownTables.put(sourceTableName, te);
                            sourceTableEl = te;
                        }
                        this.errorMessageFormat = bundle.getString("ERR_INVALID_COLUMN");
                        dbId = DBIdentifier.create(sourceColumnName);
                        ColumnElement ce = MappingFile.getColumnElement(sourceTableEl, dbId, this.helper);
                        ce.toString();
                        DBIdentifier name = ce.getName();
                        String fn = name.getFullName();
                        if (sourceTableName.equals(primaryTableName) && null == cpe.getLocalColumn()) {
                            cpe.setLocalColumn(ce);
                            if (!(0 != j || 1 != rei.getUpperBound() || ce.isNullable() || null != inverse && inverse.getLowerBound() == 1)) {
                                rei.setLowerBound(1);
                            }
                            localSet = true;
                        } else {
                            if (cpe.getLocalColumn() == null) {
                                cpe.setLocalColumn(ce);
                            } else {
                                cpe.setReferencedColumn(ce);
                            }
                            referencedSet = true;
                        }
                        ++j;
                    }
                    if (localSet && referencedSet) {
                        DBIdentifier dbId = DBIdentifier.create(mapping.getEjbName() + "Relationship" + i);
                        cpe.setName(dbId);
                        mrei.addColumn(cpe);
                    }
                    if (referencedSet && !localSet) {
                        mrei.addAssociatedColumn(cpe);
                    }
                    ++k;
                }
                FetchedWith fw = aRelation.getFetchedWith();
                if (null != fw) {
                    String ig;
                    boolean tryLevel = false;
                    int level = 0;
                    try {
                        level = fw.getLevel();
                        tryLevel = true;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (tryLevel) {
                        if (level < 1) {
                            this.errorMessageArgs[MappingFile.CURRENT_FETCH_WITH_LEVEL] = "" + level;
                            this.errorMessageFormat = bundle.getString("ERR_INVALID_FG_LEVEL");
                            throw new RuntimeException();
                        }
                        mrei.setFetchGroup(level + 1);
                    }
                    if (null != (ig = fw.getNamedGroup())) {
                        Integer fgval = (Integer)this.namedGroups.get(ig);
                        if (null == fgval) {
                            fgval = new Integer(this.groupCount--);
                            this.namedGroups.put(ig, fgval);
                        }
                        mrei.setFetchGroup(fgval);
                    }
                    if (fw.isNone()) {
                        mrei.setFetchGroup(0);
                    }
                } else {
                    mrei.setFetchGroup(0);
                }
                mcei.addField(mrei);
            }
            ++i;
        }
    }

    public SchemaElement setDatabaseRoot(MappingClassElement foo2, String schemaElementValue) throws ModelException, FileNotFoundException, ClassNotFoundException, IOException {
        return this.setDatabaseRoot(foo2, schemaElementValue, true);
    }

    private SchemaElement setDatabaseRoot(MappingClassElement foo2, String schemaElementValue, boolean strict) throws ModelException, FileNotFoundException, ClassNotFoundException, IOException {
        SchemaElement bar = null;
        if (null != this.classLoader) {
            if (this.loadedSchema.get(schemaElementValue) == null) {
                SchemaElement.removeFromCache(schemaElementValue);
                this.loadedSchema.put(schemaElementValue, schemaElementValue);
            }
            bar = SchemaElement.forName(schemaElementValue, this.classLoader);
        } else {
            bar = SchemaElement.forName(schemaElementValue);
        }
        if (strict) {
            bar.toString();
        } else if (null == bar) {
            try {
                bar = new SchemaElement();
                bar.setName(DBIdentifier.create(schemaElementValue));
            }
            catch (DBException dbx) {
                bar.getName().toString();
            }
        }
        foo2.setDatabaseRoot(bar);
        return bar;
    }

    public static String getTableName(String columnName, String defaultName) {
        String retVal = defaultName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(0, len);
        }
        return retVal;
    }

    public static String getColumnName(String columnName) {
        String retVal = columnName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(len + 1);
        }
        return retVal;
    }

    private static void loadSecondaryTables(SecondaryTable[] tableList, Map knownValues, MappingClassElement mce, SchemaElement schema, PrintStream out, ConversionHelper helper) throws ModelException, DBException {
        ArrayList tl = mce.getTables();
        if (null == tl || tl.size() < 1) {
            MappingFile.writeMessage(out, "WARN_NOT_MAPPED_TO_PRIMARY", new Object[]{mce});
            return;
        }
        MappingTableElement primary = (MappingTableElement)tl.get(0);
        if (null != primary) {
            int i = 0;
            while (null != tableList && i < tableList.length) {
                String tn = tableList[i].getTableName();
                if (null != tn && tn.trim().length() != 0) {
                    TableElement te = MappingFile.getTableElement(schema, DBIdentifier.create(tn.trim()), helper);
                    ColumnPair[] pairs = tableList[i].getColumnPair();
                    int len = 0;
                    if (null != pairs) {
                        len = pairs.length;
                    }
                    if (0 == len) {
                        MappingFile.writeMessage(out, "WARN_NO_PAIRS", new Object[]{mce, tn});
                    } else {
                        MappingReferenceKeyElement mrke = mce.addSecondaryTable(primary, te);
                        int j = 0;
                        while (null != pairs && j < pairs.length) {
                            ColumnPairElement cpe = new ColumnPairElement();
                            DBIdentifier dbId = DBIdentifier.create("SecondaryTable" + j);
                            cpe.setName(dbId);
                            ColumnPair pair = pairs[j];
                            int k = 0;
                            while (k < 2) {
                                String nameOne = pair.getColumnName(k);
                                String sourceTableName = MappingFile.getTableName(nameOne.trim(), primary.getName().toString());
                                String sourceColumnName = MappingFile.getColumnName(nameOne);
                                dbId = DBIdentifier.create(sourceTableName);
                                TableElement sourceTableEl = MappingFile.getTableElement(schema, dbId, helper);
                                dbId = DBIdentifier.create(sourceColumnName);
                                ColumnElement ce = MappingFile.getColumnElement(sourceTableEl, dbId, helper);
                                if (k == 0) {
                                    cpe.setLocalColumn(ce);
                                } else {
                                    cpe.setReferencedColumn(ce);
                                }
                                ++k;
                            }
                            mrke.addColumnPair(cpe);
                            ++j;
                        }
                        knownValues.put(tn, te);
                    }
                }
                ++i;
            }
        } else {
            MappingFile.writeMessage(out, "WARN_NULL_PRIMARY", new Object[]{mce});
        }
    }

    private static void writeMessage(PrintStream out, String messageKey, Object[] params) {
        block2: {
            if (null == out) break block2;
            try {
                String format = bundle.getString(messageKey);
                out.println(MessageFormat.format(format, params));
            }
            catch (Throwable t) {
                out.println(messageKey);
            }
        }
    }

    private boolean validateField(MappingClassElement mcei, String beanName, String fieldName, boolean throwEx) {
        MappingFieldElement mfe = mcei.getField(fieldName);
        this.errorMessageArgs[MappingFile.CURRENT_FIELD] = fieldName;
        if (null != mfe) {
            this.errorMessageFormat = bundle.getString("ERR_FIELD_MAPPED_TWICE");
            if (throwEx) {
                throw new RuntimeException();
            }
            return false;
        }
        if (!this.helper.hasField(beanName, fieldName)) {
            this.errorMessageFormat = bundle.getString("ERR_INVALID_FIELD");
            if (throwEx) {
                throw new RuntimeException();
            }
            return false;
        }
        return true;
    }

    private Map getBean2EntityMappingMap(SunCmpMapping beanSet) {
        HashMap<String, EntityMapping> retVal = new HashMap<String, EntityMapping>();
        EntityMapping[] entityMappingsInSet = beanSet.getEntityMapping();
        int len = 0;
        if (null != entityMappingsInSet) {
            len = entityMappingsInSet.length;
        }
        int k = 0;
        while (k < len) {
            EntityMapping anEntityMapping = entityMappingsInSet[k];
            String beanName = anEntityMapping.getEjbName();
            this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_MISSING_BEAN_NAME");
            beanName.trim().charAt(0);
            retVal.put(beanName, anEntityMapping);
            ++k;
        }
        return retVal;
    }

    private boolean completeCmrMappings(SunCmpMapping beanSet, ConversionHelper helper) {
        Map beanName2EntityMapping = this.getBean2EntityMappingMap(beanSet);
        Iterator emIter = beanName2EntityMapping.values().iterator();
        boolean retVal = false;
        while (emIter.hasNext()) {
            EntityMapping anEM = (EntityMapping)((Object)emIter.next());
            String beanName = anEM.getEjbName();
            this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
            String pt = anEM.getTableName();
            CmrFieldMapping[] cmrsInEM = anEM.getCmrFieldMapping();
            int len = 0;
            if (null != cmrsInEM && null != beanName && beanName.trim().length() != 0) {
                len = cmrsInEM.length;
            }
            int i = 0;
            while (i < len) {
                String fieldName = cmrsInEM[i].getCmrFieldName();
                this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_MISSING_FIELD_NAME");
                fieldName.trim().charAt(0);
                this.errorMessageArgs[MappingFile.CURRENT_FIELD] = fieldName;
                this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_NAME_MISMATCH");
                String otherField = helper.getInverseFieldName(beanName, fieldName);
                this.errorMessageFormat = bundle.getString("ERR_BAD_CONVERSION_HELPER");
                String test2 = helper.getInverseFieldName(beanName, fieldName);
                if (!otherField.equals(test2)) {
                    throw new RuntimeException(this.errorMessageFormat);
                }
                String otherBean = helper.getRelationshipFieldContent(beanName, fieldName);
                if (helper.isPseudoCMRField(otherBean, otherField)) {
                    retVal = true;
                    String otherBeanName = helper.getRelationshipFieldContent(beanName, fieldName);
                    this.errorMessageFormat = bundle.getString("ERR_EJB_JAR_ERROR_FOR_RELATIONSHIP");
                    otherBeanName.trim().charAt(0);
                    EntityMapping otherEM = (EntityMapping)((Object)beanName2EntityMapping.get(otherBeanName));
                    CmrFieldMapping inverseMapping = new CmrFieldMapping();
                    inverseMapping.setCmrFieldName(otherField);
                    inverseMapping.setColumnPair(this.reverseCPArray(cmrsInEM[i].getColumnPair(), pt));
                    this.errorMessageArgs[MappingFile.CURRENT_BEAN] = otherBeanName;
                    this.errorMessageFormat = bundle.getString("ERR_BEAN_UNMAPPED");
                    otherEM.addCmrFieldMapping(inverseMapping);
                    this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
                }
                ++i;
            }
        }
        return retVal;
    }

    private ColumnPair[] reverseCPArray(ColumnPair[] cpa, String primeTable) {
        this.errorMessageFormat = bundle.getString("ERR_COLUMN_PAIR_MISSING");
        int len = cpa.length;
        ColumnPair[] retVal = new ColumnPair[cpa.length];
        int outdex = 0;
        int index = len - 1;
        do {
            retVal[outdex] = new ColumnPair();
            retVal[outdex].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(1)));
            this.errorMessageFormat = bundle.getString("ERR_INCOMPLETE_COLUMN_PAIR");
            retVal[outdex].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(0)));
            ++outdex;
        } while (--index > -1);
        return retVal;
    }

    private String qualify(String tn, String cn) {
        int tmp = cn.indexOf(46);
        String retVal = cn;
        if (-1 == tmp) {
            retVal = tn + "." + cn;
        }
        return retVal;
    }

    private static TableElement getTableElement(SchemaElement schema, DBIdentifier dbId, ConversionHelper helper) throws DBException {
        TableElement retVal = schema.getTable(dbId);
        if (null == retVal && !helper.ensureCompleteRoles()) {
            retVal = new TableElement();
            retVal.setName(dbId);
            retVal.setDeclaringSchema(schema);
            UniqueKeyElement tkey = new UniqueKeyElement();
            ColumnElement fakeKeyCol = new ColumnElement();
            fakeKeyCol.setName(DBIdentifier.create("fookeyng"));
            tkey.addColumn(fakeKeyCol);
            retVal.addKey(tkey);
        }
        return retVal;
    }

    private static ColumnElement getColumnElement(TableElement sourceTableEl, DBIdentifier sourceColumnName, ConversionHelper helper) throws DBException {
        ColumnElement aCol = sourceTableEl.getColumn(sourceColumnName);
        if (null == aCol && !helper.ensureCompleteRoles()) {
            aCol = new ColumnElement();
            aCol.setName(DBIdentifier.create(sourceTableEl.getName().toString() + "." + sourceColumnName.toString()));
            aCol.setDeclaringTable(sourceTableEl);
        }
        return aCol;
    }

    private MappingFieldElementImpl createUnmappedField(MappingClassElementImpl mcei, String beanName, String fieldName) throws ModelException {
        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, mcei.getPersistenceElement());
        pfe.setKey(this.helper.isKey(beanName, fieldName, false));
        mcei.getPersistenceElement().addField(pfe);
        MappingFieldElementImpl mfei = new MappingFieldElementImpl(fieldName, mcei);
        return mfei;
    }

    static {
        bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.ejb.cmp.transform.Bundle");
        DEFAULT_LOCATION_IN_EJB_JAR = bundle.getString("CONST_IAS_MAPPING_FILE_LOC");
        CURRENT_BEAN = 0;
        CURRENT_SCHEMA = 1;
        CURRENT_CLASSPATH = 2;
        CURRENT_TABLE = 3;
        CURRENT_COLUMN = 4;
        CURRENT_FIELD = 5;
        CURRENT_RELATION_FIELD_TYPE = 6;
        CURRENT_FETCH_WITH_LEVEL = 7;
        CURRENT_MAPPING_FILE = 8;
        LAST_INDEX = 9;
        MINIMUM_PRECISION = 19;
    }
}

