/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.IOException;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.StubGenerator;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;

public class PEStubGenerator
extends StubGenerator {
    private String preInvokeClass = null;

    public boolean parseArgs(String[] stringArray, Main main) {
        boolean bl = super.parseArgs(stringArray, main);
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    String string = stringArray[n].toLowerCase();
                    if (string.equals("-peiiop")) {
                        stringArray[n] = null;
                    } else if (string.equals("-preinvokeclass")) {
                        stringArray[n] = null;
                        if (++n < stringArray.length && stringArray[n] != null && !stringArray[n].startsWith("-")) {
                            this.preInvokeClass = stringArray[n];
                            stringArray[n] = null;
                        } else {
                            main.error("rmic.option.requires.argument", "-preinvokeclass");
                            bl = false;
                        }
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    void writeStubMethod(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        this.addNamesInUse(method);
        this.addNameInUse("_type_ids");
        indentingWriter.p("public " + this.getName(type) + " " + string + "(");
        int n = 0;
        while (n < typeArray.length) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(this.getName(typeArray[n]) + " " + stringArray[n]);
            ++n;
        }
        indentingWriter.p(")");
        if (valueTypeArray.length > 0) {
            indentingWriter.p(" throws ");
            int n2 = 0;
            while (n2 < valueTypeArray.length) {
                if (n2 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getName(valueTypeArray[n2]));
                ++n2;
            }
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln("int numTries = 0 ;");
        indentingWriter.plnI("while (true) { ");
        if (this.localStubs) {
            this.writeLocalStubMethodBody(indentingWriter, method, compoundType);
        } else {
            this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        }
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    void writeNonLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        if (this.preInvokeClass == null) {
            System.out.println(Main.getText("rmic.option.requires.argument", "-preinvokeclass"));
            System.exit(1);
        }
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, true);
        String string3 = this.getVariableName("in");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("ex");
        boolean bl = false;
        int n2 = 0;
        while (n2 < valueTypeArray.length) {
            if (valueTypeArray[n2].getIdentifier() != Constants.idRemoteException && valueTypeArray[n2].isType(32768) && StubGenerator.needNewReadStreamClass(valueTypeArray[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            n = 0;
            while (n < typeArray.length) {
                if (StubGenerator.needNewReadStreamClass(typeArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            bl = StubGenerator.needNewReadStreamClass(type);
        }
        n = 0;
        int n3 = 0;
        while (n3 < typeArray.length) {
            if (StubGenerator.needNewWriteStreamClass(typeArray[n3])) {
                n = 1;
                break;
            }
            ++n3;
        }
        indentingWriter.plnI("try {");
        if (bl) {
            indentingWriter.pln(sun.rmi.rmic.iiop.Constants.idExtInputStream + " " + string3 + " = null;");
        } else {
            indentingWriter.pln(sun.rmi.rmic.iiop.Constants.idInputStream + " " + string3 + " = null;");
        }
        indentingWriter.plnI("try {");
        indentingWriter.pln(this.preInvokeClass + ".preinvoke( this, ++ numTries ) ;");
        String string6 = "null";
        if (n != 0) {
            indentingWriter.plnI(sun.rmi.rmic.iiop.Constants.idExtOutputStream + " " + string4 + " = ");
            indentingWriter.pln("(" + sun.rmi.rmic.iiop.Constants.idExtOutputStream + ")");
            indentingWriter.pln("_request(\"" + string2 + "\", true);");
            indentingWriter.pO();
        } else {
            indentingWriter.pln("OutputStream " + string4 + " = _request(\"" + string2 + "\", true);");
        }
        if (typeArray.length > 0) {
            this.writeMarshalArguments(indentingWriter, string4, typeArray, stringArray);
            indentingWriter.pln();
        }
        string6 = string4;
        if (type.isType(1)) {
            indentingWriter.pln("_invoke(" + string6 + ");");
            indentingWriter.pln("return;");
        } else {
            if (bl) {
                indentingWriter.plnI(string3 + " = (" + sun.rmi.rmic.iiop.Constants.idExtInputStream + ")_invoke(" + string6 + ");");
                indentingWriter.pO();
            } else {
                indentingWriter.pln(string3 + " = _invoke(" + string6 + ");");
            }
            indentingWriter.p("return ");
            this.writeUnmarshalArgument(indentingWriter, string3, type, null);
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("} catch (" + this.getName(sun.rmi.rmic.iiop.Constants.idApplicationException) + " " + string5 + ") {");
        if (bl) {
            indentingWriter.pln(string3 + " = (" + sun.rmi.rmic.iiop.Constants.idExtInputStream + ") " + string5 + ".getInputStream();");
        } else {
            indentingWriter.pln(string3 + " = " + string5 + ".getInputStream();");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < valueTypeArray.length) {
            if (valueTypeArray[n4].getIdentifier() != Constants.idRemoteException) {
                if (valueTypeArray[n4].isIDLEntityException() && !valueTypeArray[n4].isCORBAUserException()) {
                    if (!bl3 && !bl2) {
                        indentingWriter.pln("String $_id = " + string5 + ".getId();");
                        bl3 = true;
                    }
                    String string7 = IDLNames.replace(valueTypeArray[n4].getQualifiedIDLName(false), "::", ".");
                    string7 = string7 + "Helper";
                    indentingWriter.plnI("if ($_id.equals(" + string7 + ".id())) {");
                    indentingWriter.pln("throw " + string7 + ".read(" + string3 + ");");
                } else {
                    if (!bl3 && !bl2) {
                        indentingWriter.pln("String $_id = " + string3 + ".read_string();");
                        bl3 = true;
                        bl2 = true;
                    } else if (bl3 && !bl2) {
                        indentingWriter.pln("$_id = " + string3 + ".read_string();");
                        bl2 = true;
                    }
                    indentingWriter.plnI("if ($_id.equals(\"" + this.getExceptionRepositoryID(valueTypeArray[n4]) + "\")) {");
                    indentingWriter.pln("throw (" + this.getName(valueTypeArray[n4]) + ") " + string3 + ".read_value(" + this.getName(valueTypeArray[n4]) + ".class);");
                }
                indentingWriter.pOln("}");
            }
            ++n4;
        }
        if (!bl3 && !bl2) {
            indentingWriter.pln("String $_id = " + string3 + ".read_string();");
            bl3 = true;
            bl2 = true;
        } else if (bl3 && !bl2) {
            indentingWriter.pln("$_id = " + string3 + ".read_string();");
            bl2 = true;
        }
        indentingWriter.pln("throw new UnexpectedException($_id);");
        indentingWriter.pOlnI("} catch (" + this.getName(sun.rmi.rmic.iiop.Constants.idRemarshalException) + " " + string5 + ") {");
        indentingWriter.pOlnI("} catch (org.omg.CORBA.NO_PERMISSION npex) {");
        indentingWriter.pln("if ( ! (" + this.preInvokeClass + ".isMinorCodeMatch( this, numTries, npex.minor )) ||");
        indentingWriter.pln("    (" + this.preInvokeClass + ".isTooManyTries( this, numTries )))");
        indentingWriter.pln("    throw npex ;");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_releaseReply(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOlnI("} catch (SystemException " + string5 + ") {");
        indentingWriter.pln("throw Util.mapSystemException(" + string5 + ");");
        indentingWriter.pOln("}");
    }

    void writeLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        String string = method.getName();
        String string2 = method.getIDLName();
        indentingWriter.plnI("if (!Util.isLocal(this)) {");
        this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        indentingWriter.pOlnI("} else {");
        String string3 = this.getVariableName("so");
        indentingWriter.pln("ServantObject " + string3 + " = _servant_preinvoke(\"" + string2 + "\"," + this.getName(compoundType) + ".class);");
        indentingWriter.plnI("if (" + string3 + " == null) {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n]);
            ++n;
        }
        indentingWriter.pln(");");
        if (type.isType(1)) {
            indentingWriter.pln("return;");
        }
        indentingWriter.pOln("}");
        indentingWriter.plnI("try {");
        String[] stringArray2 = this.writeCopyArguments(method, indentingWriter);
        boolean bl = StubGenerator.mustCopy(type, this.passbyReference);
        String string4 = null;
        if (!type.isType(1)) {
            if (bl) {
                string4 = this.getVariableName("result");
                indentingWriter.p(this.getName(type) + " " + string4 + " = ");
            } else {
                indentingWriter.p("return ");
            }
        }
        indentingWriter.p("((" + this.getName(compoundType) + ")" + string3 + ".servant)." + string + "(");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray2[n2]);
            ++n2;
        }
        indentingWriter.pln(");");
        if (bl) {
            indentingWriter.pln("return (" + this.getName(type) + ")Util.copyObject(" + string4 + ",_orb());");
        }
        if (type.isType(1)) {
            indentingWriter.pln("return;");
        }
        String string5 = this.getVariableName("ex");
        String string6 = this.getVariableName("exCopy");
        indentingWriter.pOlnI("} catch (Throwable " + string5 + ") {");
        indentingWriter.pln("Throwable " + string6 + " = (Throwable)Util.copyObject(" + string5 + ",_orb());");
        int n3 = 0;
        while (n3 < valueTypeArray.length) {
            if (valueTypeArray[n3].getIdentifier() != Constants.idRemoteException && valueTypeArray[n3].isType(32768)) {
                indentingWriter.plnI("if (" + string6 + " instanceof " + this.getName(valueTypeArray[n3]) + ") {");
                indentingWriter.pln("throw (" + this.getName(valueTypeArray[n3]) + ")" + string6 + ";");
                indentingWriter.pOln("}");
            }
            ++n3;
        }
        indentingWriter.pln("throw Util.wrapException(" + string6 + ");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_servant_postinvoke(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }
}

