/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import com.sun.corba.se.internal.util.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RMIConstants;
import sun.rmi.rmic.RemoteClass;
import sun.rmi.rmic.Util;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RMIGenerator
implements RMIConstants,
Generator {
    private BatchEnvironment env;
    private RemoteClass remoteClass;
    private int version;
    private RemoteClass.Method[] remoteMethods;
    private Identifier remoteClassName;
    private Identifier stubClassName;
    private Identifier skeletonClassName;
    private ClassDefinition cdef;
    private File destDir;
    private File stubFile;
    private File skeletonFile;
    private String[] methodFieldNames;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;
    private ClassDefinition defRuntimeException;

    public RMIGenerator() {
        this.version = 2;
    }

    public boolean parseArgs(String[] stringArray, Main main) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                if (stringArray[n].equalsIgnoreCase("-v1.1")) {
                    this.version = 1;
                    stringArray[n] = null;
                    break;
                }
                if (stringArray[n].equalsIgnoreCase("-vcompat")) {
                    this.version = 2;
                    stringArray[n] = null;
                    break;
                }
                if (stringArray[n].equalsIgnoreCase("-v1.2")) {
                    this.version = 3;
                    stringArray[n] = null;
                    break;
                }
            }
            ++n;
        }
        return true;
    }

    public void generate(BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        RMIGenerator rMIGenerator;
        RemoteClass remoteClass = RemoteClass.forClass(batchEnvironment, classDefinition);
        if (remoteClass == null) {
            return;
        }
        try {
            rMIGenerator = new RMIGenerator(batchEnvironment, classDefinition, file, remoteClass, this.version);
        }
        catch (ClassNotFound classNotFound) {
            batchEnvironment.error(0L, "rmic.class.not.found", classNotFound.name);
            return;
        }
        rMIGenerator.generate();
    }

    private void generate() {
        Object object;
        this.env.addGeneratedFile(this.stubFile);
        try {
            object = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.stubFile)));
            this.writeStub((IndentingWriter)object);
            ((BufferedWriter)object).close();
            if (this.env.verbose()) {
                this.env.output(Main.getText("rmic.wrote", this.stubFile.getPath()));
            }
            this.env.parseFile(new ClassFile(this.stubFile));
        }
        catch (IOException iOException) {
            this.env.error(0L, "cant.write", this.stubFile.toString());
            return;
        }
        if (this.version == 1 || this.version == 2) {
            this.env.addGeneratedFile(this.skeletonFile);
            try {
                object = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.skeletonFile)));
                this.writeSkeleton((IndentingWriter)object);
                ((BufferedWriter)object).close();
                if (this.env.verbose()) {
                    this.env.output(Main.getText("rmic.wrote", this.skeletonFile.getPath()));
                }
                this.env.parseFile(new ClassFile(this.skeletonFile));
            }
            catch (IOException iOException) {
                this.env.error(0L, "cant.write", this.stubFile.toString());
                return;
            }
        } else {
            object = Util.getOutputDirectoryFor(this.remoteClassName, this.destDir, this.env);
            File file = new File((File)object, this.skeletonClassName.getName().toString() + ".class");
            this.skeletonFile.delete();
            file.delete();
        }
    }

    protected static File sourceFileForClass(Identifier identifier, Identifier identifier2, File file, BatchEnvironment batchEnvironment) {
        String string;
        File file2;
        File file3 = Util.getOutputDirectoryFor(identifier, file, batchEnvironment);
        String string2 = Names.mangleClass(identifier2).getName().toString();
        if (string2.endsWith("_Skel") && (file2 = new File(file3, Utility.tieName(string = identifier.getName().toString()) + ".class")).exists() && !batchEnvironment.getMain().iiopGeneration) {
            batchEnvironment.error(0L, "warn.rmic.tie.found", string, file2.getAbsolutePath());
        }
        string = string2 + ".java";
        return new File(file3, string);
    }

    private RMIGenerator(BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file, RemoteClass remoteClass, int n) throws ClassNotFound {
        this.destDir = file;
        this.cdef = classDefinition;
        this.env = batchEnvironment;
        this.remoteClass = remoteClass;
        this.version = n;
        this.remoteMethods = remoteClass.getRemoteMethods();
        this.remoteClassName = remoteClass.getName();
        this.stubClassName = Names.stubFor(this.remoteClassName);
        this.skeletonClassName = Names.skeletonFor(this.remoteClassName);
        this.methodFieldNames = RMIGenerator.nameMethodFields(this.remoteMethods);
        this.stubFile = RMIGenerator.sourceFileForClass(this.remoteClassName, this.stubClassName, file, batchEnvironment);
        this.skeletonFile = RMIGenerator.sourceFileForClass(this.remoteClassName, this.skeletonClassName, file, batchEnvironment);
        this.defException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangException).getClassDefinition((Environment)batchEnvironment);
        this.defRemoteException = batchEnvironment.getClassDeclaration(Constants.idRemoteException).getClassDefinition((Environment)batchEnvironment);
        this.defRuntimeException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangRuntimeException).getClassDefinition((Environment)batchEnvironment);
    }

    private void writeStub(IndentingWriter indentingWriter) throws IOException {
        int n;
        indentingWriter.pln("// Stub class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.stubClassName.getName()));
        indentingWriter.pln("extends " + RMIConstants.idRemoteStub);
        ClassDefinition[] classDefinitionArray = this.remoteClass.getRemoteInterfaces();
        if (classDefinitionArray.length > 0) {
            indentingWriter.p("implements ");
            n = 0;
            while (n < classDefinitionArray.length) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDefinitionArray[n].getName().toString());
                ++n;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        if (this.version == 1 || this.version == 2) {
            this.writeOperationsArray(indentingWriter);
            indentingWriter.pln();
            this.writeInterfaceHash(indentingWriter);
            indentingWriter.pln();
        }
        if (this.version == 2 || this.version == 3) {
            indentingWriter.pln("private static final long serialVersionUID = 2;");
            indentingWriter.pln();
            if (this.methodFieldNames.length > 0) {
                if (this.version == 2) {
                    indentingWriter.pln("private static boolean useNewInvoke;");
                }
                this.writeMethodFieldDeclarations(indentingWriter);
                indentingWriter.pln();
                indentingWriter.plnI("static {");
                indentingWriter.plnI("try {");
                if (this.version == 2) {
                    indentingWriter.plnI(RMIConstants.idRemoteRef + ".class.getMethod(\"invoke\",");
                    indentingWriter.plnI("new java.lang.Class[] {");
                    indentingWriter.pln(Constants.idRemote + ".class,");
                    indentingWriter.pln("java.lang.reflect.Method.class,");
                    indentingWriter.pln("java.lang.Object[].class,");
                    indentingWriter.pln("long.class");
                    indentingWriter.pOln("});");
                    indentingWriter.pO();
                    indentingWriter.pln("useNewInvoke = true;");
                }
                this.writeMethodFieldInitializers(indentingWriter);
                indentingWriter.pOlnI("} catch (java.lang.NoSuchMethodException e) {");
                if (this.version == 2) {
                    indentingWriter.pln("useNewInvoke = false;");
                } else {
                    indentingWriter.plnI("throw new java.lang.NoSuchMethodError(");
                    indentingWriter.pln("\"stub class initialization failed\");");
                    indentingWriter.pO();
                }
                indentingWriter.pOln("}");
                indentingWriter.pOln("}");
                indentingWriter.pln();
            }
        }
        this.writeStubConstructors(indentingWriter);
        indentingWriter.pln();
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// methods from remote interfaces");
            n = 0;
            while (n < this.remoteMethods.length) {
                indentingWriter.pln();
                this.writeStubMethod(indentingWriter, n);
                ++n;
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeStubConstructors(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// constructors");
        if (this.version == 1 || this.version == 2) {
            indentingWriter.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "() {");
            indentingWriter.pln("super();");
            indentingWriter.pOln("}");
        }
        indentingWriter.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "(" + RMIConstants.idRemoteRef + " ref) {");
        indentingWriter.pln("super(ref);");
        indentingWriter.pOln("}");
    }

    private void writeStubMethod(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = RMIGenerator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        ClassDeclaration[] classDeclarationArray = method.getExceptions();
        indentingWriter.pln("// implementation of " + type.typeString(identifier.toString(), true, false));
        indentingWriter.p("public " + type2 + " " + identifier + "(");
        int n3 = 0;
        while (n3 < typeArray.length) {
            if (n3 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(typeArray[n3] + " " + stringArray[n3]);
            ++n3;
        }
        indentingWriter.plnI(")");
        if (classDeclarationArray.length > 0) {
            indentingWriter.p("throws ");
            int n4 = 0;
            while (n4 < classDeclarationArray.length) {
                if (n4 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDeclarationArray[n4].getName().toString());
                ++n4;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        Vector vector = this.computeUniqueCatchList(classDeclarationArray);
        if (vector.size() > 0) {
            indentingWriter.plnI("try {");
        }
        if (this.version == 2) {
            indentingWriter.plnI("if (useNewInvoke) {");
        }
        if (this.version == 2 || this.version == 3) {
            if (!type2.isType(11)) {
                indentingWriter.p("Object $result = ");
            }
            indentingWriter.p("ref.invoke(this, " + this.methodFieldNames[n] + ", ");
            if (typeArray.length > 0) {
                indentingWriter.p("new java.lang.Object[] {");
                n2 = 0;
                while (n2 < typeArray.length) {
                    if (n2 > 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p(RMIGenerator.wrapArgumentCode(typeArray[n2], stringArray[n2]));
                    ++n2;
                }
                indentingWriter.p("}");
            } else {
                indentingWriter.p("null");
            }
            indentingWriter.pln(", " + method.getMethodHash() + "L);");
            if (!type2.isType(11)) {
                indentingWriter.pln("return " + RMIGenerator.unwrapArgumentCode(type2, "$result") + ";");
            }
        }
        if (this.version == 2) {
            indentingWriter.pOlnI("} else {");
        }
        if (this.version == 1 || this.version == 2) {
            indentingWriter.pln(RMIConstants.idRemoteCall + " call = ref.newCall((" + RMIConstants.idRemoteObject + ") this, operations, " + n + ", interfaceHash);");
            if (typeArray.length > 0) {
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectOutput out = call.getOutputStream();");
                RMIGenerator.writeMarshalArguments(indentingWriter, "out", typeArray, stringArray);
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new " + RMIConstants.idMarshalException + "(\"error marshalling arguments\", e);");
                indentingWriter.pOln("}");
            }
            indentingWriter.pln("ref.invoke(call);");
            if (type2.isType(11)) {
                indentingWriter.pln("ref.done(call);");
            } else {
                indentingWriter.pln(type2 + " $result;");
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
                n2 = RMIGenerator.writeUnmarshalArgument(indentingWriter, "in", type2, "$result") ? 1 : 0;
                indentingWriter.pln(";");
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"error unmarshalling return\", e);");
                if (n2 != 0) {
                    indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                    indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"error unmarshalling return\", e);");
                }
                indentingWriter.pOlnI("} finally {");
                indentingWriter.pln("ref.done(call);");
                indentingWriter.pOln("}");
                indentingWriter.pln("return $result;");
            }
        }
        if (this.version == 2) {
            indentingWriter.pOln("}");
        }
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
                indentingWriter.pOlnI("} catch (" + classDefinition.getName() + " e) {");
                indentingWriter.pln("throw e;");
            }
            indentingWriter.pOlnI("} catch (java.lang.Exception e) {");
            indentingWriter.pln("throw new " + RMIConstants.idUnexpectedException + "(\"undeclared checked exception\", e);");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private Vector computeUniqueCatchList(ClassDeclaration[] classDeclarationArray) {
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        vector.addElement(this.defRuntimeException);
        vector.addElement(this.defRemoteException);
        int n = 0;
        while (n < classDeclarationArray.length) {
            block7: {
                ClassDeclaration classDeclaration = classDeclarationArray[n];
                try {
                    if (this.defException.subClassOf((Environment)this.env, classDeclaration)) {
                        vector.clear();
                        break;
                    }
                    if (!this.defException.superClassOf((Environment)this.env, classDeclaration)) break block7;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        ClassDefinition classDefinition = (ClassDefinition)vector.elementAt(n2);
                        if (!classDefinition.superClassOf((Environment)this.env, classDeclaration)) {
                            if (classDefinition.subClassOf((Environment)this.env, classDeclaration)) {
                                vector.removeElementAt(n2);
                                continue;
                            }
                            ++n2;
                            continue;
                        }
                        break block7;
                    }
                    vector.addElement(classDeclaration.getClassDefinition((Environment)this.env));
                }
                catch (ClassNotFound classNotFound) {
                    this.env.error(0L, "class.not.found", classNotFound.name, classDeclaration.getName());
                }
            }
            ++n;
        }
        return vector;
    }

    private void writeSkeleton(IndentingWriter indentingWriter) throws IOException {
        int n;
        if (this.version == 3) {
            throw new Error("should not generate skeleton for version");
        }
        indentingWriter.pln("// Skeleton class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.skeletonClassName.getName()));
        indentingWriter.pln("implements " + RMIConstants.idSkeleton);
        indentingWriter.pOlnI("{");
        this.writeOperationsArray(indentingWriter);
        indentingWriter.pln();
        this.writeInterfaceHash(indentingWriter);
        indentingWriter.pln();
        indentingWriter.plnI("public " + RMIConstants.idOperation + "[] getOperations() {");
        indentingWriter.pln("return (" + RMIConstants.idOperation + "[]) operations.clone();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void dispatch(" + Constants.idRemote + " obj, " + RMIConstants.idRemoteCall + " call, int opnum, long hash)");
        indentingWriter.pln("throws java.lang.Exception");
        indentingWriter.pOlnI("{");
        if (this.version == 2) {
            indentingWriter.plnI("if (opnum < 0) {");
            if (this.remoteMethods.length > 0) {
                n = 0;
                while (n < this.remoteMethods.length) {
                    if (n > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (hash == " + this.remoteMethods[n].getMethodHash() + "L) {");
                    indentingWriter.pln("opnum = " + n + ";");
                    ++n;
                }
                indentingWriter.pOlnI("} else {");
            }
            indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"invalid method hash\");");
            if (this.remoteMethods.length > 0) {
                indentingWriter.pOln("}");
            }
            indentingWriter.pOlnI("} else {");
        }
        indentingWriter.plnI("if (hash != interfaceHash)");
        indentingWriter.pln("throw new " + RMIConstants.idSkeletonMismatchException + "(\"interface hash mismatch\");");
        indentingWriter.pO();
        if (this.version == 2) {
            indentingWriter.pOln("}");
        }
        indentingWriter.pln();
        indentingWriter.pln(this.remoteClassName + " server = (" + this.remoteClassName + ") obj;");
        indentingWriter.plnI("switch (opnum) {");
        n = 0;
        while (n < this.remoteMethods.length) {
            this.writeSkeletonDispatchCase(indentingWriter, n);
            ++n;
        }
        indentingWriter.pOlnI("default:");
        indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"invalid method number\");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeSkeletonDispatchCase(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = RMIGenerator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        indentingWriter.pOlnI("case " + n + ": // " + type.typeString(identifier.toString(), true, false));
        indentingWriter.pOlnI("{");
        if (typeArray.length > 0) {
            n2 = 0;
            while (n2 < typeArray.length) {
                indentingWriter.pln(typeArray[n2] + " " + stringArray[n2] + ";");
                ++n2;
            }
            indentingWriter.plnI("try {");
            indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
            boolean bl = RMIGenerator.writeUnmarshalArguments(indentingWriter, "in", typeArray, stringArray);
            indentingWriter.pOlnI("} catch (java.io.IOException e) {");
            indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            if (bl) {
                indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                indentingWriter.pln("throw new " + RMIConstants.idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            }
            indentingWriter.pOlnI("} finally {");
            indentingWriter.pln("call.releaseInputStream();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("call.releaseInputStream();");
        }
        if (!type2.isType(11)) {
            indentingWriter.p(type2 + " $result = ");
        }
        indentingWriter.p("server." + identifier + "(");
        n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n2]);
            ++n2;
        }
        indentingWriter.pln(");");
        indentingWriter.plnI("try {");
        if (!type2.isType(11)) {
            indentingWriter.p("java.io.ObjectOutput out = ");
        }
        indentingWriter.pln("call.getResultStream(true);");
        if (!type2.isType(11)) {
            RMIGenerator.writeMarshalArgument(indentingWriter, "out", type2, "$result");
            indentingWriter.pln(";");
        }
        indentingWriter.pOlnI("} catch (java.io.IOException e) {");
        indentingWriter.pln("throw new " + RMIConstants.idMarshalException + "(\"error marshalling return\", e);");
        indentingWriter.pOln("}");
        indentingWriter.pln("break;");
        indentingWriter.pOlnI("}");
        indentingWriter.pln();
    }

    private void writeOperationsArray(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("private static final " + RMIConstants.idOperation + "[] operations = {");
        int n = 0;
        while (n < this.remoteMethods.length) {
            if (n > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p("new " + RMIConstants.idOperation + "(\"" + this.remoteMethods[n].getOperationString() + "\")");
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pOln("};");
    }

    private void writeInterfaceHash(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("private static final long interfaceHash = " + this.remoteClass.getInterfaceHash() + "L;");
    }

    private void writeMethodFieldDeclarations(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.pln("private static java.lang.reflect.Method " + this.methodFieldNames[n] + ";");
            ++n;
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.p(this.methodFieldNames[n] + " = ");
            RemoteClass.Method method = this.remoteMethods[n];
            MemberDefinition memberDefinition = method.getMemberDefinition();
            Identifier identifier = method.getName();
            Type type = method.getType();
            Type[] typeArray = type.getArgumentTypes();
            indentingWriter.p(memberDefinition.getClassDefinition().getName() + ".class.getMethod(\"" + identifier + "\", new java.lang.Class[] {");
            int n2 = 0;
            while (n2 < typeArray.length) {
                if (n2 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(typeArray[n2] + ".class");
                ++n2;
            }
            indentingWriter.pln("});");
            ++n;
        }
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$method_" + methodArray[n].getName() + "_" + n;
            ++n;
        }
        return stringArray;
    }

    private static String[] nameParameters(Type[] typeArray) {
        String[] stringArray = new String[typeArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$param_" + RMIGenerator.generateNameFromType(typeArray[n]) + "_" + (n + 1);
            ++n;
        }
        return stringArray;
    }

    private static String generateNameFromType(Type type) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf_" + RMIGenerator.generateNameFromType(type.getElementType());
            }
            case 10: {
                return Names.mangleClass(type.getClassName().getName()).toString();
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                indentingWriter.p(string + ".writeBoolean(" + string2 + ")");
                break;
            }
            case 1: {
                indentingWriter.p(string + ".writeByte(" + string2 + ")");
                break;
            }
            case 2: {
                indentingWriter.p(string + ".writeChar(" + string2 + ")");
                break;
            }
            case 3: {
                indentingWriter.p(string + ".writeShort(" + string2 + ")");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".writeInt(" + string2 + ")");
                break;
            }
            case 5: {
                indentingWriter.p(string + ".writeLong(" + string2 + ")");
                break;
            }
            case 6: {
                indentingWriter.p(string + ".writeFloat(" + string2 + ")");
                break;
            }
            case 7: {
                indentingWriter.p(string + ".writeDouble(" + string2 + ")");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p(string + ".writeObject(" + string2 + ")");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    private static void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        int n = 0;
        while (n < typeArray.length) {
            RMIGenerator.writeMarshalArgument(indentingWriter, string, typeArray[n], stringArray[n]);
            indentingWriter.pln(";");
            ++n;
        }
    }

    private static boolean writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        boolean bl = false;
        if (string2 != null) {
            indentingWriter.p(string2 + " = ");
        }
        int n = type.getTypeCode();
        switch (type.getTypeCode()) {
            case 0: {
                indentingWriter.p(string + ".readBoolean()");
                break;
            }
            case 1: {
                indentingWriter.p(string + ".readByte()");
                break;
            }
            case 2: {
                indentingWriter.p(string + ".readChar()");
                break;
            }
            case 3: {
                indentingWriter.p(string + ".readShort()");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".readInt()");
                break;
            }
            case 5: {
                indentingWriter.p(string + ".readLong()");
                break;
            }
            case 6: {
                indentingWriter.p(string + ".readFloat()");
                break;
            }
            case 7: {
                indentingWriter.p(string + ".readDouble()");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p("(" + type + ") " + string + ".readObject()");
                bl = true;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
        return bl;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        boolean bl = false;
        int n = 0;
        while (n < typeArray.length) {
            if (RMIGenerator.writeUnmarshalArgument(indentingWriter, string, typeArray[n], stringArray[n])) {
                bl = true;
            }
            indentingWriter.pln(";");
            ++n;
        }
        return bl;
    }

    private static String wrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "new java.lang.Boolean(" + string + ")";
            }
            case 1: {
                return "new java.lang.Byte(" + string + ")";
            }
            case 2: {
                return "new java.lang.Character(" + string + ")";
            }
            case 3: {
                return "new java.lang.Short(" + string + ")";
            }
            case 4: {
                return "new java.lang.Integer(" + string + ")";
            }
            case 5: {
                return "new java.lang.Long(" + string + ")";
            }
            case 6: {
                return "new java.lang.Float(" + string + ")";
            }
            case 7: {
                return "new java.lang.Double(" + string + ")";
            }
            case 9: 
            case 10: {
                return string;
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static String unwrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "((java.lang.Boolean) " + string + ").booleanValue()";
            }
            case 1: {
                return "((java.lang.Byte) " + string + ").byteValue()";
            }
            case 2: {
                return "((java.lang.Character) " + string + ").charValue()";
            }
            case 3: {
                return "((java.lang.Short) " + string + ").shortValue()";
            }
            case 4: {
                return "((java.lang.Integer) " + string + ").intValue()";
            }
            case 5: {
                return "((java.lang.Long) " + string + ").longValue()";
            }
            case 6: {
                return "((java.lang.Float) " + string + ").floatValue()";
            }
            case 7: {
                return "((java.lang.Double) " + string + ").doubleValue()";
            }
            case 9: 
            case 10: {
                return "((" + type + ") " + string + ")";
            }
        }
        throw new Error("unexpected type code: " + n);
    }
}

