/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.MacData;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.DigestInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;

public class PFX
implements ASN1Value {
    private INTEGER version;
    private AuthenticatedSafes authSafes;
    private MacData macData;
    private byte[] encodedAuthSafes;
    private static final INTEGER VERSION = new INTEGER(3L);
    public static final int DEFAULT_ITERATIONS = 1;
    private static final Tag TAG = SEQUENCE.TAG;

    private PFX() {
    }

    public PFX(INTEGER iNTEGER, AuthenticatedSafes authenticatedSafes, MacData macData) {
        if (iNTEGER == null || authenticatedSafes == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.version = iNTEGER;
        this.authSafes = authenticatedSafes;
        this.macData = macData;
    }

    public PFX(AuthenticatedSafes authenticatedSafes) {
        this(VERSION, authenticatedSafes, null);
    }

    public PFX(AuthenticatedSafes authenticatedSafes, MacData macData) {
        this(VERSION, authenticatedSafes, macData);
    }

    public void computeMacData(Password password, byte[] byArray, int n) throws CryptoManager.NotInitializedException, DigestException, TokenException, CharConversionException {
        this.macData = new MacData(password, byArray, n, ASN1Util.encode(this.authSafes));
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.version);
        sEQUENCE.addElement(new ContentInfo(ASN1Util.encode(this.authSafes)));
        if (this.macData != null) {
            sEQUENCE.addElement(this.macData);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public AuthenticatedSafes getAuthSafes() {
        return this.authSafes;
    }

    public MacData getMacData() {
        return this.macData;
    }

    public Tag getTag() {
        return TAG;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public static void main(String[] stringArray) {
        try {
            ASN1Value aSN1Value;
            if (stringArray.length != 2) {
                System.out.println("Usage: PFX <dbdir> <infile>");
                System.exit(-1);
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            int n = 0;
            CryptoManager.initialize(stringArray[0]);
            Template template = new Template();
            PFX pFX = (PFX)template.decode(new BufferedInputStream(fileInputStream, 2048));
            System.out.println("Decoded PFX");
            System.out.println("Version: " + pFX.getVersion());
            AuthenticatedSafes authenticatedSafes = pFX.getAuthSafes();
            SEQUENCE sEQUENCE = authenticatedSafes.getSequence();
            System.out.println("AuthSafes has " + sEQUENCE.size() + " SafeContents");
            System.out.println("Enter password: ");
            Password password = Password.readPasswordFromConsole();
            System.out.println("Enter new password:");
            Password password2 = Password.readPasswordFromConsole();
            StringBuffer stringBuffer = new StringBuffer();
            if (pFX.verifyAuthSafes(password, stringBuffer)) {
                System.out.println("AuthSafes verifies correctly");
            } else {
                System.out.println("AuthSafes failed to verify because: " + stringBuffer);
            }
            AuthenticatedSafes authenticatedSafes2 = new AuthenticatedSafes();
            int n2 = 0;
            while (n2 < sEQUENCE.size()) {
                aSN1Value = authenticatedSafes.getSafeContentsAt(password, n2);
                System.out.println("\n\nSafeContents #" + n2 + " has " + ((SET)aSN1Value).size() + " bags");
                int n3 = 0;
                while (n3 < ((SET)aSN1Value).size()) {
                    Object object;
                    Object object2;
                    ASN1Value aSN1Value2;
                    ASN1Value aSN1Value3;
                    SafeBag safeBag = (SafeBag)((SET)aSN1Value).elementAt(n3);
                    System.out.println("\nBag " + n3 + " has type " + safeBag.getBagType());
                    SET sET = safeBag.getBagAttributes();
                    if (sET == null) {
                        System.out.println("Bag has no attributes");
                    } else {
                        int n4 = 0;
                        while (n4 < sET.size()) {
                            aSN1Value3 = (Attribute)sET.elementAt(n4);
                            if (((Attribute)aSN1Value3).getType().equals(SafeBag.FRIENDLY_NAME)) {
                                aSN1Value2 = (BMPString)((ANY)((Attribute)aSN1Value3).getValues().elementAt(0)).decodeWith(BMPString.getTemplate());
                                System.out.println("Friendly Name: " + aSN1Value2);
                            } else if (((Attribute)aSN1Value3).getType().equals(SafeBag.LOCAL_KEY_ID)) {
                                aSN1Value2 = (OCTET_STRING)((ANY)((Attribute)aSN1Value3).getValues().elementAt(0)).decodeWith(OCTET_STRING.getTemplate());
                                System.out.println("LocalKeyID:");
                                AuthenticatedSafes.print_byte_array(((OCTET_STRING)aSN1Value2).toByteArray());
                            } else {
                                System.out.println("Unknown attribute type");
                            }
                            ++n4;
                        }
                    }
                    ASN1Value aSN1Value4 = safeBag.getInterpretedBagContent();
                    if (aSN1Value4 instanceof PrivateKeyInfo) {
                        System.out.println("content is PrivateKeyInfo");
                    } else if (aSN1Value4 instanceof EncryptedPrivateKeyInfo) {
                        aSN1Value3 = (EncryptedPrivateKeyInfo)aSN1Value4;
                        System.out.println("content is EncryptedPrivateKeyInfo, algoid:" + ((EncryptedPrivateKeyInfo)aSN1Value3).getEncryptionAlgorithm().getOID());
                        aSN1Value2 = ((EncryptedPrivateKeyInfo)aSN1Value3).decrypt(password, new PasswordConverter());
                        object2 = new byte[20];
                        object = CryptoManager.getInstance().getSecureRNG();
                        object.nextBytes((byte[])object2);
                        aSN1Value3 = EncryptedPrivateKeyInfo.createPBE(PBEAlgorithm.PBE_SHA1_DES3_CBC, password2, (byte[])object2, 1, new PasswordConverter(), (PrivateKeyInfo)aSN1Value2);
                        ((SET)aSN1Value).insertElementAt(new SafeBag(safeBag.getBagType(), aSN1Value3, safeBag.getBagAttributes()), n2);
                        ((SET)aSN1Value).removeElementAt(n2 + 1);
                    } else if (aSN1Value4 instanceof CertBag) {
                        System.out.println("   content is CertBag");
                        aSN1Value3 = (CertBag)aSN1Value4;
                        if (((CertBag)aSN1Value3).getCertType().equals(CertBag.X509_CERT_TYPE)) {
                            aSN1Value2 = (OCTET_STRING)((CertBag)aSN1Value3).getInterpretedCert();
                            object2 = new FileOutputStream("cert" + n++ + ".der");
                            ((OCTET_STRING)aSN1Value2).encode((OutputStream)object2);
                            ((FileOutputStream)object2).close();
                            object = (Certificate)ASN1Util.decode(Certificate.getTemplate(), ((OCTET_STRING)aSN1Value2).toByteArray());
                            ((Certificate)object).getInfo().print(System.out);
                        } else {
                            System.out.println("Unrecognized cert type");
                        }
                    } else {
                        System.out.println("content is ANY");
                    }
                    ++n3;
                }
                if (authenticatedSafes.safeContentsIsEncrypted(n2)) {
                    authenticatedSafes2.addEncryptedSafeContents(AuthenticatedSafes.DEFAULT_KEY_GEN_ALG, password2, null, 1, (SEQUENCE)aSN1Value);
                } else {
                    authenticatedSafes2.addSafeContents((SEQUENCE)aSN1Value);
                }
                ++n2;
            }
            aSN1Value = new PFX(authenticatedSafes2);
            ((PFX)aSN1Value).computeMacData(password2, null, 1);
            FileOutputStream fileOutputStream = new FileOutputStream("newjss.p12");
            ((PFX)aSN1Value).encode(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setEncodedAuthSafes(byte[] byArray) {
        this.encodedAuthSafes = byArray;
    }

    public boolean verifyAuthSafes(Password password, StringBuffer stringBuffer) throws CryptoManager.NotInitializedException {
        try {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (this.macData == null) {
                stringBuffer.append("No MAC present in PFX");
                return false;
            }
            if (this.encodedAuthSafes == null) {
                this.encodedAuthSafes = ASN1Util.encode(this.authSafes);
            }
            DigestInfo digestInfo = this.macData.getMac();
            MacData macData = new MacData(password, this.macData.getMacSalt().toByteArray(), this.macData.getMacIterationCount().intValue(), this.encodedAuthSafes);
            if (macData.getMac().equals(digestInfo)) {
                return true;
            }
            stringBuffer.append("Digests do not match");
            return false;
        }
        catch (DigestException digestException) {
            digestException.printStackTrace();
            stringBuffer.append("A DigestException occurred");
            return false;
        }
        catch (TokenException tokenException) {
            stringBuffer.append("A TokenException occurred");
            return false;
        }
        catch (CharConversionException charConversionException) {
            stringBuffer.append("An exception occurred converting the password from chars to bytes");
            return false;
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addOptionalElement(MacData.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            ContentInfo contentInfo = (ContentInfo)sEQUENCE.elementAt(1);
            if (!contentInfo.getContentType().equals(ContentInfo.DATA)) {
                throw new InvalidBERException("ContentInfo containing AuthenticatedSafes does not have content-type DATA");
            }
            OCTET_STRING oCTET_STRING = (OCTET_STRING)contentInfo.getInterpretedContent();
            AuthenticatedSafes authenticatedSafes = (AuthenticatedSafes)ASN1Util.decode(AuthenticatedSafes.getTemplate(), oCTET_STRING.toByteArray());
            PFX pFX = new PFX((INTEGER)sEQUENCE.elementAt(0), authenticatedSafes, (MacData)sEQUENCE.elementAt(2));
            pFX.setEncodedAuthSafes(oCTET_STRING.toByteArray());
            return pFX;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

