/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.FileDeclarationPhase;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.InfoGenerator;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.JakartaCommentGenerator;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.MappedCharDataGenerator;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.StaticInitializerPhase;
import org.apache.jasper.compiler.StoredCharDataGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.UninterpretedTagBeginGenerator;
import org.apache.jasper.compiler.UninterpretedTagEndGenerator;
import org.apache.jasper.compiler.XmlOutputter;
import org.xml.sax.Attributes;

public class JspParseEventListener
implements ParseEventListener {
    private static CommentGenerator commentGenerator = new JakartaCommentGenerator();
    protected JspReader reader;
    protected ServletWriter writer;
    JspCompilationContext ctxt;
    ParserController parserCtl;
    String jspServletBase = "HttpJspBase";
    String serviceMethodName = "_jspService";
    String servletContentType = null;
    String pageEncoding = null;
    String defaultType = null;
    String defaultCharset = null;
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    int stringId = 0;
    Vector vector = new Vector();
    String dataFile;
    TagLibraries libraries;
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;
    private XmlOutputter xo = new XmlOutputter();
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    static final String pageEncodingStr = "pageEncoding";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("pageEncoding", new PageEncodingHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    final void addGenerator(Generator generator) throws JasperException {
        generator.init(this.ctxt);
        this.generators.addElement(generator);
    }

    public void setDefault(boolean bl) {
        if (bl) {
            this.defaultType = "text/xml;";
            this.defaultCharset = "UTF-8";
        } else {
            this.defaultType = "text/html;";
            this.defaultCharset = "ISO-8859-1";
        }
    }

    public static void setCommentGenerator(CommentGenerator commentGenerator) {
        if (null == JspParseEventListener.commentGenerator) {
            throw new IllegalArgumentException("null == generator");
        }
        JspParseEventListener.commentGenerator = commentGenerator;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setTemplateInfo(Mark mark, Mark mark2) {
    }

    JspParseEventListener(JspCompilationContext jspCompilationContext, ParserController parserController) {
        String string;
        int n;
        this.reader = jspCompilationContext.getReader();
        this.writer = jspCompilationContext.getWriter();
        this.ctxt = jspCompilationContext;
        this.parserCtl = parserController;
        this.beanInfo = new BeanRepository(jspCompilationContext.getClassLoader());
        this.libraries = new TagLibraries(jspCompilationContext.getClassLoader());
        if (jspCompilationContext.getOptions().getLargeFile() && (n = (string = jspCompilationContext.getServletJavaFileName()).lastIndexOf(".java")) > 0) {
            this.dataFile = string.substring(0, n) + ".dat";
        }
    }

    public void beginPageProcessing() throws JasperException {
        int n = 0;
        while (n < Constants.STANDARD_IMPORTS.length) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[n]);
            ++n;
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase == null ? (class$org$apache$jasper$compiler$ServiceMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")) : class$org$apache$jasper$compiler$ServiceMethodPhase);
        this.writer.println();
        this.generateFooter();
        if (this.ctxt.getOptions().getLargeFile()) {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataFile));
                char[][] cArrayArray = new char[this.vector.size()][];
                this.vector.copyInto((Object[])cArrayArray);
                objectOutputStream.writeObject(cArrayArray);
                objectOutputStream.close();
                this.writer.close();
            }
            catch (IOException iOException) {
                throw new JasperException(Constants.getString("jsp.error.data.file.write"), iOException);
            }
        }
        this.ctxt.setContentType(this.servletContentType);
    }

    private Stack getTagHandlerStack() {
        if (this.tagHandlerStack == null) {
            this.tagHandlerStack = new Stack();
        }
        return this.tagHandlerStack;
    }

    private Hashtable getTagVarNumbers() {
        if (this.tagVarNumbers == null) {
            this.tagVarNumbers = new Hashtable();
        }
        return this.tagVarNumbers;
    }

    private void generateAll(Class clazz) throws JasperException {
        int n = 0;
        while (n < this.generators.size()) {
            Generator generator = (Generator)this.generators.elementAt(n);
            if (clazz.isInstance(generator)) {
                generator.generate(this.writer, clazz);
            }
            ++n;
        }
    }

    private void generateHeader() throws JasperException {
        String string = this.ctxt.getServletPackageName();
        String string2 = this.ctxt.getServletClassName();
        if (!"".equals(string) && string != null) {
            this.writer.println("package " + string + ";");
            this.writer.println();
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            this.writer.println("import " + (String)enumeration.nextElement() + ";");
        }
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase == null ? (class$org$apache$jasper$compiler$FileDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")) : class$org$apache$jasper$compiler$FileDeclarationPhase);
        this.writer.println();
        this.writer.print("public class " + string2 + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.println("     implements ");
            int n = 0;
            while (n < this.interfaces.size() - 1) {
                this.writer.println(" " + this.interfaces.elementAt(n) + ",");
                ++n;
            }
            this.writer.println(" " + this.interfaces.elementAt(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase == null ? (class$org$apache$jasper$compiler$ClassDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")) : class$org$apache$jasper$compiler$ClassDeclarationPhase);
        this.writer.println();
        this.writer.println("static {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase == null ? (class$org$apache$jasper$compiler$StaticInitializerPhase = JspParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")) : class$org$apache$jasper$compiler$StaticInitializerPhase);
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public " + string2 + "( ) {");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("private static boolean _jspx_inited = false;");
        this.writer.println();
        this.writer.println("public final void _jspx_init() throws org.apache.jasper.runtime.JspException {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase == null ? (class$org$apache$jasper$compiler$InitMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")) : class$org$apache$jasper$compiler$InitMethodPhase);
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println("String  _value = null;");
        this.writer.println("javax.servlet.jsp.tagext.Tag _jspx_curTag = null;");
        this.writer.println();
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("synchronized (this) {");
        this.writer.pushIndent();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("_jspx_init();");
        this.writer.println("_jspx_inited = true;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        if (this.servletContentType == null) {
            this.servletContentType = this.defaultType + "charset=" + (this.pageEncoding == null ? this.defaultCharset : this.pageEncoding);
        }
        this.writer.println("response.setContentType(" + this.writer.quoteString(this.servletContentType) + ");");
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.writer.println("\t\t\t" + this.writer.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
    }

    private void generateFooter() throws JasperException {
        this.writer.popIndent();
        this.writer.println("} catch (Throwable t) {");
        this.writer.pushIndent();
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.pushIndent();
        this.writer.println("out.clearBuffer();");
        this.writer.popIndent();
        this.writer.println("if (pageContext != null) pageContext.handlePageException(t);");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("_jspx_releaseTags(_jspx_curTag, null);");
        this.writer.println("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.generateReleaseTags();
        this.writer.popIndent();
        this.writer.println("}");
    }

    public void handleComment(Mark mark, Mark mark2, char[] cArray) throws JasperException {
        Constants.message("jsp.message.htmlcomment", new Object[]{cArray}, 4);
    }

    public void handleDirective(String string, Mark mark, Mark mark2, Attributes attributes) throws JasperException {
        String string2;
        Constants.message("jsp.message.handling_directive", new Object[]{string, attributes}, 4);
        if (string.equals("page")) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                string2 = attributes.getQName(n2);
                int n3 = 0;
                while (n3 < this.pdhis.length) {
                    PageDirectiveHandlerInfo pageDirectiveHandlerInfo = this.pdhis[n3];
                    if (string2.equals(pageDirectiveHandlerInfo.attribute)) {
                        String string3 = attributes.getValue(n2);
                        pageDirectiveHandlerInfo.handler.handlePageDirectiveAttribute(this, string3, mark, mark2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new CompileException(mark, Constants.getString("jsp.error.page.bad_b_and_a_combo"));
        }
        if (string.equals("taglib")) {
            String string4 = attributes.getValue("uri");
            string2 = attributes.getValue("prefix");
            this.processTaglibDirective(string4, string2);
            this.xo.addRootNamespaces(string2, string4);
        } else if (string.equals("include")) {
            String string5 = attributes.getValue("file");
            if (string5 == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.include.missing.file"));
            }
            try {
                this.parserCtl.parse(string5);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CompileException(mark, Constants.getString("jsp.error.file.not.found", new Object[]{string5}));
            }
            catch (Exception exception) {
                throw new CompileException(mark, exception.getMessage());
            }
        } else if (!string.equals("include")) {
            this.xo.append("jsp:directive." + string, attributes, true);
        }
    }

    public void handleDeclaration(Mark mark, Mark mark2, Attributes attributes, char[] cArray) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new DeclarationGenerator(cArray), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:declaration", attributes, cArray);
    }

    public void handleScriptlet(Mark mark, Mark mark2, Attributes attributes, char[] cArray) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ScriptletGenerator(cArray), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:scriptlet", attributes, cArray);
    }

    public void handleExpression(Mark mark, Mark mark2, Attributes attributes, char[] cArray) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ExpressionGenerator(cArray), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:expression", attributes, cArray);
    }

    public void handleBean(Mark mark, Mark mark2, Attributes attributes) throws JasperException {
        this.handleBean(mark, mark2, attributes, false);
    }

    public void handleBean(Mark mark, Mark mark2, Attributes attributes, boolean bl) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new BeanGenerator(mark, attributes, this.beanInfo, this.genSessionVariable, bl), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:useBean", attributes, false);
    }

    public void handleBeanEnd(Mark mark, Mark mark2, Attributes attributes) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new BeanEndGenerator(), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:useBean");
    }

    public void handleGetProperty(Mark mark, Mark mark2, Attributes attributes) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new GetPropertyGenerator(mark, mark2, attributes, this.beanInfo), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:getProperty", attributes, true);
    }

    public void handleSetProperty(Mark mark, Mark mark2, Attributes attributes) throws JasperException {
        this.handleSetProperty(mark, mark2, attributes, false);
    }

    public void handleSetProperty(Mark mark, Mark mark2, Attributes attributes, boolean bl) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new SetPropertyGenerator(mark, mark2, attributes, this.beanInfo, bl), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:setProperty", attributes, true);
    }

    public void handlePlugin(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable, String string) throws JasperException {
        this.handlePlugin(mark, mark2, attributes, hashtable, string, false);
    }

    public void handlePlugin(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable, String string, boolean bl) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new PluginGenerator(mark, attributes, hashtable, string, bl), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleForward(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable) throws JasperException {
        this.handleForward(mark, mark2, attributes, hashtable, false);
    }

    public void handleForward(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable, boolean bl) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ForwardGenerator(mark, attributes, hashtable, bl), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:forward", attributes, false);
        this.xo.append("jsp:param", hashtable);
        this.xo.append("jsp:forward");
    }

    public void handleInclude(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable) throws JasperException {
        this.handleInclude(mark, mark2, attributes, hashtable, false);
    }

    public void handleInclude(Mark mark, Mark mark2, Attributes attributes, Hashtable hashtable, boolean bl) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new IncludeGenerator(mark, attributes, hashtable, bl), mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append("jsp:include", attributes, false);
        this.xo.append("jsp:param", hashtable);
        this.xo.append("jsp:include");
    }

    public void handleCharData(Mark mark, Mark mark2, char[] cArray) throws JasperException {
        GeneratorBase generatorBase = this.ctxt.getOptions().getLargeFile() ? new StoredCharDataGenerator(this.vector, this.dataFile, this.stringId++, cArray) : (this.ctxt.getOptions().getMappedFile() ? new MappedCharDataGenerator(cArray) : new CharDataGenerator(cArray));
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(generatorBase, mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleTagBegin(Mark mark, Mark mark2, Attributes attributes, String string, String string2, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo, boolean bl) throws JasperException {
        this.handleTagBegin(mark, mark2, attributes, string, string2, tagLibraryInfo, tagInfo, bl, false);
    }

    public void handleTagBegin(Mark mark, Mark mark2, Attributes attributes, String string, String string2, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo, boolean bl, boolean bl2) throws JasperException {
        TagBeginGenerator tagBeginGenerator = new TagBeginGenerator(mark, string, string2, attributes, tagLibraryInfo, tagInfo, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), bl, bl2);
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(tagBeginGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append(string + ":" + string2, attributes, false);
    }

    public void handleTagEnd(Mark mark, Mark mark2, String string, String string2, Attributes attributes, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo, boolean bl) throws JasperException {
        TagEndGenerator tagEndGenerator = new TagEndGenerator(string, string2, attributes, tagLibraryInfo, tagInfo, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), bl);
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(tagEndGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append(string + ":" + string2);
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    public void handleRootEnd() {
        this.xo.rootEnd();
    }

    public void handleRootBegin(Attributes attributes) throws JasperException {
        boolean bl = false;
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            if (string.startsWith("xmlns:")) {
                String string2 = string.substring(6);
                if (!string2.equals("jsp")) {
                    String string3 = attributes.getValue(n2);
                    if (string3.startsWith("urn:jsptld:")) {
                        string3 = string3.substring(11);
                    }
                    this.processTaglibDirective(string3, string2);
                }
            } else if (string.equals("version")) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            throw new CompileException(Constants.getString("jsp.error.root.noversion"));
        }
        this.xo.addRootAttrs(attributes);
    }

    public void handleUninterpretedTagBegin(Mark mark, Mark mark2, String string, Attributes attributes) throws JasperException {
        UninterpretedTagBeginGenerator uninterpretedTagBeginGenerator = new UninterpretedTagBeginGenerator(string, attributes);
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(uninterpretedTagBeginGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append(string, attributes, false);
    }

    public void handleUninterpretedTagEnd(Mark mark, Mark mark2, String string, char[] cArray) throws JasperException {
        if (cArray != null) {
            this.handleCharData(mark, mark2, cArray);
            this.xo.append(cArray);
        }
        UninterpretedTagEndGenerator uninterpretedTagEndGenerator = new UninterpretedTagEndGenerator(string);
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(uninterpretedTagEndGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
        this.xo.append(string);
    }

    public void handleJspCdata(Mark mark, Mark mark2, char[] cArray) throws JasperException {
        if (cArray != null) {
            this.handleCharData(mark, mark2, cArray);
            this.xo.append("jsp:text", null, cArray);
        }
    }

    public void validate() throws JasperException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.libraries.getTagLibInfos();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            TagLibraryInfo tagLibraryInfo = (TagLibraryInfo)enumeration.nextElement();
            ValidationMessage[] validationMessageArray = ((TagLibraryInfoImpl)tagLibraryInfo).validate(this.xo.getPageData());
            if (validationMessageArray == null || validationMessageArray.length == 0) continue;
            bl = true;
            stringBuffer.append("<h3>");
            stringBuffer.append(Constants.getString("jsp.error.taglibraryvalidator.invalidpage", new Object[]{tagLibraryInfo.getShortName()}));
            stringBuffer.append("</h3>");
            int n = 0;
            while (n < validationMessageArray.length) {
                String string = validationMessageArray[n].getId();
                if (string != null) {
                    stringBuffer.append(validationMessageArray[n].getId());
                    stringBuffer.append(": ");
                }
                stringBuffer.append(validationMessageArray[n].getMessage());
                ++n;
            }
        }
        if (bl) {
            throw new JasperException(stringBuffer.toString());
        }
    }

    private void processTaglibDirective(String string, String string2) throws JasperException {
        TagLibraryInfoImpl tagLibraryInfoImpl = null;
        String[] stringArray = this.ctxt.getTldLocation(string);
        tagLibraryInfoImpl = stringArray == null ? new TagLibraryInfoImpl(this.ctxt, string2, string) : new TagLibraryInfoImpl(this.ctxt, string2, string, stringArray);
        this.libraries.addTagLibrary(string2, tagLibraryInfoImpl);
    }

    private void generateReleaseTags() {
        this.writer.println("private static void _jspx_releaseTags(javax.servlet.jsp.tagext.Tag tag, javax.servlet.jsp.tagext.Tag until) {");
        this.writer.pushIndent();
        this.writer.println("while (tag != until && tag != null) {");
        this.writer.pushIndent();
        this.writer.println("javax.servlet.jsp.tagext.Tag cur = tag;");
        this.writer.println("tag = tag.getParent();");
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println("cur.release();");
        this.writer.popIndent();
        this.writer.println("} catch (Exception e) {}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class GeneratorWrapper
    implements Generator,
    ClassDeclarationPhase,
    FileDeclarationPhase,
    ServiceMethodPhase,
    InitMethodPhase,
    StaticInitializerPhase {
        Generator generator;
        Mark start;
        Mark stop;

        GeneratorWrapper(Generator generator, Mark mark, Mark mark2) {
            this.generator = generator;
            this.start = mark;
            this.stop = mark2;
        }

        public boolean generateCoordinates(Class clazz) {
            return this.generator.generateCoordinates(clazz);
        }

        public void init(JspCompilationContext jspCompilationContext) throws JasperException {
            this.generator.init(jspCompilationContext);
        }

        public void generate(ServletWriter servletWriter, Class clazz) throws JasperException {
            if (clazz.isInstance(this.generator)) {
                boolean bl = this.generator.generateCoordinates(clazz);
                if (bl) {
                    commentGenerator.generateStartComment(this.generator, servletWriter, this.start, this.stop);
                }
                this.generator.generate(servletWriter, clazz);
                if (bl) {
                    commentGenerator.generateEndComment(this.generator, servletWriter, this.start, this.stop);
                }
            }
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.extendsDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.extends"));
            }
            jspParseEventListener.extendsDir = true;
            if (string != null) {
                jspParseEventListener.extendsClass = string;
                if (string.indexOf(".") == -1) {
                    jspParseEventListener.imports.addElement(string);
                }
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    jspParseEventListener.imports.addElement(stringTokenizer.nextToken());
                }
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.languageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.language"));
            }
            jspParseEventListener.languageDir = true;
            if (string != null && !string.equalsIgnoreCase("java")) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.nomapping.language") + string);
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.errorpageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.errorpage"));
            }
            jspParseEventListener.errorpageDir = true;
            if (string != null) {
                jspParseEventListener.error = string;
            }
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.iserrorpageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.iserrorpage"));
            }
            jspParseEventListener.iserrorpageDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.ctxt.setErrorPage(true);
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.ctxt.setErrorPage(false);
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.infoDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.info"));
            }
            jspParseEventListener.infoDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.info"));
            }
            JspParseEventListener jspParseEventListener2 = jspParseEventListener;
            jspParseEventListener2.getClass();
            GeneratorWrapper generatorWrapper = jspParseEventListener2.new GeneratorWrapper(new InfoGenerator(string), mark, mark2);
            jspParseEventListener.addGenerator(generatorWrapper);
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.threadsafeDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.threadsafe"));
            }
            jspParseEventListener.threadsafeDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.singleThreaded = false;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.singleThreaded = true;
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.autoFlushDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.autoflush"));
            }
            jspParseEventListener.autoFlushDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.autoFlush = true;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.autoFlush = false;
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.bufferDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.buffer"));
            }
            jspParseEventListener.bufferDir = true;
            if (string != null) {
                if (string.equalsIgnoreCase("none")) {
                    jspParseEventListener.bufferSize = 0;
                } else {
                    Integer n = null;
                    try {
                        int n2 = string.indexOf("k");
                        String string2 = n2 == -1 ? string : string.substring(0, n2);
                        n = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.buffer"));
                    }
                    jspParseEventListener.bufferSize = n * 1024;
                }
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.sessionDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.session"));
            }
            jspParseEventListener.sessionDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.session"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.genSessionVariable = true;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.genSessionVariable = false;
            } else {
                throw new CompileException(mark, "Invalid value for session");
            }
        }
    }

    static final class PageEncodingHandler
    implements PageDirectiveHandler {
        PageEncodingHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.pageencoding"));
            }
            jspParseEventListener.pageEncoding = string;
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.contentTypeDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.contenttypes"));
            }
            jspParseEventListener.contentTypeDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.contenttype"));
            }
            jspParseEventListener.servletContentType = string;
        }
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String string, PageDirectiveHandler pageDirectiveHandler) {
            this.attribute = string;
            this.handler = pageDirectiveHandler;
        }
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(JspParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }
}

