/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

public class JNDIRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected DirContext context = null;
    protected String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected static final String info = "org.apache.catalina.realm.JNDIRealm/1.0";
    protected static final String name = "JNDIRealm";
    protected String roleBase = "";
    protected MessageFormat roleFormat = null;
    protected String[] roleName = null;
    protected String roleSearch = null;
    protected boolean roleSubtree = false;
    protected MessageFormat userFormat = null;
    protected String[] userPassword = null;
    protected String userPattern = null;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String string) {
        this.roleBase = string;
    }

    public String getRoleName() {
        if (this.roleName != null) {
            return this.roleName[0];
        }
        return null;
    }

    public void setRoleName(String string) {
        this.roleName = string != null ? new String[]{string} : null;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public void setRoleSearch(String string) {
        this.roleSearch = string;
        this.roleFormat = string == null ? null : new MessageFormat(string);
    }

    public boolean getRoleSubtree() {
        return this.roleSubtree;
    }

    public void setRoleSubtree(boolean bl) {
        this.roleSubtree = bl;
    }

    public String getUserPassword() {
        if (this.userPassword != null) {
            return this.userPassword[0];
        }
        return null;
    }

    public void setUserPassword(String string) {
        this.userPassword = string != null ? new String[]{string} : null;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    public void setUserPattern(String string) {
        this.userPattern = string;
        this.userFormat = string == null ? null : new MessageFormat(string);
    }

    public Principal authenticate(String string, String string2) {
        DirContext dirContext = null;
        try {
            dirContext = this.open();
            Principal principal = this.authenticate(dirContext, string, string2);
            this.release(dirContext);
            return principal;
        }
        catch (NamingException namingException) {
            this.log(RealmBase.sm.getString("jndiRealm.exception"), namingException);
            if (dirContext != null) {
                this.close(dirContext);
            }
            return null;
        }
    }

    public synchronized Principal authenticate(DirContext dirContext, String string, String string2) throws NamingException {
        String string3 = this.getUserDN(dirContext, string, string2);
        if (string3 == null) {
            return null;
        }
        List list = this.getRoles(dirContext, string, string3);
        return new GenericPrincipal(this, string, string2, list);
    }

    protected void close(DirContext dirContext) {
        if (dirContext == null) {
            return;
        }
        try {
            if (this.debug >= 1) {
                this.log("Closing directory context");
            }
            dirContext.close();
        }
        catch (NamingException namingException) {
            this.log(RealmBase.sm.getString("jndiRealm.close"), namingException);
        }
        this.context = null;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String string) {
        return null;
    }

    protected Principal getPrincipal(String string) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected List getRoles(DirContext var1_1, String var2_2, String var3_3) throws NamingException {
        if (this.debug >= 2) {
            this.log("getRoles(" + var3_3 + ")");
        }
        var4_4 = new ArrayList<String>();
        if (this.roleFormat == null || this.roleName == null) {
            return var4_4;
        }
        var5_5 = this.roleFormat.format(new String[]{var3_3, var2_2});
        var6_6 = new SearchControls();
        if (this.roleSubtree) {
            var6_6.setSearchScope(2);
        } else {
            var6_6.setSearchScope(1);
        }
        var6_6.setReturningAttributes(this.roleName);
        if (this.debug >= 3) {
            this.log("  Searching role base '" + this.roleBase + "' for attribute '" + this.roleName[0] + "'");
            this.log("  With filter expression '" + var5_5 + "'");
        }
        if ((var7_7 = var1_1.search(this.roleBase, var5_5, var6_6)) != null) ** GOTO lbl26
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var8_8 = var7_7.next();
            var9_9 = var8_8.getAttributes();
            if (var9_9 == null || (var10_10 = var9_9.get(this.roleName[0])) == null) continue;
            var11_11 = (String)var10_10.get();
            if (this.debug >= 3) {
                this.log("  Found role '" + var11_11 + "'");
            }
            var4_4.add(var11_11);
lbl26:
            // 3 sources

            ** while (var7_7.hasMore())
        }
lbl27:
        // 1 sources

        if (this.debug >= 2) {
            this.log("  Returning " + var4_4.size() + " roles");
        }
        return var4_4;
    }

    protected String getUserDN(DirContext dirContext, String string, String string2) throws NamingException {
        Object object;
        Attribute attribute;
        if (this.debug >= 2) {
            this.log("getUserDN(" + string + ")");
        }
        if (string == null) {
            return null;
        }
        if (this.userFormat == null || this.userPassword == null) {
            return null;
        }
        String string3 = this.userFormat.format(new String[]{string});
        if (this.debug >= 3) {
            this.log("  dn=" + string3);
        }
        Attributes attributes = null;
        try {
            attributes = dirContext.getAttributes(string3, this.userPassword);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        if (attributes == null) {
            return null;
        }
        if (this.debug >= 3) {
            this.log("  retrieving attribute " + this.userPassword[0]);
        }
        if ((attribute = attributes.get(this.userPassword[0])) == null) {
            return null;
        }
        if (this.debug >= 3) {
            this.log("  retrieving value");
        }
        if ((object = attribute.get()) == null) {
            return null;
        }
        String string4 = null;
        string4 = object instanceof byte[] ? new String((byte[])object) : object.toString();
        if (this.debug >= 3) {
            this.log("  validating credentials");
        }
        boolean bl = false;
        bl = this.hasMessageDigest() ? this.digest(string2).equalsIgnoreCase(string4) : this.digest(string2).equals(string4);
        if (bl) {
            if (this.debug >= 2) {
                this.log(RealmBase.sm.getString("jndiRealm.authenticateSuccess", string));
            }
        } else {
            if (this.debug >= 2) {
                this.log(RealmBase.sm.getString("jndiRealm.authenticateFailure", string));
            }
            return null;
        }
        return string3;
    }

    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        if (this.debug >= 1) {
            this.log("Connecting to URL " + this.connectionURL);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            hashtable.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            hashtable.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null) {
            hashtable.put("java.naming.provider.url", this.connectionURL);
        }
        this.context = new InitialDirContext(hashtable);
        return this.context;
    }

    protected void release(DirContext dirContext) {
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (NamingException namingException) {
            throw new LifecycleException(RealmBase.sm.getString("jndiRealm.open"), namingException);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.context);
    }
}

