/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected static final String info = "org.apache.catalina.realm.JDBCRealm/1.0";
    protected static final String name = "JDBCRealm";
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    public Principal authenticate(String string, String string2) {
        Connection connection = null;
        try {
            connection = this.open();
            Principal principal = this.authenticate(connection, string, string2);
            this.release(connection);
            return principal;
        }
        catch (SQLException sQLException) {
            this.log(sm.getString("jdbcRealm.exception"), sQLException);
            if (connection != null) {
                this.close(connection);
            }
            return null;
        }
    }

    public synchronized Principal authenticate(Connection connection, String string, String string2) throws SQLException {
        String string3 = null;
        PreparedStatement preparedStatement = this.credentials(connection, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string3 = resultSet.getString(1).trim();
        }
        resultSet.close();
        if (string3 == null) {
            return null;
        }
        boolean bl = false;
        bl = this.hasMessageDigest() ? this.digest(string2).equalsIgnoreCase(string3) : this.digest(string2).equals(string3);
        if (bl) {
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateSuccess", string));
            }
        } else {
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateFailure", string));
            }
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        preparedStatement = this.roles(connection, string);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1).trim());
        }
        resultSet.close();
        connection.commit();
        return new GenericPrincipal(this, string, string2, arrayList);
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.preparedRoles.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.log(sm.getString("jdbcRealm.close"), sQLException);
        }
        this.dbConnection = null;
        this.preparedCredentials = null;
        this.preparedRoles = null;
    }

    protected PreparedStatement credentials(Connection connection, String string) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            stringBuffer.append(this.userCredCol);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this.userTable);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.userNameCol);
            stringBuffer.append(" = ?");
            this.preparedCredentials = connection.prepareStatement(stringBuffer.toString());
        }
        this.preparedCredentials.setString(1, string);
        return this.preparedCredentials;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String string) {
        return null;
    }

    protected Principal getPrincipal(String string) {
        return null;
    }

    protected Connection open() throws SQLException {
        Serializable serializable;
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                serializable = Class.forName(this.driverName);
                this.driver = (Driver)((Class)serializable).newInstance();
            }
            catch (Throwable throwable) {
                throw new SQLException(throwable.getMessage());
            }
        }
        serializable = new Properties();
        if (this.connectionName != null) {
            ((Properties)serializable).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Properties)serializable).put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, (Properties)serializable);
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected void release(Connection connection) {
    }

    protected PreparedStatement roles(Connection connection, String string) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            stringBuffer.append(this.roleNameCol);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this.userRoleTable);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.userNameCol);
            stringBuffer.append(" = ?");
            this.preparedRoles = connection.prepareStatement(stringBuffer.toString());
        }
        this.preparedRoles.setString(1, string);
        return this.preparedRoles;
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException sQLException) {
            throw new LifecycleException(sm.getString("jdbcRealm.open"), sQLException);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.dbConnection);
    }
}

