/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http10;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Stack;
import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.connector.http10.HttpProcessor;
import org.apache.catalina.connector.http10.HttpRequestImpl;
import org.apache.catalina.connector.http10.HttpResponseImpl;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class HttpConnector
implements Connector,
Lifecycle,
Runnable {
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.catalina.connector.http10.HttpConnector/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int connectionTimeout = 30000;
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int port = 8080;
    private Stack processors = new Stack();
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String scheme = "http";
    private boolean secure = false;
    private ServerSocket serverSocket = null;
    private Service service = null;
    private StringManager sm = StringManager.getManager("org.apache.catalina.connector.http10");
    private boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int n) {
        this.acceptCount = n;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean bl) {
        this.enableLookups = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public void setFactory(ServerSocketFactory serverSocketFactory) {
        this.factory = serverSocketFactory;
    }

    public String getInfo() {
        return info;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int n) {
        this.minProcessors = n;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int n) {
        this.maxProcessors = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String string) {
        this.proxyName = string;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int n) {
        this.redirectPort = n;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Request createRequest() {
        HttpRequestImpl httpRequestImpl = new HttpRequestImpl();
        httpRequestImpl.setConnector(this);
        return httpRequestImpl;
    }

    public Response createResponse() {
        HttpResponseImpl httpResponseImpl = new HttpResponseImpl();
        httpResponseImpl.setConnector(this);
        return httpResponseImpl;
    }

    void recycle(HttpProcessor httpProcessor) {
        this.processors.push(httpProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpProcessor createProcessor() {
        Stack stack = this.processors;
        synchronized (stack) {
            if (this.processors.size() > 0) {
                return (HttpProcessor)this.processors.pop();
            }
            if (this.maxProcessors > 0 && this.curProcessors < this.maxProcessors) {
                return this.newProcessor();
            }
            if (this.maxProcessors < 0) {
                return this.newProcessor();
            }
            return null;
        }
    }

    private void log(String string) {
        Logger logger = this.container.getLogger();
        String string2 = this.threadName;
        if (string2 == null) {
            string2 = "HttpConnector";
        }
        if (logger != null) {
            logger.log(string2 + " " + string);
        } else {
            System.out.println(string2 + " " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this.container.getLogger();
        String string2 = this.threadName;
        if (string2 == null) {
            string2 = "HttpConnector";
        }
        if (logger != null) {
            logger.log(string2 + " " + string, throwable);
        } else {
            System.out.println(string2 + " " + string);
            throwable.printStackTrace(System.out);
        }
    }

    private HttpProcessor newProcessor() {
        HttpProcessor httpProcessor;
        if ((httpProcessor = new HttpProcessor(this, this.curProcessors++)) instanceof Lifecycle) {
            try {
                httpProcessor.start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("newProcessor", lifecycleException);
                return null;
            }
        }
        this.created.addElement(httpProcessor);
        return httpProcessor;
    }

    private ServerSocket open() throws IOException {
        ServerSocketFactory serverSocketFactory = this.getFactory();
        if (this.address == null) {
            this.log(this.sm.getString("httpConnector.allAddresses"));
            return serverSocketFactory.createSocket(this.port, this.acceptCount);
        }
        InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        int n = 0;
        while (n < inetAddressArray.length) {
            if (inetAddressArray[n].getHostAddress().equals(this.address)) break;
            ++n;
        }
        if (n < inetAddressArray.length) {
            this.log(this.sm.getString("httpConnector.anAddress", this.address));
            return serverSocketFactory.createSocket(this.port, this.acceptCount, inetAddressArray[n]);
        }
        this.log(this.sm.getString("httpConnector.noAddress", this.address));
        return serverSocketFactory.createSocket(this.port, this.acceptCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (!this.stopped) {
            block10: {
                object = null;
                try {
                    object = this.serverSocket.accept();
                    if (this.connectionTimeout <= 0) break block10;
                    ((Socket)object).setSoTimeout(this.connectionTimeout);
                }
                catch (AccessControlException accessControlException) {
                    this.log("socket accept security exception: " + accessControlException.getMessage());
                    continue;
                }
                catch (IOException iOException) {
                    if (!this.started || this.stopped) break;
                    this.log("accept: ", iOException);
                    break;
                }
            }
            HttpProcessor httpProcessor = this.createProcessor();
            if (httpProcessor == null) {
                try {
                    this.log(this.sm.getString("httpConnector.noProcessor"));
                    ((Socket)object).close();
                }
                catch (IOException iOException) {}
                continue;
            }
            httpProcessor.assign((Socket)object);
        }
        object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.log(this.sm.getString("httpConnector.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStop() {
        this.log(this.sm.getString("httpConnector.stopping"));
        this.stopped = true;
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(this.sm.getString("httpConnector.alreadyInitialized"));
        }
        this.initialized = true;
        try {
            this.serverSocket = this.open();
        }
        catch (IOException iOException) {
            throw new LifecycleException(this.threadName + ".open", iOException);
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.alreadyStarted"));
        }
        this.threadName = "HttpConnector[" + this.port + "]";
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
        while (this.curProcessors < this.minProcessors) {
            if (this.maxProcessors > 0 && this.curProcessors >= this.maxProcessors) break;
            HttpProcessor httpProcessor = this.newProcessor();
            this.recycle(httpProcessor);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int n = this.created.size() - 1;
        while (n >= 0) {
            HttpProcessor httpProcessor = (HttpProcessor)this.created.elementAt(n);
            if (httpProcessor instanceof Lifecycle) {
                try {
                    httpProcessor.stop();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("HttpConnector.stop", lifecycleException);
                }
            }
            --n;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        this.threadStop();
    }
}

