/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.CoordinatorResourceImpl;
import com.sun.jts.CosTransactions.CoordinatorSynchronizationImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.NestingInfo;
import com.sun.jts.CosTransactions.RecoveryCoordinatorImpl;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RegisteredResources;
import com.sun.jts.CosTransactions.RegisteredSyncs;
import com.sun.jts.CosTransactions.SubCoordinator;
import com.sun.jts.CosTransactions.SuperiorInfo;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TransactionState;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.otsidl.JCoordinator;
import com.sun.jts.otsidl.JCoordinatorHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

public class TopCoordinator
extends CoordinatorImpl {
    String name = null;
    RegisteredResources participants = null;
    RegisteredSyncs synchronizations = null;
    SuperiorInfo superInfo = null;
    NestingInfo nestingInfo = null;
    TransactionState tranState = null;
    CoordinatorLog logRecord = null;
    CompletionHandler terminator = null;
    boolean registered = false;
    boolean registeredSync = false;
    boolean root = true;
    boolean rollbackOnly = false;
    boolean dying = false;
    boolean temporary = false;
    int hash = 0;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    Vector recoveryCoordinatorList = null;
    CoordinatorSynchronizationImpl coordSyncImpl = null;
    static String[] resultName = new String[]{"Commit", "Rollback", "Read-only"};
    private static Any emptyData = null;

    TopCoordinator() {
    }

    TopCoordinator(int n) throws LogicErrorException {
        this.logRecord = Configuration.isRecoverable() ? CoordinatorLogPool.getCoordinatorLog() : null;
        this.tranState = new TransactionState(this.logRecord);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, null, this.logRecord);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = null;
        this.participants = null;
        this.synchronizations = null;
        this.root = true;
        this.registered = true;
        this.registeredSync = true;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw logicErrorException;
        }
        if (!RecoveryManager.addCoordinator(this.tranState.globalTID, this.tranState.localTID, this, n)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw logicErrorException;
        }
    }

    TopCoordinator(int n, GlobalTID globalTID, Coordinator coordinator, boolean bl) throws LogicErrorException {
        this.logRecord = Configuration.isRecoverable() ? CoordinatorLogPool.getCoordinatorLog() : null;
        this.tranState = new TransactionState(globalTID, this.logRecord);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, coordinator, this.logRecord);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = null;
        this.participants = null;
        this.synchronizations = null;
        this.root = false;
        this.registered = false;
        this.registeredSync = false;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = bl;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw logicErrorException;
        }
        if (!RecoveryManager.addCoordinator(globalTID, this.tranState.localTID, this, n)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw logicErrorException;
        }
    }

    public synchronized void finalize() {
        this.dying = true;
        int n = 9;
        if (this.tranState != null && !this.temporary) {
            n = this.tranState.state;
        }
        switch (n) {
            case 1: {
                try {
                    this.rollback(true);
                }
                catch (Throwable throwable) {}
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                if (this.tranState != null) {
                    this.tranState.finalize();
                }
                if (this.superInfo != null) {
                    this.superInfo.finalize();
                }
                if (this.nestingInfo != null) {
                    this.nestingInfo.finalize();
                }
                if (this.participants != null) {
                    this.participants.finalize();
                }
                if (this.synchronizations != null) {
                    this.synchronizations.finalize();
                }
                this.tranState = null;
                this.superInfo = null;
                this.nestingInfo = null;
                this.participants = null;
                this.synchronizations = null;
                this.logRecord = null;
                this.terminator = null;
                this.name = null;
                break;
            }
        }
    }

    synchronized void reconstruct(CoordinatorLog coordinatorLog) {
        this.rollbackOnly = false;
        this.registered = false;
        this.registeredSync = false;
        this.root = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        this.logRecord = coordinatorLog;
        this.name = null;
        this.nestingInfo = null;
        this.synchronizations = null;
        this.tranState = new TransactionState();
        int n = this.tranState.reconstruct(coordinatorLog);
        if (n == 0 || n == 7 || n == 11 || n == 12 || n == 9) {
            CoordinatorLog.removeLog(coordinatorLog.localTID);
            this.destroy();
        } else {
            this.participants = new RegisteredResources();
            this.participants.reconstruct(coordinatorLog);
            this.superInfo = new SuperiorInfo();
            this.superInfo.reconstruct(coordinatorLog, this);
            this.name = this.superInfo.globalTID.toString();
            this.hash = this.superInfo.globalTID.hashCode();
        }
    }

    synchronized Status recover(boolean[] blArray) {
        Status status;
        if (this.superInfo.recovery != null) {
            switch (this.tranState.state) {
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: {
                    status = Status.StatusCommitted;
                    break;
                }
                case 8: 
                case 9: {
                    status = Status.StatusRolledBack;
                    break;
                }
                default: {
                    boolean bl = true;
                    int n = 0;
                    String string = Configuration.getPropertyValue("com.sun.jts.commitRetry");
                    if (string != null) {
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.superInfo.resyncRetries() >= n) {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        boolean bl2 = false;
                        status = Status.StatusRolledBack;
                        String string2 = Configuration.getPropertyValue("com.sun.jts.heuristicDirection");
                        if (string2 != null) {
                            boolean bl3 = bl2 = string2.charAt(0) == '1';
                        }
                        if (!bl2) break;
                        status = Status.StatusCommitted;
                        break;
                    }
                    try {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "TopCoordinator", "recover", "Before invoking replay_completion on Superior Coordinator");
                        }
                        if ((status = this.superInfo.recovery.replay_completion(this.superInfo.resource)) != Status.StatusCommitting) break;
                        status = Status.StatusCommitted;
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof COMM_FAILURE) && !(throwable instanceof TRANSIENT)) {
                            status = Status.StatusRolledBack;
                            break;
                        }
                        status = Status.StatusUnknown;
                    }
                    break;
                }
            }
            this.root = false;
        } else {
            status = this.tranState.state == 3 ? Status.StatusCommitted : Status.StatusRolledBack;
            this.root = true;
        }
        blArray[0] = this.root;
        return status;
    }

    public Status get_status() {
        Status status = Status.StatusUnknown;
        if (this.tranState != null) {
            switch (this.tranState.state) {
                case 1: {
                    if (this.rollbackOnly) {
                        status = Status.StatusMarkedRollback;
                        break;
                    }
                    status = Status.StatusActive;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    status = Status.StatusPrepared;
                    break;
                }
                case 0: {
                    status = Status.StatusNoTransaction;
                    break;
                }
                case 2: 
                case 10: {
                    status = Status.StatusPreparing;
                    break;
                }
                case 6: {
                    status = Status.StatusCommitting;
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 14: {
                    status = Status.StatusCommitted;
                    break;
                }
                case 8: 
                case 12: {
                    status = Status.StatusRollingBack;
                    break;
                }
                case 9: {
                    status = Status.StatusRolledBack;
                    break;
                }
                default: {
                    status = Status.StatusUnknown;
                    break;
                }
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return status;
    }

    public Status get_parent_status() {
        Status status = this.get_status();
        return status;
    }

    public Status get_top_level_status() {
        Status status = this.get_status();
        return status;
    }

    public boolean is_same_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = this.name.equals(coordinator.get_transaction_name());
        return bl;
    }

    public boolean is_related_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = coordinator.is_descendant_transaction(this.object());
        return bl;
    }

    public boolean is_root_transaction() {
        boolean bl = this.root;
        return bl;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = coordinator.is_descendant_transaction(this.object());
        return bl;
    }

    public boolean is_descendant_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = this.is_same_transaction(coordinator);
        return bl;
    }

    public boolean is_top_level_transaction() {
        boolean bl = true;
        return bl;
    }

    public int hash_transaction() {
        int n = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return n;
    }

    public synchronized int hash_top_level_tran() {
        int n = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return n;
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws Inactive, TRANSACTION_ROLLEDBACK {
        java.lang.Object object;
        RecoveryCoordinator recoveryCoordinator = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        if (!this.registered) {
            CoordinatorResourceImpl coordinatorResourceImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, false);
            try {
                object = coordinatorResourceImpl.object();
                RecoveryCoordinator recoveryCoordinator2 = this.superInfo.superior.register_resource((Resource)object);
                this.superInfo.setRecovery(recoveryCoordinator2);
                this.superInfo.setResource((SubtransactionAwareResource)object);
                this.registered = true;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "TopCoordinator", "register_resource()", "CoordinatorResource " + coordinatorResourceImpl + " has been registered with (Root)TopCoordinator" + this.superInfo.globalTID.toString());
                }
            }
            catch (Exception exception) {
                coordinatorResourceImpl.destroy();
                if (exception instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    throw tRANSACTION_ROLLEDBACK;
                }
                if (exception instanceof Inactive) {
                    throw (Inactive)exception;
                }
                if (exception instanceof SystemException) {
                    throw (SystemException)exception;
                }
                INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                throw iNTERNAL;
            }
        }
        if (this.participants == null) {
            this.participants = new RegisteredResources(this.logRecord);
        }
        int n = 0;
        if (resource instanceof OTSResourceImpl) {
            n = this.participants.addRes(resource);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.logp(Level.FINEST, "TopCoordinator", "register_resource()", "OTSResource " + resource + " has been registered" + "GTID is:" + this.superInfo.globalTID.toString());
            }
        } else {
            n = this.participants.addRes((Resource)resource._duplicate());
        }
        this.temporary = false;
        if (!(resource instanceof OTSResourceImpl)) {
            object = null;
            try {
                object = new RecoveryCoordinatorImpl(this.superInfo.globalTID, n);
                recoveryCoordinator = ((RecoveryCoordinatorImpl)object).object();
            }
            catch (Exception exception) {
                INTERNAL iNTERNAL = new INTERNAL(264, CompletionStatus.COMPLETED_NO);
                throw iNTERNAL;
            }
            if (this.recoveryCoordinatorList == null) {
                this.recoveryCoordinatorList = new Vector();
            }
            this.recoveryCoordinatorList.add(object);
        }
        return recoveryCoordinator;
    }

    public synchronized void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws NotSubtransaction {
        NotSubtransaction notSubtransaction = new NotSubtransaction();
        throw notSubtransaction;
    }

    public void rollback_only() throws Inactive {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        this.rollbackOnly = true;
    }

    public String get_transaction_name() {
        String string = null;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        string = new String(this.name);
        return string;
    }

    public synchronized Control create_subtransaction() throws Inactive {
        Control control = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        CoordinatorImpl[] coordinatorImplArray = new CoordinatorImpl[]{this};
        SubCoordinator subCoordinator = null;
        TerminatorImpl terminatorImpl = null;
        try {
            subCoordinator = new SubCoordinator(this.superInfo.globalTID, this.superInfo.localTID, coordinatorImplArray);
            terminatorImpl = new TerminatorImpl(subCoordinator, true);
            control = new ControlImpl(terminatorImpl, subCoordinator, new GlobalTID(subCoordinator.getGlobalTID()), new Long(subCoordinator.getLocalTID())).object();
        }
        catch (Throwable throwable) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        this.nestingInfo.addChild(subCoordinator);
        return control;
    }

    public otid_t getGlobalTID() {
        otid_t otid_t2 = this.superInfo.globalTID.realTID;
        return otid_t2;
    }

    public long getLocalTID() {
        long l = this.superInfo.localTID;
        return l;
    }

    synchronized CoordinatorImpl replyAction(int[] nArray) throws SystemException {
        CoordinatorImpl coordinatorImpl = null;
        nArray[0] = 1;
        if (!this.root && this.nestingInfo != null && this.nestingInfo.replyCheck()) {
            nArray[0] = 3;
        } else {
            if (!this.registered) {
                if (this.participants != null && this.participants.involved()) {
                    INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw iNTERNAL;
                }
                if (!this.registeredSync) {
                    nArray[0] = 2;
                }
            }
            if (!this.registeredSync) {
                if (this.synchronizations != null && this.synchronizations.involved()) {
                    INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw iNTERNAL;
                }
                if (nArray[0] == 1 && !this.registered) {
                    nArray[0] = 2;
                }
            }
        }
        coordinatorImpl = null;
        return coordinatorImpl;
    }

    synchronized Long setPermanent() {
        Long l = this.superInfo.localTID;
        this.temporary = false;
        return l;
    }

    public synchronized boolean isRollbackOnly() {
        boolean bl = this.rollbackOnly;
        return bl;
    }

    synchronized boolean isActive() {
        boolean bl = this.tranState.state == 1;
        return bl;
    }

    synchronized boolean hasRegistered() {
        boolean bl = this.registered || this.registeredSync;
        return bl;
    }

    public synchronized TransIdentity[] getAncestors() {
        return null;
    }

    synchronized boolean addChild(CoordinatorImpl coordinatorImpl) {
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        boolean bl = this.nestingInfo.addChild(coordinatorImpl);
        return bl;
    }

    synchronized boolean removeChild(CoordinatorImpl coordinatorImpl) {
        boolean bl = false;
        if (this.nestingInfo != null) {
            bl = this.nestingInfo.removeChild(coordinatorImpl);
        }
        if (!(!this.temporary || this.registered || this.participants != null && this.participants.involved() || this.synchronizations != null && this.synchronizations.involved() || this.nestingInfo != null && this.nestingInfo.numChildren() > 0)) {
            this.cleanUpEmpty(null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vote prepare() throws INVALID_TRANSACTION, HeuristicMixed, HeuristicHazard {
        Vote vote = Vote.VoteRollback;
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
                INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
                throw iNVALID_TRANSACTION;
            }
            if (!this.tranState.setState(2)) {
                return Vote.VoteRollback;
            }
            if (this.rollbackOnly) {
                if (!this.tranState.setState(4)) {
                    // empty if block
                }
                return Vote.VoteRollback;
            }
        }
        Vote vote2 = Vote.VoteReadOnly;
        java.lang.Object var4_6 = null;
        if (this.participants != null) {
            try {
                vote2 = this.participants.distributePrepare();
            }
            catch (Throwable throwable) {
                if (throwable instanceof HeuristicMixed || throwable instanceof HeuristicHazard) {
                    if (!this.tranState.setState(9)) {
                        // empty if block
                    }
                    if (!this.root) {
                        this.afterCompletion(Status.StatusRolledBack);
                    }
                    if (var4_6 instanceof HeuristicMixed) {
                        throw (HeuristicMixed)var4_6;
                    }
                    throw (HeuristicHazard)var4_6;
                }
                vote2 = Vote.VoteRollback;
            }
        }
        TopCoordinator topCoordinator2 = this;
        synchronized (topCoordinator2) {
            if (this.rollbackOnly) {
                vote2 = Vote.VoteRollback;
            }
            if (vote2 == Vote.VoteReadOnly) {
                if (!this.tranState.setState(5)) {
                    vote2 = Vote.VoteRollback;
                }
                if (!this.root) {
                    this.afterCompletion(Status.StatusUnknown);
                }
            } else if (vote2 == Vote.VoteCommit) {
                int n = 0;
                if (!this.root) {
                    n = 2;
                }
                TimeoutManager.setTimeout(this.superInfo.localTID, n, 60);
                if (!this.tranState.setState(3)) {
                    vote2 = Vote.VoteRollback;
                }
            } else if (!this.tranState.setState(4)) {
                vote2 = Vote.VoteRollback;
            }
        }
        return vote2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws HeuristicMixed, HeuristicHazard, NotPrepared {
        Throwable throwable;
        block19: {
            TopCoordinator topCoordinator = this;
            synchronized (topCoordinator) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "TopCoordinator", "commit()", "Within TopCoordinator.commit()GTID is :" + this.superInfo.globalTID.toString());
                }
                if (this.tranState.state == 5) {
                    return;
                }
                if (this.tranState.state == 7) {
                    return;
                }
                if (!this.tranState.setState(6)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                    throw new INTERNAL(string);
                }
            }
            throwable = null;
            if (this.participants != null) {
                try {
                    this.participants.distributeCommit();
                }
                catch (Throwable throwable2) {
                    if (throwable2 instanceof HeuristicMixed || throwable2 instanceof HeuristicHazard) {
                        throwable = throwable2;
                    }
                    if (!(throwable2 instanceof INTERNAL)) break block19;
                    throw (INTERNAL)throwable2;
                }
            }
        }
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (!this.tranState.setState(7)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(string);
            }
            if (this.terminator != null) {
                this.terminator.setCompleted(false, throwable != null);
            }
            if (!this.root) {
                this.afterCompletion(Status.StatusCommitted);
            }
            if (throwable != null) {
                if (throwable instanceof HeuristicMixed) {
                    throw (HeuristicMixed)throwable;
                }
                throw (HeuristicHazard)throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean bl) throws HeuristicMixed, HeuristicHazard {
        Throwable throwable;
        block22: {
            TopCoordinator topCoordinator = this;
            synchronized (topCoordinator) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "TopCoordinator", "rollback()", "Within TopCoordinator.rollback() :GTID is : " + this.superInfo.globalTID.toString());
                }
                if (this.tranState == null) {
                    return;
                }
                if (this.tranState.state == 9) {
                    return;
                }
                if (this.tranState.state == 7) {
                    return;
                }
                if (!(bl || this.tranState.state != 3 && this.tranState.setState(8))) {
                    return;
                }
                if (this.temporary || !this.tranState.setState(8)) {
                    // empty if block
                }
                if (this.nestingInfo != null) {
                    this.nestingInfo.rollbackFamily();
                }
            }
            throwable = null;
            if (this.participants != null) {
                try {
                    this.participants.distributeRollback(false);
                }
                catch (Throwable throwable2) {
                    if (throwable2 instanceof HeuristicMixed || throwable2 instanceof HeuristicHazard) {
                        throwable = throwable2;
                    }
                    if (!(throwable2 instanceof INTERNAL)) break block22;
                    throw (INTERNAL)throwable2;
                }
            }
        }
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.temporary || !this.tranState.setState(9)) {
                // empty if block
            }
            if (this.terminator != null) {
                this.terminator.setCompleted(true, throwable != null);
            }
            if (!this.root) {
                this.afterCompletion(Status.StatusRolledBack);
            }
            if (throwable != null) {
                if (throwable instanceof HeuristicMixed) {
                    throw (HeuristicMixed)throwable;
                }
                throw (HeuristicHazard)throwable;
            }
        }
    }

    public synchronized void register_synchronization(Synchronization synchronization) throws SystemException, Inactive, SynchronizationUnavailable {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        if (!this.registeredSync) {
            CoordinatorSynchronizationImpl coordinatorSynchronizationImpl = new CoordinatorSynchronizationImpl(this);
            try {
                Synchronization synchronization2 = coordinatorSynchronizationImpl.object();
                this.superInfo.superior.register_synchronization(synchronization2);
                this.registeredSync = true;
                this.coordSyncImpl = coordinatorSynchronizationImpl;
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "TopCoordinator", "register_synchronization()", "CoordinatorSynchronizationImpl :" + coordinatorSynchronizationImpl + " has been registered with (Root)TopCoordinator" + "GTID is: " + this.superInfo.globalTID.toString());
                }
            }
            catch (Exception exception) {
                coordinatorSynchronizationImpl.destroy();
                if (exception instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    throw tRANSACTION_ROLLEDBACK;
                }
                if (exception instanceof Inactive) {
                    throw (Inactive)exception;
                }
                if (exception instanceof SystemException) {
                    throw (SystemException)exception;
                }
                INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                throw iNTERNAL;
            }
        }
        if (this.synchronizations == null) {
            this.synchronizations = new RegisteredSyncs();
        }
        if (synchronization instanceof SynchronizationImpl) {
            this.synchronizations.addSync(synchronization);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.logp(Level.FINER, "TopCoordinator", "register_synchronization()", "SynchronizationImpl :" + synchronization + " has been registeredwith TopCoordinator :" + "GTID is : " + this.superInfo.globalTID.toString().toString());
            }
        } else {
            this.synchronizations.addSync((Synchronization)synchronization._duplicate());
        }
        this.temporary = false;
    }

    synchronized void beforeCompletion() throws INVALID_TRANSACTION {
        if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        if (this.synchronizations != null && !this.synchronizations.distributeBefore()) {
            this.rollbackOnly = true;
        }
    }

    synchronized void afterCompletion(Status status) {
        if (this.tranState.state == 1) {
            this.tranState.setState(2);
            this.tranState.setState(5);
        }
        if (this.synchronizations != null) {
            this.synchronizations.distributeAfter(this.get_status());
        }
        boolean bl = true;
        if (status == Status.StatusCommitted) {
            bl = false;
        }
        RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, bl);
        if (this.recoveryCoordinatorList != null) {
            int n = 0;
            while (n < this.recoveryCoordinatorList.size()) {
                RecoveryCoordinatorImpl recoveryCoordinatorImpl = (RecoveryCoordinatorImpl)this.recoveryCoordinatorList.elementAt(n);
                recoveryCoordinatorImpl.destroy();
                ++n;
            }
            this.recoveryCoordinatorList = null;
        }
        if (this.coordSyncImpl != null) {
            this.coordSyncImpl.destroy();
        }
        this.synchronizations = null;
        this.destroy();
    }

    synchronized void setTerminator(CompletionHandler completionHandler) {
        this.terminator = completionHandler;
    }

    Coordinator getParent() {
        Coordinator coordinator = null;
        return coordinator;
    }

    Coordinator getSuperior() {
        Coordinator coordinator = this.superInfo.superior;
        return coordinator;
    }

    CompletionHandler getTerminator() {
        CompletionHandler completionHandler = this.terminator;
        return completionHandler;
    }

    void directRegisterResource(Resource resource) {
        if (this.participants == null) {
            this.participants = new RegisteredResources(null);
        }
        this.participants.addRes(resource);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "TopCoordinator", "directRegisterResource()", "Registered resource :" + resource);
        }
    }

    public synchronized PropagationContext get_txcontext() throws Unavailable {
        if (this.tranState == null || this.tranState.state != 1 || this.rollbackOnly) {
            Unavailable unavailable = new Unavailable();
            throw unavailable;
        }
        long l = TimeoutManager.timeLeft(this.superInfo.localTID);
        int n = 0;
        if (l > 0L) {
            n = (int)l / 1000;
        } else if (l == 0L) {
            TimeoutManager.timeoutCoordinator(this.superInfo.localTID, 1);
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        TransIdentity transIdentity = new TransIdentity(this.object(), null, this.superInfo.globalTID.realTID);
        if (emptyData == null) {
            emptyData = Configuration.getORB().create_any();
            emptyData.insert_boolean(false);
        }
        PropagationContext propagationContext = new PropagationContext(n, transIdentity, new TransIdentity[0], emptyData);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.logp(Level.FINEST, "TopCoordinator", "get_txcontext()", "Obtained PropagationContextGTID is: " + this.superInfo.globalTID.toString());
        }
        return propagationContext;
    }

    void cleanUpEmpty(CoordinatorImpl coordinatorImpl) {
        try {
            this.rollback(true);
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commitOnePhase() throws HeuristicMixed, HeuristicHazard {
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
                INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
                throw iNVALID_TRANSACTION;
            }
            if (this.participants != null && this.participants.numRegistered() > 1) {
                return false;
            }
            if (!this.tranState.setState(10)) {
                return false;
            }
            if (this.rollbackOnly) {
                return false;
            }
            boolean bl = false;
            if (this.root) {
                TimeoutManager.setTimeout(this.superInfo.localTID, 0, 60);
            } else {
                TimeoutManager.setTimeout(this.superInfo.localTID, 2, 60);
            }
        }
        if (this.participants != null && this.participants.numRegistered() == 1) {
            boolean bl;
            java.lang.Object var2_4;
            block33: {
                var2_4 = null;
                bl = false;
                try {
                    this.participants.commitOnePhase();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof HeuristicMixed) {
                        if (!this.tranState.setState(14)) {
                            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (1)");
                            String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (1)"});
                            throw new INTERNAL(string);
                        }
                        throw (HeuristicMixed)throwable;
                    }
                    if (throwable instanceof HeuristicHazard) {
                        if (!this.tranState.setState(13)) {
                            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (2)");
                            String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (2)"});
                            throw new INTERNAL(string);
                        }
                        throw (HeuristicHazard)throwable;
                    }
                    if (throwable instanceof TRANSACTION_ROLLEDBACK) {
                        bl = true;
                    }
                    if (!(throwable instanceof INTERNAL)) break block33;
                    throw (INTERNAL)throwable;
                }
            }
            if (bl) {
                if (!this.tranState.setState(12)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (4)");
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (4)"});
                    throw new INTERNAL(string);
                }
                if (!this.tranState.setState(9)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (5)");
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (5)"});
                    throw new INTERNAL(string);
                }
            } else {
                if (!this.tranState.setState(11)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (6)");
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (6)"});
                    throw new INTERNAL(string);
                }
                if (!this.tranState.setState(7)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (7)");
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (7)"});
                    throw new INTERNAL(string);
                }
            }
            TopCoordinator topCoordinator2 = this;
            synchronized (topCoordinator2) {
                if (this.terminator != null) {
                    this.terminator.setCompleted(false, var2_4 != null);
                }
                if (!this.root) {
                    this.afterCompletion(Status.StatusCommitted);
                }
                if (var2_4 != null) {
                    if (var2_4 instanceof HeuristicMixed) {
                        throw (HeuristicMixed)var2_4;
                    }
                    throw (HeuristicHazard)var2_4;
                }
                if (bl) {
                    TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                    throw tRANSACTION_ROLLEDBACK;
                }
            }
            return true;
        }
        if (!this.tranState.setState(11)) {
            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (8)");
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (8)"});
            throw new INTERNAL(string);
        }
        if (!this.tranState.setState(7)) {
            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (9)");
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (9)"});
            throw new INTERNAL(string);
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0 && this.superInfo != null && this.superInfo.globalTID != null) {
            this.hash = this.superInfo.globalTID.hashCode();
        }
        return this.hash;
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        otid_t otid_t2 = null;
        if (object instanceof CoordinatorImpl) {
            if (object instanceof TopCoordinator) {
                otid_t2 = ((TopCoordinator)object).superInfo.globalTID.realTID;
            }
        } else if (object instanceof Object) {
            try {
                JCoordinator jCoordinator = JCoordinatorHelper.narrow((Object)object);
                otid_t2 = jCoordinator.getGlobalTID();
            }
            catch (BAD_PARAM bAD_PARAM) {
                try {
                    Coordinator coordinator = CoordinatorHelper.narrow((Object)object);
                    PropagationContext propagationContext = coordinator.get_txcontext();
                    otid_t2 = propagationContext.current.otid;
                }
                catch (BAD_PARAM bAD_PARAM2) {
                }
                catch (Unavailable unavailable) {
                    INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(7, CompletionStatus.COMPLETED_NO);
                    throw iNVALID_TRANSACTION;
                }
            }
        }
        if (otid_t2 != null) {
            return this.superInfo.globalTID.equals(otid_t2);
        }
        return false;
    }
}

