/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.Messages;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.omg.CORBA.INTERNAL;

public class ErrorLog {
    private static Messages messages = null;
    static final String DEFAULT_LOGFILE = "jts.log";
    private static String errorLogPath = null;
    private static String serverName = null;

    private static final void setup() {
        int[] nArray = new int[1];
        errorLogPath = Configuration.getDirectory("com.sun.jts.traceDirectory", "jts", nArray);
        if (nArray[0] == 1 || nArray[0] == 2) {
            boolean bl;
            boolean bl2 = bl = Configuration.getPropertyValue("com.sun.jts.errorLogging") != null;
            if (errorLogPath != null && bl) {
                System.err.println(ErrorLog.getMessage(18, new Object[]{errorLogPath}));
            }
            if (nArray[0] == 2) {
                if (bl) {
                    System.err.println(ErrorLog.getMessage(19));
                }
                errorLogPath = ".";
            }
        }
        if ((serverName = Configuration.getServerName()) == null) {
            serverName = "Anonymous transient server";
        }
        messages = (Messages)ResourceBundle.getBundle("com.sun.jts.CosTransactions.Messages");
    }

    private static final void fileWrite(String string) {
        if (Configuration.getPropertyValue("com.sun.jts.errorLogging") == null) {
            return;
        }
        try {
            File file = new File(errorLogPath, DEFAULT_LOGFILE);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes(string);
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
            System.err.println(ErrorLog.getMessage(61));
        }
    }

    public static final void error(int n, Object[] objectArray, boolean bl) {
        String string = ErrorLog.getMessage(n, objectArray);
        System.err.println(ErrorLog.getMessage(62, new Object[]{string}));
        new Exception().printStackTrace();
        String string2 = DateFormat.getDateTimeInstance().format(new Date());
        string = ErrorLog.getMessage(65, new Object[]{string2, serverName, messages.getMessageNumber(n), bl ? "F" : "E", string});
        ErrorLog.fileWrite(string);
        if (bl) {
            throw new INTERNAL(string);
        }
    }

    public static final void warning(int n, Object[] objectArray) {
        String string = ErrorLog.getMessage(n, objectArray);
        System.err.println(ErrorLog.getMessage(63, new Object[]{string}));
        String string2 = DateFormat.getDateTimeInstance().format(new Date());
        string = ErrorLog.getMessage(65, new Object[]{string2, serverName, messages.getMessageNumber(n), "W", string});
        ErrorLog.fileWrite(string);
    }

    public static final void info(int n, Object[] objectArray) {
        String string = ErrorLog.getMessage(n, objectArray);
        System.err.println(ErrorLog.getMessage(64, new Object[]{string}));
        String string2 = DateFormat.getDateTimeInstance().format(new Date());
        string = ErrorLog.getMessage(65, new Object[]{string2, serverName, messages.getMessageNumber(n), "I", string});
        ErrorLog.fileWrite(string);
    }

    static final String getMessage(int n, Object[] objectArray) {
        Object var2_2 = null;
        if (errorLogPath == null) {
            ErrorLog.setup();
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        return messages.getMessage(n, objectArray);
    }

    public static final String getMessage(int n) {
        Object var1_1 = null;
        if (errorLogPath == null) {
            ErrorLog.setup();
        }
        return messages.getMessage(n);
    }
}

