/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class JarEntrySource {
    private boolean markOnly;
    private String name;
    private InputStream is;
    private File file;
    private long modifiedTime;

    public JarEntrySource(File file) {
        this.markOnly = false;
        this.name = file.getPath().replace(File.separatorChar, '/');
        this.file = file;
    }

    public JarEntrySource(String string, File file) {
        this.markOnly = false;
        this.name = string;
        this.file = file;
    }

    public JarEntrySource(String string, InputStream inputStream) {
        this.markOnly = false;
        this.name = string;
        this.is = inputStream;
    }

    public JarEntrySource(String string) {
        this.markOnly = true;
        this.name = string;
    }

    public boolean isMarkOnly() {
        return this.markOnly;
    }

    public long getTime() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        return 0L;
    }

    public long getLength() {
        if (this.file != null) {
            return this.file.length();
        }
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.is;
    }

    public String toString() {
        return this.file == null ? this.getName() : this.file.toString();
    }
}

