/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.SecurityService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.Switch;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RoleMapper
implements Serializable {
    private static boolean debug;
    private static Hashtable roleMaps;
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private static Role defaultRole;
    private static String defaultRoleName;
    private Hashtable prinTable = new Hashtable();
    private Hashtable roleTable = new Hashtable();
    private String appName;
    private static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$RoleMapper;

    private RoleMapper(String string) {
        this.appName = string;
        Switch switch_ = Switch.getSwitch();
        if (switch_.getContainerType() == 2) {
            RoleMapper.initDefaultRole();
        }
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                if (!$assertionsDisabled && configContext == null) {
                    throw new AssertionError();
                }
                Server server = ServerBeansFactory.getServerBean(configContext);
                if (!$assertionsDisabled && server == null) {
                    throw new AssertionError();
                }
                SecurityService securityService = server.getSecurityService();
                if (!$assertionsDisabled && securityService == null) {
                    throw new AssertionError();
                }
                defaultRoleName = securityService.getAnonymousRole();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", exception);
            }
            _logger.log(Level.FINE, "Default role is: " + defaultRoleName);
            defaultRole = new Role(defaultRoleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoleMapper getRoleMapper(String string) {
        if (!roleMaps.containsKey(string)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.put(string, new RoleMapper(string));
            }
        }
        return (RoleMapper)roleMaps.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoleMapper(String string, RoleMapper roleMapper) {
        if (!roleMaps.containsKey(string)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.put(string, roleMapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoleMapper(String string) {
        if (roleMaps.containsKey(string)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.remove(string);
            }
        }
    }

    public String getName() {
        return this.appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        if (roleMaps.containsKey(this.appName)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.remove(this.appName);
                this.appName = string;
                roleMaps.remove(string);
                roleMaps.put(this.appName, this);
            }
        }
    }

    public static Role getDefaultRole() {
        if (defaultRole == null) {
            RoleMapper.initDefaultRole();
        }
        return defaultRole;
    }

    public void assignRole(Principal principal, Role role) {
        this.createMapping(this.prinTable, principal, role);
        this.createMapping(this.roleTable, role, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMapping(Hashtable hashtable, Principal principal, Principal principal2) {
        Cloneable cloneable;
        if (!hashtable.containsKey(principal)) {
            cloneable = hashtable;
            synchronized (cloneable) {
                hashtable.put(principal, new HashSet());
            }
        }
        Cloneable cloneable2 = cloneable = (HashSet)hashtable.get(principal);
        synchronized (cloneable2) {
            ((HashSet)cloneable).add(principal2);
        }
    }

    private void removeKey(Hashtable hashtable, Principal principal) {
        hashtable.remove(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValue(Hashtable hashtable, Principal principal) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet = (HashSet)enumeration.nextElement();
            synchronized (hashSet2) {
                hashSet.remove(principal);
            }
        }
    }

    private void removeValueFromSetWithKey(Hashtable hashtable, Object object, Object object2) {
        Set set = (Set)hashtable.get(object);
        if (set != null) {
            set.remove(object2);
            if (set.isEmpty()) {
                hashtable.remove(object);
            }
        }
    }

    public void unassignRole(Role role) {
        this.removeKey(this.roleTable, role);
        this.removeValue(this.prinTable, role);
    }

    public void unassignAllRoles() {
        this.roleTable.clear();
        this.prinTable.clear();
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        this.removeValueFromSetWithKey(this.prinTable, principal, role);
        this.removeValueFromSetWithKey(this.roleTable, role, principal);
    }

    private void unassignPrincipalFromRole(Hashtable hashtable, Role role, Principal principal) {
    }

    private Iterator getRoles(Principal principal) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, this.toString());
            _logger.log(Level.FINEST, "In roleMapper.getRoles(" + principal + ")");
        }
        HashSet hashSet = (HashSet)this.prinTable.get(principal);
        if (debug) {
            _logger.log(Level.FINEST, "Set of roles = " + hashSet);
        }
        if (hashSet != null) {
            return hashSet.iterator();
        }
        return null;
    }

    public boolean hasRole(Principal principal, String string) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "PRINCIPAL : " + principal + " hasRole?: " + string);
            _logger.log(Level.FINEST, "PRINCIPAL TABLE: " + this.prinTable);
        }
        if (string != null && string.equals(defaultRoleName)) {
            return true;
        }
        HashSet hashSet = (HashSet)this.prinTable.get(principal);
        if (debug) {
            _logger.log(Level.FINEST, "For principal: " + principal + ", set of roles= " + hashSet);
        }
        Role role = new Role(string);
        if (hashSet != null && hashSet.contains(role)) {
            return true;
        }
        return this.arePrincipalsGroupsInRole(principal.getName(), role);
    }

    private Enumeration getGroupsForPrincipal(String string) {
        try {
            Realm realm = Realm.getInstance(Realm.getDefaultRealm());
            Enumeration enumeration = realm.getGroupNames(string);
            return enumeration;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.retrieving_group_membership_exception", new Object[]{string, exception.toString()});
            Vector vector = new Vector();
            return vector.elements();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean arePrincipalsGroupsInRole(String var1_1, Role var2_2) {
        var3_3 = this.getGroupsForPrincipal(var1_1);
        var4_4 = (HashSet)this.roleTable.get(var2_2);
        if (var4_4 != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5 = (String)var3_3.nextElement();
            var6_6 = new PrincipalImpl(var5_5);
            if (!var4_4.contains(var6_6)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (var3_3.hasMoreElements())
        }
lbl10:
        // 1 sources

        return false;
    }

    public Enumeration getRoles() {
        return this.roleTable.keys();
    }

    public Enumeration getGroupsAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Group)) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    public Enumeration getUsersAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Group) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector computeCurrentRoles() {
        block22: {
            block21: {
                if (RoleMapper.debug) {
                    RoleMapper._logger.log(Level.FINE, "Within roleMapper.getCurrentRoles()");
                }
                var1_1 = new Vector<Role>();
                var2_2 = SecurityContext.getCurrent();
                if (RoleMapper.debug) {
                    RoleMapper._logger.log(Level.FINE, "roleMapper.SecurityContext=" + var2_2);
                }
                if (RoleMapper.getDefaultRole() != null) {
                    if (RoleMapper.debug) {
                        RoleMapper._logger.log(Level.FINE, "roleMapper.adding the default role=" + RoleMapper.getDefaultRole());
                    }
                    var1_1.add(RoleMapper.getDefaultRole());
                }
                if (var2_2 == null) {
                    return var1_1;
                }
                try {
                    var3_3 = var2_2.getCredentials();
                    if (RoleMapper.debug) {
                        RoleMapper._logger.log(Level.FINE, "roleMapper.credential = " + var3_3);
                    }
                    if (RoleMapper.debug) {
                        // empty if block
                    }
                    var4_5 = var3_3.getAuthenticationInfo();
                    if (RoleMapper.debug) {
                        RoleMapper._logger.log(Level.FINE, "AuthInfoList = " + var4_5.length);
                    }
                    var5_8 = 0;
                    block5: while (true) {
                        if (var5_8 >= var4_5.length) {
                        }
                        var6_10 = var4_5[var5_8];
                        if (RoleMapper.debug) {
                            RoleMapper._logger.log(Level.FINE, "AuthInfo = " + var6_10);
                        }
                        if (!var6_10.isAuthenticated()) ** GOTO lbl46
                        var7_11 = new PrincipalImpl(var6_10.getPrincipalName());
                        var8_12 = this.getRoles(var7_11);
                        if (var8_12 != null) {
                            while (var8_12.hasNext()) {
                                var1_1.add((Role)var8_12.next());
                            }
                        }
                        var9_13 = var6_10.getAttribute("Groups");
                        var10_14 = 0;
lbl40:
                        // 2 sources

                        while (true) {
                            block23: {
                                if (var10_14 >= var9_13.length) break block23;
                                var11_15 = new Group(var9_13[var10_14].getName());
                                var8_12 = this.getRoles(var11_15);
                                if (var8_12 == null) break block21;
                                if (true) ** GOTO lbl61
                            }
                            ++var5_8;
                            continue block5;
                            break;
                        }
                        break;
                    }
                }
                catch (Exception var3_4) {
                    RoleMapper._logger.log(Level.SEVERE, "java_security.credential_exception", var3_4);
                }
                finally {
                    if (!RoleMapper._logger.isLoggable(Level.FINER)) break block22;
                    var4_7 = new StringBuffer();
                    var4_7.append("Current principal has roles:");
                    var5_9 = 0;
                    if (true) ** GOTO lbl71
                }
                do {
                    var1_1.add((Role)var8_12.next());
lbl61:
                    // 2 sources

                } while (var8_12.hasNext());
            }
            ++var10_14;
            ** while (true)
            do {
                var4_7.append(" ");
                var4_7.append(var1_1.get(var5_9).toString());
                ++var5_9;
lbl71:
                // 2 sources

            } while (var5_9 < var1_1.size());
            RoleMapper._logger.finer(var4_7.toString());
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getCurrentRoles() {
        SecurityContext securityContext = SecurityContext.getCurrent();
        Vector vector = securityContext.getUserRolesByApp(this.appName);
        if (vector == null) {
            SecurityContext securityContext2 = securityContext;
            synchronized (securityContext2) {
                vector = this.computeCurrentRoles();
                securityContext.setUserRolesByApp(this.appName, vector);
            }
        }
        return vector.elements();
    }

    public String toString() {
        String string = "RoleMapper";
        Enumeration enumeration = this.getRoles();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            Enumeration enumeration2 = null;
            string = string + " : " + role + "(";
            enumeration2 = this.getGroupsAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")(";
            enumeration2 = this.getUsersAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper).desiredAssertionStatus();
        debug = false;
        roleMaps = new Hashtable();
        defaultRole = null;
        defaultRoleName = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

